pragma Ada_95;
pragma Source_File_Name (ada_main, Spec_File_Name => "b_gnatl.ads");
pragma Source_File_Name (ada_main, Body_File_Name => "b_gnatl.adb");

package body ada_main is
   pragma Warnings (Off);

   E068 : Short_Integer; pragma Import (Ada, E068, "system__os_lib_E");
   E014 : Short_Integer; pragma Import (Ada, E014, "system__soft_links_E");
   E020 : Short_Integer; pragma Import (Ada, E020, "system__exception_table_E");
   E114 : Short_Integer; pragma Import (Ada, E114, "interfaces__c_E");
   E116 : Short_Integer; pragma Import (Ada, E116, "interfaces__c__strings_E");
   E026 : Short_Integer; pragma Import (Ada, E026, "system__exceptions_E");
   E056 : Short_Integer; pragma Import (Ada, E056, "system__assertions_E");
   E010 : Short_Integer; pragma Import (Ada, E010, "system__secondary_stack_E");
   E061 : Short_Integer; pragma Import (Ada, E061, "types_E");
   E110 : Short_Integer; pragma Import (Ada, E110, "casing_E");
   E002 : Short_Integer; pragma Import (Ada, E002, "gnatlink_E");
   E081 : Short_Integer; pragma Import (Ada, E081, "gnatvsn_E");
   E057 : Short_Integer; pragma Import (Ada, E057, "hostparm_E");
   E112 : Short_Integer; pragma Import (Ada, E112, "indepsw_E");
   E079 : Short_Integer; pragma Import (Ada, E079, "opt_E");
   E077 : Short_Integer; pragma Import (Ada, E077, "csets_E");
   E054 : Short_Integer; pragma Import (Ada, E054, "output_E");
   E106 : Short_Integer; pragma Import (Ada, E106, "rident_E");
   E103 : Short_Integer; pragma Import (Ada, E103, "sdefault_E");
   E122 : Short_Integer; pragma Import (Ada, E122, "switch_E");
   E083 : Short_Integer; pragma Import (Ada, E083, "tree_io_E");
   E099 : Short_Integer; pragma Import (Ada, E099, "namet_E");
   E050 : Short_Integer; pragma Import (Ada, E050, "ali_E");
   E052 : Short_Integer; pragma Import (Ada, E052, "butil_E");
   E090 : Short_Integer; pragma Import (Ada, E090, "fmap_E");
   E108 : Short_Integer; pragma Import (Ada, E108, "fname_E");
   E087 : Short_Integer; pragma Import (Ada, E087, "osint_E");
   E120 : Short_Integer; pragma Import (Ada, E120, "snames_E");
   E075 : Short_Integer; pragma Import (Ada, E075, "targparm_E");
   E101 : Short_Integer; pragma Import (Ada, E101, "widechar_E");

   Local_Priority_Specific_Dispatching : constant String := "";
   Local_Interrupt_States : constant String := "";

   Is_Elaborated : Boolean := False;

   procedure adafinal is
      procedure s_stalib_adafinal;
      pragma Import (C, s_stalib_adafinal, "system__standard_library__adafinal");
   begin
      if not Is_Elaborated then
         return;
      end if;
      Is_Elaborated := False;
      s_stalib_adafinal;
   end adafinal;

   type No_Param_Proc is access procedure;

   procedure adainit is
      Main_Priority : Integer;
      pragma Import (C, Main_Priority, "__gl_main_priority");
      Time_Slice_Value : Integer;
      pragma Import (C, Time_Slice_Value, "__gl_time_slice_val");
      WC_Encoding : Character;
      pragma Import (C, WC_Encoding, "__gl_wc_encoding");
      Locking_Policy : Character;
      pragma Import (C, Locking_Policy, "__gl_locking_policy");
      Queuing_Policy : Character;
      pragma Import (C, Queuing_Policy, "__gl_queuing_policy");
      Task_Dispatching_Policy : Character;
      pragma Import (C, Task_Dispatching_Policy, "__gl_task_dispatching_policy");
      Priority_Specific_Dispatching : System.Address;
      pragma Import (C, Priority_Specific_Dispatching, "__gl_priority_specific_dispatching");
      Num_Specific_Dispatching : Integer;
      pragma Import (C, Num_Specific_Dispatching, "__gl_num_specific_dispatching");
      Main_CPU : Integer;
      pragma Import (C, Main_CPU, "__gl_main_cpu");
      Interrupt_States : System.Address;
      pragma Import (C, Interrupt_States, "__gl_interrupt_states");
      Num_Interrupt_States : Integer;
      pragma Import (C, Num_Interrupt_States, "__gl_num_interrupt_states");
      Unreserve_All_Interrupts : Integer;
      pragma Import (C, Unreserve_All_Interrupts, "__gl_unreserve_all_interrupts");
      Detect_Blocking : Integer;
      pragma Import (C, Detect_Blocking, "__gl_detect_blocking");
      Default_Stack_Size : Integer;
      pragma Import (C, Default_Stack_Size, "__gl_default_stack_size");
      Leap_Seconds_Support : Integer;
      pragma Import (C, Leap_Seconds_Support, "__gl_leap_seconds_support");

      procedure Install_Handler;
      pragma Import (C, Install_Handler, "__gnat_install_handler");

      Handler_Installed : Integer;
      pragma Import (C, Handler_Installed, "__gnat_handler_installed");

      Finalize_Library_Objects : No_Param_Proc;
      pragma Import (C, Finalize_Library_Objects, "__gnat_finalize_library_objects");
   begin
      if Is_Elaborated then
         return;
      end if;
      Is_Elaborated := True;
      Main_Priority := -1;
      Time_Slice_Value := -1;
      WC_Encoding := 'b';
      Locking_Policy := ' ';
      Queuing_Policy := ' ';
      Task_Dispatching_Policy := ' ';
      Priority_Specific_Dispatching :=
        Local_Priority_Specific_Dispatching'Address;
      Num_Specific_Dispatching := 0;
      Main_CPU := -1;
      Interrupt_States := Local_Interrupt_States'Address;
      Num_Interrupt_States := 0;
      Unreserve_All_Interrupts := 0;
      Detect_Blocking := 0;
      Default_Stack_Size := -1;
      Leap_Seconds_Support := 0;

      if Handler_Installed = 0 then
         Install_Handler;
      end if;

      Finalize_Library_Objects := null;

      System.Soft_Links'Elab_Spec;
      System.Exception_Table'Elab_Body;
      E020 := E020 + 1;
      Interfaces.C'Elab_Spec;
      Interfaces.C.Strings'Elab_Spec;
      System.Exceptions'Elab_Spec;
      E026 := E026 + 1;
      System.Assertions'Elab_Spec;
      E056 := E056 + 1;
      E116 := E116 + 1;
      E114 := E114 + 1;
      System.Soft_Links'Elab_Body;
      E014 := E014 + 1;
      System.Os_Lib'Elab_Body;
      E068 := E068 + 1;
      System.Secondary_Stack'Elab_Body;
      E010 := E010 + 1;
      Types'Elab_Spec;
      E061 := E061 + 1;
      E081 := E081 + 1;
      Hostparm'Elab_Spec;
      E057 := E057 + 1;
      Opt'Elab_Spec;
      Csets'Elab_Body;
      E077 := E077 + 1;
      Output'Elab_Spec;
      E054 := E054 + 1;
      E112 := E112 + 1;
      Rident'Elab_Spec;
      E106 := E106 + 1;
      Tree_Io'Elab_Spec;
      E083 := E083 + 1;
      E079 := E079 + 1;
      Namet'Elab_Spec;
      ALI'ELAB_SPEC;
      Fname'Elab_Body;
      E108 := E108 + 1;
      Osint'Elab_Spec;
      Fmap'Elab_Body;
      E090 := E090 + 1;
      ALI'ELAB_BODY;
      E050 := E050 + 1;
      E122 := E122 + 1;
      E103 := E103 + 1;
      Snames'Elab_Body;
      E120 := E120 + 1;
      Targparm'Elab_Spec;
      Targparm'Elab_Body;
      E075 := E075 + 1;
      Osint'Elab_Body;
      E087 := E087 + 1;
      E052 := E052 + 1;
      E002 := E002 + 1;
      E101 := E101 + 1;
      Namet'Elab_Body;
      E099 := E099 + 1;
      E110 := E110 + 1;
   end adainit;

   procedure Ada_Main_Program;
   pragma Import (Ada, Ada_Main_Program, "_ada_gnatlink");

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer
   is
      procedure Initialize (Addr : System.Address);
      pragma Import (C, Initialize, "__gnat_initialize");

      procedure Finalize;
      pragma Import (C, Finalize, "__gnat_finalize");
      SEH : aliased array (1 .. 2) of Integer;

      Ensure_Reference : aliased System.Address := Ada_Main_Program_Name'Address;
      pragma Volatile (Ensure_Reference);

   begin
      gnat_argc := argc;
      gnat_argv := argv;
      gnat_envp := envp;

      Initialize (SEH'Address);
      adainit;
      Ada_Main_Program;
      adafinal;
      Finalize;
      return (gnat_exit_status);
   end;

--  BEGIN Object file/option list
   --   ../rts/ada.o
   --   ../rts/gnat.o
   --   ../rts/interfac.o
   --   ../rts/system.o
   --   ../rts/s-addope.o
   --   ../rts/s-casuti.o
   --   ../rts/g-htable.o
   --   ../rts/s-imenne.o
   --   ../rts/s-imgint.o
   --   ../rts/s-parame.o
   --   ../rts/s-crtl.o
   --   ../rts/i-cstrea.o
   --   ../rts/s-excdeb.o
   --   ../rts/s-stoele.o
   --   ../rts/s-stache.o
   --   ../rts/s-strhas.o
   --   ../rts/s-htable.o
   --   ../rts/s-string.o
   --   ../rts/s-traent.o
   --   ../rts/s-unstyp.o
   --   ../rts/s-wchcon.o
   --   ../rts/s-wchjis.o
   --   ../rts/s-wchcnv.o
   --   ../rts/s-wchstw.o
   --   ../rts/a-elchha.o
   --   ../rts/s-carun8.o
   --   ../rts/s-conca2.o
   --   ../rts/s-exctab.o
   --   ../rts/s-except.o
   --   ../rts/s-excmac.o
   --   ../rts/s-assert.o
   --   ../rts/s-memory.o
   --   ../rts/s-stalib.o
   --   ../rts/i-cstrin.o
   --   ../rts/i-c.o
   --   ../rts/s-soflin.o
   --   ../rts/s-os_lib.o
   --   ../rts/a-comlin.o
   --   ../rts/s-secsta.o
   --   ../rts/a-except.o
   --   ../rts/s-traceb.o
   --   ./debug.o
   --   ./types.o
   --   ./alloc.o
   --   ./gnatvsn.o
   --   ./hostparm.o
   --   ./csets.o
   --   ./output.o
   --   ./indepsw.o
   --   ./rident.o
   --   ./tree_io.o
   --   ./opt.o
   --   ./table.o
   --   ./fname.o
   --   ./fmap.o
   --   ./ali.o
   --   ./switch.o
   --   ./sdefault.o
   --   ./snames.o
   --   ./targparm.o
   --   ./osint.o
   --   ./butil.o
   --   ./gnatlink.o
   --   ./widechar.o
   --   ./namet.o
   --   ./casing.o
   --   -L../rts/
   --   -L./
   --   -L/cygdrive/i/szsz/tmpp/gcc/gcc-4.9.3-1.x86_64/src/gcc-4.9.3/gcc/ada/
   --   -L/usr/lib/gcc/x86_64-pc-cygwin/4.9.3/adalib/
   --   -static
   --   -lgnat
   --   -Wl,--stack=0x2000000
--  END Object file/option list   

end ada_main;
