/* types.c generated by valac 0.22.1, the Vala compiler
 * generated from types.vala, do not modify */

/*
 * This file is part of gnome-code-assistance.
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gnome-code-assistance is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gnome-code-assistance is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gnome-code-assistance.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>


#define TYPE_SOURCE_LOCATION (source_location_get_type ())
typedef struct _SourceLocation SourceLocation;

#define TYPE_SOURCE_RANGE (source_range_get_type ())
typedef struct _SourceRange SourceRange;

#define TYPE_FIXIT (fixit_get_type ())
typedef struct _Fixit Fixit;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SEVERITY (severity_get_type ())

#define TYPE_DIAGNOSTIC (diagnostic_get_type ())
typedef struct _Diagnostic Diagnostic;

#define TYPE_REMOTE_DOCUMENT (remote_document_get_type ())
typedef struct _RemoteDocument RemoteDocument;

#define TYPE_OPEN_DOCUMENT (open_document_get_type ())
typedef struct _OpenDocument OpenDocument;

struct _SourceLocation {
	gint64 line;
	gint64 column;
};

struct _SourceRange {
	gint64 file;
	SourceLocation start;
	SourceLocation end;
};

struct _Fixit {
	SourceRange location;
	gchar* replacement;
};

typedef enum  {
	SEVERITY_NONE,
	SEVERITY_INFO,
	SEVERITY_WARNING,
	SEVERITY_DEPRECATED,
	SEVERITY_ERROR,
	SEVERITY_FATAL
} Severity;

struct _Diagnostic {
	guint32 severity;
	Fixit* fixits;
	gint fixits_length1;
	SourceRange* locations;
	gint locations_length1;
	gchar* message;
};

struct _RemoteDocument {
	gchar* path;
	char* remote_path;
};

struct _OpenDocument {
	gchar* path;
	gchar* data_path;
};



GType source_location_get_type (void) G_GNUC_CONST;
SourceLocation* source_location_dup (const SourceLocation* self);
void source_location_free (SourceLocation* self);
gint source_location_compare_to (SourceLocation *self, SourceLocation* other);
GType source_range_get_type (void) G_GNUC_CONST;
SourceRange* source_range_dup (const SourceRange* self);
void source_range_free (SourceRange* self);
GType fixit_get_type (void) G_GNUC_CONST;
Fixit* fixit_dup (const Fixit* self);
void fixit_free (Fixit* self);
void fixit_copy (const Fixit* self, Fixit* dest);
void fixit_destroy (Fixit* self);
GType severity_get_type (void) G_GNUC_CONST;
GType diagnostic_get_type (void) G_GNUC_CONST;
Diagnostic* diagnostic_dup (const Diagnostic* self);
void diagnostic_free (Diagnostic* self);
void diagnostic_copy (const Diagnostic* self, Diagnostic* dest);
void diagnostic_destroy (Diagnostic* self);
static void _vala_Fixit_array_free (Fixit* array, gint array_length);
static Fixit* _vala_array_dup1 (Fixit* self, int length);
static SourceRange* _vala_array_dup2 (SourceRange* self, int length);
GType remote_document_get_type (void) G_GNUC_CONST;
RemoteDocument* remote_document_dup (const RemoteDocument* self);
void remote_document_free (RemoteDocument* self);
void remote_document_copy (const RemoteDocument* self, RemoteDocument* dest);
void remote_document_destroy (RemoteDocument* self);
GType open_document_get_type (void) G_GNUC_CONST;
OpenDocument* open_document_dup (const OpenDocument* self);
void open_document_free (OpenDocument* self);
void open_document_copy (const OpenDocument* self, OpenDocument* dest);
void open_document_destroy (OpenDocument* self);


gint source_location_compare_to (SourceLocation *self, SourceLocation* other) {
	gint result = 0;
	SourceLocation _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	g_return_val_if_fail (other != NULL, 0);
	_tmp0_ = *other;
	_tmp1_ = _tmp0_.line;
	_tmp2_ = (*self).line;
	if (_tmp1_ == _tmp2_) {
		gint64 _tmp3_ = 0LL;
		SourceLocation _tmp4_ = {0};
		gint64 _tmp5_ = 0LL;
		gint _tmp6_ = 0;
		gint64 _tmp7_ = 0LL;
		SourceLocation _tmp8_ = {0};
		gint64 _tmp9_ = 0LL;
		gint _tmp10_ = 0;
		_tmp3_ = (*self).column;
		_tmp4_ = *other;
		_tmp5_ = _tmp4_.column;
		if (_tmp3_ == _tmp5_) {
			result = 0;
			return result;
		}
		_tmp7_ = (*self).column;
		_tmp8_ = *other;
		_tmp9_ = _tmp8_.column;
		if (_tmp7_ < _tmp9_) {
			_tmp6_ = -1;
		} else {
			_tmp6_ = 1;
		}
		_tmp10_ = _tmp6_;
		result = _tmp10_;
		return result;
	} else {
		gint _tmp11_ = 0;
		gint64 _tmp12_ = 0LL;
		SourceLocation _tmp13_ = {0};
		gint64 _tmp14_ = 0LL;
		gint _tmp15_ = 0;
		_tmp12_ = (*self).line;
		_tmp13_ = *other;
		_tmp14_ = _tmp13_.line;
		if (_tmp12_ < _tmp14_) {
			_tmp11_ = -1;
		} else {
			_tmp11_ = 1;
		}
		_tmp15_ = _tmp11_;
		result = _tmp15_;
		return result;
	}
}


SourceLocation* source_location_dup (const SourceLocation* self) {
	SourceLocation* dup;
	dup = g_new0 (SourceLocation, 1);
	memcpy (dup, self, sizeof (SourceLocation));
	return dup;
}


void source_location_free (SourceLocation* self) {
	g_free (self);
}


GType source_location_get_type (void) {
	static volatile gsize source_location_type_id__volatile = 0;
	if (g_once_init_enter (&source_location_type_id__volatile)) {
		GType source_location_type_id;
		source_location_type_id = g_boxed_type_register_static ("SourceLocation", (GBoxedCopyFunc) source_location_dup, (GBoxedFreeFunc) source_location_free);
		g_once_init_leave (&source_location_type_id__volatile, source_location_type_id);
	}
	return source_location_type_id__volatile;
}


SourceRange* source_range_dup (const SourceRange* self) {
	SourceRange* dup;
	dup = g_new0 (SourceRange, 1);
	memcpy (dup, self, sizeof (SourceRange));
	return dup;
}


void source_range_free (SourceRange* self) {
	g_free (self);
}


GType source_range_get_type (void) {
	static volatile gsize source_range_type_id__volatile = 0;
	if (g_once_init_enter (&source_range_type_id__volatile)) {
		GType source_range_type_id;
		source_range_type_id = g_boxed_type_register_static ("SourceRange", (GBoxedCopyFunc) source_range_dup, (GBoxedFreeFunc) source_range_free);
		g_once_init_leave (&source_range_type_id__volatile, source_range_type_id);
	}
	return source_range_type_id__volatile;
}


void fixit_copy (const Fixit* self, Fixit* dest) {
	SourceRange _tmp0_ = {0};
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_tmp0_ = (*self).location;
	(*dest).location = _tmp0_;
	_tmp1_ = (*self).replacement;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).replacement);
	(*dest).replacement = _tmp2_;
}


void fixit_destroy (Fixit* self) {
	_g_free0 ((*self).replacement);
}


Fixit* fixit_dup (const Fixit* self) {
	Fixit* dup;
	dup = g_new0 (Fixit, 1);
	fixit_copy (self, dup);
	return dup;
}


void fixit_free (Fixit* self) {
	fixit_destroy (self);
	g_free (self);
}


GType fixit_get_type (void) {
	static volatile gsize fixit_type_id__volatile = 0;
	if (g_once_init_enter (&fixit_type_id__volatile)) {
		GType fixit_type_id;
		fixit_type_id = g_boxed_type_register_static ("Fixit", (GBoxedCopyFunc) fixit_dup, (GBoxedFreeFunc) fixit_free);
		g_once_init_leave (&fixit_type_id__volatile, fixit_type_id);
	}
	return fixit_type_id__volatile;
}


GType severity_get_type (void) {
	static volatile gsize severity_type_id__volatile = 0;
	if (g_once_init_enter (&severity_type_id__volatile)) {
		static const GEnumValue values[] = {{SEVERITY_NONE, "SEVERITY_NONE", "none"}, {SEVERITY_INFO, "SEVERITY_INFO", "info"}, {SEVERITY_WARNING, "SEVERITY_WARNING", "warning"}, {SEVERITY_DEPRECATED, "SEVERITY_DEPRECATED", "deprecated"}, {SEVERITY_ERROR, "SEVERITY_ERROR", "error"}, {SEVERITY_FATAL, "SEVERITY_FATAL", "fatal"}, {0, NULL, NULL}};
		GType severity_type_id;
		severity_type_id = g_enum_register_static ("Severity", values);
		g_once_init_leave (&severity_type_id__volatile, severity_type_id);
	}
	return severity_type_id__volatile;
}


static void _vala_Fixit_array_free (Fixit* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			fixit_destroy (&array[i]);
		}
	}
	g_free (array);
}


static Fixit* _vala_array_dup1 (Fixit* self, int length) {
	Fixit* result;
	int i;
	result = g_new0 (Fixit, length);
	for (i = 0; i < length; i++) {
		Fixit _tmp0_ = {0};
		fixit_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static SourceRange* _vala_array_dup2 (SourceRange* self, int length) {
	return g_memdup (self, length * sizeof (SourceRange));
}


void diagnostic_copy (const Diagnostic* self, Diagnostic* dest) {
	guint32 _tmp0_ = 0U;
	Fixit* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	Fixit* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	SourceRange* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	SourceRange* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	_tmp0_ = (*self).severity;
	(*dest).severity = _tmp0_;
	_tmp1_ = (*self).fixits;
	_tmp1__length1 = (*self).fixits_length1;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp1__length1;
	(*dest).fixits = (_vala_Fixit_array_free ((*dest).fixits, (*dest).fixits_length1), NULL);
	(*dest).fixits = _tmp2_;
	(*dest).fixits_length1 = _tmp2__length1;
	_tmp3_ = (*self).locations;
	_tmp3__length1 = (*self).locations_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	(*dest).locations = (g_free ((*dest).locations), NULL);
	(*dest).locations = _tmp4_;
	(*dest).locations_length1 = _tmp4__length1;
	_tmp5_ = (*self).message;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 ((*dest).message);
	(*dest).message = _tmp6_;
}


void diagnostic_destroy (Diagnostic* self) {
	(*self).fixits = (_vala_Fixit_array_free ((*self).fixits, (*self).fixits_length1), NULL);
	(*self).locations = (g_free ((*self).locations), NULL);
	_g_free0 ((*self).message);
}


Diagnostic* diagnostic_dup (const Diagnostic* self) {
	Diagnostic* dup;
	dup = g_new0 (Diagnostic, 1);
	diagnostic_copy (self, dup);
	return dup;
}


void diagnostic_free (Diagnostic* self) {
	diagnostic_destroy (self);
	g_free (self);
}


GType diagnostic_get_type (void) {
	static volatile gsize diagnostic_type_id__volatile = 0;
	if (g_once_init_enter (&diagnostic_type_id__volatile)) {
		GType diagnostic_type_id;
		diagnostic_type_id = g_boxed_type_register_static ("Diagnostic", (GBoxedCopyFunc) diagnostic_dup, (GBoxedFreeFunc) diagnostic_free);
		g_once_init_leave (&diagnostic_type_id__volatile, diagnostic_type_id);
	}
	return diagnostic_type_id__volatile;
}


void remote_document_copy (const RemoteDocument* self, RemoteDocument* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const char* _tmp2_ = NULL;
	char* _tmp3_ = NULL;
	_tmp0_ = (*self).path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).path);
	(*dest).path = _tmp1_;
	_tmp2_ = (*self).remote_path;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).remote_path);
	(*dest).remote_path = _tmp3_;
}


void remote_document_destroy (RemoteDocument* self) {
	_g_free0 ((*self).path);
	_g_free0 ((*self).remote_path);
}


RemoteDocument* remote_document_dup (const RemoteDocument* self) {
	RemoteDocument* dup;
	dup = g_new0 (RemoteDocument, 1);
	remote_document_copy (self, dup);
	return dup;
}


void remote_document_free (RemoteDocument* self) {
	remote_document_destroy (self);
	g_free (self);
}


GType remote_document_get_type (void) {
	static volatile gsize remote_document_type_id__volatile = 0;
	if (g_once_init_enter (&remote_document_type_id__volatile)) {
		GType remote_document_type_id;
		remote_document_type_id = g_boxed_type_register_static ("RemoteDocument", (GBoxedCopyFunc) remote_document_dup, (GBoxedFreeFunc) remote_document_free);
		g_once_init_leave (&remote_document_type_id__volatile, remote_document_type_id);
	}
	return remote_document_type_id__volatile;
}


void open_document_copy (const OpenDocument* self, OpenDocument* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = (*self).path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).path);
	(*dest).path = _tmp1_;
	_tmp2_ = (*self).data_path;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).data_path);
	(*dest).data_path = _tmp3_;
}


void open_document_destroy (OpenDocument* self) {
	_g_free0 ((*self).path);
	_g_free0 ((*self).data_path);
}


OpenDocument* open_document_dup (const OpenDocument* self) {
	OpenDocument* dup;
	dup = g_new0 (OpenDocument, 1);
	open_document_copy (self, dup);
	return dup;
}


void open_document_free (OpenDocument* self) {
	open_document_destroy (self);
	g_free (self);
}


GType open_document_get_type (void) {
	static volatile gsize open_document_type_id__volatile = 0;
	if (g_once_init_enter (&open_document_type_id__volatile)) {
		GType open_document_type_id;
		open_document_type_id = g_boxed_type_register_static ("OpenDocument", (GBoxedCopyFunc) open_document_dup, (GBoxedFreeFunc) open_document_free);
		g_once_init_leave (&open_document_type_id__volatile, open_document_type_id);
	}
	return open_document_type_id__volatile;
}



