/* diagnostics.c generated by valac 0.22.1, the Vala compiler
 * generated from diagnostics.vala, do not modify */

/*
 * This file is part of gnome-code-assistance.
 *
 * Copyright (C) 2013 - Melissa Wen <melissa.srw@gmail.com>
 * Copyright (C) 2013 - Jesse van den Kieboom <jessevdk@gnome.org>
 *
 * gnome-code-assistance is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gnome-code-assistance is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gnome-code-assistance.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include "backends/vala/libvalashared.h"


#define TYPE_DIAGNOSTICS (diagnostics_get_type ())
#define DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIAGNOSTICS, Diagnostics))
#define DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIAGNOSTICS, DiagnosticsClass))
#define IS_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIAGNOSTICS))
#define IS_DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIAGNOSTICS))
#define DIAGNOSTICS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIAGNOSTICS, DiagnosticsClass))

typedef struct _Diagnostics Diagnostics;
typedef struct _DiagnosticsClass DiagnosticsClass;
typedef struct _DiagnosticsPrivate DiagnosticsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_Diagnostic_free0(var) ((var == NULL) ? NULL : (var = (_vala_Diagnostic_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Diagnostics {
	ValaReport parent_instance;
	DiagnosticsPrivate * priv;
};

struct _DiagnosticsClass {
	ValaReportClass parent_class;
};

struct _DiagnosticsPrivate {
	GeeHashMap* d_diagnostics;
};


static gpointer diagnostics_parent_class = NULL;

GType diagnostics_get_type (void) G_GNUC_CONST;
#define DIAGNOSTICS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIAGNOSTICS, DiagnosticsPrivate))
enum  {
	DIAGNOSTICS_DUMMY_PROPERTY
};
Diagnostics* diagnostics_new (void);
Diagnostics* diagnostics_construct (GType object_type);
Diagnostic* diagnostics_diagnostics_for_path (Diagnostics* self, const gchar* path, int* result_length1);
static void _vala_array_add1 (Diagnostic** array, int* length, int* size, const Diagnostic* value);
static void _vala_Diagnostic_free (Diagnostic* self);
static void _vala_Diagnostic_array_free (Diagnostic* array, gint array_length);
static void diagnostics_diags_report (Diagnostics* self, ValaSourceReference* source, const gchar* message, Severity severity);
static Diagnostic* _diagnostic_dup (Diagnostic* self);
static void _vala_Fixit_array_free (Fixit* array, gint array_length);
static void diagnostics_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void diagnostics_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void diagnostics_real_depr (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void diagnostics_real_note (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void diagnostics_finalize (GObject* obj);


Diagnostics* diagnostics_construct (GType object_type) {
	Diagnostics * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	self = (Diagnostics*) vala_report_construct (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_diagnostics);
	self->priv->d_diagnostics = _tmp0_;
	return self;
}


Diagnostics* diagnostics_new (void) {
	return diagnostics_construct (TYPE_DIAGNOSTICS);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (Diagnostic** array, int* length, int* size, const Diagnostic* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Diagnostic, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_Diagnostic_free (Diagnostic* self) {
	diagnostic_destroy (self);
	g_free (self);
}


static void _vala_Diagnostic_array_free (Diagnostic* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			diagnostic_destroy (&array[i]);
		}
	}
	g_free (array);
}


Diagnostic* diagnostics_diagnostics_for_path (Diagnostics* self, const gchar* path, int* result_length1) {
	Diagnostic* result = NULL;
	GeeArrayList* diagnostics = NULL;
	GeeHashMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	Diagnostic* ret = NULL;
	GeeArrayList* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	Diagnostic* _tmp9_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	gint _tmp10_ = 0;
	Diagnostic* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->d_diagnostics;
	_tmp1_ = path;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	diagnostics = (GeeArrayList*) _tmp2_;
	_tmp3_ = diagnostics;
	if (_tmp3_ == NULL) {
		Diagnostic* _tmp4_ = NULL;
		Diagnostic* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		_tmp4_ = g_new0 (Diagnostic, 0);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp5__length1;
		}
		result = _tmp5_;
		_g_object_unref0 (diagnostics);
		return result;
	}
	_tmp6_ = diagnostics;
	_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_new0 (Diagnostic, _tmp8_);
	ret = _tmp9_;
	ret_length1 = _tmp8_;
	_ret_size_ = ret_length1;
	ret_length1 = 0;
	_tmp10_ = ret_length1;
	{
		GeeArrayList* _d_list = NULL;
		GeeArrayList* _tmp11_ = NULL;
		GeeArrayList* _tmp12_ = NULL;
		gint _d_size = 0;
		GeeArrayList* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _d_index = 0;
		_tmp11_ = diagnostics;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_d_list = _tmp12_;
		_tmp13_ = _d_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_d_size = _tmp15_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			Diagnostic* d = NULL;
			GeeArrayList* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gpointer _tmp21_ = NULL;
			Diagnostic* _tmp22_ = NULL;
			gint _tmp22__length1 = 0;
			Diagnostic* _tmp23_ = NULL;
			Diagnostic _tmp24_ = {0};
			_tmp16_ = _d_index;
			_d_index = _tmp16_ + 1;
			_tmp17_ = _d_index;
			_tmp18_ = _d_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _d_list;
			_tmp20_ = _d_index;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_);
			d = (Diagnostic*) _tmp21_;
			_tmp22_ = ret;
			_tmp22__length1 = ret_length1;
			_tmp23_ = d;
			diagnostic_copy (_tmp23_, &_tmp24_);
			_vala_array_add1 (&ret, &ret_length1, &_ret_size_, &_tmp24_);
			__vala_Diagnostic_free0 (d);
		}
		_g_object_unref0 (_d_list);
	}
	_tmp25_ = ret;
	_tmp25__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp25__length1;
	}
	result = _tmp25_;
	_g_object_unref0 (diagnostics);
	return result;
}


static Diagnostic* _diagnostic_dup (Diagnostic* self) {
	Diagnostic* dup;
	dup = g_new0 (Diagnostic, 1);
	diagnostic_copy (self, dup);
	return dup;
}


static void _vala_Fixit_array_free (Fixit* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			fixit_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void diagnostics_diags_report (Diagnostics* self, ValaSourceReference* source, const gchar* message, Severity severity) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaSourceReference* _tmp2_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GeeArrayList* diagnostics = NULL;
	GeeHashMap* _tmp13_ = NULL;
	ValaSourceReference* _tmp14_ = NULL;
	ValaSourceFile* _tmp15_ = NULL;
	ValaSourceFile* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gpointer _tmp19_ = NULL;
	GeeArrayList* _tmp20_ = NULL;
	SourceLocation start = {0};
	ValaSourceReference* _tmp29_ = NULL;
	ValaSourceLocation _tmp30_ = {0};
	ValaSourceLocation _tmp31_ = {0};
	gint _tmp32_ = 0;
	ValaSourceReference* _tmp33_ = NULL;
	ValaSourceLocation _tmp34_ = {0};
	ValaSourceLocation _tmp35_ = {0};
	gint _tmp36_ = 0;
	SourceLocation _tmp37_ = {0};
	SourceLocation end = {0};
	ValaSourceReference* _tmp38_ = NULL;
	ValaSourceLocation _tmp39_ = {0};
	ValaSourceLocation _tmp40_ = {0};
	gint _tmp41_ = 0;
	ValaSourceReference* _tmp42_ = NULL;
	ValaSourceLocation _tmp43_ = {0};
	ValaSourceLocation _tmp44_ = {0};
	gint _tmp45_ = 0;
	SourceLocation _tmp46_ = {0};
	SourceLocation _tmp47_ = {0};
	gint _tmp48_ = 0;
	SourceRange range = {0};
	SourceLocation _tmp52_ = {0};
	SourceLocation _tmp53_ = {0};
	SourceRange _tmp54_ = {0};
	GeeArrayList* _tmp55_ = NULL;
	Severity _tmp56_ = 0;
	Fixit* _tmp57_ = NULL;
	SourceRange _tmp58_ = {0};
	SourceRange* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	gchar* _tmp61_ = NULL;
	Diagnostic _tmp62_ = {0};
	Diagnostic _tmp63_ = {0};
	Diagnostic _tmp64_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp2_ = source;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaSourceReference* _tmp3_ = NULL;
		ValaSourceFile* _tmp4_ = NULL;
		ValaSourceFile* _tmp5_ = NULL;
		_tmp3_ = source;
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ == NULL;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		_tmp0_ = TRUE;
	} else {
		ValaSourceReference* _tmp7_ = NULL;
		ValaSourceFile* _tmp8_ = NULL;
		ValaSourceFile* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp7_ = source;
		_tmp8_ = vala_source_reference_get_file (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_source_file_get_filename (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp0_ = _tmp11_ == NULL;
	}
	_tmp12_ = _tmp0_;
	if (_tmp12_) {
		return;
	}
	_tmp13_ = self->priv->d_diagnostics;
	_tmp14_ = source;
	_tmp15_ = vala_source_reference_get_file (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_source_file_get_filename (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp18_);
	diagnostics = (GeeArrayList*) _tmp19_;
	_tmp20_ = diagnostics;
	if (_tmp20_ == NULL) {
		GeeArrayList* _tmp21_ = NULL;
		GeeHashMap* _tmp22_ = NULL;
		ValaSourceReference* _tmp23_ = NULL;
		ValaSourceFile* _tmp24_ = NULL;
		ValaSourceFile* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		GeeArrayList* _tmp28_ = NULL;
		_tmp21_ = gee_array_list_new (TYPE_DIAGNOSTIC, (GBoxedCopyFunc) _diagnostic_dup, _vala_Diagnostic_free, NULL, NULL, NULL);
		_g_object_unref0 (diagnostics);
		diagnostics = _tmp21_;
		_tmp22_ = self->priv->d_diagnostics;
		_tmp23_ = source;
		_tmp24_ = vala_source_reference_get_file (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_source_file_get_filename (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = diagnostics;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, _tmp27_, _tmp28_);
	}
	_tmp29_ = source;
	vala_source_reference_get_begin (_tmp29_, &_tmp30_);
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_.line;
	_tmp33_ = source;
	vala_source_reference_get_begin (_tmp33_, &_tmp34_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_.column;
	memset (&_tmp37_, 0, sizeof (SourceLocation));
	_tmp37_.line = (gint64) _tmp32_;
	_tmp37_.column = (gint64) _tmp36_;
	start = _tmp37_;
	_tmp38_ = source;
	vala_source_reference_get_end (_tmp38_, &_tmp39_);
	_tmp40_ = _tmp39_;
	_tmp41_ = _tmp40_.line;
	_tmp42_ = source;
	vala_source_reference_get_end (_tmp42_, &_tmp43_);
	_tmp44_ = _tmp43_;
	_tmp45_ = _tmp44_.column;
	memset (&_tmp46_, 0, sizeof (SourceLocation));
	_tmp46_.line = (gint64) _tmp41_;
	_tmp46_.column = (gint64) _tmp45_;
	end = _tmp46_;
	_tmp47_ = end;
	_tmp48_ = source_location_compare_to (&start, &_tmp47_);
	if (_tmp48_ > 0) {
		SourceLocation tmp = {0};
		SourceLocation _tmp49_ = {0};
		SourceLocation _tmp50_ = {0};
		SourceLocation _tmp51_ = {0};
		_tmp49_ = end;
		tmp = _tmp49_;
		_tmp50_ = start;
		end = _tmp50_;
		_tmp51_ = tmp;
		start = _tmp51_;
	}
	_tmp52_ = start;
	_tmp53_ = end;
	memset (&_tmp54_, 0, sizeof (SourceRange));
	_tmp54_.file = (gint64) 0;
	_tmp54_.start = _tmp52_;
	_tmp54_.end = _tmp53_;
	range = _tmp54_;
	_tmp55_ = diagnostics;
	_tmp56_ = severity;
	_tmp57_ = g_new0 (Fixit, 0);
	_tmp58_ = range;
	_tmp59_ = g_new0 (SourceRange, 1);
	_tmp59_[0] = _tmp58_;
	_tmp60_ = message;
	_tmp61_ = g_strdup (_tmp60_);
	memset (&_tmp62_, 0, sizeof (Diagnostic));
	_tmp62_.severity = (guint32) _tmp56_;
	_tmp62_.fixits = (_vala_Fixit_array_free (_tmp62_.fixits, _tmp62_.fixits_length1), NULL);
	_tmp62_.fixits = _tmp57_;
	_tmp62_.fixits_length1 = 0;
	_tmp62_.locations = (g_free (_tmp62_.locations), NULL);
	_tmp62_.locations = _tmp59_;
	_tmp62_.locations_length1 = 1;
	_g_free0 (_tmp62_.message);
	_tmp62_.message = _tmp61_;
	_tmp63_ = _tmp62_;
	_tmp64_ = _tmp63_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp55_, &_tmp64_);
	diagnostic_destroy (&_tmp63_);
	_g_object_unref0 (diagnostics);
}


static void diagnostics_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	Diagnostics * self;
	const gchar* _tmp0_ = NULL;
	ValaSourceReference* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	self = (Diagnostics*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	g_log ("GcaVala", G_LOG_LEVEL_DEBUG, "diagnostics.vala:103: [err]: %s", _tmp0_);
	_tmp1_ = source;
	_tmp2_ = message;
	diagnostics_diags_report (self, _tmp1_, _tmp2_, SEVERITY_ERROR);
}


static void diagnostics_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	Diagnostics * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ValaSourceReference* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	self = (Diagnostics*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	g_log ("GcaVala", G_LOG_LEVEL_DEBUG, "diagnostics.vala:110: [warn]: %s", _tmp0_);
	_tmp1_ = vala_report_get_enable_warnings ((ValaReport*) self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = source;
	_tmp4_ = message;
	diagnostics_diags_report (self, _tmp3_, _tmp4_, SEVERITY_WARNING);
}


static void diagnostics_real_depr (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	Diagnostics * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ValaSourceReference* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	self = (Diagnostics*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	g_log ("GcaVala", G_LOG_LEVEL_DEBUG, "diagnostics.vala:122: [depr]: %s", _tmp0_);
	_tmp1_ = vala_report_get_enable_warnings ((ValaReport*) self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = source;
	_tmp4_ = message;
	diagnostics_diags_report (self, _tmp3_, _tmp4_, SEVERITY_DEPRECATED);
}


static void diagnostics_real_note (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	Diagnostics * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ValaSourceReference* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	self = (Diagnostics*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	g_log ("GcaVala", G_LOG_LEVEL_DEBUG, "diagnostics.vala:134: [note]: %s", _tmp0_);
	_tmp1_ = vala_report_get_enable_warnings ((ValaReport*) self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = source;
	_tmp4_ = message;
	diagnostics_diags_report (self, _tmp3_, _tmp4_, SEVERITY_INFO);
}


static void diagnostics_class_init (DiagnosticsClass * klass) {
	diagnostics_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DiagnosticsPrivate));
	VALA_REPORT_CLASS (klass)->err = diagnostics_real_err;
	VALA_REPORT_CLASS (klass)->warn = diagnostics_real_warn;
	VALA_REPORT_CLASS (klass)->depr = diagnostics_real_depr;
	VALA_REPORT_CLASS (klass)->note = diagnostics_real_note;
	G_OBJECT_CLASS (klass)->finalize = diagnostics_finalize;
}


static void diagnostics_instance_init (Diagnostics * self) {
	self->priv = DIAGNOSTICS_GET_PRIVATE (self);
}


static void diagnostics_finalize (GObject* obj) {
	Diagnostics * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIAGNOSTICS, Diagnostics);
	_g_object_unref0 (self->priv->d_diagnostics);
	G_OBJECT_CLASS (diagnostics_parent_class)->finalize (obj);
}


GType diagnostics_get_type (void) {
	static volatile gsize diagnostics_type_id__volatile = 0;
	if (g_once_init_enter (&diagnostics_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DiagnosticsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) diagnostics_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Diagnostics), 0, (GInstanceInitFunc) diagnostics_instance_init, NULL };
		GType diagnostics_type_id;
		diagnostics_type_id = g_type_register_static (VALA_TYPE_REPORT, "Diagnostics", &g_define_type_info, 0);
		g_once_init_leave (&diagnostics_type_id__volatile, diagnostics_type_id);
	}
	return diagnostics_type_id__volatile;
}



