/* benchmark.c generated by valac 0.26.0, the Vala compiler
 * generated from benchmark.vala, do not modify */

/* benchmark.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois

 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gee-internals.h>
#include <math.h>
#include <float.h>

#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GEE_BENCHMARK_TYPE_FACTORY (gee_benchmark_factory_get_type ())
#define GEE_BENCHMARK_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_FACTORY, GeeBenchmarkFactory))
#define GEE_BENCHMARK_IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_FACTORY))
#define GEE_BENCHMARK_FACTORY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_BENCHMARK_TYPE_FACTORY, GeeBenchmarkFactoryIface))

typedef struct _GeeBenchmarkFactory GeeBenchmarkFactory;
typedef struct _GeeBenchmarkFactoryIface GeeBenchmarkFactoryIface;

#define GEE_BENCHMARK_TYPE_GENERATOR (gee_benchmark_generator_get_type ())
#define GEE_BENCHMARK_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_GENERATOR, GeeBenchmarkGenerator))
#define GEE_BENCHMARK_IS_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_GENERATOR))
#define GEE_BENCHMARK_GENERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_BENCHMARK_TYPE_GENERATOR, GeeBenchmarkGeneratorIface))

typedef struct _GeeBenchmarkGenerator GeeBenchmarkGenerator;
typedef struct _GeeBenchmarkGeneratorIface GeeBenchmarkGeneratorIface;

#define GEE_BENCHMARK_TYPE_ALGORITHM (gee_benchmark_algorithm_get_type ())
#define GEE_BENCHMARK_ALGORITHM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_ALGORITHM, GeeBenchmarkAlgorithm))
#define GEE_BENCHMARK_IS_ALGORITHM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_ALGORITHM))
#define GEE_BENCHMARK_ALGORITHM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_BENCHMARK_TYPE_ALGORITHM, GeeBenchmarkAlgorithmIface))

typedef struct _GeeBenchmarkAlgorithm GeeBenchmarkAlgorithm;
typedef struct _GeeBenchmarkAlgorithmIface GeeBenchmarkAlgorithmIface;

#define GEE_BENCHMARK_TYPE_RANDOM_INT32 (gee_benchmark_random_int32_get_type ())
#define GEE_BENCHMARK_RANDOM_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_RANDOM_INT32, GeeBenchmarkRandomInt32))
#define GEE_BENCHMARK_RANDOM_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_RANDOM_INT32, GeeBenchmarkRandomInt32Class))
#define GEE_BENCHMARK_IS_RANDOM_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_RANDOM_INT32))
#define GEE_BENCHMARK_IS_RANDOM_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_RANDOM_INT32))
#define GEE_BENCHMARK_RANDOM_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_RANDOM_INT32, GeeBenchmarkRandomInt32Class))

typedef struct _GeeBenchmarkRandomInt32 GeeBenchmarkRandomInt32;
typedef struct _GeeBenchmarkRandomInt32Class GeeBenchmarkRandomInt32Class;
typedef struct _GeeBenchmarkRandomInt32Private GeeBenchmarkRandomInt32Private;

#define GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32 (gee_benchmark_fixed_variance_int32_get_type ())
#define GEE_BENCHMARK_FIXED_VARIANCE_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32, GeeBenchmarkFixedVarianceInt32))
#define GEE_BENCHMARK_FIXED_VARIANCE_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32, GeeBenchmarkFixedVarianceInt32Class))
#define GEE_BENCHMARK_IS_FIXED_VARIANCE_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32))
#define GEE_BENCHMARK_IS_FIXED_VARIANCE_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32))
#define GEE_BENCHMARK_FIXED_VARIANCE_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32, GeeBenchmarkFixedVarianceInt32Class))

typedef struct _GeeBenchmarkFixedVarianceInt32 GeeBenchmarkFixedVarianceInt32;
typedef struct _GeeBenchmarkFixedVarianceInt32Class GeeBenchmarkFixedVarianceInt32Class;
typedef struct _GeeBenchmarkFixedVarianceInt32Private GeeBenchmarkFixedVarianceInt32Private;

#define GEE_BENCHMARK_TYPE_MOUNTS_INT32 (gee_benchmark_mounts_int32_get_type ())
#define GEE_BENCHMARK_MOUNTS_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_MOUNTS_INT32, GeeBenchmarkMountsInt32))
#define GEE_BENCHMARK_MOUNTS_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_MOUNTS_INT32, GeeBenchmarkMountsInt32Class))
#define GEE_BENCHMARK_IS_MOUNTS_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_MOUNTS_INT32))
#define GEE_BENCHMARK_IS_MOUNTS_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_MOUNTS_INT32))
#define GEE_BENCHMARK_MOUNTS_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_MOUNTS_INT32, GeeBenchmarkMountsInt32Class))

typedef struct _GeeBenchmarkMountsInt32 GeeBenchmarkMountsInt32;
typedef struct _GeeBenchmarkMountsInt32Class GeeBenchmarkMountsInt32Class;
typedef struct _GeeBenchmarkMountsInt32Private GeeBenchmarkMountsInt32Private;

#define GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32 (gee_benchmark_reverse_sorted_int32_get_type ())
#define GEE_BENCHMARK_REVERSE_SORTED_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32, GeeBenchmarkReverseSortedInt32))
#define GEE_BENCHMARK_REVERSE_SORTED_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32, GeeBenchmarkReverseSortedInt32Class))
#define GEE_BENCHMARK_IS_REVERSE_SORTED_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32))
#define GEE_BENCHMARK_IS_REVERSE_SORTED_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32))
#define GEE_BENCHMARK_REVERSE_SORTED_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32, GeeBenchmarkReverseSortedInt32Class))

typedef struct _GeeBenchmarkReverseSortedInt32 GeeBenchmarkReverseSortedInt32;
typedef struct _GeeBenchmarkReverseSortedInt32Class GeeBenchmarkReverseSortedInt32Class;
typedef struct _GeeBenchmarkReverseSortedInt32Private GeeBenchmarkReverseSortedInt32Private;

#define GEE_BENCHMARK_TYPE_SORTED_INT32 (gee_benchmark_sorted_int32_get_type ())
#define GEE_BENCHMARK_SORTED_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_SORTED_INT32, GeeBenchmarkSortedInt32))
#define GEE_BENCHMARK_SORTED_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_SORTED_INT32, GeeBenchmarkSortedInt32Class))
#define GEE_BENCHMARK_IS_SORTED_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_SORTED_INT32))
#define GEE_BENCHMARK_IS_SORTED_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_SORTED_INT32))
#define GEE_BENCHMARK_SORTED_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_SORTED_INT32, GeeBenchmarkSortedInt32Class))

typedef struct _GeeBenchmarkSortedInt32 GeeBenchmarkSortedInt32;
typedef struct _GeeBenchmarkSortedInt32Class GeeBenchmarkSortedInt32Class;
typedef struct _GeeBenchmarkSortedInt32Private GeeBenchmarkSortedInt32Private;

#define GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY (gee_benchmark_array_list_factory_get_type ())
#define GEE_BENCHMARK_ARRAY_LIST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactory))
#define GEE_BENCHMARK_ARRAY_LIST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactoryClass))
#define GEE_BENCHMARK_IS_ARRAY_LIST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY))
#define GEE_BENCHMARK_IS_ARRAY_LIST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY))
#define GEE_BENCHMARK_ARRAY_LIST_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactoryClass))

typedef struct _GeeBenchmarkArrayListFactory GeeBenchmarkArrayListFactory;
typedef struct _GeeBenchmarkArrayListFactoryClass GeeBenchmarkArrayListFactoryClass;
typedef struct _GeeBenchmarkArrayListFactoryPrivate GeeBenchmarkArrayListFactoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_BENCHMARK_TYPE_BENCHMARK (gee_benchmark_benchmark_get_type ())
#define GEE_BENCHMARK_BENCHMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmark))
#define GEE_BENCHMARK_BENCHMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmarkClass))
#define GEE_BENCHMARK_IS_BENCHMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_BENCHMARK))
#define GEE_BENCHMARK_IS_BENCHMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_BENCHMARK))
#define GEE_BENCHMARK_BENCHMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmarkClass))

typedef struct _GeeBenchmarkBenchmark GeeBenchmarkBenchmark;
typedef struct _GeeBenchmarkBenchmarkClass GeeBenchmarkBenchmarkClass;
typedef struct _GeeBenchmarkBenchmarkPrivate GeeBenchmarkBenchmarkPrivate;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _GeeBenchmarkFactoryIface {
	GTypeInterface parent_iface;
	GeeCollection* (*create) (GeeBenchmarkFactory* self);
	GeeCollection* (*copy) (GeeBenchmarkFactory* self, GeeCollection* collection);
};

struct _GeeBenchmarkGeneratorIface {
	GTypeInterface parent_iface;
	void (*generate_collection) (GeeBenchmarkGenerator* self, gint size, GeeCollection* collection);
	const gchar* (*get_name) (GeeBenchmarkGenerator* self);
};

struct _GeeBenchmarkAlgorithmIface {
	GTypeInterface parent_iface;
	void (*process_collection) (GeeBenchmarkAlgorithm* self, GeeCollection* collection);
	const gchar* (*get_name) (GeeBenchmarkAlgorithm* self);
};

struct _GeeBenchmarkRandomInt32 {
	GObject parent_instance;
	GeeBenchmarkRandomInt32Private * priv;
};

struct _GeeBenchmarkRandomInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkFixedVarianceInt32 {
	GObject parent_instance;
	GeeBenchmarkFixedVarianceInt32Private * priv;
};

struct _GeeBenchmarkFixedVarianceInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkMountsInt32 {
	GObject parent_instance;
	GeeBenchmarkMountsInt32Private * priv;
};

struct _GeeBenchmarkMountsInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkReverseSortedInt32 {
	GObject parent_instance;
	GeeBenchmarkReverseSortedInt32Private * priv;
};

struct _GeeBenchmarkReverseSortedInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkSortedInt32 {
	GObject parent_instance;
	GeeBenchmarkSortedInt32Private * priv;
};

struct _GeeBenchmarkSortedInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkArrayListFactory {
	GObject parent_instance;
	GeeBenchmarkArrayListFactoryPrivate * priv;
};

struct _GeeBenchmarkArrayListFactoryClass {
	GObjectClass parent_class;
};

struct _GeeBenchmarkArrayListFactoryPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeeBenchmarkBenchmark {
	GObject parent_instance;
	GeeBenchmarkBenchmarkPrivate * priv;
};

struct _GeeBenchmarkBenchmarkClass {
	GObjectClass parent_class;
};

struct _GeeBenchmarkBenchmarkPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeBenchmarkFactory* factory;
	gint* sizes;
	gint sizes_length1;
	gint _sizes_size_;
	GeeList* generators;
	GeeList* algorithms;
	gint iteration_count;
	gdouble* results_sum;
	gint results_sum_length1;
	gint results_sum_length2;
	gint results_sum_length3;
	gdouble* results_squared_sum;
	gint results_squared_sum_length1;
	gint results_squared_sum_length2;
	gint results_squared_sum_length3;
};


static gpointer gee_benchmark_random_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface* gee_benchmark_random_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_fixed_variance_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface* gee_benchmark_fixed_variance_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_mounts_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface* gee_benchmark_mounts_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_reverse_sorted_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface* gee_benchmark_reverse_sorted_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_sorted_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface* gee_benchmark_sorted_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_array_list_factory_parent_class = NULL;
static GeeBenchmarkFactoryIface* gee_benchmark_array_list_factory_gee_benchmark_factory_parent_iface = NULL;
static gpointer gee_benchmark_benchmark_parent_class = NULL;

G_GNUC_INTERNAL void gee_benchmark_run_benchmark_option (const gchar* long_name, gchar short_name, const gchar* description, gboolean* do_run, GOptionEntry* result);
G_GNUC_INTERNAL gint gee_benchmark_main (gchar** args, int args_length1);
void gee_benchmark_benchmark_sorts (void);
GType gee_benchmark_factory_get_type (void) G_GNUC_CONST;
GeeCollection* gee_benchmark_factory_create (GeeBenchmarkFactory* self);
GeeCollection* gee_benchmark_factory_copy (GeeBenchmarkFactory* self, GeeCollection* collection);
GType gee_benchmark_generator_get_type (void) G_GNUC_CONST;
void gee_benchmark_generator_generate_collection (GeeBenchmarkGenerator* self, gint size, GeeCollection* collection);
const gchar* gee_benchmark_generator_get_name (GeeBenchmarkGenerator* self);
GType gee_benchmark_algorithm_get_type (void) G_GNUC_CONST;
void gee_benchmark_algorithm_process_collection (GeeBenchmarkAlgorithm* self, GeeCollection* collection);
const gchar* gee_benchmark_algorithm_get_name (GeeBenchmarkAlgorithm* self);
GType gee_benchmark_random_int32_get_type (void) G_GNUC_CONST;
enum  {
	GEE_BENCHMARK_RANDOM_INT32_DUMMY_PROPERTY,
	GEE_BENCHMARK_RANDOM_INT32_NAME
};
static void gee_benchmark_random_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection);
GeeBenchmarkRandomInt32* gee_benchmark_random_int32_new (void);
GeeBenchmarkRandomInt32* gee_benchmark_random_int32_construct (GType object_type);
static void _vala_gee_benchmark_random_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType gee_benchmark_fixed_variance_int32_get_type (void) G_GNUC_CONST;
enum  {
	GEE_BENCHMARK_FIXED_VARIANCE_INT32_DUMMY_PROPERTY,
	GEE_BENCHMARK_FIXED_VARIANCE_INT32_NAME
};
static void gee_benchmark_fixed_variance_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection);
GeeBenchmarkFixedVarianceInt32* gee_benchmark_fixed_variance_int32_new (void);
GeeBenchmarkFixedVarianceInt32* gee_benchmark_fixed_variance_int32_construct (GType object_type);
static void _vala_gee_benchmark_fixed_variance_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType gee_benchmark_mounts_int32_get_type (void) G_GNUC_CONST;
enum  {
	GEE_BENCHMARK_MOUNTS_INT32_DUMMY_PROPERTY,
	GEE_BENCHMARK_MOUNTS_INT32_NAME
};
static void gee_benchmark_mounts_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection);
GeeBenchmarkMountsInt32* gee_benchmark_mounts_int32_new (void);
GeeBenchmarkMountsInt32* gee_benchmark_mounts_int32_construct (GType object_type);
static void _vala_gee_benchmark_mounts_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType gee_benchmark_reverse_sorted_int32_get_type (void) G_GNUC_CONST;
enum  {
	GEE_BENCHMARK_REVERSE_SORTED_INT32_DUMMY_PROPERTY,
	GEE_BENCHMARK_REVERSE_SORTED_INT32_NAME
};
static void gee_benchmark_reverse_sorted_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection);
GeeBenchmarkReverseSortedInt32* gee_benchmark_reverse_sorted_int32_new (void);
GeeBenchmarkReverseSortedInt32* gee_benchmark_reverse_sorted_int32_construct (GType object_type);
static void _vala_gee_benchmark_reverse_sorted_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType gee_benchmark_sorted_int32_get_type (void) G_GNUC_CONST;
enum  {
	GEE_BENCHMARK_SORTED_INT32_DUMMY_PROPERTY,
	GEE_BENCHMARK_SORTED_INT32_NAME
};
static void gee_benchmark_sorted_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection);
GeeBenchmarkSortedInt32* gee_benchmark_sorted_int32_new (void);
GeeBenchmarkSortedInt32* gee_benchmark_sorted_int32_construct (GType object_type);
static void _vala_gee_benchmark_sorted_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType gee_benchmark_array_list_factory_get_type (void) G_GNUC_CONST;
#define GEE_BENCHMARK_ARRAY_LIST_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactoryPrivate))
enum  {
	GEE_BENCHMARK_ARRAY_LIST_FACTORY_DUMMY_PROPERTY,
	GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_TYPE,
	GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DUP_FUNC,
	GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DESTROY_FUNC
};
static GeeCollection* gee_benchmark_array_list_factory_real_create (GeeBenchmarkFactory* base);
static GeeCollection* gee_benchmark_array_list_factory_real_copy (GeeBenchmarkFactory* base, GeeCollection* collection);
GeeBenchmarkArrayListFactory* gee_benchmark_array_list_factory_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeBenchmarkArrayListFactory* gee_benchmark_array_list_factory_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static void _vala_gee_benchmark_array_list_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_benchmark_array_list_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gee_benchmark_benchmark_get_type (void) G_GNUC_CONST;
#define GEE_BENCHMARK_BENCHMARK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmarkPrivate))
enum  {
	GEE_BENCHMARK_BENCHMARK_DUMMY_PROPERTY,
	GEE_BENCHMARK_BENCHMARK_G_TYPE,
	GEE_BENCHMARK_BENCHMARK_G_DUP_FUNC,
	GEE_BENCHMARK_BENCHMARK_G_DESTROY_FUNC
};
GeeBenchmarkBenchmark* gee_benchmark_benchmark_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeBenchmarkFactory* factory, GeeList* algorithms, GeeList* generators, gint* sizes, int sizes_length1, gint iteration_count);
GeeBenchmarkBenchmark* gee_benchmark_benchmark_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeBenchmarkFactory* factory, GeeList* algorithms, GeeList* generators, gint* sizes, int sizes_length1, gint iteration_count);
static gint* _vala_array_dup1 (gint* self, int length);
void gee_benchmark_benchmark_run (GeeBenchmarkBenchmark* self);
void gee_benchmark_benchmark_display_results (GeeBenchmarkBenchmark* self, gint iteration);
static void gee_benchmark_benchmark_finalize (GObject* obj);
static void _vala_gee_benchmark_benchmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_benchmark_benchmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


G_GNUC_INTERNAL void gee_benchmark_run_benchmark_option (const gchar* long_name, gchar short_name, const gchar* description, gboolean* do_run, GOptionEntry* result) {
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	const gchar* _tmp2_ = NULL;
	GOptionEntry _tmp3_ = {0};
	g_return_if_fail (long_name != NULL);
	g_return_if_fail (description != NULL);
	_tmp0_ = long_name;
	_tmp1_ = short_name;
	_tmp2_ = description;
	memset (&_tmp3_, 0, sizeof (GOptionEntry));
	_tmp3_.long_name = _tmp0_;
	_tmp3_.short_name = _tmp1_;
	_tmp3_.flags = 0;
	_tmp3_.arg = G_OPTION_ARG_NONE;
	_tmp3_.arg_data = do_run;
	_tmp3_.description = _tmp2_;
	_tmp3_.arg_description = NULL;
	*result = _tmp3_;
	return;
}


G_GNUC_INTERNAL gint gee_benchmark_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean run_sort = FALSE;
	GOptionEntry* entries = NULL;
	GOptionEntry _tmp0_ = {0};
	GOptionEntry* _tmp1_ = NULL;
	gint entries_length1 = 0;
	gint _entries_size_ = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionEntry* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gboolean _tmp9_ = FALSE;
	GError * _inner_error_ = NULL;
	run_sort = FALSE;
	gee_benchmark_run_benchmark_option ("run-sort", 's', "Run sorting benchmark", &run_sort, &_tmp0_);
	_tmp1_ = g_new0 (GOptionEntry, 1);
	_tmp1_[0] = _tmp0_;
	entries = _tmp1_;
	entries_length1 = 1;
	_entries_size_ = entries_length1;
	_tmp2_ = g_option_context_new ("Run various benchmarks");
	context = _tmp2_;
	_tmp3_ = context;
	_tmp4_ = entries;
	_tmp4__length1 = entries_length1;
	g_option_context_add_main_entries (_tmp3_, _tmp4_, "gee-benchmark");
	{
		GOptionContext* _tmp5_ = NULL;
		_tmp5_ = context;
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (context);
			entries = (g_free (entries), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stdout;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "option parsing failed: %s\n", _tmp8_);
		result = 2;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		entries = (g_free (entries), NULL);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		entries = (g_free (entries), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = run_sort;
	if (_tmp9_) {
		gee_benchmark_benchmark_sorts ();
	}
	result = 0;
	_g_option_context_free0 (context);
	entries = (g_free (entries), NULL);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return gee_benchmark_main (argv, argc);
}


GeeCollection* gee_benchmark_factory_create (GeeBenchmarkFactory* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_BENCHMARK_FACTORY_GET_INTERFACE (self)->create (self);
}


GeeCollection* gee_benchmark_factory_copy (GeeBenchmarkFactory* self, GeeCollection* collection) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_BENCHMARK_FACTORY_GET_INTERFACE (self)->copy (self, collection);
}


static void gee_benchmark_factory_base_init (GeeBenchmarkFactoryIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType gee_benchmark_factory_get_type (void) {
	static volatile gsize gee_benchmark_factory_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkFactoryIface), (GBaseInitFunc) gee_benchmark_factory_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_benchmark_factory_type_id;
		gee_benchmark_factory_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeBenchmarkFactory", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_benchmark_factory_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_benchmark_factory_type_id__volatile, gee_benchmark_factory_type_id);
	}
	return gee_benchmark_factory_type_id__volatile;
}


void gee_benchmark_generator_generate_collection (GeeBenchmarkGenerator* self, gint size, GeeCollection* collection) {
	g_return_if_fail (self != NULL);
	GEE_BENCHMARK_GENERATOR_GET_INTERFACE (self)->generate_collection (self, size, collection);
}


const gchar* gee_benchmark_generator_get_name (GeeBenchmarkGenerator* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_BENCHMARK_GENERATOR_GET_INTERFACE (self)->get_name (self);
}


static void gee_benchmark_generator_base_init (GeeBenchmarkGeneratorIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


GType gee_benchmark_generator_get_type (void) {
	static volatile gsize gee_benchmark_generator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_generator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkGeneratorIface), (GBaseInitFunc) gee_benchmark_generator_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_benchmark_generator_type_id;
		gee_benchmark_generator_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeBenchmarkGenerator", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_benchmark_generator_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_benchmark_generator_type_id__volatile, gee_benchmark_generator_type_id);
	}
	return gee_benchmark_generator_type_id__volatile;
}


void gee_benchmark_algorithm_process_collection (GeeBenchmarkAlgorithm* self, GeeCollection* collection) {
	g_return_if_fail (self != NULL);
	GEE_BENCHMARK_ALGORITHM_GET_INTERFACE (self)->process_collection (self, collection);
}


const gchar* gee_benchmark_algorithm_get_name (GeeBenchmarkAlgorithm* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_BENCHMARK_ALGORITHM_GET_INTERFACE (self)->get_name (self);
}


static void gee_benchmark_algorithm_base_init (GeeBenchmarkAlgorithmIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


GType gee_benchmark_algorithm_get_type (void) {
	static volatile gsize gee_benchmark_algorithm_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_algorithm_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkAlgorithmIface), (GBaseInitFunc) gee_benchmark_algorithm_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_benchmark_algorithm_type_id;
		gee_benchmark_algorithm_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeBenchmarkAlgorithm", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_benchmark_algorithm_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_benchmark_algorithm_type_id__volatile, gee_benchmark_algorithm_type_id);
	}
	return gee_benchmark_algorithm_type_id__volatile;
}


static void gee_benchmark_random_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection) {
	GeeBenchmarkRandomInt32 * self;
	self = (GeeBenchmarkRandomInt32*) base;
	g_return_if_fail (collection != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				GeeCollection* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint32 _tmp6_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = size;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp4_ = collection;
				_tmp5_ = size;
				_tmp6_ = g_random_int_range ((gint32) 0, (gint32) (_tmp5_ - 1));
				gee_collection_add (_tmp4_, (gpointer) ((gintptr) _tmp6_));
			}
		}
	}
}


GeeBenchmarkRandomInt32* gee_benchmark_random_int32_construct (GType object_type) {
	GeeBenchmarkRandomInt32 * self = NULL;
	self = (GeeBenchmarkRandomInt32*) g_object_new (object_type, NULL);
	return self;
}


GeeBenchmarkRandomInt32* gee_benchmark_random_int32_new (void) {
	return gee_benchmark_random_int32_construct (GEE_BENCHMARK_TYPE_RANDOM_INT32);
}


static const gchar* gee_benchmark_random_int32_real_get_name (GeeBenchmarkGenerator* base) {
	const gchar* result;
	GeeBenchmarkRandomInt32* self;
	self = (GeeBenchmarkRandomInt32*) base;
	result = "FullRandom";
	return result;
}


static void gee_benchmark_random_int32_class_init (GeeBenchmarkRandomInt32Class * klass) {
	gee_benchmark_random_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_random_int32_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_RANDOM_INT32_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_benchmark_random_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface) {
	gee_benchmark_random_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*)(GeeBenchmarkGenerator*, gint, GeeCollection*)) gee_benchmark_random_int32_real_generate_collection;
	iface->get_name = gee_benchmark_random_int32_real_get_name;
}


static void gee_benchmark_random_int32_instance_init (GeeBenchmarkRandomInt32 * self) {
}


GType gee_benchmark_random_int32_get_type (void) {
	static volatile gsize gee_benchmark_random_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_random_int32_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkRandomInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_random_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkRandomInt32), 0, (GInstanceInitFunc) gee_benchmark_random_int32_instance_init, NULL };
		static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_random_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_benchmark_random_int32_type_id;
		gee_benchmark_random_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkRandomInt32", &g_define_type_info, 0);
		g_type_add_interface_static (gee_benchmark_random_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
		g_once_init_leave (&gee_benchmark_random_int32_type_id__volatile, gee_benchmark_random_int32_type_id);
	}
	return gee_benchmark_random_int32_type_id__volatile;
}


static void _vala_gee_benchmark_random_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkRandomInt32 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_RANDOM_INT32, GeeBenchmarkRandomInt32);
	switch (property_id) {
		case GEE_BENCHMARK_RANDOM_INT32_NAME:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_benchmark_fixed_variance_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection) {
	GeeBenchmarkFixedVarianceInt32 * self;
	gint variance = 0;
	gint _tmp0_ = 0;
	gdouble _tmp1_ = 0.0;
	self = (GeeBenchmarkFixedVarianceInt32*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = size;
	_tmp1_ = sqrt ((gdouble) _tmp0_);
	variance = (gint) _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				GeeCollection* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gint32 _tmp9_ = 0;
				gint _tmp10_ = 0;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = size;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = collection;
				_tmp7_ = i;
				_tmp8_ = variance;
				_tmp9_ = g_random_int_range ((gint32) 0, (gint32) _tmp8_);
				_tmp10_ = variance;
				gee_collection_add (_tmp6_, (gpointer) ((gintptr) ((gint32) ((_tmp7_ + _tmp9_) - (_tmp10_ / 2)))));
			}
		}
	}
}


GeeBenchmarkFixedVarianceInt32* gee_benchmark_fixed_variance_int32_construct (GType object_type) {
	GeeBenchmarkFixedVarianceInt32 * self = NULL;
	self = (GeeBenchmarkFixedVarianceInt32*) g_object_new (object_type, NULL);
	return self;
}


GeeBenchmarkFixedVarianceInt32* gee_benchmark_fixed_variance_int32_new (void) {
	return gee_benchmark_fixed_variance_int32_construct (GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32);
}


static const gchar* gee_benchmark_fixed_variance_int32_real_get_name (GeeBenchmarkGenerator* base) {
	const gchar* result;
	GeeBenchmarkFixedVarianceInt32* self;
	self = (GeeBenchmarkFixedVarianceInt32*) base;
	result = "FixedVariance";
	return result;
}


static void gee_benchmark_fixed_variance_int32_class_init (GeeBenchmarkFixedVarianceInt32Class * klass) {
	gee_benchmark_fixed_variance_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_fixed_variance_int32_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_FIXED_VARIANCE_INT32_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_benchmark_fixed_variance_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface) {
	gee_benchmark_fixed_variance_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*)(GeeBenchmarkGenerator*, gint, GeeCollection*)) gee_benchmark_fixed_variance_int32_real_generate_collection;
	iface->get_name = gee_benchmark_fixed_variance_int32_real_get_name;
}


static void gee_benchmark_fixed_variance_int32_instance_init (GeeBenchmarkFixedVarianceInt32 * self) {
}


GType gee_benchmark_fixed_variance_int32_get_type (void) {
	static volatile gsize gee_benchmark_fixed_variance_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_fixed_variance_int32_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkFixedVarianceInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_fixed_variance_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkFixedVarianceInt32), 0, (GInstanceInitFunc) gee_benchmark_fixed_variance_int32_instance_init, NULL };
		static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_fixed_variance_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_benchmark_fixed_variance_int32_type_id;
		gee_benchmark_fixed_variance_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkFixedVarianceInt32", &g_define_type_info, 0);
		g_type_add_interface_static (gee_benchmark_fixed_variance_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
		g_once_init_leave (&gee_benchmark_fixed_variance_int32_type_id__volatile, gee_benchmark_fixed_variance_int32_type_id);
	}
	return gee_benchmark_fixed_variance_int32_type_id__volatile;
}


static void _vala_gee_benchmark_fixed_variance_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkFixedVarianceInt32 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32, GeeBenchmarkFixedVarianceInt32);
	switch (property_id) {
		case GEE_BENCHMARK_FIXED_VARIANCE_INT32_NAME:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_benchmark_mounts_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection) {
	GeeBenchmarkMountsInt32 * self;
	gint index = 0;
	gint last = 0;
	gint variance = 0;
	gint _tmp0_ = 0;
	gdouble _tmp1_ = 0.0;
	self = (GeeBenchmarkMountsInt32*) base;
	g_return_if_fail (collection != NULL);
	index = 0;
	last = 0;
	_tmp0_ = size;
	_tmp1_ = sqrt ((gdouble) _tmp0_);
	variance = (gint) _tmp1_;
	while (TRUE) {
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint width = 0;
		gint _tmp4_ = 0;
		gint32 _tmp5_ = 0;
		gint height = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint32 _tmp8_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		_tmp2_ = index;
		_tmp3_ = size;
		if (!(_tmp2_ < _tmp3_)) {
			break;
		}
		_tmp4_ = variance;
		_tmp5_ = g_random_int_range ((gint32) 0, (gint32) _tmp4_);
		width = (gint) _tmp5_;
		_tmp6_ = variance;
		_tmp7_ = variance;
		_tmp8_ = g_random_int_range ((gint32) ((-_tmp6_) / 2), (gint32) (_tmp7_ / 2));
		height = (gint) _tmp8_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp9_ = FALSE;
				_tmp9_ = TRUE;
				while (TRUE) {
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					GeeCollection* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					if (!_tmp9_) {
						gint _tmp10_ = 0;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp9_ = FALSE;
					_tmp11_ = i;
					_tmp12_ = width;
					if (!(_tmp11_ < _tmp12_)) {
						break;
					}
					_tmp13_ = collection;
					_tmp14_ = last;
					_tmp15_ = height;
					_tmp16_ = width;
					gee_collection_add (_tmp13_, (gpointer) ((gintptr) ((gint32) (_tmp14_ + (_tmp15_ / _tmp16_)))));
				}
			}
		}
		_tmp17_ = index;
		_tmp18_ = width;
		index = _tmp17_ + _tmp18_;
		_tmp19_ = last;
		_tmp20_ = height;
		last = _tmp19_ + _tmp20_;
	}
}


GeeBenchmarkMountsInt32* gee_benchmark_mounts_int32_construct (GType object_type) {
	GeeBenchmarkMountsInt32 * self = NULL;
	self = (GeeBenchmarkMountsInt32*) g_object_new (object_type, NULL);
	return self;
}


GeeBenchmarkMountsInt32* gee_benchmark_mounts_int32_new (void) {
	return gee_benchmark_mounts_int32_construct (GEE_BENCHMARK_TYPE_MOUNTS_INT32);
}


static const gchar* gee_benchmark_mounts_int32_real_get_name (GeeBenchmarkGenerator* base) {
	const gchar* result;
	GeeBenchmarkMountsInt32* self;
	self = (GeeBenchmarkMountsInt32*) base;
	result = "Mounts";
	return result;
}


static void gee_benchmark_mounts_int32_class_init (GeeBenchmarkMountsInt32Class * klass) {
	gee_benchmark_mounts_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_mounts_int32_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_MOUNTS_INT32_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_benchmark_mounts_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface) {
	gee_benchmark_mounts_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*)(GeeBenchmarkGenerator*, gint, GeeCollection*)) gee_benchmark_mounts_int32_real_generate_collection;
	iface->get_name = gee_benchmark_mounts_int32_real_get_name;
}


static void gee_benchmark_mounts_int32_instance_init (GeeBenchmarkMountsInt32 * self) {
}


GType gee_benchmark_mounts_int32_get_type (void) {
	static volatile gsize gee_benchmark_mounts_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_mounts_int32_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkMountsInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_mounts_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkMountsInt32), 0, (GInstanceInitFunc) gee_benchmark_mounts_int32_instance_init, NULL };
		static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_mounts_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_benchmark_mounts_int32_type_id;
		gee_benchmark_mounts_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkMountsInt32", &g_define_type_info, 0);
		g_type_add_interface_static (gee_benchmark_mounts_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
		g_once_init_leave (&gee_benchmark_mounts_int32_type_id__volatile, gee_benchmark_mounts_int32_type_id);
	}
	return gee_benchmark_mounts_int32_type_id__volatile;
}


static void _vala_gee_benchmark_mounts_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkMountsInt32 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_MOUNTS_INT32, GeeBenchmarkMountsInt32);
	switch (property_id) {
		case GEE_BENCHMARK_MOUNTS_INT32_NAME:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_benchmark_reverse_sorted_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection) {
	GeeBenchmarkReverseSortedInt32 * self;
	self = (GeeBenchmarkReverseSortedInt32*) base;
	g_return_if_fail (collection != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				GeeCollection* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = size;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp4_ = collection;
				_tmp5_ = size;
				_tmp6_ = i;
				gee_collection_add (_tmp4_, (gpointer) ((gintptr) ((gint32) ((_tmp5_ - _tmp6_) - 1))));
			}
		}
	}
}


GeeBenchmarkReverseSortedInt32* gee_benchmark_reverse_sorted_int32_construct (GType object_type) {
	GeeBenchmarkReverseSortedInt32 * self = NULL;
	self = (GeeBenchmarkReverseSortedInt32*) g_object_new (object_type, NULL);
	return self;
}


GeeBenchmarkReverseSortedInt32* gee_benchmark_reverse_sorted_int32_new (void) {
	return gee_benchmark_reverse_sorted_int32_construct (GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32);
}


static const gchar* gee_benchmark_reverse_sorted_int32_real_get_name (GeeBenchmarkGenerator* base) {
	const gchar* result;
	GeeBenchmarkReverseSortedInt32* self;
	self = (GeeBenchmarkReverseSortedInt32*) base;
	result = "ReverseSorted";
	return result;
}


static void gee_benchmark_reverse_sorted_int32_class_init (GeeBenchmarkReverseSortedInt32Class * klass) {
	gee_benchmark_reverse_sorted_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_reverse_sorted_int32_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_REVERSE_SORTED_INT32_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_benchmark_reverse_sorted_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface) {
	gee_benchmark_reverse_sorted_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*)(GeeBenchmarkGenerator*, gint, GeeCollection*)) gee_benchmark_reverse_sorted_int32_real_generate_collection;
	iface->get_name = gee_benchmark_reverse_sorted_int32_real_get_name;
}


static void gee_benchmark_reverse_sorted_int32_instance_init (GeeBenchmarkReverseSortedInt32 * self) {
}


GType gee_benchmark_reverse_sorted_int32_get_type (void) {
	static volatile gsize gee_benchmark_reverse_sorted_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_reverse_sorted_int32_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkReverseSortedInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_reverse_sorted_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkReverseSortedInt32), 0, (GInstanceInitFunc) gee_benchmark_reverse_sorted_int32_instance_init, NULL };
		static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_reverse_sorted_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_benchmark_reverse_sorted_int32_type_id;
		gee_benchmark_reverse_sorted_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkReverseSortedInt32", &g_define_type_info, 0);
		g_type_add_interface_static (gee_benchmark_reverse_sorted_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
		g_once_init_leave (&gee_benchmark_reverse_sorted_int32_type_id__volatile, gee_benchmark_reverse_sorted_int32_type_id);
	}
	return gee_benchmark_reverse_sorted_int32_type_id__volatile;
}


static void _vala_gee_benchmark_reverse_sorted_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkReverseSortedInt32 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32, GeeBenchmarkReverseSortedInt32);
	switch (property_id) {
		case GEE_BENCHMARK_REVERSE_SORTED_INT32_NAME:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_benchmark_sorted_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection) {
	GeeBenchmarkSortedInt32 * self;
	self = (GeeBenchmarkSortedInt32*) base;
	g_return_if_fail (collection != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				GeeCollection* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = size;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp4_ = collection;
				_tmp5_ = i;
				gee_collection_add (_tmp4_, (gpointer) ((gintptr) ((gint32) _tmp5_)));
			}
		}
	}
}


GeeBenchmarkSortedInt32* gee_benchmark_sorted_int32_construct (GType object_type) {
	GeeBenchmarkSortedInt32 * self = NULL;
	self = (GeeBenchmarkSortedInt32*) g_object_new (object_type, NULL);
	return self;
}


GeeBenchmarkSortedInt32* gee_benchmark_sorted_int32_new (void) {
	return gee_benchmark_sorted_int32_construct (GEE_BENCHMARK_TYPE_SORTED_INT32);
}


static const gchar* gee_benchmark_sorted_int32_real_get_name (GeeBenchmarkGenerator* base) {
	const gchar* result;
	GeeBenchmarkSortedInt32* self;
	self = (GeeBenchmarkSortedInt32*) base;
	result = "Sorted";
	return result;
}


static void gee_benchmark_sorted_int32_class_init (GeeBenchmarkSortedInt32Class * klass) {
	gee_benchmark_sorted_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_sorted_int32_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_SORTED_INT32_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_benchmark_sorted_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface) {
	gee_benchmark_sorted_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*)(GeeBenchmarkGenerator*, gint, GeeCollection*)) gee_benchmark_sorted_int32_real_generate_collection;
	iface->get_name = gee_benchmark_sorted_int32_real_get_name;
}


static void gee_benchmark_sorted_int32_instance_init (GeeBenchmarkSortedInt32 * self) {
}


GType gee_benchmark_sorted_int32_get_type (void) {
	static volatile gsize gee_benchmark_sorted_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_sorted_int32_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkSortedInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_sorted_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkSortedInt32), 0, (GInstanceInitFunc) gee_benchmark_sorted_int32_instance_init, NULL };
		static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_sorted_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_benchmark_sorted_int32_type_id;
		gee_benchmark_sorted_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkSortedInt32", &g_define_type_info, 0);
		g_type_add_interface_static (gee_benchmark_sorted_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
		g_once_init_leave (&gee_benchmark_sorted_int32_type_id__volatile, gee_benchmark_sorted_int32_type_id);
	}
	return gee_benchmark_sorted_int32_type_id__volatile;
}


static void _vala_gee_benchmark_sorted_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkSortedInt32 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_SORTED_INT32, GeeBenchmarkSortedInt32);
	switch (property_id) {
		case GEE_BENCHMARK_SORTED_INT32_NAME:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static GeeCollection* gee_benchmark_array_list_factory_real_create (GeeBenchmarkFactory* base) {
	GeeBenchmarkArrayListFactory * self;
	GeeCollection* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	self = (GeeBenchmarkArrayListFactory*) base;
	_tmp0_ = gee_array_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, NULL, NULL, NULL);
	result = (GeeCollection*) _tmp0_;
	return result;
}


static GeeCollection* gee_benchmark_array_list_factory_real_copy (GeeBenchmarkFactory* base, GeeCollection* collection) {
	GeeBenchmarkArrayListFactory * self;
	GeeCollection* result = NULL;
	GeeArrayList* copy = NULL;
	GeeArrayList* _tmp0_ = NULL;
	self = (GeeBenchmarkArrayListFactory*) base;
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = gee_array_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, NULL, NULL, NULL);
	copy = _tmp0_;
	{
		GeeIterator* _item_it = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
		_tmp1_ = collection;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_item_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			gpointer item = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			GeeArrayList* _tmp7_ = NULL;
			gconstpointer _tmp8_ = NULL;
			_tmp3_ = _item_it;
			_tmp4_ = gee_iterator_next (_tmp3_);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = _item_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			item = _tmp6_;
			_tmp7_ = copy;
			_tmp8_ = item;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = (GeeCollection*) copy;
	return result;
}


GeeBenchmarkArrayListFactory* gee_benchmark_array_list_factory_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeBenchmarkArrayListFactory * self = NULL;
	self = (GeeBenchmarkArrayListFactory*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


GeeBenchmarkArrayListFactory* gee_benchmark_array_list_factory_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	return gee_benchmark_array_list_factory_construct (GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, g_type, g_dup_func, g_destroy_func);
}


static void gee_benchmark_array_list_factory_class_init (GeeBenchmarkArrayListFactoryClass * klass) {
	gee_benchmark_array_list_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeBenchmarkArrayListFactoryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_array_list_factory_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_benchmark_array_list_factory_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_benchmark_array_list_factory_gee_benchmark_factory_interface_init (GeeBenchmarkFactoryIface * iface) {
	gee_benchmark_array_list_factory_gee_benchmark_factory_parent_iface = g_type_interface_peek_parent (iface);
	iface->create = (GeeCollection* (*)(GeeBenchmarkFactory*)) gee_benchmark_array_list_factory_real_create;
	iface->copy = (GeeCollection* (*)(GeeBenchmarkFactory*, GeeCollection*)) gee_benchmark_array_list_factory_real_copy;
}


static void gee_benchmark_array_list_factory_instance_init (GeeBenchmarkArrayListFactory * self) {
	self->priv = GEE_BENCHMARK_ARRAY_LIST_FACTORY_GET_PRIVATE (self);
}


GType gee_benchmark_array_list_factory_get_type (void) {
	static volatile gsize gee_benchmark_array_list_factory_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_array_list_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkArrayListFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_array_list_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkArrayListFactory), 0, (GInstanceInitFunc) gee_benchmark_array_list_factory_instance_init, NULL };
		static const GInterfaceInfo gee_benchmark_factory_info = { (GInterfaceInitFunc) gee_benchmark_array_list_factory_gee_benchmark_factory_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_benchmark_array_list_factory_type_id;
		gee_benchmark_array_list_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkArrayListFactory", &g_define_type_info, 0);
		g_type_add_interface_static (gee_benchmark_array_list_factory_type_id, GEE_BENCHMARK_TYPE_FACTORY, &gee_benchmark_factory_info);
		g_once_init_leave (&gee_benchmark_array_list_factory_type_id__volatile, gee_benchmark_array_list_factory_type_id);
	}
	return gee_benchmark_array_list_factory_type_id__volatile;
}


static void _vala_gee_benchmark_array_list_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkArrayListFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactory);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_benchmark_array_list_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeBenchmarkArrayListFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactory);
	switch (property_id) {
		case GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint* _vala_array_dup1 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


GeeBenchmarkBenchmark* gee_benchmark_benchmark_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeBenchmarkFactory* factory, GeeList* algorithms, GeeList* generators, gint* sizes, int sizes_length1, gint iteration_count) {
	GeeBenchmarkBenchmark * self = NULL;
	GeeBenchmarkFactory* _tmp0_ = NULL;
	GeeBenchmarkFactory* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GeeList* _tmp6_ = NULL;
	GeeList* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	g_return_val_if_fail (factory != NULL, NULL);
	g_return_val_if_fail (algorithms != NULL, NULL);
	g_return_val_if_fail (generators != NULL, NULL);
	self = (GeeBenchmarkBenchmark*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = factory;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp1_;
	_tmp2_ = algorithms;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->algorithms);
	self->priv->algorithms = _tmp3_;
	_tmp4_ = sizes;
	_tmp4__length1 = sizes_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup1 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp4__length1;
	self->priv->sizes = (g_free (self->priv->sizes), NULL);
	self->priv->sizes = _tmp5_;
	self->priv->sizes_length1 = _tmp5__length1;
	self->priv->_sizes_size_ = self->priv->sizes_length1;
	_tmp6_ = generators;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->generators);
	self->priv->generators = _tmp7_;
	_tmp8_ = iteration_count;
	self->priv->iteration_count = _tmp8_;
	return self;
}


GeeBenchmarkBenchmark* gee_benchmark_benchmark_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeBenchmarkFactory* factory, GeeList* algorithms, GeeList* generators, gint* sizes, int sizes_length1, gint iteration_count) {
	return gee_benchmark_benchmark_construct (GEE_BENCHMARK_TYPE_BENCHMARK, g_type, g_dup_func, g_destroy_func, factory, algorithms, generators, sizes, sizes_length1, iteration_count);
}


void gee_benchmark_benchmark_run (GeeBenchmarkBenchmark* self) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GeeList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GeeList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gdouble* _tmp7_ = NULL;
	gint* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	GeeList* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GeeList* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gdouble* _tmp15_ = NULL;
	GTimer* timer = NULL;
	GTimer* _tmp42_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sizes;
	_tmp0__length1 = self->priv->sizes_length1;
	_tmp1_ = self->priv->generators;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->algorithms;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (gdouble, (_tmp0__length1 * _tmp3_) * _tmp6_);
	self->priv->results_sum = (g_free (self->priv->results_sum), NULL);
	self->priv->results_sum = _tmp7_;
	self->priv->results_sum_length1 = _tmp0__length1;
	self->priv->results_sum_length2 = _tmp3_;
	self->priv->results_sum_length3 = _tmp6_;
	_tmp8_ = self->priv->sizes;
	_tmp8__length1 = self->priv->sizes_length1;
	_tmp9_ = self->priv->generators;
	_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->algorithms;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_new0 (gdouble, (_tmp8__length1 * _tmp11_) * _tmp14_);
	self->priv->results_squared_sum = (g_free (self->priv->results_squared_sum), NULL);
	self->priv->results_squared_sum = _tmp15_;
	self->priv->results_squared_sum_length1 = _tmp8__length1;
	self->priv->results_squared_sum_length2 = _tmp11_;
	self->priv->results_squared_sum_length3 = _tmp14_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp18_ = 0;
				gint* _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				if (!_tmp16_) {
					gint _tmp17_ = 0;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = i;
				_tmp19_ = self->priv->sizes;
				_tmp19__length1 = self->priv->sizes_length1;
				if (!(_tmp18_ < _tmp19__length1)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp20_ = FALSE;
						_tmp20_ = TRUE;
						while (TRUE) {
							gint _tmp22_ = 0;
							GeeList* _tmp23_ = NULL;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							if (!_tmp20_) {
								gint _tmp21_ = 0;
								_tmp21_ = j;
								j = _tmp21_ + 1;
							}
							_tmp20_ = FALSE;
							_tmp22_ = j;
							_tmp23_ = self->priv->generators;
							_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
							_tmp25_ = _tmp24_;
							if (!(_tmp22_ < _tmp25_)) {
								break;
							}
							{
								gint k = 0;
								k = 0;
								{
									gboolean _tmp26_ = FALSE;
									_tmp26_ = TRUE;
									while (TRUE) {
										gint _tmp28_ = 0;
										GeeList* _tmp29_ = NULL;
										gint _tmp30_ = 0;
										gint _tmp31_ = 0;
										gdouble* _tmp32_ = NULL;
										gint _tmp32__length1 = 0;
										gint _tmp32__length2 = 0;
										gint _tmp32__length3 = 0;
										gint _tmp33_ = 0;
										gint _tmp34_ = 0;
										gint _tmp35_ = 0;
										gdouble _tmp36_ = 0.0;
										gdouble* _tmp37_ = NULL;
										gint _tmp37__length1 = 0;
										gint _tmp37__length2 = 0;
										gint _tmp37__length3 = 0;
										gint _tmp38_ = 0;
										gint _tmp39_ = 0;
										gint _tmp40_ = 0;
										gdouble _tmp41_ = 0.0;
										if (!_tmp26_) {
											gint _tmp27_ = 0;
											_tmp27_ = k;
											k = _tmp27_ + 1;
										}
										_tmp26_ = FALSE;
										_tmp28_ = k;
										_tmp29_ = self->priv->algorithms;
										_tmp30_ = gee_collection_get_size ((GeeCollection*) _tmp29_);
										_tmp31_ = _tmp30_;
										if (!(_tmp28_ < _tmp31_)) {
											break;
										}
										_tmp32_ = self->priv->results_sum;
										_tmp32__length1 = self->priv->results_sum_length1;
										_tmp32__length2 = self->priv->results_sum_length2;
										_tmp32__length3 = self->priv->results_sum_length3;
										_tmp33_ = i;
										_tmp34_ = j;
										_tmp35_ = k;
										_tmp32_[(((_tmp33_ * _tmp32__length2) + _tmp34_) * _tmp32__length3) + _tmp35_] = (gdouble) 0;
										_tmp36_ = _tmp32_[(((_tmp33_ * _tmp32__length2) + _tmp34_) * _tmp32__length3) + _tmp35_];
										_tmp37_ = self->priv->results_squared_sum;
										_tmp37__length1 = self->priv->results_squared_sum_length1;
										_tmp37__length2 = self->priv->results_squared_sum_length2;
										_tmp37__length3 = self->priv->results_squared_sum_length3;
										_tmp38_ = i;
										_tmp39_ = j;
										_tmp40_ = k;
										_tmp37_[(((_tmp38_ * _tmp37__length2) + _tmp39_) * _tmp37__length3) + _tmp40_] = (gdouble) 0;
										_tmp41_ = _tmp37_[(((_tmp38_ * _tmp37__length2) + _tmp39_) * _tmp37__length3) + _tmp40_];
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp42_ = g_timer_new ();
	timer = _tmp42_;
	{
		gint iteration = 0;
		iteration = 1;
		{
			gboolean _tmp43_ = FALSE;
			_tmp43_ = TRUE;
			while (TRUE) {
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				gint _tmp100_ = 0;
				FILE* _tmp103_ = NULL;
				gint _tmp104_ = 0;
				if (!_tmp43_) {
					gint _tmp44_ = 0;
					_tmp44_ = iteration;
					iteration = _tmp44_ + 1;
				}
				_tmp43_ = FALSE;
				_tmp45_ = iteration;
				_tmp46_ = self->priv->iteration_count;
				if (!(_tmp45_ <= _tmp46_)) {
					break;
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp47_ = FALSE;
						_tmp47_ = TRUE;
						while (TRUE) {
							gint _tmp49_ = 0;
							gint* _tmp50_ = NULL;
							gint _tmp50__length1 = 0;
							gint size = 0;
							gint* _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							if (!_tmp47_) {
								gint _tmp48_ = 0;
								_tmp48_ = i;
								i = _tmp48_ + 1;
							}
							_tmp47_ = FALSE;
							_tmp49_ = i;
							_tmp50_ = self->priv->sizes;
							_tmp50__length1 = self->priv->sizes_length1;
							if (!(_tmp49_ < _tmp50__length1)) {
								break;
							}
							_tmp51_ = self->priv->sizes;
							_tmp51__length1 = self->priv->sizes_length1;
							_tmp52_ = i;
							_tmp53_ = _tmp51_[_tmp52_];
							size = _tmp53_;
							{
								gint j = 0;
								j = 0;
								{
									gboolean _tmp54_ = FALSE;
									_tmp54_ = TRUE;
									while (TRUE) {
										gint _tmp56_ = 0;
										GeeList* _tmp57_ = NULL;
										gint _tmp58_ = 0;
										gint _tmp59_ = 0;
										GeeCollection* collection = NULL;
										GeeBenchmarkFactory* _tmp60_ = NULL;
										GeeCollection* _tmp61_ = NULL;
										GeeList* _tmp62_ = NULL;
										gint _tmp63_ = 0;
										gpointer _tmp64_ = NULL;
										GeeBenchmarkGenerator* _tmp65_ = NULL;
										gint _tmp66_ = 0;
										GeeCollection* _tmp67_ = NULL;
										if (!_tmp54_) {
											gint _tmp55_ = 0;
											_tmp55_ = j;
											j = _tmp55_ + 1;
										}
										_tmp54_ = FALSE;
										_tmp56_ = j;
										_tmp57_ = self->priv->generators;
										_tmp58_ = gee_collection_get_size ((GeeCollection*) _tmp57_);
										_tmp59_ = _tmp58_;
										if (!(_tmp56_ < _tmp59_)) {
											break;
										}
										_tmp60_ = self->priv->factory;
										_tmp61_ = gee_benchmark_factory_create (_tmp60_);
										collection = _tmp61_;
										_tmp62_ = self->priv->generators;
										_tmp63_ = j;
										_tmp64_ = gee_list_get (_tmp62_, _tmp63_);
										_tmp65_ = (GeeBenchmarkGenerator*) _tmp64_;
										_tmp66_ = size;
										_tmp67_ = collection;
										gee_benchmark_generator_generate_collection (_tmp65_, _tmp66_, _tmp67_);
										_g_object_unref0 (_tmp65_);
										{
											gint k = 0;
											k = 0;
											{
												gboolean _tmp68_ = FALSE;
												_tmp68_ = TRUE;
												while (TRUE) {
													gint _tmp70_ = 0;
													GeeList* _tmp71_ = NULL;
													gint _tmp72_ = 0;
													gint _tmp73_ = 0;
													GeeCollection* copy = NULL;
													GeeBenchmarkFactory* _tmp74_ = NULL;
													GeeCollection* _tmp75_ = NULL;
													GeeCollection* _tmp76_ = NULL;
													GTimer* _tmp77_ = NULL;
													GTimer* _tmp78_ = NULL;
													GeeList* _tmp79_ = NULL;
													gint _tmp80_ = 0;
													gpointer _tmp81_ = NULL;
													GeeBenchmarkAlgorithm* _tmp82_ = NULL;
													GeeCollection* _tmp83_ = NULL;
													GTimer* _tmp84_ = NULL;
													gdouble elapsed = 0.0;
													GTimer* _tmp85_ = NULL;
													gdouble _tmp86_ = 0.0;
													gdouble* _tmp87_ = NULL;
													gint _tmp87__length1 = 0;
													gint _tmp87__length2 = 0;
													gint _tmp87__length3 = 0;
													gint _tmp88_ = 0;
													gint _tmp89_ = 0;
													gint _tmp90_ = 0;
													gdouble _tmp91_ = 0.0;
													gdouble _tmp92_ = 0.0;
													gdouble* _tmp93_ = NULL;
													gint _tmp93__length1 = 0;
													gint _tmp93__length2 = 0;
													gint _tmp93__length3 = 0;
													gint _tmp94_ = 0;
													gint _tmp95_ = 0;
													gint _tmp96_ = 0;
													gdouble _tmp97_ = 0.0;
													gdouble _tmp98_ = 0.0;
													gdouble _tmp99_ = 0.0;
													if (!_tmp68_) {
														gint _tmp69_ = 0;
														_tmp69_ = k;
														k = _tmp69_ + 1;
													}
													_tmp68_ = FALSE;
													_tmp70_ = k;
													_tmp71_ = self->priv->algorithms;
													_tmp72_ = gee_collection_get_size ((GeeCollection*) _tmp71_);
													_tmp73_ = _tmp72_;
													if (!(_tmp70_ < _tmp73_)) {
														break;
													}
													_tmp74_ = self->priv->factory;
													_tmp75_ = collection;
													_tmp76_ = gee_benchmark_factory_copy (_tmp74_, _tmp75_);
													copy = _tmp76_;
													_tmp77_ = timer;
													g_timer_reset (_tmp77_);
													_tmp78_ = timer;
													g_timer_start (_tmp78_);
													_tmp79_ = self->priv->algorithms;
													_tmp80_ = k;
													_tmp81_ = gee_list_get (_tmp79_, _tmp80_);
													_tmp82_ = (GeeBenchmarkAlgorithm*) _tmp81_;
													_tmp83_ = copy;
													gee_benchmark_algorithm_process_collection (_tmp82_, _tmp83_);
													_g_object_unref0 (_tmp82_);
													_tmp84_ = timer;
													g_timer_stop (_tmp84_);
													_tmp85_ = timer;
													_tmp86_ = g_timer_elapsed (_tmp85_, NULL);
													elapsed = _tmp86_;
													_tmp87_ = self->priv->results_sum;
													_tmp87__length1 = self->priv->results_sum_length1;
													_tmp87__length2 = self->priv->results_sum_length2;
													_tmp87__length3 = self->priv->results_sum_length3;
													_tmp88_ = i;
													_tmp89_ = j;
													_tmp90_ = k;
													_tmp91_ = elapsed;
													_tmp87_[(((_tmp88_ * _tmp87__length2) + _tmp89_) * _tmp87__length3) + _tmp90_] += _tmp91_;
													_tmp92_ = _tmp87_[(((_tmp88_ * _tmp87__length2) + _tmp89_) * _tmp87__length3) + _tmp90_];
													_tmp93_ = self->priv->results_squared_sum;
													_tmp93__length1 = self->priv->results_squared_sum_length1;
													_tmp93__length2 = self->priv->results_squared_sum_length2;
													_tmp93__length3 = self->priv->results_squared_sum_length3;
													_tmp94_ = i;
													_tmp95_ = j;
													_tmp96_ = k;
													_tmp97_ = elapsed;
													_tmp98_ = pow (_tmp97_, (gdouble) 2);
													_tmp93_[(((_tmp94_ * _tmp93__length2) + _tmp95_) * _tmp93__length3) + _tmp96_] += _tmp98_;
													_tmp99_ = _tmp93_[(((_tmp94_ * _tmp93__length2) + _tmp95_) * _tmp93__length3) + _tmp96_];
													_g_object_unref0 (copy);
												}
											}
										}
										_g_object_unref0 (collection);
									}
								}
							}
						}
					}
				}
				_tmp100_ = iteration;
				if ((_tmp100_ % 10) == 0) {
					FILE* _tmp101_ = NULL;
					_tmp101_ = stdout;
					fprintf (_tmp101_, "|");
				} else {
					FILE* _tmp102_ = NULL;
					_tmp102_ = stdout;
					fprintf (_tmp102_, "*");
				}
				_tmp103_ = stdout;
				fflush (_tmp103_);
				_tmp104_ = iteration;
				if ((_tmp104_ % 100) == 0) {
					FILE* _tmp105_ = NULL;
					gint _tmp106_ = 0;
					_tmp105_ = stdout;
					fprintf (_tmp105_, "\n\n");
					_tmp106_ = iteration;
					gee_benchmark_benchmark_display_results (self, _tmp106_);
				}
			}
		}
	}
	_g_timer_destroy0 (timer);
}


void gee_benchmark_benchmark_display_results (GeeBenchmarkBenchmark* self, gint iteration) {
	FILE* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	FILE* _tmp66_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	_tmp1_ = iteration;
	fprintf (_tmp0_, "After %d iterations: (average [sample standard deviation] in seconds)\n" \
"\n", _tmp1_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				gint* _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				FILE* _tmp6_ = NULL;
				gint* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				FILE* _tmp10_ = NULL;
				FILE* _tmp24_ = NULL;
				FILE* _tmp65_ = NULL;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->priv->sizes;
				_tmp5__length1 = self->priv->sizes_length1;
				if (!(_tmp4_ < _tmp5__length1)) {
					break;
				}
				_tmp6_ = stdout;
				_tmp7_ = self->priv->sizes;
				_tmp7__length1 = self->priv->sizes_length1;
				_tmp8_ = i;
				_tmp9_ = _tmp7_[_tmp8_];
				fprintf (_tmp6_, "%d elements:\n", _tmp9_);
				_tmp10_ = stdout;
				fprintf (_tmp10_, "%20s\t", "");
				{
					gint k = 0;
					k = 0;
					{
						gboolean _tmp11_ = FALSE;
						_tmp11_ = TRUE;
						while (TRUE) {
							gint _tmp13_ = 0;
							GeeList* _tmp14_ = NULL;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							FILE* _tmp17_ = NULL;
							GeeList* _tmp18_ = NULL;
							gint _tmp19_ = 0;
							gpointer _tmp20_ = NULL;
							GeeBenchmarkAlgorithm* _tmp21_ = NULL;
							const gchar* _tmp22_ = NULL;
							const gchar* _tmp23_ = NULL;
							if (!_tmp11_) {
								gint _tmp12_ = 0;
								_tmp12_ = k;
								k = _tmp12_ + 1;
							}
							_tmp11_ = FALSE;
							_tmp13_ = k;
							_tmp14_ = self->priv->algorithms;
							_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
							_tmp16_ = _tmp15_;
							if (!(_tmp13_ < _tmp16_)) {
								break;
							}
							_tmp17_ = stdout;
							_tmp18_ = self->priv->algorithms;
							_tmp19_ = k;
							_tmp20_ = gee_list_get (_tmp18_, _tmp19_);
							_tmp21_ = (GeeBenchmarkAlgorithm*) _tmp20_;
							_tmp22_ = gee_benchmark_algorithm_get_name (_tmp21_);
							_tmp23_ = _tmp22_;
							fprintf (_tmp17_, "%-20s\t", _tmp23_);
							_g_object_unref0 (_tmp21_);
						}
					}
				}
				_tmp24_ = stdout;
				fprintf (_tmp24_, "\n");
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp25_ = FALSE;
						_tmp25_ = TRUE;
						while (TRUE) {
							gint _tmp27_ = 0;
							GeeList* _tmp28_ = NULL;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							FILE* _tmp31_ = NULL;
							GeeList* _tmp32_ = NULL;
							gint _tmp33_ = 0;
							gpointer _tmp34_ = NULL;
							GeeBenchmarkGenerator* _tmp35_ = NULL;
							const gchar* _tmp36_ = NULL;
							const gchar* _tmp37_ = NULL;
							FILE* _tmp64_ = NULL;
							if (!_tmp25_) {
								gint _tmp26_ = 0;
								_tmp26_ = j;
								j = _tmp26_ + 1;
							}
							_tmp25_ = FALSE;
							_tmp27_ = j;
							_tmp28_ = self->priv->generators;
							_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
							_tmp30_ = _tmp29_;
							if (!(_tmp27_ < _tmp30_)) {
								break;
							}
							_tmp31_ = stdout;
							_tmp32_ = self->priv->generators;
							_tmp33_ = j;
							_tmp34_ = gee_list_get (_tmp32_, _tmp33_);
							_tmp35_ = (GeeBenchmarkGenerator*) _tmp34_;
							_tmp36_ = gee_benchmark_generator_get_name (_tmp35_);
							_tmp37_ = _tmp36_;
							fprintf (_tmp31_, "%20s\t", _tmp37_);
							_g_object_unref0 (_tmp35_);
							{
								gint k = 0;
								k = 0;
								{
									gboolean _tmp38_ = FALSE;
									_tmp38_ = TRUE;
									while (TRUE) {
										gint _tmp40_ = 0;
										GeeList* _tmp41_ = NULL;
										gint _tmp42_ = 0;
										gint _tmp43_ = 0;
										gdouble average = 0.0;
										gdouble* _tmp44_ = NULL;
										gint _tmp44__length1 = 0;
										gint _tmp44__length2 = 0;
										gint _tmp44__length3 = 0;
										gint _tmp45_ = 0;
										gint _tmp46_ = 0;
										gint _tmp47_ = 0;
										gdouble _tmp48_ = 0.0;
										gint _tmp49_ = 0;
										gdouble squared_deviation = 0.0;
										gdouble* _tmp50_ = NULL;
										gint _tmp50__length1 = 0;
										gint _tmp50__length2 = 0;
										gint _tmp50__length3 = 0;
										gint _tmp51_ = 0;
										gint _tmp52_ = 0;
										gint _tmp53_ = 0;
										gdouble _tmp54_ = 0.0;
										gint _tmp55_ = 0;
										gdouble _tmp56_ = 0.0;
										gdouble _tmp57_ = 0.0;
										gint _tmp58_ = 0;
										gdouble deviation = 0.0;
										gdouble _tmp59_ = 0.0;
										gdouble _tmp60_ = 0.0;
										FILE* _tmp61_ = NULL;
										gdouble _tmp62_ = 0.0;
										gdouble _tmp63_ = 0.0;
										if (!_tmp38_) {
											gint _tmp39_ = 0;
											_tmp39_ = k;
											k = _tmp39_ + 1;
										}
										_tmp38_ = FALSE;
										_tmp40_ = k;
										_tmp41_ = self->priv->algorithms;
										_tmp42_ = gee_collection_get_size ((GeeCollection*) _tmp41_);
										_tmp43_ = _tmp42_;
										if (!(_tmp40_ < _tmp43_)) {
											break;
										}
										_tmp44_ = self->priv->results_sum;
										_tmp44__length1 = self->priv->results_sum_length1;
										_tmp44__length2 = self->priv->results_sum_length2;
										_tmp44__length3 = self->priv->results_sum_length3;
										_tmp45_ = i;
										_tmp46_ = j;
										_tmp47_ = k;
										_tmp48_ = _tmp44_[(((_tmp45_ * _tmp44__length2) + _tmp46_) * _tmp44__length3) + _tmp47_];
										_tmp49_ = iteration;
										average = _tmp48_ / _tmp49_;
										_tmp50_ = self->priv->results_squared_sum;
										_tmp50__length1 = self->priv->results_squared_sum_length1;
										_tmp50__length2 = self->priv->results_squared_sum_length2;
										_tmp50__length3 = self->priv->results_squared_sum_length3;
										_tmp51_ = i;
										_tmp52_ = j;
										_tmp53_ = k;
										_tmp54_ = _tmp50_[(((_tmp51_ * _tmp50__length2) + _tmp52_) * _tmp50__length3) + _tmp53_];
										_tmp55_ = iteration;
										_tmp56_ = average;
										_tmp57_ = pow (_tmp56_, (gdouble) 2);
										_tmp58_ = iteration;
										squared_deviation = (_tmp54_ - (((gdouble) _tmp55_) * _tmp57_)) / (_tmp58_ - 1);
										_tmp59_ = squared_deviation;
										_tmp60_ = sqrt (_tmp59_);
										deviation = _tmp60_;
										_tmp61_ = stdout;
										_tmp62_ = average;
										_tmp63_ = deviation;
										fprintf (_tmp61_, "%8f [%8f] \t", _tmp62_, _tmp63_);
									}
								}
							}
							_tmp64_ = stdout;
							fprintf (_tmp64_, "\n");
						}
					}
				}
				_tmp65_ = stdout;
				fprintf (_tmp65_, "\n");
			}
		}
	}
	_tmp66_ = stdout;
	fprintf (_tmp66_, "\n\n");
}


static void gee_benchmark_benchmark_class_init (GeeBenchmarkBenchmarkClass * klass) {
	gee_benchmark_benchmark_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeBenchmarkBenchmarkPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_benchmark_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_benchmark_benchmark_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_benchmark_benchmark_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_BENCHMARK_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_BENCHMARK_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_BENCHMARK_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_benchmark_benchmark_instance_init (GeeBenchmarkBenchmark * self) {
	self->priv = GEE_BENCHMARK_BENCHMARK_GET_PRIVATE (self);
}


static void gee_benchmark_benchmark_finalize (GObject* obj) {
	GeeBenchmarkBenchmark * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmark);
	_g_object_unref0 (self->priv->factory);
	self->priv->sizes = (g_free (self->priv->sizes), NULL);
	_g_object_unref0 (self->priv->generators);
	_g_object_unref0 (self->priv->algorithms);
	self->priv->results_sum = (g_free (self->priv->results_sum), NULL);
	self->priv->results_squared_sum = (g_free (self->priv->results_squared_sum), NULL);
	G_OBJECT_CLASS (gee_benchmark_benchmark_parent_class)->finalize (obj);
}


GType gee_benchmark_benchmark_get_type (void) {
	static volatile gsize gee_benchmark_benchmark_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_benchmark_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkBenchmarkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_benchmark_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkBenchmark), 0, (GInstanceInitFunc) gee_benchmark_benchmark_instance_init, NULL };
		GType gee_benchmark_benchmark_type_id;
		gee_benchmark_benchmark_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkBenchmark", &g_define_type_info, 0);
		g_once_init_leave (&gee_benchmark_benchmark_type_id__volatile, gee_benchmark_benchmark_type_id);
	}
	return gee_benchmark_benchmark_type_id__volatile;
}


static void _vala_gee_benchmark_benchmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkBenchmark * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmark);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_benchmark_benchmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeBenchmarkBenchmark * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmark);
	switch (property_id) {
		case GEE_BENCHMARK_BENCHMARK_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_BENCHMARK_BENCHMARK_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_BENCHMARK_BENCHMARK_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



