/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.22 from the
 * contents of GKeyFile.xs. Do not edit this file, edit GKeyFile.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "GKeyFile.xs"
/*
 * Copyright (C) 2005,2013 by the gtk2-perl team (see the file AUTHORS for
 * the full list)
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "gperl.h"
#include "gperl-gtypes.h"

SV *
newSVGKeyFileFlags (GKeyFileFlags flags)
{
	return gperl_convert_back_flags (GPERL_TYPE_KEY_FILE_FLAGS, flags);
}

GKeyFileFlags
SvGKeyFileFlags (SV * sv)
{
	return gperl_convert_flags (GPERL_TYPE_KEY_FILE_FLAGS, sv);
}

SV *
newSVGKeyFile (GKeyFile * key_file)
{
	HV * key = newHV ();
	SV * sv;
	HV * stash;

	/* tie the key_file to our hash using some magic */
	_gperl_attach_mg ((SV*) key, key_file);

	/* wrap it, bless it, ship it. */
	sv = newRV_noinc ((SV*) key);

	stash = gv_stashpv ("Glib::KeyFile", TRUE);
	sv_bless (sv, stash);

	return sv;
}

GKeyFile *
SvGKeyFile (SV * sv)
{
	MAGIC * mg;
	if (!gperl_sv_is_ref (sv) || !(mg = _gperl_find_mg (SvRV (sv))))
		return NULL;
	return (GKeyFile *) mg->mg_ptr;
}

#line 74 "GKeyFile.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)    S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage        S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 216 "GKeyFile.c"

XS_EUPXS(XS_Glib__KeyFile_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "key_file");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
#line 118 "GKeyFile.xs"
    	g_key_file_free (key_file);
#line 229 "GKeyFile.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__KeyFile_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	GKeyFile *	RETVAL;

	RETVAL = g_key_file_new(/* void */);
	ST(0) = newSVGKeyFile (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__KeyFile_set_list_separator); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_set_list_separator)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "key_file, separator");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	gchar	separator = (gchar)SvIV(ST(1))
;

	g_key_file_set_list_separator(key_file, separator);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__KeyFile_load_from_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_load_from_file)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "key_file, file, flags");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	file;
	GKeyFileFlags	flags = SvGKeyFileFlags (ST(2))
;
#line 148 "GKeyFile.xs"
    	GError *err = NULL;
#line 284 "GKeyFile.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	file = (const gchar *)SvPV_nolen (ST(1))
;
#line 150 "GKeyFile.xs"
    	RETVAL = g_key_file_load_from_file (key_file, file, flags, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 295 "GKeyFile.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__KeyFile_load_from_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_load_from_data)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "key_file, buf, flags");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	SV *	buf = ST(1)
;
	GKeyFileFlags	flags = SvGKeyFileFlags (ST(2))
;
#line 165 "GKeyFile.xs"
	STRLEN length;
	GError *err = NULL;
	const gchar *data = (const gchar *) SvPV (buf, length);
#line 319 "GKeyFile.c"
	gboolean	RETVAL;
#line 169 "GKeyFile.xs"
	RETVAL = g_key_file_load_from_data (key_file, data, length, flags, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 325 "GKeyFile.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#if GLIB_CHECK_VERSION (2, 14, 0)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Glib__KeyFile_load_from_dirs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_load_from_dirs)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "key_file, file, flags, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	file;
	GKeyFileFlags	flags = SvGKeyFileFlags (ST(2))
;
#line 191 "GKeyFile.xs"
	int n_dirs, i;
	gchar **search_dirs;
	gchar *full_path = NULL;
	GError *error = NULL;
	gboolean retval;
#line 355 "GKeyFile.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	file = (const gchar *)SvPV_nolen (ST(1))
;
#line 197 "GKeyFile.xs"
	n_dirs = items - 3;
	search_dirs = g_new0 (gchar*, n_dirs + 1);
	for (i = 0; i < n_dirs; i++) {
		search_dirs[i] = SvGChar (ST (3 + i));
	}
	search_dirs[n_dirs] = NULL;

	retval = g_key_file_load_from_dirs (
			key_file,
			file,
			(const gchar **) search_dirs,
			&full_path,
			flags,
			&error);

	if (error)
		gperl_croak_gerror (NULL, error);

	PUSHs (sv_2mortal (newSVuv (retval)));
	if (GIMME_V == G_ARRAY && full_path)
		XPUSHs (sv_2mortal (newSVGChar (full_path)));

	if (full_path)
		g_free (full_path);

	g_free (search_dirs);
#line 388 "GKeyFile.c"
	PUTBACK;
	return;
    }
}

#endif

XS_EUPXS(XS_Glib__KeyFile_load_from_data_dirs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_load_from_data_dirs)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "key_file, file, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	file;
	GKeyFileFlags	flags = SvGKeyFileFlags (ST(2))
;
#line 240 "GKeyFile.xs"
    	GError *err = NULL;
	gchar *full_path = NULL;
	gboolean retval;
#line 414 "GKeyFile.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	file = (const gchar *)SvPV_nolen (ST(1))
;
#line 244 "GKeyFile.xs"
    	retval = g_key_file_load_from_data_dirs (key_file,
			file,
			GIMME_V == G_ARRAY ? &full_path : NULL,
			flags,
			&err);
	if (err)
		gperl_croak_gerror (NULL, err);
	PUSHs (sv_2mortal (newSViv (retval)));
	if (GIMME_V == G_ARRAY && full_path)
		XPUSHs (sv_2mortal (newSVGChar (full_path)));
	if (full_path) g_free (full_path);
#line 432 "GKeyFile.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Glib__KeyFile_to_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_to_data)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "key_file");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
#line 263 "GKeyFile.xs"
    	GError *err = NULL;
	gsize len;
#line 451 "GKeyFile.c"
	gchar_own *	RETVAL;
#line 266 "GKeyFile.xs"
    	RETVAL = g_key_file_to_data (key_file, &len, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 457 "GKeyFile.c"
	ST(0) = sv_newmortal();
	/* used when we can directly own the returned string. */
	/* we have to copy in the case when perl's malloc != gtk's malloc,
         * so best copy all the time. */
	sv_setpv ((SV*)ST(0), RETVAL);
	SvUTF8_on (ST(0));
        g_free (RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__KeyFile_get_start_group); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_get_start_group)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "key_file");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	gchar_own *	RETVAL;

	RETVAL = g_key_file_get_start_group(key_file);
	ST(0) = sv_newmortal();
	/* used when we can directly own the returned string. */
	/* we have to copy in the case when perl's malloc != gtk's malloc,
         * so best copy all the time. */
	sv_setpv ((SV*)ST(0), RETVAL);
	SvUTF8_on (ST(0));
        g_free (RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__KeyFile_get_groups); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_get_groups)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "key_file");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
#line 287 "GKeyFile.xs"
    	gchar **groups;
	gsize len, i;
#line 508 "GKeyFile.c"
#line 290 "GKeyFile.xs"
    	groups = g_key_file_get_groups (key_file, &len);
	if (len != 0) {
		EXTEND(SP, len);
		for (i = 0; i < len; i++)
			PUSHs (sv_2mortal (newSVGChar (groups[i])));
	}
	g_strfreev (groups); /* otherwise, we leak */
#line 517 "GKeyFile.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Glib__KeyFile_get_keys); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_get_keys)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "key_file, group_name");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
#line 307 "GKeyFile.xs"
    	GError *err = NULL;
    	gchar **keys;
	gsize len, i;
#line 540 "GKeyFile.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;
#line 311 "GKeyFile.xs"
    	keys = g_key_file_get_keys (key_file, group_name, &len, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
	if (len != 0) {
		for (i = 0; i < len; i++)
			if (keys[i])
				XPUSHs (sv_2mortal (newSVGChar (keys[i])));
	}
	g_strfreev (keys); /* otherwise, we leak */
#line 556 "GKeyFile.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Glib__KeyFile_has_group); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_has_group)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "key_file, group_name");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	RETVAL = g_key_file_has_group(key_file, group_name);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__KeyFile_has_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_has_key)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "key_file, group_name, key");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
#line 339 "GKeyFile.xs"
    	GError *err = NULL;
#line 600 "GKeyFile.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;
#line 341 "GKeyFile.xs"
    	RETVAL = g_key_file_has_key (key_file, group_name, key, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 616 "GKeyFile.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__KeyFile_get_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_get_value)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "key_file, group_name, key");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
#line 356 "GKeyFile.xs"
    	GError *err = NULL;
#line 636 "GKeyFile.c"
	gchar_own *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;
#line 358 "GKeyFile.xs"
    	RETVAL = g_key_file_get_value (key_file, group_name, key, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 652 "GKeyFile.c"
	ST(0) = sv_newmortal();
	/* used when we can directly own the returned string. */
	/* we have to copy in the case when perl's malloc != gtk's malloc,
         * so best copy all the time. */
	sv_setpv ((SV*)ST(0), RETVAL);
	SvUTF8_on (ST(0));
        g_free (RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__KeyFile_set_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_set_value)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "key_file, group_name, key, value");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
	const gchar *	value;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(3));
	value = (const gchar *)SvPV_nolen (ST(3))
;

	g_key_file_set_value(key_file, group_name, key, value);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__KeyFile_set_boolean); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_set_boolean)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 4)
       croak_xs_usage(cv,  "key_file, group_name, key, value");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
	SV *	value = ST(3)
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;
#line 405 "GKeyFile.xs"
    	switch (ix) {
		case 0:
			g_key_file_set_boolean (key_file,
					group_name, key,
					SvTRUE (value));
			break;
		case 1:
			g_key_file_set_integer (key_file,
					group_name, key,
					SvIV (value));
			break;
		case 2:
			g_key_file_set_string (key_file,
					group_name, key,
					SvGChar (value));
			break;
	}
#line 741 "GKeyFile.c"
    }
    XSRETURN_EMPTY;
}

#if GLIB_CHECK_VERSION (2, 12, 0)
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Glib__KeyFile_set_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_set_double)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "key_file, group_name, key, value");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
	gdouble	value = (double)SvNV(ST(3))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;

	g_key_file_set_double(key_file, group_name, key, value);
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Glib__KeyFile_get_boolean); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_get_boolean)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 3)
       croak_xs_usage(cv,  "key_file, group_name, key");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
#line 457 "GKeyFile.xs"
    	GError *err = NULL;
#line 795 "GKeyFile.c"
	SV *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;
#line 459 "GKeyFile.xs"
    	switch (ix) {
		case 0:
		{
			gboolean retval;
			retval = g_key_file_get_boolean (key_file,
					group_name, key,
					&err);
			if (err)
				gperl_croak_gerror (NULL, err);
			RETVAL = boolSV (retval);
			break;
		}
		case 1:
		{
			gint retval;
			retval = g_key_file_get_integer (key_file,
					group_name, key,
					&err);
			if (err)
				gperl_croak_gerror (NULL, err);
			RETVAL = newSViv (retval);
			break;
		}
		case 2:
		{
			gchar *retval;
			retval = g_key_file_get_string (key_file,
					group_name, key,
					&err);
			if (err)
				gperl_croak_gerror (NULL, err);
			RETVAL = newSVGChar (retval);
			g_free (retval); /* leaks otherwise */
			break;
		}
		default:
			RETVAL = NULL;
			g_assert_not_reached ();
	}
#line 847 "GKeyFile.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#if GLIB_CHECK_VERSION (2, 12, 0)
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Glib__KeyFile_get_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_get_double)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "key_file, group_name, key");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
#line 512 "GKeyFile.xs"
    	GError *err = NULL;
#line 871 "GKeyFile.c"
	gdouble	RETVAL;
	dXSTARG;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;
#line 514 "GKeyFile.xs"
	RETVAL = g_key_file_get_double (key_file,
			group_name, key, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 889 "GKeyFile.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Glib__KeyFile_get_locale_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_get_locale_string)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "key_file, group_name, key, locale=NULL");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
	const gchar_ornull *	locale;
#line 535 "GKeyFile.xs"
    	GError *err = NULL;
#line 911 "GKeyFile.c"
	gchar_own *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;

	if (items < 4)
	    locale = NULL;
	else {
	    /* same as SvGChar(), but allows undef as NULL */
	    if (gperl_sv_is_defined (ST(3))) {
		    sv_utf8_upgrade (ST(3));
		    locale = (const gchar_ornull *)SvPV_nolen (ST(3));
	    } else {
		    locale = NULL;
	    }
;
	}
#line 537 "GKeyFile.xs"
    	RETVAL = g_key_file_get_locale_string (key_file,
			group_name, key,
			locale,
			&err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 943 "GKeyFile.c"
	ST(0) = sv_newmortal();
	/* used when we can directly own the returned string. */
	/* we have to copy in the case when perl's malloc != gtk's malloc,
         * so best copy all the time. */
	sv_setpv ((SV*)ST(0), RETVAL);
	SvUTF8_on (ST(0));
        g_free (RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__KeyFile_set_locale_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_set_locale_string)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "key_file, group_name, key, locale, string");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
	const gchar *	locale;
	const gchar *	string;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(3));
	locale = (const gchar *)SvPV_nolen (ST(3))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(4));
	string = (const gchar *)SvPV_nolen (ST(4))
;

	g_key_file_set_locale_string(key_file, group_name, key, locale, string);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__KeyFile_get_locale_string_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_get_locale_string_list)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "key_file, group_name, key, locale");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
	const gchar *	locale;
#line 563 "GKeyFile.xs"
	gchar **retlist;
    	GError *err = NULL;
	gsize retlen, i;
#line 1014 "GKeyFile.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(3));
	locale = (const gchar *)SvPV_nolen (ST(3))
;
#line 567 "GKeyFile.xs"
	retlist = g_key_file_get_locale_string_list (key_file,
			group_name, key,
			locale,
			&retlen,
			&err);
	if (err)
		gperl_croak_gerror (NULL, err);
	for (i = 0; i < retlen; i++)
		XPUSHs (sv_2mortal (newSVGChar (retlist[i])));
	g_strfreev (retlist);
#line 1041 "GKeyFile.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Glib__KeyFile_set_locale_string_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_set_locale_string_list)
{
    dVAR; dXSARGS;
    if (items < 4)
       croak_xs_usage(cv,  "key_file, group_name, key, locale, ...");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
	const gchar *	locale;
#line 589 "GKeyFile.xs"
    	gchar **list;
	gsize list_len;
	int i;
#line 1064 "GKeyFile.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(3));
	locale = (const gchar *)SvPV_nolen (ST(3))
;
#line 593 "GKeyFile.xs"
	list_len = (gsize) (items - 3);
	list = g_new0 (gchar *, list_len);
	for (i = 4; i < items; i++)
		list[i - 4] = SvPV_nolen (ST (i));
	g_key_file_set_locale_string_list (key_file,
			group_name, key,
			locale,
			(const gchar * const *) list, list_len);
	g_free (list);
#line 1090 "GKeyFile.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__KeyFile_get_string_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_get_string_list)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 3)
       croak_xs_usage(cv,  "key_file, group_name, key");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
#line 627 "GKeyFile.xs"
    	GError *err = NULL;
	gsize retlen, i;
#line 1113 "GKeyFile.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;
#line 630 "GKeyFile.xs"
    	switch (ix) {
#define CROAK_ON_GERROR(error)	if (error) gperl_croak_gerror (NULL, error)
		case 0:
		{
			gchar **retlist;
			retlist = g_key_file_get_string_list (key_file,
					group_name, key,
					&retlen,
					&err);
			CROAK_ON_GERROR (err);
			EXTEND (sp, retlen);
			for (i = 0; i < retlen; i++)
				PUSHs (sv_2mortal (newSVGChar (retlist[i])));
			g_strfreev (retlist);
			break;
		}
		case 1:
		{
			gboolean *retlist;
			retlist = g_key_file_get_boolean_list (key_file,
					group_name, key,
					&retlen,
					&err);
			CROAK_ON_GERROR (err);
			EXTEND (sp, retlen);
			for (i = 0; i < retlen; i++)
				PUSHs (sv_2mortal (boolSV (retlist[i])));
			g_free (retlist);
			break;
		}
		case 2:
		{
			gint *retlist;
			retlist = g_key_file_get_integer_list (key_file,
					group_name, key,
					&retlen,
					&err);
			CROAK_ON_GERROR (err);
			EXTEND (sp, retlen);
			for (i = 0; i < retlen; i++)
				PUSHs (sv_2mortal (newSViv (retlist[i])));
			g_free (retlist);
		}
	}
#line 1169 "GKeyFile.c"
	PUTBACK;
	return;
    }
}

#if GLIB_CHECK_VERSION (2, 12, 0)
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Glib__KeyFile_get_double_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_get_double_list)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "key_file, group_name, key");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
#line 687 "GKeyFile.xs"
    	GError *err = NULL;
	gsize retlen, i;
	gdouble *retlist;
#line 1196 "GKeyFile.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;
#line 691 "GKeyFile.xs"
	retlist = g_key_file_get_double_list (key_file,
			group_name, key,
			&retlen,
			&err);
	if (err)
		gperl_croak_gerror (NULL, err);
	EXTEND (sp, retlen);
	for (i = 0; i < retlen; i++)
		PUSHs (sv_2mortal (newSVnv (retlist[i])));
	g_free (retlist);
#line 1218 "GKeyFile.c"
	PUTBACK;
	return;
    }
}

#endif

XS_EUPXS(XS_Glib__KeyFile_set_string_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_set_string_list)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 3)
       croak_xs_usage(cv,  "key_file, group_name, key, ...");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
#line 732 "GKeyFile.xs"
	gsize list_len;
	int i;
#line 1241 "GKeyFile.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;
#line 735 "GKeyFile.xs"
    	switch (ix) {
		case 0:
		{
			gchar **list;
			list_len = (gsize) (items - 3);
			list = g_new0 (gchar *, list_len);
			for (i = 3; i < items; i++)
				list[i - 3] = SvPV_nolen (ST (i));
			g_key_file_set_string_list (key_file,
					group_name, key,
					(const gchar * const *) list, list_len);
			g_free (list);
			break;
		}
		case 1:
		{
			gboolean *list;
			list_len = (gsize) (items - 3);
			list = g_new0 (gboolean, list_len);
			for (i = 3; i < items; i++)
				list[i - 3] = SvTRUE (ST (i));
			g_key_file_set_boolean_list (key_file,
					group_name, key,
					list, list_len);
			g_free (list);
			break;
		}
		case 2:
		{
			gint *list;
			list_len = (gsize) (items - 3);
			list = g_new0 (gint, list_len);
			for (i = 3; i < items; i++)
				list[i - 3] = SvIV (ST (i));
			g_key_file_set_integer_list (key_file,
					group_name, key,
					list, list_len);
			g_free (list);
			break;
		}
	}
#line 1294 "GKeyFile.c"
    }
    XSRETURN_EMPTY;
}

#if GLIB_CHECK_VERSION (2, 12, 0)
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_Glib__KeyFile_set_double_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_set_double_list)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "key_file, group_name, key, ...");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
#line 790 "GKeyFile.xs"
	gsize list_len;
	int i;
	gdouble *list;
#line 1318 "GKeyFile.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;
#line 794 "GKeyFile.xs"
	list_len = (gsize) (items - 3);
	list = g_new0 (gdouble, list_len);
	for (i = 3; i < items; i++)
		list[i - 3] = SvNV (ST (i));
	g_key_file_set_double_list (key_file,
			group_name, key,
			list, list_len);
	g_free (list);
#line 1338 "GKeyFile.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Glib__KeyFile_set_comment); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_set_comment)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "key_file, group_name, key, comment");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar_ornull *	group_name;
	const gchar_ornull *	key;
	const gchar *	comment;
#line 817 "GKeyFile.xs"
    	GError *err = NULL;
#line 1359 "GKeyFile.c"

	/* same as SvGChar(), but allows undef as NULL */
	if (gperl_sv_is_defined (ST(1))) {
		sv_utf8_upgrade (ST(1));
		group_name = (const gchar_ornull *)SvPV_nolen (ST(1));
	} else {
		group_name = NULL;
	}
;

	/* same as SvGChar(), but allows undef as NULL */
	if (gperl_sv_is_defined (ST(2))) {
		sv_utf8_upgrade (ST(2));
		key = (const gchar_ornull *)SvPV_nolen (ST(2));
	} else {
		key = NULL;
	}
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(3));
	comment = (const gchar *)SvPV_nolen (ST(3))
;
#line 819 "GKeyFile.xs"
    	g_key_file_set_comment (key_file, group_name, key, comment, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 1387 "GKeyFile.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__KeyFile_get_comment); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_get_comment)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "key_file, group_name=NULL, key=NULL");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar_ornull *	group_name;
	const gchar_ornull *	key;
#line 834 "GKeyFile.xs"
    	GError *err = NULL;
#line 1406 "GKeyFile.c"
	gchar_own *	RETVAL;

	if (items < 2)
	    group_name = NULL;
	else {
	    /* same as SvGChar(), but allows undef as NULL */
	    if (gperl_sv_is_defined (ST(1))) {
		    sv_utf8_upgrade (ST(1));
		    group_name = (const gchar_ornull *)SvPV_nolen (ST(1));
	    } else {
		    group_name = NULL;
	    }
;
	}

	if (items < 3)
	    key = NULL;
	else {
	    /* same as SvGChar(), but allows undef as NULL */
	    if (gperl_sv_is_defined (ST(2))) {
		    sv_utf8_upgrade (ST(2));
		    key = (const gchar_ornull *)SvPV_nolen (ST(2));
	    } else {
		    key = NULL;
	    }
;
	}
#line 836 "GKeyFile.xs"
    	RETVAL = g_key_file_get_comment (key_file, group_name, key, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 1438 "GKeyFile.c"
	ST(0) = sv_newmortal();
	/* used when we can directly own the returned string. */
	/* we have to copy in the case when perl's malloc != gtk's malloc,
         * so best copy all the time. */
	sv_setpv ((SV*)ST(0), RETVAL);
	SvUTF8_on (ST(0));
        g_free (RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__KeyFile_remove_comment); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_remove_comment)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "key_file, group_name=NULL, key=NULL");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar_ornull *	group_name;
	const gchar_ornull *	key;
#line 853 "GKeyFile.xs"
    	GError *err = NULL;
#line 1464 "GKeyFile.c"

	if (items < 2)
	    group_name = NULL;
	else {
	    /* same as SvGChar(), but allows undef as NULL */
	    if (gperl_sv_is_defined (ST(1))) {
		    sv_utf8_upgrade (ST(1));
		    group_name = (const gchar_ornull *)SvPV_nolen (ST(1));
	    } else {
		    group_name = NULL;
	    }
;
	}

	if (items < 3)
	    key = NULL;
	else {
	    /* same as SvGChar(), but allows undef as NULL */
	    if (gperl_sv_is_defined (ST(2))) {
		    sv_utf8_upgrade (ST(2));
		    key = (const gchar_ornull *)SvPV_nolen (ST(2));
	    } else {
		    key = NULL;
	    }
;
	}
#line 855 "GKeyFile.xs"
    	g_key_file_remove_comment (key_file, group_name, key, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 1495 "GKeyFile.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__KeyFile_remove_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_remove_key)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "key_file, group_name, key");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
	const gchar *	key;
#line 868 "GKeyFile.xs"
    	GError *err = NULL;
#line 1514 "GKeyFile.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	key = (const gchar *)SvPV_nolen (ST(2))
;
#line 870 "GKeyFile.xs"
    	g_key_file_remove_key (key_file, group_name, key, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 1529 "GKeyFile.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__KeyFile_remove_group); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__KeyFile_remove_group)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "key_file, group_name");
    {
	GKeyFile *	key_file = SvGKeyFile (ST(0))
;
	const gchar *	group_name;
#line 882 "GKeyFile.xs"
    	GError *err = NULL;
#line 1547 "GKeyFile.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	group_name = (const gchar *)SvPV_nolen (ST(1))
;
#line 884 "GKeyFile.xs"
    	g_key_file_remove_group (key_file, group_name, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 1557 "GKeyFile.c"
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Glib__KeyFile); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Glib__KeyFile)
{
    dVAR; dXSARGS;
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK;

    {
        CV * cv;

        newXS("Glib::KeyFile::DESTROY", XS_Glib__KeyFile_DESTROY, file);
        newXS("Glib::KeyFile::new", XS_Glib__KeyFile_new, file);
        newXS("Glib::KeyFile::set_list_separator", XS_Glib__KeyFile_set_list_separator, file);
        newXS("Glib::KeyFile::load_from_file", XS_Glib__KeyFile_load_from_file, file);
        newXS("Glib::KeyFile::load_from_data", XS_Glib__KeyFile_load_from_data, file);
#if XSubPPtmpAAAA
        newXS("Glib::KeyFile::load_from_dirs", XS_Glib__KeyFile_load_from_dirs, file);
#endif
        newXS("Glib::KeyFile::load_from_data_dirs", XS_Glib__KeyFile_load_from_data_dirs, file);
        newXS("Glib::KeyFile::to_data", XS_Glib__KeyFile_to_data, file);
        newXS("Glib::KeyFile::get_start_group", XS_Glib__KeyFile_get_start_group, file);
        newXS("Glib::KeyFile::get_groups", XS_Glib__KeyFile_get_groups, file);
        newXS("Glib::KeyFile::get_keys", XS_Glib__KeyFile_get_keys, file);
        newXS("Glib::KeyFile::has_group", XS_Glib__KeyFile_has_group, file);
        newXS("Glib::KeyFile::has_key", XS_Glib__KeyFile_has_key, file);
        newXS("Glib::KeyFile::get_value", XS_Glib__KeyFile_get_value, file);
        newXS("Glib::KeyFile::set_value", XS_Glib__KeyFile_set_value, file);
        cv = newXS("Glib::KeyFile::set_boolean", XS_Glib__KeyFile_set_boolean, file);
        XSANY.any_i32 = 0;
        cv = newXS("Glib::KeyFile::set_integer", XS_Glib__KeyFile_set_boolean, file);
        XSANY.any_i32 = 1;
        cv = newXS("Glib::KeyFile::set_string", XS_Glib__KeyFile_set_boolean, file);
        XSANY.any_i32 = 2;
#if XSubPPtmpAAAB
        newXS("Glib::KeyFile::set_double", XS_Glib__KeyFile_set_double, file);
#endif
        cv = newXS("Glib::KeyFile::get_boolean", XS_Glib__KeyFile_get_boolean, file);
        XSANY.any_i32 = 0;
        cv = newXS("Glib::KeyFile::get_integer", XS_Glib__KeyFile_get_boolean, file);
        XSANY.any_i32 = 1;
        cv = newXS("Glib::KeyFile::get_string", XS_Glib__KeyFile_get_boolean, file);
        XSANY.any_i32 = 2;
#if XSubPPtmpAAAC
        newXS("Glib::KeyFile::get_double", XS_Glib__KeyFile_get_double, file);
#endif
        newXS("Glib::KeyFile::get_locale_string", XS_Glib__KeyFile_get_locale_string, file);
        newXS("Glib::KeyFile::set_locale_string", XS_Glib__KeyFile_set_locale_string, file);
        newXS("Glib::KeyFile::get_locale_string_list", XS_Glib__KeyFile_get_locale_string_list, file);
        newXS("Glib::KeyFile::set_locale_string_list", XS_Glib__KeyFile_set_locale_string_list, file);
        cv = newXS("Glib::KeyFile::get_boolean_list", XS_Glib__KeyFile_get_string_list, file);
        XSANY.any_i32 = 1;
        cv = newXS("Glib::KeyFile::get_integer_list", XS_Glib__KeyFile_get_string_list, file);
        XSANY.any_i32 = 2;
        cv = newXS("Glib::KeyFile::get_string_list", XS_Glib__KeyFile_get_string_list, file);
        XSANY.any_i32 = 0;
#if XSubPPtmpAAAD
        newXS("Glib::KeyFile::get_double_list", XS_Glib__KeyFile_get_double_list, file);
#endif
        cv = newXS("Glib::KeyFile::set_boolean_list", XS_Glib__KeyFile_set_string_list, file);
        XSANY.any_i32 = 1;
        cv = newXS("Glib::KeyFile::set_integer_list", XS_Glib__KeyFile_set_string_list, file);
        XSANY.any_i32 = 2;
        cv = newXS("Glib::KeyFile::set_string_list", XS_Glib__KeyFile_set_string_list, file);
        XSANY.any_i32 = 0;
#if XSubPPtmpAAAE
        newXS("Glib::KeyFile::set_double_list", XS_Glib__KeyFile_set_double_list, file);
#endif
        newXS("Glib::KeyFile::set_comment", XS_Glib__KeyFile_set_comment, file);
        newXS("Glib::KeyFile::get_comment", XS_Glib__KeyFile_get_comment, file);
        newXS("Glib::KeyFile::remove_comment", XS_Glib__KeyFile_remove_comment, file);
        newXS("Glib::KeyFile::remove_key", XS_Glib__KeyFile_remove_key, file);
        newXS("Glib::KeyFile::remove_group", XS_Glib__KeyFile_remove_group, file);
    }

    /* Initialisation Section */

#line 112 "GKeyFile.xs"
	gperl_register_fundamental (GPERL_TYPE_KEY_FILE_FLAGS,
				    "Glib::KeyFileFlags");

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#line 1665 "GKeyFile.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

