/*
 * This file was generated automatically by ExtUtils::ParseXS version 2.2210 from the
 * contents of GConfClient.xs. Do not edit this file, edit GConfClient.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "xs/GConfClient.xs"
/*
 * Copyright (c) 2003, 2004 by Emmanuele Bassi (see the file AUTHORS)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 * Boston, MA  02111-1307  USA.
 */

#include "gconfperl.h"
#include <gperl_marshal.h>

/* Here's some magic.  In C, the notify function has the following parameters:
 * the GConfClient that is monitoring the keys, the connection id for notifier
 * handler and a GConfEntry, which is an opaque container for the key which is
 * being monitored and its value, stored as a GConfValue dynamic type (similar
 * to GValue).  Both GConfEntry and GConfValue should not be accessed directly
 * from the programmer (except for the "type" field of GConfValue, which is
 * used for type detection); so, these two objects do not have a type inside
 * Glib.  In order to expose the data contained inside those two objects, we
 * create an hashref and fill it with the key and the value; then, we pass it
 * to the notify marshaller.
 */
static GPerlCallback *
gconfperl_notify_func_create (SV * func, SV * data)
{
	GType param_types [] = {
		GCONF_TYPE_CLIENT,
		G_TYPE_INT,
		GPERL_TYPE_SV,
	};
	return gperl_callback_new (func, data,
			           G_N_ELEMENTS (param_types),
				   param_types, 0);
}

static void
gconfperl_notify_func (GConfClient * client,
		       guint cnxn_id,
		       GConfEntry * entry,
		       gpointer data)
{
	gperl_callback_invoke ((GPerlCallback*)data, NULL,
			       client,
			       cnxn_id,
			       newSVGConfEntry (entry));
}

/* the "error" and "unreturned_error" signals pass a GError to the callbacks
 * attached to them.  GError is an opaque struct which contains the error
 * message string.  Since GError is not a Glib type, we pass to the Perl
 * marshallers directly the message string.
 */
static void
gconfperl_client_error_marshal (GClosure * closure,
                                GValue * return_value,
                                guint n_param_values,
                                const GValue * param_values,
                                gpointer invocation_hint,
                                gpointer marshal_data)
{
	GError *err;
	dGPERL_CLOSURE_MARSHAL_ARGS;

	GPERL_CLOSURE_MARSHAL_INIT (closure, marshal_data);

	PERL_UNUSED_VAR (return_value);
	PERL_UNUSED_VAR (n_param_values);
	PERL_UNUSED_VAR (invocation_hint);

	ENTER;
	SAVETMPS;

	PUSHMARK (SP);

	GPERL_CLOSURE_MARSHAL_PUSH_INSTANCE (param_values);
	
	err = (GError *) g_value_get_pointer (param_values + 1);
	XPUSHs (sv_2mortal (gperl_sv_from_gerror (err)));

	GPERL_CLOSURE_MARSHAL_PUSH_DATA;
	
	PUTBACK;

	GPERL_CLOSURE_MARSHAL_CALL (G_DISCARD);
	
	FREETMPS;
	LEAVE;
}

#line 111 "xs/GConfClient.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)	S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage		S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 163 "xs/GConfClient.c"

XS(XS_Gnome2__GConf__Client_get_default); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_get_default)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	GConfClient_noinc *	RETVAL;

	RETVAL = gconf_client_get_default(/* void */);
	ST(0) = newSVGConfClient_noinc (RETVAL);

	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_get_for_engine); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_get_for_engine)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "class, engine");
    {
	GConfEngine *	engine = SvGConfEngine (ST(1));
	GConfClient_noinc *	RETVAL;

	RETVAL = gconf_client_get_for_engine(engine);
	ST(0) = newSVGConfClient_noinc (RETVAL);

	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_add_dir); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_add_dir)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, dir, preload, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	dir;
	GConfClientPreloadType	preload = SvGConfClientPreloadType (ST(2));
	gboolean	check_error;
#line 175 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 227 "xs/GConfClient.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	dir = (const gchar *)SvPV_nolen (ST(1));

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3));
	}
#line 177 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
     		gconf_client_add_dir (client, dir, preload, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else
		gconf_client_add_dir (client, dir, preload, NULL);
#line 246 "xs/GConfClient.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Gnome2__GConf__Client_remove_dir); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_remove_dir)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, dir, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	dir;
	gboolean	check_error;
#line 191 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 268 "xs/GConfClient.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	dir = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 193 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		gconf_client_remove_dir (client, dir, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else
		gconf_client_remove_dir (client, dir, NULL);
#line 287 "xs/GConfClient.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Gnome2__GConf__Client_notify_add); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_notify_add)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3 || items > 5)
       croak_xs_usage(cv,  "client, namespace_section, func, data=NULL, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	namespace_section;
	SV *	func = ST(2);
	SV *	data;
	gboolean	check_error;
#line 209 "xs/GConfClient.xs"
     	GPerlCallback * callback;
	GError * err = NULL;
	guint cnxn_id = 0;
#line 313 "xs/GConfClient.c"
	guint	RETVAL;
	dXSTARG;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	namespace_section = (const gchar *)SvPV_nolen (ST(1));

	if (items < 4)
	    data = NULL;
	else {
	    data = ST(3);
	}

	if (items < 5)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(4));
	}
#line 213 "xs/GConfClient.xs"
     	callback = gconfperl_notify_func_create (func, data);
	if (TRUE == check_error) {
		cnxn_id = gconf_client_notify_add (client, namespace_section,
					gconfperl_notify_func,
					callback,
					(GFreeFunc) gperl_callback_destroy,
					&err);
		if (err)
			gperl_croak_gerror (NULL, err);

	}
	else {
		cnxn_id = gconf_client_notify_add (client, namespace_section,
					gconfperl_notify_func,
					callback,
					(GFreeFunc) gperl_callback_destroy,
					NULL);
	}
	RETVAL = cnxn_id;
#line 352 "xs/GConfClient.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_notify_remove); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_notify_remove)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "client, cnxn_id");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	guint	cnxn_id = (guint)SvUV(ST(1));

	gconf_client_notify_remove(client, cnxn_id);
    }
    XSRETURN_EMPTY;
}


XS(XS_Gnome2__GConf__Client_set_error_handling); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_set_error_handling)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "client, mode");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	GConfClientErrorHandlingMode	mode = SvGConfClientErrorHandlingMode (ST(1));

	gconf_client_set_error_handling(client, mode);
    }
    XSRETURN_EMPTY;
}


XS(XS_Gnome2__GConf__Client_clear_cache); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_clear_cache)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "client");
    {
	GConfClient *	client = SvGConfClient (ST(0));

	gconf_client_clear_cache(client);
    }
    XSRETURN_EMPTY;
}


XS(XS_Gnome2__GConf__Client_preload); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_preload)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, dirname, type, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	dirname;
	GConfClientPreloadType	type = SvGConfClientPreloadType (ST(2));
	gboolean	check_error;
#line 258 "xs/GConfClient.xs"
    	GError * err = NULL;
#line 435 "xs/GConfClient.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	dirname = (const gchar *)SvPV_nolen (ST(1));

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3));
	}
#line 260 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		gconf_client_preload (client, dirname, type, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		gconf_client_preload (client, dirname, type, NULL);
	}
#line 455 "xs/GConfClient.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Gnome2__GConf__Client_set); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_set)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, key, value, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	GConfValue *	value = SvGConfValue (ST(2));
	gboolean	check_error;
#line 283 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 478 "xs/GConfClient.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3));
	}
#line 285 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		gconf_client_set (client, key, value, &err);
	}
	else {
		gconf_client_set (client, key, value, NULL);
	}
	gconf_value_free (value);	/* leaks otherwise */
	if (err)
		gperl_croak_gerror (NULL, err);
#line 499 "xs/GConfClient.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Gnome2__GConf__Client_get); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_get)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gboolean	check_error;
#line 306 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 521 "xs/GConfClient.c"
	GConfValue *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 308 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get (client, key, NULL);
	}
#line 542 "xs/GConfClient.c"
	ST(0) = newSVGConfValue (RETVAL);

	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_get_without_default); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_get_without_default)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gboolean	check_error;
#line 327 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 567 "xs/GConfClient.c"
	GConfValue *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 329 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get_without_default (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_without_default (client, key, NULL);
	}
#line 588 "xs/GConfClient.c"
	ST(0) = newSVGConfValue (RETVAL);

	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_get_entry); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_get_entry)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "client, key, locale, use_schema_default, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	const gchar *	locale;
	gboolean	use_schema_default = (bool)SvTRUE(ST(3));
	gboolean	check_error;
#line 349 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 615 "xs/GConfClient.c"
	GConfEntry *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	locale = (const gchar *)SvPV_nolen (ST(2));

	if (items < 5)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(4));
	}
#line 351 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get_entry (client, key, locale, use_schema_default, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_entry (client, key, locale, use_schema_default, NULL);
	}
#line 640 "xs/GConfClient.c"
	ST(0) = newSVGConfEntry (RETVAL);

	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_get_default_from_schema); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_get_default_from_schema)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gboolean	check_error;
#line 369 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 665 "xs/GConfClient.c"
	GConfValue *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 371 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get_default_from_schema (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_default_from_schema (client, key, NULL);
	}
#line 686 "xs/GConfClient.c"
	ST(0) = newSVGConfValue (RETVAL);

	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_unset); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_unset)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gboolean	check_error;
#line 389 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 711 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 391 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_unset (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_unset (client, key, NULL);
	}
#line 732 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#if GCONF_CHECK_VERSION (2, 3, 3)
#define XSubPPtmpAAAA 1


XS(XS_Gnome2__GConf__Client_recursive_unset); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_recursive_unset)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "client, key, flags=0, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	GConfUnsetFlags	flags;
	gboolean	check_error;
#line 411 "xs/GConfClient.xs"
        GError * err = NULL;
#line 760 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    flags = 0;
	else {
	    flags = SvGConfUnsetFlags (ST(2));
	}

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3));
	}
#line 413 "xs/GConfClient.xs"
        if (TRUE == check_error) {
                RETVAL = gconf_client_recursive_unset (client, key, flags, &err);
                if (err)
                        gperl_croak_gerror (NULL, err);
        }
        else {
                RETVAL = gconf_client_recursive_unset (client, key, flags, NULL);
        }
#line 787 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif /* GCONF_CHECK_VERSION (2, 3, 3) */

XS(XS_Gnome2__GConf__Client_all_entries); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_all_entries)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, dir, check_error=TRUE");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	dir;
	gboolean	check_error;
#line 437 "xs/GConfClient.xs"
     	GError * err = NULL;
	GSList * l, * tmp;
#line 815 "xs/GConfClient.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	dir = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 440 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		l = gconf_client_all_entries (client, dir, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		l = gconf_client_all_entries (client, dir, NULL);
	}
	for (tmp = l; tmp != NULL; tmp = tmp->next) {
		GConfEntry *entry = (GConfEntry *) tmp->data;
		XPUSHs (sv_2mortal (newSVGConfEntry (entry)));
	}
	g_slist_free (l);
#line 840 "xs/GConfClient.c"
	PUTBACK;
	return;
    }
}


XS(XS_Gnome2__GConf__Client_all_dirs); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_all_dirs)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, dir, check_error=TRUE");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	dir;
	gboolean	check_error;
#line 466 "xs/GConfClient.xs"
     	GError * err = NULL;
	GSList * l, * tmp;
#line 866 "xs/GConfClient.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	dir = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 469 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		l = gconf_client_all_dirs (client, dir, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		l = gconf_client_all_dirs (client, dir, NULL);
	}
	for (tmp = l; tmp != NULL; tmp = tmp->next)
		XPUSHs (sv_2mortal (newSVGChar (tmp->data)));
	g_slist_free (l);
#line 889 "xs/GConfClient.c"
	PUTBACK;
	return;
    }
}


XS(XS_Gnome2__GConf__Client_suggest_sync); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_suggest_sync)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "client, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	gboolean	check_error;
#line 487 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 911 "xs/GConfClient.c"

	if (items < 2)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(1));
	}
#line 489 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		gconf_client_suggest_sync (client, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		gconf_client_suggest_sync (client, NULL);
	}
#line 927 "xs/GConfClient.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Gnome2__GConf__Client_dir_exists); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_dir_exists)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, dir, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	dir;
	gboolean	check_error;
#line 505 "xs/GConfClient.xs"
	GError * err = NULL;
#line 949 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	dir = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 507 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_dir_exists (client, dir, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_dir_exists (client, dir, NULL);
	}
#line 970 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_key_is_writable); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_key_is_writable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gboolean	check_error;
#line 525 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 994 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 527 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_key_is_writable (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_key_is_writable (client, key, NULL);
	}
#line 1015 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_get_float); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_get_float)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gboolean	check_error;
#line 545 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1039 "xs/GConfClient.c"
	gdouble	RETVAL;
	dXSTARG;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 547 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get_float (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_float (client, key, NULL);
	}
#line 1061 "xs/GConfClient.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_get_int); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_get_int)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gboolean	check_error;
#line 565 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1084 "xs/GConfClient.c"
	gint	RETVAL;
	dXSTARG;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 567 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get_int (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_int (client, key, NULL);
	}
#line 1106 "xs/GConfClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_get_string); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_get_string)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gboolean	check_error;
#line 586 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1129 "xs/GConfClient.c"
	gchar_own *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 588 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get_string (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_string (client, key, NULL);
	}
#line 1150 "xs/GConfClient.c"
	ST(0) = sv_newmortal();
	/* used when we can directly own the returned string. */
	/* we have to copy in the case when perl's malloc != gtk's malloc,
         * so best copy all the time. */
	sv_setpv ((SV*)ST(0), RETVAL);
	SvUTF8_on (ST(0));
        g_free (RETVAL);

    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_get_bool); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_get_bool)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gboolean	check_error;
#line 606 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1180 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 608 "xs/GConfClient.xs"
     	if (TRUE == check_error) {
		RETVAL = gconf_client_get_bool (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_bool (client, key, NULL);
	}
#line 1201 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_get_schema); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_get_schema)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "client, key");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
#line 626 "xs/GConfClient.xs"
	GError * err = NULL;
#line 1224 "xs/GConfClient.c"
	GConfSchema *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));
#line 628 "xs/GConfClient.xs"
	RETVAL = gconf_client_get_schema (client, key, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 1234 "xs/GConfClient.c"
	ST(0) = newSVGConfSchema (RETVAL);

	sv_2mortal(ST(0));
#line 634 "xs/GConfClient.xs"
	gconf_schema_free (RETVAL);
#line 1240 "xs/GConfClient.c"
    }
    XSRETURN(1);
}

#if 0
#define XSubPPtmpAAAB 1


XS(XS_Gnome2__GConf__Client_get_list); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_get_list)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gboolean	check_error;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}

	gconf_client_get_list(client, key, check_error);
    }
    XSRETURN_EMPTY;
}


XS(XS_Gnome2__GConf__Client_get_pair); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_get_pair)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gboolean	check_error;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}

	gconf_client_get_pair(client, key, check_error);
    }
    XSRETURN_EMPTY;
}

#endif

XS(XS_Gnome2__GConf__Client_set_float); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_set_float)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, key, val, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gdouble	val = (double)SvNV(ST(2));
	gboolean	check_error;
#line 673 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1329 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3));
	}
#line 675 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_set_float (client, key, val, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_set_float (client, key, val, NULL);
	}
#line 1350 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_set_int); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_set_int)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, key, val, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gint	val = (gint)SvIV(ST(2));
	gboolean	check_error;
#line 697 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1375 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3));
	}
#line 699 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_set_int (client, key, val, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_set_int (client, key, val, NULL);
	}
#line 1396 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_set_string); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_set_string)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, key, val, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	const gchar *	val;
	gboolean	check_error;
#line 721 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1421 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	val = (const gchar *)SvPV_nolen (ST(2));

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3));
	}
#line 723 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_set_string (client, key, val, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_set_string (client, key, val, NULL);
	}
#line 1446 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_set_bool); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_set_bool)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, key, val, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	gboolean	val = (bool)SvTRUE(ST(2));
	gboolean	check_error;
#line 745 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1471 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3));
	}
#line 747 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_set_bool (client, key, val, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_set_bool (client, key, val, NULL);
	}
#line 1492 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_set_schema); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_set_schema)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, key, schema, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	GConfSchema *	schema = SvGConfSchema (ST(2));
	gboolean	check_error;
#line 767 "xs/GConfClient.xs"
	GError * err = NULL;
#line 1517 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3));
	}
#line 769 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_set_schema (client, key, schema, &err);
		gconf_schema_free (schema);	/* leaks otherwise */
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_set_schema (client, key, schema, NULL);
		gconf_schema_free (schema);
	}
#line 1540 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#if 0
#define XSubPPtmpAAAC 1


XS(XS_Gnome2__GConf__Client_set_list); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_set_list)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "client, key, list_type, list, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	const gchar *	list_type;
	SV *	list = ST(3);
	gboolean	check_error;
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	list_type = (const gchar *)SvPV_nolen (ST(2));

	if (items < 5)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(4));
	}

	RETVAL = gconf_client_set_list(client, key, list_type, list, check_error);
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_set_pair); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_set_pair)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "client, key, car, cdr, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	GConfValue *	car = SvGConfValue (ST(2));
	GConfValue *	cdr = SvGConfValue (ST(3));
	gboolean	check_error;
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));

	if (items < 5)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(4));
	}

	RETVAL = gconf_client_set_pair(client, key, car, cdr, check_error);
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif

XS(XS_Gnome2__GConf__Client_error); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_error)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "client, error");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GConfClient *	client = SvGConfClient (ST(0));
	SV *	error = ST(1);
#line 829 "xs/GConfClient.xs"
	GError * err = NULL;
#line 1645 "xs/GConfClient.c"
#line 831 "xs/GConfClient.xs"
	gperl_gerror_from_sv (error, &err);
    	gconf_client_error (client, err);
	/* free err, otherwise we'd leak it. */
	g_error_free (err);
#line 1651 "xs/GConfClient.c"
	PUTBACK;
	return;
    }
}


XS(XS_Gnome2__GConf__Client_unreturned_error); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_unreturned_error)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "client, error");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GConfClient *	client = SvGConfClient (ST(0));
	SV *	error = ST(1);
#line 849 "xs/GConfClient.xs"
    	GError * err = NULL;
#line 1675 "xs/GConfClient.c"
#line 851 "xs/GConfClient.xs"
	gperl_gerror_from_sv (error, &err);
	gconf_client_unreturned_error (client, err);
	/* free err, otherwise we'd leak it. */
	g_error_free (err);
#line 1681 "xs/GConfClient.c"
	PUTBACK;
	return;
    }
}


XS(XS_Gnome2__GConf__Client_value_changed); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_value_changed)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "client, key, value");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GConfClient *	client = SvGConfClient (ST(0));
	const gchar *	key;
	GConfValue *	value = SvGConfValue (ST(2));

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1));
#line 871 "xs/GConfClient.xs"
	gconf_client_value_changed (client, key, value);
	gconf_value_free (value);	/* leaks otherwise */
#line 1711 "xs/GConfClient.c"
	PUTBACK;
	return;
    }
}


XS(XS_Gnome2__GConf__Client_commit_change_set); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_commit_change_set)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, cs, remove_committed, check_error=TRUE");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GConfClient *	client = SvGConfClient (ST(0));
	GConfChangeSet *	cs = SvGConfChangeSet (ST(1));
	gboolean	remove_committed = (bool)SvTRUE(ST(2));
	gboolean	check_error;
#line 903 "xs/GConfClient.xs"
	GError * err = NULL;
	gboolean res;
#line 1738 "xs/GConfClient.c"

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3));
	}
#line 906 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		res = gconf_client_commit_change_set (client, cs, remove_committed, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		res = gconf_client_commit_change_set (client, cs, remove_committed, NULL);
	}

	if ((GIMME_V != G_ARRAY) || (! remove_committed)) {
		/* push on the stack the returned boolean value if the user
		 * wants only that, or if the user does not want to remove
		 * the successfully committed keys. */
		XPUSHs (sv_2mortal (newSViv (res)));
		gconf_change_set_unref (cs);
	}
	else {
		/* push on the stack the returned value AND the reduced set. */
		XPUSHs (sv_2mortal (newSViv (res)));
		XPUSHs (sv_2mortal (newSVGConfChangeSet (cs)));
	}
#line 1767 "xs/GConfClient.c"
	PUTBACK;
	return;
    }
}


XS(XS_Gnome2__GConf__Client_reverse_change_set); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_reverse_change_set)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, cs, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	GConfChangeSet *	cs = SvGConfChangeSet (ST(1));
	gboolean	check_error;
#line 941 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1790 "xs/GConfClient.c"
	GConfChangeSet *	RETVAL;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2));
	}
#line 943 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_reverse_change_set (client, cs, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_reverse_change_set (client, cs, NULL);
	}
#line 1807 "xs/GConfClient.c"
	ST(0) = newSVGConfChangeSet (RETVAL);

	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Gnome2__GConf__Client_change_set_from_current); /* prototype to pass -Wmissing-prototypes */
XS(XS_Gnome2__GConf__Client_change_set_from_current)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2)
       croak_xs_usage(cv,  "client, check_error=TRUE, key, ...");
    {
	GConfClient *	client = SvGConfClient (ST(0));
	gboolean	check_error;
#line 977 "xs/GConfClient.xs"
     	char ** keys;
	int i;
	GError * err = NULL;
#line 1833 "xs/GConfClient.c"
	GConfChangeSet *	RETVAL;

	if (items < 2)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(1));
	}
#line 981 "xs/GConfClient.xs"
    	keys = g_new0 (char *, items - 1);
	for (i = 2; i < items; i++)
		keys[i-1] = SvPV_nolen (ST (i));
	if (TRUE == check_error) {
		RETVAL = gconf_client_change_set_from_currentv (client, (const gchar **) keys, &err);
		g_free (keys);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_change_set_from_currentv (client, (const gchar **) keys, NULL);
		g_free (keys);
	}
#line 1855 "xs/GConfClient.c"
	ST(0) = newSVGConfChangeSet (RETVAL);

	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_Gnome2__GConf__Client); /* prototype to pass -Wmissing-prototypes */
XS(boot_Gnome2__GConf__Client)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK ;

        newXS("Gnome2::GConf::Client::get_default", XS_Gnome2__GConf__Client_get_default, file);
        newXS("Gnome2::GConf::Client::get_for_engine", XS_Gnome2__GConf__Client_get_for_engine, file);
        newXS("Gnome2::GConf::Client::add_dir", XS_Gnome2__GConf__Client_add_dir, file);
        newXS("Gnome2::GConf::Client::remove_dir", XS_Gnome2__GConf__Client_remove_dir, file);
        newXS("Gnome2::GConf::Client::notify_add", XS_Gnome2__GConf__Client_notify_add, file);
        newXS("Gnome2::GConf::Client::notify_remove", XS_Gnome2__GConf__Client_notify_remove, file);
        newXS("Gnome2::GConf::Client::set_error_handling", XS_Gnome2__GConf__Client_set_error_handling, file);
        newXS("Gnome2::GConf::Client::clear_cache", XS_Gnome2__GConf__Client_clear_cache, file);
        newXS("Gnome2::GConf::Client::preload", XS_Gnome2__GConf__Client_preload, file);
        newXS("Gnome2::GConf::Client::set", XS_Gnome2__GConf__Client_set, file);
        newXS("Gnome2::GConf::Client::get", XS_Gnome2__GConf__Client_get, file);
        newXS("Gnome2::GConf::Client::get_without_default", XS_Gnome2__GConf__Client_get_without_default, file);
        newXS("Gnome2::GConf::Client::get_entry", XS_Gnome2__GConf__Client_get_entry, file);
        newXS("Gnome2::GConf::Client::get_default_from_schema", XS_Gnome2__GConf__Client_get_default_from_schema, file);
        newXS("Gnome2::GConf::Client::unset", XS_Gnome2__GConf__Client_unset, file);
#if XSubPPtmpAAAA
        newXS("Gnome2::GConf::Client::recursive_unset", XS_Gnome2__GConf__Client_recursive_unset, file);
#endif
        newXS("Gnome2::GConf::Client::all_entries", XS_Gnome2__GConf__Client_all_entries, file);
        newXS("Gnome2::GConf::Client::all_dirs", XS_Gnome2__GConf__Client_all_dirs, file);
        newXS("Gnome2::GConf::Client::suggest_sync", XS_Gnome2__GConf__Client_suggest_sync, file);
        newXS("Gnome2::GConf::Client::dir_exists", XS_Gnome2__GConf__Client_dir_exists, file);
        newXS("Gnome2::GConf::Client::key_is_writable", XS_Gnome2__GConf__Client_key_is_writable, file);
        newXS("Gnome2::GConf::Client::get_float", XS_Gnome2__GConf__Client_get_float, file);
        newXS("Gnome2::GConf::Client::get_int", XS_Gnome2__GConf__Client_get_int, file);
        newXS("Gnome2::GConf::Client::get_string", XS_Gnome2__GConf__Client_get_string, file);
        newXS("Gnome2::GConf::Client::get_bool", XS_Gnome2__GConf__Client_get_bool, file);
        newXS("Gnome2::GConf::Client::get_schema", XS_Gnome2__GConf__Client_get_schema, file);
#if XSubPPtmpAAAB
        newXS("Gnome2::GConf::Client::get_list", XS_Gnome2__GConf__Client_get_list, file);
        newXS("Gnome2::GConf::Client::get_pair", XS_Gnome2__GConf__Client_get_pair, file);
#endif
        newXS("Gnome2::GConf::Client::set_float", XS_Gnome2__GConf__Client_set_float, file);
        newXS("Gnome2::GConf::Client::set_int", XS_Gnome2__GConf__Client_set_int, file);
        newXS("Gnome2::GConf::Client::set_string", XS_Gnome2__GConf__Client_set_string, file);
        newXS("Gnome2::GConf::Client::set_bool", XS_Gnome2__GConf__Client_set_bool, file);
        newXS("Gnome2::GConf::Client::set_schema", XS_Gnome2__GConf__Client_set_schema, file);
#if XSubPPtmpAAAC
        newXS("Gnome2::GConf::Client::set_list", XS_Gnome2__GConf__Client_set_list, file);
        newXS("Gnome2::GConf::Client::set_pair", XS_Gnome2__GConf__Client_set_pair, file);
#endif
        newXS("Gnome2::GConf::Client::error", XS_Gnome2__GConf__Client_error, file);
        newXS("Gnome2::GConf::Client::unreturned_error", XS_Gnome2__GConf__Client_unreturned_error, file);
        newXS("Gnome2::GConf::Client::value_changed", XS_Gnome2__GConf__Client_value_changed, file);
        newXS("Gnome2::GConf::Client::commit_change_set", XS_Gnome2__GConf__Client_commit_change_set, file);
        newXS("Gnome2::GConf::Client::reverse_change_set", XS_Gnome2__GConf__Client_reverse_change_set, file);
        newXS("Gnome2::GConf::Client::change_set_from_current", XS_Gnome2__GConf__Client_change_set_from_current, file);

    /* Initialisation Section */

#line 104 "xs/GConfClient.xs"
	gperl_signal_set_marshaller_for (GCONF_TYPE_CLIENT, "unreturned_error",
	                                 gconfperl_client_error_marshal);
	gperl_signal_set_marshaller_for (GCONF_TYPE_CLIENT, "error",
					 gconfperl_client_error_marshal);

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#line 1949 "xs/GConfClient.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

