/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.24 from the
 * contents of Rsvg.xs. Do not edit this file, edit Rsvg.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "xs/Rsvg.xs"
/*
 * Copyright (C) 2003-2005, 2010  Torsten Schoenfeld
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "rsvg2perl.h"
#include <gperl_marshal.h>

/* ------------------------------------------------------------------------- */

GPerlCallback *
rsvg2perl_size_func_create (SV *func, SV *data)
{
	return gperl_callback_new (func, data, 0, NULL, 0);
}

void
rsvg2perl_size_func (gint *width,
                     gint *height,
                     GPerlCallback *callback)
{
	int count;
	dGPERL_CALLBACK_MARSHAL_SP;
	GPERL_CALLBACK_MARSHAL_INIT (callback);

	ENTER;
	SAVETMPS;

	PUSHMARK (SP);

	EXTEND (SP, 2);
	PUSHs (sv_2mortal (newSViv (*width)));
	PUSHs (sv_2mortal (newSViv (*height)));

	PUTBACK;

	count = call_sv (callback->func, G_ARRAY);

	SPAGAIN;

	if (count != 2)
		croak ("a size callback must return two values, the width and the height");

	*width = POPi;
	*height = POPi;

	PUTBACK;
	FREETMPS;
	LEAVE;
}

/* ------------------------------------------------------------------------- */

#if LIBRSVG_CHECK_VERSION (2, 14, 0)

static SV *
newSVRsvgDimensionData (RsvgDimensionData *data)
{
	HV *hv;

	if (!data)
		return &PL_sv_undef;

	hv = newHV ();
	hv_store (hv, "width", 5, newSViv (data->width), 0);
	hv_store (hv, "height", 6, newSViv (data->height), 0);
	hv_store (hv, "em", 2, newSVnv (data->em), 0);
	hv_store (hv, "ex", 2, newSVnv (data->ex), 0);

	return newRV_noinc ((SV *) hv);
}

#endif

#if LIBRSVG_CHECK_VERSION (2, 22, 0)

static SV *
newSVRsvgPositionData (RsvgPositionData *data)
{
	HV *hv;

	if (!data)
		return &PL_sv_undef;

	hv = newHV ();
	hv_store (hv, "x", 1, newSViv (data->x), 0);
	hv_store (hv, "y", 1, newSVnv (data->y), 0);

	return newRV_noinc ((SV *) hv);
}

#endif

/* ------------------------------------------------------------------------- */


#line 120 "xs/Rsvg.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)    S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage        S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 262 "xs/Rsvg.c"

XS_EUPXS(XS_Gnome2__Rsvg_GET_VERSION_INFO); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg_GET_VERSION_INFO)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 123 "xs/Rsvg.xs"
	EXTEND (SP, 3);
	PUSHs (sv_2mortal (newSViv (LIBRSVG_MAJOR_VERSION)));
	PUSHs (sv_2mortal (newSViv (LIBRSVG_MINOR_VERSION)));
	PUSHs (sv_2mortal (newSViv (LIBRSVG_MICRO_VERSION)));
	PERL_UNUSED_VAR (ax);
#line 279 "xs/Rsvg.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Gnome2__Rsvg_CHECK_VERSION); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg_CHECK_VERSION)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "class, major, minor, micro");
    {
	int	major = (int)SvIV(ST(1))
;
	int	minor = (int)SvIV(ST(2))
;
	int	micro = (int)SvIV(ST(3))
;
	bool	RETVAL;
#line 135 "xs/Rsvg.xs"
	RETVAL = LIBRSVG_CHECK_VERSION (major, minor, micro);
#line 302 "xs/Rsvg.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg_pixbuf_from_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg_pixbuf_from_file)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, file_name");
    {
	const gchar *	file_name;
#line 148 "xs/Rsvg.xs"
        GError *error = NULL;
#line 319 "xs/Rsvg.c"
	GdkPixbuf_noinc *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	file_name = (const gchar *)SvPV_nolen (ST(1))
;
#line 150 "xs/Rsvg.xs"
	RETVAL = rsvg_pixbuf_from_file (file_name, &error);
        if (error)
		gperl_croak_gerror (file_name, error);
#line 330 "xs/Rsvg.c"
	ST(0) = newSVGdkPixbuf_noinc (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg_pixbuf_from_file_at_zoom); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg_pixbuf_from_file_at_zoom)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "class, file_name, x_zoom, y_zoom");
    {
	const gchar *	file_name;
	double	x_zoom = (double)SvNV(ST(2))
;
	double	y_zoom = (double)SvNV(ST(3))
;
#line 165 "xs/Rsvg.xs"
        GError *error = NULL;
#line 352 "xs/Rsvg.c"
	GdkPixbuf_noinc *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	file_name = (const gchar *)SvPV_nolen (ST(1))
;
#line 167 "xs/Rsvg.xs"
	RETVAL = rsvg_pixbuf_from_file_at_zoom (file_name, x_zoom, y_zoom, &error);
        if (error)
		gperl_croak_gerror (file_name, error);
#line 363 "xs/Rsvg.c"
	ST(0) = newSVGdkPixbuf_noinc (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg_pixbuf_from_file_at_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg_pixbuf_from_file_at_size)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "class, file_name, width, height");
    {
	const gchar *	file_name;
	gint	width = (gint)SvIV(ST(2))
;
	gint	height = (gint)SvIV(ST(3))
;
#line 182 "xs/Rsvg.xs"
        GError *error = NULL;
#line 385 "xs/Rsvg.c"
	GdkPixbuf_noinc *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	file_name = (const gchar *)SvPV_nolen (ST(1))
;
#line 184 "xs/Rsvg.xs"
	RETVAL = rsvg_pixbuf_from_file_at_size (file_name, width, height, &error);
        if (error)
		gperl_croak_gerror (file_name, error);
#line 396 "xs/Rsvg.c"
	ST(0) = newSVGdkPixbuf_noinc (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg_pixbuf_from_file_at_max_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg_pixbuf_from_file_at_max_size)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "class, file_name, max_width, max_height");
    {
	const gchar *	file_name;
	gint	max_width = (gint)SvIV(ST(2))
;
	gint	max_height = (gint)SvIV(ST(3))
;
#line 199 "xs/Rsvg.xs"
        GError *error = NULL;
#line 418 "xs/Rsvg.c"
	GdkPixbuf_noinc *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	file_name = (const gchar *)SvPV_nolen (ST(1))
;
#line 201 "xs/Rsvg.xs"
	RETVAL = rsvg_pixbuf_from_file_at_max_size (file_name, max_width, max_height, &error);
        if (error)
		gperl_croak_gerror (file_name, error);
#line 429 "xs/Rsvg.c"
	ST(0) = newSVGdkPixbuf_noinc (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg_pixbuf_from_file_at_zoom_with_max); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg_pixbuf_from_file_at_zoom_with_max)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "class, file_name, x_zoom, y_zoom, max_width, max_height");
    {
	const gchar *	file_name;
	double	x_zoom = (double)SvNV(ST(2))
;
	double	y_zoom = (double)SvNV(ST(3))
;
	gint	max_width = (gint)SvIV(ST(4))
;
	gint	max_height = (gint)SvIV(ST(5))
;
#line 218 "xs/Rsvg.xs"
        GError *error = NULL;
#line 455 "xs/Rsvg.c"
	GdkPixbuf_noinc *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	file_name = (const gchar *)SvPV_nolen (ST(1))
;
#line 220 "xs/Rsvg.xs"
	RETVAL = rsvg_pixbuf_from_file_at_zoom_with_max (file_name, x_zoom, y_zoom, max_width, max_height, &error);
        if (error)
		gperl_croak_gerror (file_name, error);
#line 466 "xs/Rsvg.c"
	ST(0) = newSVGdkPixbuf_noinc (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg_set_default_dpi); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg_set_default_dpi)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, dpi");
    {
	double	dpi = (double)SvNV(ST(1))
;

	rsvg_set_default_dpi(dpi);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Rsvg_set_default_dpi_x_y); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg_set_default_dpi_x_y)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "class, dpi_x, dpi_y");
    {
	double	dpi_x = (double)SvNV(ST(1))
;
	double	dpi_y = (double)SvNV(ST(2))
;

	rsvg_set_default_dpi_x_y(dpi_x, dpi_y);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	RsvgHandle *	RETVAL;

	RETVAL = rsvg_handle_new(/* void */);
	ST(0) = sv_newmortal();
	sv_setref_pv (ST(0), "Gnome2::Rsvg::Handle", (void *) RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
#line 251 "xs/Rsvg.xs"
	rsvg_handle_free (handle);
#line 536 "xs/Rsvg.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_set_size_callback); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_set_size_callback)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, size_func, user_data=NULL");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	SV *	size_func = ST(1)
;
	SV *	user_data;
#line 260 "xs/Rsvg.xs"
	GPerlCallback *callback;
#line 556 "xs/Rsvg.c"

	if (items < 3)
	    user_data = NULL;
	else {
	    user_data = ST(2)
;
	}
#line 262 "xs/Rsvg.xs"
	callback = rsvg2perl_size_func_create (size_func, user_data);
	rsvg_handle_set_size_callback (handle,
	                               (RsvgSizeFunc) rsvg2perl_size_func,
	                               callback,
	                               (GDestroyNotify) gperl_callback_destroy);
#line 570 "xs/Rsvg.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_write); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_write)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, data");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	SV *	data = ST(1)
;
#line 276 "xs/Rsvg.xs"
	const guchar *buf = NULL;
	STRLEN len;
        GError *error = NULL;
#line 591 "xs/Rsvg.c"
	gboolean	RETVAL;
#line 280 "xs/Rsvg.xs"
	buf = (const guchar *) SvPV (data, len);
	RETVAL = rsvg_handle_write (handle, buf, len, &error);
        if (error)
		gperl_croak_gerror (NULL, error);
#line 598 "xs/Rsvg.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_close); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_close)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
#line 294 "xs/Rsvg.xs"
        GError *error = NULL;
#line 616 "xs/Rsvg.c"
	gboolean	RETVAL;
#line 296 "xs/Rsvg.xs"
	RETVAL = rsvg_handle_close (handle, &error);
        if (error)
		gperl_croak_gerror (NULL, error);
#line 622 "xs/Rsvg.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#if LIBRSVG_CHECK_VERSION (2, 14, 0)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Gnome2__Rsvg__Handle_new_from_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_new_from_data)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, data");
    {
#line 310 "xs/Rsvg.xs"
	const guint8 *real_data;
	gsize data_len = 0;
	GError *error = NULL;
#line 643 "xs/Rsvg.c"
	RsvgHandle *	RETVAL;
	SV *	data = ST(1)
;
#line 314 "xs/Rsvg.xs"
	real_data = (const guint8 *) SvPV (data, data_len);
	RETVAL = rsvg_handle_new_from_data (real_data, data_len, &error);
	if (error)
		gperl_croak_gerror (NULL, error);
#line 652 "xs/Rsvg.c"
	ST(0) = sv_newmortal();
	sv_setref_pv (ST(0), "Gnome2::Rsvg::Handle", (void *) RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_new_from_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_new_from_file)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, file_name");
    {
#line 328 "xs/Rsvg.xs"
	GError *error = NULL;
#line 669 "xs/Rsvg.c"
	RsvgHandle *	RETVAL;
	const char *	file_name = (const char *)SvPV_nolen(ST(1))
;
#line 330 "xs/Rsvg.xs"
	RETVAL = rsvg_handle_new_from_file (file_name, &error);
	if (error)
		gperl_croak_gerror (NULL, error);
#line 677 "xs/Rsvg.c"
	ST(0) = sv_newmortal();
	sv_setref_pv (ST(0), "Gnome2::Rsvg::Handle", (void *) RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_pixbuf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_pixbuf)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	GdkPixbuf_noinc *	RETVAL;

	RETVAL = rsvg_handle_get_pixbuf(handle);
	ST(0) = newSVGdkPixbuf_noinc (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#if LIBRSVG_CHECK_VERSION (2, 14, 0)
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_pixbuf_sub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_pixbuf_sub)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, id");
    {
	GdkPixbuf_noinc *	RETVAL;
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	const char_ornull *	id;

	if (gperl_sv_is_defined (ST(1))) {
		id = (const char_ornull *)SvPV_nolen (ST(1));
	} else {
		id = NULL;
	}
;

	RETVAL = rsvg_handle_get_pixbuf_sub(handle, id);
	ST(0) = newSVGdkPixbuf_noinc (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif
#if LIBRSVG_CHECK_VERSION (2, 4, 0)
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_title); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_title)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = rsvg_handle_get_title(handle);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_desc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_desc)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = rsvg_handle_get_desc(handle);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

#endif /* 2.4.0 */
#if LIBRSVG_CHECK_VERSION (2, 14, 0)
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_dimensions); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_dimensions)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
#line 369 "xs/Rsvg.xs"
	RsvgDimensionData dimension_data = {0,};
#line 790 "xs/Rsvg.c"
	SV *	RETVAL;
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
#line 371 "xs/Rsvg.xs"
	rsvg_handle_get_dimensions (handle, &dimension_data);
	RETVAL = newSVRsvgDimensionData (&dimension_data);
#line 797 "xs/Rsvg.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif
#if LIBRSVG_CHECK_VERSION (2, 22, 0)
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_dimensions_sub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_dimensions_sub)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, id");
    {
#line 384 "xs/Rsvg.xs"
	RsvgDimensionData dimension_data = {0,};
#line 818 "xs/Rsvg.c"
	SV *	RETVAL;
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	const char_ornull *	id;

	if (gperl_sv_is_defined (ST(1))) {
		id = (const char_ornull *)SvPV_nolen (ST(1));
	} else {
		id = NULL;
	}
;
#line 386 "xs/Rsvg.xs"
	if (!rsvg_handle_get_dimensions_sub (handle, &dimension_data, id))
		RETVAL = &PL_sv_undef;
	else
		RETVAL = newSVRsvgDimensionData (&dimension_data);
#line 835 "xs/Rsvg.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_position_sub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_position_sub)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, id");
    {
#line 397 "xs/Rsvg.xs"
	RsvgPositionData position_data = {0,};
#line 852 "xs/Rsvg.c"
	SV *	RETVAL;
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	const char_ornull *	id;

	if (gperl_sv_is_defined (ST(1))) {
		id = (const char_ornull *)SvPV_nolen (ST(1));
	} else {
		id = NULL;
	}
;
#line 399 "xs/Rsvg.xs"
	if (!rsvg_handle_get_position_sub (handle, &position_data, id))
		RETVAL = &PL_sv_undef;
	else
		RETVAL = newSVRsvgPositionData (&position_data);
#line 869 "xs/Rsvg.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_has_sub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_has_sub)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, id");
    {
	gboolean	RETVAL;
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	const char *	id = (const char *)SvPV_nolen(ST(1))
;

	RETVAL = rsvg_handle_has_sub(handle, id);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Gnome2__Rsvg__Handle_set_dpi); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_set_dpi)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, dpi");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	double	dpi = (double)SvNV(ST(1))
;

	rsvg_handle_set_dpi(handle, dpi);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_set_dpi_x_y); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_set_dpi_x_y)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, dpi_x, dpi_y");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	double	dpi_x = (double)SvNV(ST(1))
;
	double	dpi_y = (double)SvNV(ST(2))
;

	rsvg_handle_set_dpi_x_y(handle, dpi_x, dpi_y);
    }
    XSRETURN_EMPTY;
}

#if LIBRSVG_CHECK_VERSION (2, 10, 0)
#define XSubPPtmpAAAF 1


XS_EUPXS(XS_Gnome2__Rsvg__Handle_set_base_uri); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_set_base_uri)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, base_uri");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	const char *	base_uri = (const char *)SvPV_nolen(ST(1))
;

	rsvg_handle_set_base_uri(handle, base_uri);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_base_uri); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_base_uri)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	const char_ornull *	RETVAL;

	RETVAL = rsvg_handle_get_base_uri(handle);
	ST(0) = sv_newmortal();
	if (RETVAL) {
		sv_setpv ((SV*)ST(0), RETVAL);
	} else {
		SvSetSV (ST(0), &PL_sv_undef);
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_metadata); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_get_metadata)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	const char_ornull *	RETVAL;

	RETVAL = rsvg_handle_get_metadata(handle);
	ST(0) = sv_newmortal();
	if (RETVAL) {
		sv_setpv ((SV*)ST(0), RETVAL);
	} else {
		SvSetSV (ST(0), &PL_sv_undef);
	}
    }
    XSRETURN(1);
}

#endif /* 2.10.0 */
#if LIBRSVG_CHECK_VERSION (2, 22, 0)
#define XSubPPtmpAAAG 1


XS_EUPXS(XS_Gnome2__Rsvg__Handle_render_cairo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_render_cairo)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, cr");
    {
	gboolean	RETVAL;
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	cairo_t *	cr = SvCairo (ST(1))
;

	RETVAL = rsvg_handle_render_cairo(handle, cr);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_render_cairo_sub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_render_cairo_sub)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, cr, id");
    {
	gboolean	RETVAL;
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	cairo_t *	cr = SvCairo (ST(1))
;
	const char_ornull *	id;

	if (gperl_sv_is_defined (ST(2))) {
		id = (const char_ornull *)SvPV_nolen (ST(2));
	} else {
		id = NULL;
	}
;

	RETVAL = rsvg_handle_render_cairo_sub(handle, cr, id);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#else
#if LIBRSVG_CHECK_VERSION (2, 14, 0)
#define XSubPPtmpAAAH 1


XS_EUPXS(XS_Gnome2__Rsvg__Handle_render_cairo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_render_cairo)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, cr");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	cairo_t *	cr = SvCairo (ST(1))
;

	rsvg_handle_render_cairo(handle, cr);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Rsvg__Handle_render_cairo_sub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Rsvg__Handle_render_cairo_sub)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, cr, id");
    {
	RsvgHandle *	handle = INT2PTR (RsvgHandle *, SvIV ((SV *) SvRV (ST(0))))
;
	cairo_t *	cr = SvCairo (ST(1))
;
	const char_ornull *	id;

	if (gperl_sv_is_defined (ST(2))) {
		id = (const char_ornull *)SvPV_nolen (ST(2));
	} else {
		id = NULL;
	}
;

	rsvg_handle_render_cairo_sub(handle, cr, id);
    }
    XSRETURN_EMPTY;
}

#endif
#endif
#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Gnome2__Rsvg); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Gnome2__Rsvg)
{
    dVAR; dXSARGS;
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK;

        newXS("Gnome2::Rsvg::GET_VERSION_INFO", XS_Gnome2__Rsvg_GET_VERSION_INFO, file);
        newXS("Gnome2::Rsvg::CHECK_VERSION", XS_Gnome2__Rsvg_CHECK_VERSION, file);
        newXS("Gnome2::Rsvg::pixbuf_from_file", XS_Gnome2__Rsvg_pixbuf_from_file, file);
        newXS("Gnome2::Rsvg::pixbuf_from_file_at_zoom", XS_Gnome2__Rsvg_pixbuf_from_file_at_zoom, file);
        newXS("Gnome2::Rsvg::pixbuf_from_file_at_size", XS_Gnome2__Rsvg_pixbuf_from_file_at_size, file);
        newXS("Gnome2::Rsvg::pixbuf_from_file_at_max_size", XS_Gnome2__Rsvg_pixbuf_from_file_at_max_size, file);
        newXS("Gnome2::Rsvg::pixbuf_from_file_at_zoom_with_max", XS_Gnome2__Rsvg_pixbuf_from_file_at_zoom_with_max, file);
        newXS("Gnome2::Rsvg::set_default_dpi", XS_Gnome2__Rsvg_set_default_dpi, file);
        newXS("Gnome2::Rsvg::set_default_dpi_x_y", XS_Gnome2__Rsvg_set_default_dpi_x_y, file);
        newXS("Gnome2::Rsvg::Handle::new", XS_Gnome2__Rsvg__Handle_new, file);
        newXS("Gnome2::Rsvg::Handle::DESTROY", XS_Gnome2__Rsvg__Handle_DESTROY, file);
        newXS("Gnome2::Rsvg::Handle::set_size_callback", XS_Gnome2__Rsvg__Handle_set_size_callback, file);
        newXS("Gnome2::Rsvg::Handle::write", XS_Gnome2__Rsvg__Handle_write, file);
        newXS("Gnome2::Rsvg::Handle::close", XS_Gnome2__Rsvg__Handle_close, file);
#if XSubPPtmpAAAA
        newXS("Gnome2::Rsvg::Handle::new_from_data", XS_Gnome2__Rsvg__Handle_new_from_data, file);
        newXS("Gnome2::Rsvg::Handle::new_from_file", XS_Gnome2__Rsvg__Handle_new_from_file, file);
#endif
        newXS("Gnome2::Rsvg::Handle::get_pixbuf", XS_Gnome2__Rsvg__Handle_get_pixbuf, file);
#if XSubPPtmpAAAB
        newXS("Gnome2::Rsvg::Handle::get_pixbuf_sub", XS_Gnome2__Rsvg__Handle_get_pixbuf_sub, file);
#endif
#if XSubPPtmpAAAC
        newXS("Gnome2::Rsvg::Handle::get_title", XS_Gnome2__Rsvg__Handle_get_title, file);
        newXS("Gnome2::Rsvg::Handle::get_desc", XS_Gnome2__Rsvg__Handle_get_desc, file);
#endif
#if XSubPPtmpAAAD
        newXS("Gnome2::Rsvg::Handle::get_dimensions", XS_Gnome2__Rsvg__Handle_get_dimensions, file);
#endif
#if XSubPPtmpAAAE
        newXS("Gnome2::Rsvg::Handle::get_dimensions_sub", XS_Gnome2__Rsvg__Handle_get_dimensions_sub, file);
        newXS("Gnome2::Rsvg::Handle::get_position_sub", XS_Gnome2__Rsvg__Handle_get_position_sub, file);
        newXS("Gnome2::Rsvg::Handle::has_sub", XS_Gnome2__Rsvg__Handle_has_sub, file);
#endif
        newXS("Gnome2::Rsvg::Handle::set_dpi", XS_Gnome2__Rsvg__Handle_set_dpi, file);
        newXS("Gnome2::Rsvg::Handle::set_dpi_x_y", XS_Gnome2__Rsvg__Handle_set_dpi_x_y, file);
#if XSubPPtmpAAAF
        newXS("Gnome2::Rsvg::Handle::set_base_uri", XS_Gnome2__Rsvg__Handle_set_base_uri, file);
        newXS("Gnome2::Rsvg::Handle::get_base_uri", XS_Gnome2__Rsvg__Handle_get_base_uri, file);
        newXS("Gnome2::Rsvg::Handle::get_metadata", XS_Gnome2__Rsvg__Handle_get_metadata, file);
#endif
#if XSubPPtmpAAAG
        newXS("Gnome2::Rsvg::Handle::render_cairo", XS_Gnome2__Rsvg__Handle_render_cairo, file);
        newXS("Gnome2::Rsvg::Handle::render_cairo_sub", XS_Gnome2__Rsvg__Handle_render_cairo_sub, file);
#endif
#if XSubPPtmpAAAH
        newXS("Gnome2::Rsvg::Handle::render_cairo", XS_Gnome2__Rsvg__Handle_render_cairo, file);
        newXS("Gnome2::Rsvg::Handle::render_cairo_sub", XS_Gnome2__Rsvg__Handle_render_cairo_sub, file);
#endif

    /* Initialisation Section */

#line 117 "xs/Rsvg.xs"
#include "register.xsh"
#include "boot.xsh"

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#if XSubPPtmpAAAG
#endif
#if XSubPPtmpAAAH
#endif
#line 1196 "xs/Rsvg.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

