/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.28 from the
 * contents of Int64.xs. Do not edit this file, edit Int64.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "Int64.xs"
/* -*- Mode: C -*- */

#define PERL_NO_GET_CONTEXT 1

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#define NEED_sv_2pvbyte
#define NEED_sv_2pv_flags
#include "ppport.h"

static int may_die_on_overflow;
static int may_use_native;

#ifdef HAS_STDINT_H
#include <stdint.h>
#endif

#define NV_0x1p15 ((NV)32768)
#define NV_0x1p16 ((NV)65536)
#define NV_0x1p31 (NV_0x1p16 * NV_0x1p15)
#define NV_0x1p32 (NV_0x1p16 * NV_0x1p16)
#define NV_0x1p63 (NV_0x1p32 * NV_0x1p31)
#define NV_0x1p64 (NV_0x1p32 * NV_0x1p32)

#ifdef _MSC_VER
#include <stdlib.h>

#ifndef INT64_MAX
#define INT64_MAX _I64_MAX
#endif
#ifndef INT64_MIN
#define INT64_MIN _I64_MIN
#endif
#ifndef UINT64_MAX
#define UINT64_MAX _UI64_MAX
#endif
#ifndef UINT32_MAX
#define UINT32_MAX _UI32_MAX
#endif

#endif

#ifdef USE_INT64_T
/* do nothing */

#elif defined(USE___INT64)
typedef __int64 int64_t;
typedef unsigned __int64 uint64_t;

#elif defined(USE_INT64_DI)
typedef int int64_t __attribute__ ((__mode__ (DI)));
typedef unsigned int uint64_t __attribute__ ((__mode__ (DTI)));

#else
#error "No int64 type define was passed to the compiler!"
#endif

#if ((defined _MSC_VER) || (defined INT64_MY_NV2U64))

/* Old MS compilers do not implement the double->uint64 conversion and
 * silently do a double->int64 conversion instead. See
 * http://connect.microsoft.com/VisualStudio/feedback/details/270762/error-in-converting-double-to-unsigned-long-long */

/* I don't trust atof, so I generate 2**-32 from simpler constants and
 * hope the optimizer will do its work properly */

#define NV_0x1p_4 ((NV)0.0625)
#define NV_0x1p_16 (NV_0x1p_4 * NV_0x1p_4 * NV_0x1p_4 * NV_0x1p_4)
#define NV_0x1p_32 (NV_0x1p_16 * NV_0x1p_16)

static uint64_t
nv2u64(NV nv) {
    if ((nv > 0.0) && (nv < NV_0x1p64)) {
        uint64_t h = nv * NV_0x1p_32;
        uint64_t l = nv - (NV)(int64_t)h * NV_0x1p32;
        return ((h << 32) + l);
    }
    return 0;
}
#define NV2U64(nv) nv2u64(nv)

#  if defined(_MSC_VER) && _MSC_VER >= 1300
#    define U642NV(u64) ((NV)(u64))
#  else
static NV
u642nv(uint64_t u64) {
    unsigned long h = u64 >> 32;
    unsigned long l = u64 & 0xffffffff;
    return (NV_0x1p32 * h) + (NV)l;
}
#    define U642NV(nv) u642nv(nv)
#  endif
#else
#define NV2U64(nv) ((uint64_t)(nv))
#define U642NV(u64) ((NV)(u64))
#endif

#if (PERL_VERSION >= 10)

#ifndef cop_hints_fetch_pvs
#define cop_hints_fetch_pvs(cop, key, flags) \
    Perl_refcounted_he_fetch(aTHX_ (cop)->cop_hints_hash, NULL, STR_WITH_LEN(key), (flags), 0)
#endif

static int
check_die_on_overflow_hint(pTHX) {
    SV *hint = cop_hints_fetch_pvs(PL_curcop, "Math::Int64::die_on_overflow", 0);
    return (hint && SvTRUE(hint));
}

static int
check_use_native_hint(pTHX) {
    SV *hint = cop_hints_fetch_pvs(PL_curcop, "Math::Int64::native_if_available", 0);
    return (hint && SvTRUE(hint));
}

#define use_native (may_use_native && check_use_native_hint(aTHX))

#else

static int
check_die_on_overflow_hint(pTHX) {
    return 1;
}

static int
check_use_native_hint(pTHX) {
    return 1;
}

#define use_native may_use_native

#endif

static void
overflow(pTHX_ const char *msg) {
    if (check_die_on_overflow_hint(aTHX))
        Perl_croak(aTHX_ "Math::Int64 overflow: %s", msg);
}

static const char *out_of_bounds_error_s  = "Number is out of bounds for int64_t conversion";
static const char *out_of_bounds_error_u  = "Number is out of bounds for uint64_t conversion";
static const char *mul_error              = "Multiplication overflows";
static const char *add_error              = "Addition overflows";
static const char *sub_error              = "Subtraction overflows";
static const char *inc_error              = "Increment operation wraps";
static const char *dec_error              = "Decrement operation wraps";
static const char *div_by_0_error         = "Illegal division by zero";
static const char *pow_error              = "Exponentiation overflows";
static const char *invalid_length_error_s = "Invalid length for int64";
static const char *invalid_length_error_u = "Invalid length for uint64";
static const char *invalid_BER_error      = "Invalid BER encoding";

static void croak_string(pTHX_ const char *str) {
    Perl_croak(aTHX_ "%s", str);
}

#include "strtoint64.h"
#include "isaac64.h"

#define MY_CXT_KEY "Math::Int64::isaac64_state" XS_VERSION
typedef struct {
    isaac64_state_t is;
} my_cxt_t;
START_MY_CXT

#if defined(INT64_BACKEND_NV)
#  define BACKEND "NV"
#  define SvI64Y SvNVX
#  define SvI64_onY SvNOK_on
#  define SVt_I64 SVt_NV
#elif defined(INT64_BACKEND_IV)
#  define BACKEND "IV"
#  define SvI64Y SvIVX
#  define SvI64_onY SvIOK_on
#  define SVt_I64 SVt_IV
#else
#  error "unsupported backend"
#endif

static int
SvI64OK(pTHX_ SV *sv) {
    if (SvROK(sv)) {
        SV *si64 = SvRV(sv);
        return (si64 && (SvTYPE(si64) >= SVt_I64) && sv_isa(sv, "Math::Int64"));
    }
    return 0;
}

static int
SvU64OK(pTHX_ SV *sv) {
    if (SvROK(sv)) {
        SV *su64 = SvRV(sv);
        return (su64 && (SvTYPE(su64) >= SVt_I64) && sv_isa(sv, "Math::UInt64"));
    }
    return 0;
}

static SV *
newSVi64(pTHX_ int64_t i64) {
    SV *sv;
    SV *si64 = newSV(0);
    SvUPGRADE(si64, SVt_I64);
    SvI64_onY(si64);
    sv = newRV_noinc(si64);
    sv_bless(sv, gv_stashpvs("Math::Int64", TRUE));
    *(int64_t*)(&(SvI64Y(si64))) = i64;
    SvREADONLY_on(si64);
    return sv;
}

static SV *
newSVu64(pTHX_ uint64_t u64) {
    SV *sv;
    SV *su64 = newSV(0);
    SvUPGRADE(su64, SVt_I64);
    SvI64_onY(su64);
    sv = newRV_noinc(su64);
    sv_bless(sv, gv_stashpvs("Math::UInt64", TRUE));
    *(int64_t*)(&(SvI64Y(su64))) = u64;
    SvREADONLY_on(su64);
    return sv;
}

#define SvI64X(sv) (*(int64_t*)(&(SvI64Y(SvRV(sv)))))
#define SvU64X(sv) (*(uint64_t*)(&(SvI64Y(SvRV(sv)))))

static SV *
SvSI64(pTHX_ SV *sv) {
    if (SvROK(sv)) {
        SV *si64 = SvRV(sv);
        if (si64 && (SvTYPE(si64) >= SVt_I64))
            return si64;
    }
    croak_string(aTHX_ "internal error: reference to NV expected");
    return NULL; /* this dead code is a workaround for OpenWatcom */
}

static SV *
SvSU64(pTHX_ SV *sv) {
    if (SvROK(sv)) {
        SV *su64 = SvRV(sv);
        if (su64 && (SvTYPE(su64) >= SVt_I64))
            return su64;
    }
    croak_string(aTHX_ "internal error: reference to NV expected");
    return NULL; /* this dead code is a workaround for OpenWatcom */
}

#define SvI64x(sv) (*(int64_t*)(&(SvI64Y(SvSI64(aTHX_ sv)))))
#define SvU64x(sv) (*(uint64_t*)(&(SvI64Y(SvSU64(aTHX_ sv)))))

static int64_t
SvI64(pTHX_ SV *sv) {
    if (SvROK(sv)) {
        SV *si64 = SvRV(sv);
        if (si64 && SvOBJECT(si64)) {
            GV *method;
            HV *stash = SvSTASH(si64);
            char const * classname = HvNAME_get(stash);
            if (memcmp(classname, "Math::", 6) == 0) {
                int u;
                if (classname[6] == 'U') {
                    u = 1;
                    classname += 7;
                }
                else {
                    u = 0;
                    classname += 6;
                }
                if (memcmp(classname, "Int64", 6) == 0) {
                    if (SvTYPE(si64) < SVt_I64)
                        Perl_croak(aTHX_ "Wrong internal representation for %s object", HvNAME_get(stash));
                    if (u) {
                        uint64_t u = *(uint64_t*)(&(SvI64Y(si64)));
                        if (may_die_on_overflow && (u > INT64_MAX)) overflow(aTHX_ out_of_bounds_error_s);
                        return u;
                    }
                    else {
                        return *(int64_t*)(&(SvI64Y(si64)));
                    }
                }
            }
            method = gv_fetchmethod(stash, "as_int64");
            if (method) {
                SV *result;
                int count;
                dSP;
                ENTER;
                SAVETMPS;
                PUSHSTACKi(PERLSI_MAGIC);
                PUSHMARK(SP);
                XPUSHs(sv);
                PUTBACK;
                count = perl_call_sv( (SV*)method, G_SCALAR );
                SPAGAIN;
                if (count != 1)
                    Perl_croak(aTHX_ "internal error: method call returned %d values, 1 expected", count);
                result = newSVsv(POPs);
                PUTBACK;
                POPSTACK;
                SPAGAIN;
                FREETMPS;
                LEAVE;
                return SvI64(aTHX_ sv_2mortal(result));
            }
        }
    }
    else {
        SvGETMAGIC(sv);
        if (SvIOK(sv)) {
            if (SvIOK_UV(sv)) {
                UV uv = SvUV(sv);
                if (may_die_on_overflow &&
                    (uv > INT64_MAX)) overflow(aTHX_ out_of_bounds_error_s);
                return uv;
            }
            return SvIV(sv);
        }
        if (SvNOK(sv)) {
            NV nv = SvNV(sv);
            if ( may_die_on_overflow &&
                 ((nv >= NV_0x1p63) || (nv < -NV_0x1p63)) ) overflow(aTHX_ out_of_bounds_error_s);
            return nv;
        }
    }
    return strtoint64(aTHX_ SvPV_nolen(sv), 10, 1);
}

static uint64_t
SvU64(pTHX_ SV *sv) {
    if (SvROK(sv)) {
        SV *su64 = SvRV(sv);
        if (su64 && SvOBJECT(su64)) {
            GV *method;
            HV *stash = SvSTASH(su64);
            char const * classname = HvNAME_get(stash);
            if (memcmp(classname, "Math::", 6) == 0) {
                int u;
                if (classname[6] == 'U') {
                    u = 1;
                    classname += 7;
                }
                else {
                    u = 0;
                    classname += 6;
                }
                if (memcmp(classname, "Int64", 6) == 0) {
                    if (SvTYPE(su64) < SVt_I64)
                        Perl_croak(aTHX_ "Wrong internal representation for %s object", HvNAME_get(stash));
                    if (u) {
                        return *(uint64_t*)(&(SvI64Y(su64)));
                    }
                    else {
                        int64_t i = *(int64_t*)(&(SvI64Y(su64)));
                        if (may_die_on_overflow && (i < 0)) overflow(aTHX_ out_of_bounds_error_u);
                        return i;
                    }
                }
            }
            method = gv_fetchmethod(SvSTASH(su64), "as_uint64");
            if (method) {
                SV *result;
                int count;
                dSP;
                ENTER;
                SAVETMPS;
                PUSHSTACKi(PERLSI_MAGIC);
                PUSHMARK(SP);
                XPUSHs(sv);
                PUTBACK;
                count = perl_call_sv( (SV*)method, G_SCALAR );
                SPAGAIN;
                if (count != 1)
                    Perl_croak(aTHX_ "internal error: method call returned %d values, 1 expected", count);
                result = newSVsv(POPs);
                PUTBACK;
                POPSTACK;
                SPAGAIN;
                FREETMPS;
                LEAVE;
                return SvU64(aTHX_ sv_2mortal(result));
            }
        }
    }
    else {
        SvGETMAGIC(sv);
        if (SvIOK(sv)) {
            if (SvIOK_UV(sv)) {
                return SvUV(sv);
            }
            else {
                IV iv = SvIV(sv);
                if (may_die_on_overflow &&
                    (iv < 0) ) overflow(aTHX_ out_of_bounds_error_u);
                return SvIV(sv);
            }
        }
        if (SvNOK(sv)) {
            NV nv = SvNV(sv);
            if (may_die_on_overflow &&
                ( (nv < 0) || (nv >= NV_0x1p64)) ) overflow(aTHX_ out_of_bounds_error_u);
            return NV2U64(nv);
        }
    }
    return strtoint64(aTHX_ SvPV_nolen(sv), 10, 0);
}

static SV *
si64_to_number(pTHX_ SV *sv) {
    int64_t i64 = SvI64(aTHX_ sv);
    if (i64 < 0) {
        IV iv = i64;
        if (iv == i64)
            return newSViv(iv);
    }
    else {
        UV uv = i64;
        if (uv == i64)
            return newSVuv(uv);
    }
    return newSVnv(i64);
}

static SV *
su64_to_number(pTHX_ SV *sv) {
    uint64_t u64 = SvU64(aTHX_ sv);
    UV uv = u64;
    if (uv == u64)
        return newSVuv(uv);
    return newSVnv(U642NV(u64));
}

#define I64STRLEN 65

static SV *
u64_to_string_with_sign(pTHX_ uint64_t u64, int base, int sign) {
    char str[I64STRLEN];
    int len = 0;
    if ((base > 36) || (base < 2))
        Perl_croak(aTHX_ "base %d out of range [2,36]", base);
    while (u64) {
        char c = u64 % base;
        u64 /= base;
        str[len++] = c + (c > 9 ? 'A' - 10 : '0');
    }
    if (len) {
        int i;
        int svlen = len + (sign ? 1 : 0);
        SV *sv = newSV(svlen);
        char *pv = SvPVX(sv);
        SvPOK_on(sv);
        SvCUR_set(sv, svlen);
        if (sign) *(pv++) = '-';
        for (i = len; i--;) *(pv++) = str[i];
        *pv = '\0';
        return sv;
    }
    else {
        return newSVpvs("0");
    }
}

static SV *
i64_to_string(pTHX_ int64_t i64, int base) {
    if (i64 < 0) {    
        return u64_to_string_with_sign(aTHX_ -i64, base, 1);
    }
    return u64_to_string_with_sign(aTHX_ i64, base, 0);
}

static uint64_t
randU64(pTHX) {
    dMY_CXT;
    return rand64(&(MY_CXT.is));
}

static void
mul_check_overflow(pTHX_ uint64_t a, uint64_t b, const char *error_str) {
    if (a < b) {
        uint64_t tmp = a;
        a = b; b = tmp;
    }
    if (b > UINT32_MAX) overflow(aTHX_ error_str);
    else {
        uint64_t rl, rh;
        rl = (a & UINT32_MAX) * b;
        rh = (a >> 32) * b + (rl >> 32);
        if (rh > UINT32_MAX) overflow(aTHX_ error_str);
    }
}

static uint64_t
powU64(pTHX_ uint64_t a, uint64_t b) {
    uint64_t r;
    int mdoo = may_die_on_overflow;
    if (b == 0) return 1;
    if (b == 1) return a;
    if (b == 2) {
        if (mdoo && (a > UINT32_MAX)) overflow(aTHX_ pow_error);
        return a*a;
    }
    if (a == 0) return 0;
    if (a == 1) return 1;
    if (a == 2) {
        if (b > 63) {
            if (mdoo) overflow(aTHX_ pow_error);
            return 0;
        }
        return (((uint64_t)1) << b);
    }
    if (mdoo) {
        r = ((b & 1) ? a : 1);
        while ((b >>= 1)) {
            if (a > UINT32_MAX) overflow(aTHX_ pow_error);
            a *= a;
            if (b & 1) {
                mul_check_overflow(aTHX_ r, a, pow_error);
                r *= a;
            }
        }
    }
    else {
        r = 1;
        while (b) {
            if (b & 1) r *= a;
            a *= a;
            b >>= 1;
        }
    }
    return r;
}

static SV *
uint64_to_BER(pTHX_ uint64_t a) {
    char buffer[10];
    char *top = buffer + sizeof(buffer);
    char *p = top;
    *(--p) = (a & 0x7f);
    while ((a >>= 7)) {
        *(--p) = (a & 0x7f) | 0x80;

    }
    return newSVpvn(p, top - p);
}

static SV *
int64_to_BER(pTHX_ int64_t a) {
    return uint64_to_BER(aTHX_
                         a < 0
                         ? ( ( ( ~(uint64_t)a) << 1 ) | 1 )
                         : ( ( (  (uint64_t)a) << 1 ) | 0 ) );
}

static uint64_t
BER_to_uint64(pTHX_ SV *sv) {
    STRLEN len;
    char *pv = SvPVbyte(sv, len);
    uint64_t a;
    IV i;
    for (i = 0, a = 0; i < len; i++) {
        if (may_die_on_overflow && (a > (((uint64_t)1) << (63 - 7))))
            overflow(aTHX_ out_of_bounds_error_u);
        a = (a << 7) | (pv[i] & 0x7f);
        if ((pv[i] & 0x80) == 0) {
            if (i + 1 != len) croak_string(aTHX_ invalid_BER_error);
            return a;
        }
    }
    croak_string(aTHX_ invalid_BER_error);
    return 0; /* this dead code is a workaround for OpenWatcom */
}

static int64_t
BER_to_int64(pTHX_ SV *sv) {
    uint64_t a = BER_to_uint64(aTHX_ sv);
    int64_t b = (int64_t)(a >> 1);
    return (a & 1 ? ~b : b);
}

static IV
BER_length(pTHX_ SV *sv) {
    STRLEN len;
    char *pv = SvPVbyte(sv, len);
    IV i;
    for (i = 0; i < len; i++) {
      if ((pv[i] & 0x80) == 0) return i + 1;
    }
    return -1;
}

#include "c_api.h"

#line 606 "Int64.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 750 "Int64.c"

XS_EUPXS(XS_Math__Int64__backend); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__backend)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	char *	RETVAL;
	dXSTARG;
#line 611 "Int64.xs"
    RETVAL = BACKEND;
#line 763 "Int64.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__set_may_die_on_overflow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__set_may_die_on_overflow)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "v");
    {
	int	v = (int)SvIV(ST(0))
;
#line 619 "Int64.xs"
    may_die_on_overflow = v;
#line 781 "Int64.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Math__Int64__set_may_use_native); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__set_may_use_native)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "v");
    {
	int	v = (int)SvIV(ST(0))
;
#line 625 "Int64.xs"
    may_use_native = v;
#line 798 "Int64.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Math__Int64_int64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_int64)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "value=&PL_sv_undef");
    {
	SV *	value;
	SV *	RETVAL;

	if (items < 1)
	    value = &PL_sv_undef;
	else {
	    value = ST(0)
;
	}
#line 631 "Int64.xs"
    RETVAL = (use_native
              ? newSViv(SvIV(value))
              : newSVi64(aTHX_ SvI64(aTHX_ value)));
#line 824 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_uint64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_uint64)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "value=&PL_sv_undef");
    {
	SV *	value;
	SV *	RETVAL;

	if (items < 1)
	    value = &PL_sv_undef;
	else {
	    value = ST(0)
;
	}
#line 641 "Int64.xs"
    RETVAL = (use_native
              ? newSVuv(SvUV(value))
              : newSVu64(aTHX_ SvU64(aTHX_ value)));
#line 852 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_int64_to_number); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_int64_to_number)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
	SV *	RETVAL;
#line 651 "Int64.xs"
    RETVAL = si64_to_number(aTHX_ self);
#line 872 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_uint64_to_number); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_uint64_to_number)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
	SV *	RETVAL;
#line 659 "Int64.xs"
    RETVAL = su64_to_number(aTHX_ self);
#line 892 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_net_to_int64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_net_to_int64)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "net");
    {
	SV *	net = ST(0)
;
#line 667 "Int64.xs"
    STRLEN len;
    unsigned char *pv = (unsigned char *)SvPVbyte(net, len);
    int64_t i64;
#line 913 "Int64.c"
	SV *	RETVAL;
#line 671 "Int64.xs"
    if (len != 8) croak_string(aTHX_ invalid_length_error_s);
    i64 = (((((((((((((((int64_t)pv[0]) << 8)
                      + (int64_t)pv[1]) << 8)
                    + (int64_t)pv[2]) << 8)
                  + (int64_t)pv[3]) << 8)
                + (int64_t)pv[4]) << 8)
              + (int64_t)pv[5]) << 8)
            + (int64_t)pv[6]) <<8)
        + (int64_t)pv[7];
    RETVAL = ( use_native
               ? newSViv(i64)
               : newSVi64(aTHX_ i64) );
#line 928 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_net_to_uint64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_net_to_uint64)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "net");
    {
	SV *	net = ST(0)
;
#line 690 "Int64.xs"
    STRLEN len;
    unsigned char *pv = (unsigned char *)SvPVbyte(net, len);
    uint64_t u64;
#line 949 "Int64.c"
	SV *	RETVAL;
#line 694 "Int64.xs"
    if (len != 8)
        croak_string(aTHX_ invalid_length_error_u);
    u64 = (((((((((((((((uint64_t)pv[0]) << 8)
                      + (uint64_t)pv[1]) << 8)
                    + (uint64_t)pv[2]) << 8)
                  + (uint64_t)pv[3]) << 8)
                + (uint64_t)pv[4]) << 8)
              + (uint64_t)pv[5]) << 8)
            + (uint64_t)pv[6]) <<8)
        + (uint64_t)pv[7];
    RETVAL = ( use_native
               ? newSVuv(u64)
               : newSVu64(aTHX_ u64) );
#line 965 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_int64_to_net); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_int64_to_net)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
#line 714 "Int64.xs"
    char *pv;
    int64_t i64 = SvI64(aTHX_ self);
    int i;
#line 986 "Int64.c"
	SV *	RETVAL;
#line 718 "Int64.xs"
    RETVAL = newSV(8);
    SvPOK_on(RETVAL);
    SvCUR_set(RETVAL, 8);
    pv = SvPVX(RETVAL);
    pv[8] = '\0';
    for (i = 7; i >= 0; i--, i64 >>= 8)
        pv[i] = i64;
#line 996 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_uint64_to_net); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_uint64_to_net)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
#line 732 "Int64.xs"
    char *pv;
    uint64_t u64 = SvU64(aTHX_ self);
    int i;
#line 1017 "Int64.c"
	SV *	RETVAL;
#line 736 "Int64.xs"
    RETVAL = newSV(8);
    SvPOK_on(RETVAL);
    SvCUR_set(RETVAL, 8);
    pv = SvPVX(RETVAL);
    pv[8] = '\0';
    for (i = 7; i >= 0; i--, u64 >>= 8)
        pv[i] = u64;
#line 1027 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_BER_to_int64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_BER_to_int64)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ber");
    {
	SV *	ber = ST(0)
;
	SV *	RETVAL;
#line 750 "Int64.xs"
    RETVAL = newSVi64(aTHX_ BER_to_int64(aTHX_ ber));
#line 1047 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_BER_to_uint64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_BER_to_uint64)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ber");
    {
	SV *	ber = ST(0)
;
	SV *	RETVAL;
#line 758 "Int64.xs"
    RETVAL = newSVu64(aTHX_ BER_to_uint64(aTHX_ ber));
#line 1067 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_int64_to_BER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_int64_to_BER)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
	SV *	RETVAL;
#line 766 "Int64.xs"
    RETVAL = int64_to_BER(aTHX_ SvI64(aTHX_ self));
#line 1087 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_uint64_to_BER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_uint64_to_BER)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
	SV *	RETVAL;
#line 774 "Int64.xs"
    RETVAL = uint64_to_BER(aTHX_ SvU64(aTHX_ self));
#line 1107 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_native_to_int64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_native_to_int64)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "native");
    {
	SV *	native = ST(0)
;
#line 782 "Int64.xs"
    STRLEN len;
    char *pv = SvPVbyte(native, len);
#line 1127 "Int64.c"
	SV *	RETVAL;
#line 785 "Int64.xs"
    if (len != 8)
        croak_string(aTHX_ invalid_length_error_s);
    if (use_native) {
        RETVAL = newSViv(0);
        Copy(pv, &(SvIVX(RETVAL)), 8, char);
    }
    else {
        RETVAL = newSVi64(aTHX_ 0);
        Copy(pv, &(SvI64X(RETVAL)), 8, char);
    }
#line 1140 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_BER_length); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_BER_length)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 802 "Int64.xs"
    IV len;
#line 1159 "Int64.c"
	SV *	RETVAL;
#line 804 "Int64.xs"
    len = BER_length(aTHX_ sv);
    RETVAL = (len < 0 ? &PL_sv_undef : newSViv(len));
#line 1164 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_native_to_uint64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_native_to_uint64)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "native");
    {
	SV *	native = ST(0)
;
#line 813 "Int64.xs"
    STRLEN len;
    char *pv = SvPVbyte(native, len);
#line 1184 "Int64.c"
	SV *	RETVAL;
#line 816 "Int64.xs"
    if (len != 8)
        croak_string(aTHX_ invalid_length_error_u);
    if (use_native) {
        uint64_t tmp;
        Copy(pv, &tmp, 8, char);
        RETVAL = newSVuv(tmp);
    }
    else {
        RETVAL = newSVu64(aTHX_ 0);
        Copy(pv, &(SvU64X(RETVAL)), 8, char);
    }
#line 1198 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_int64_to_native); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_int64_to_native)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
#line 834 "Int64.xs"
    char *pv;
    int64_t i64 = SvI64(aTHX_ self);
#line 1218 "Int64.c"
	SV *	RETVAL;
#line 837 "Int64.xs"
    RETVAL = newSV(9);
    SvPOK_on(RETVAL);
    SvCUR_set(RETVAL, 8);
    pv = SvPVX(RETVAL);
    Copy(&i64, pv, 8, char);
    pv[8] = '\0';
#line 1227 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_uint64_to_native); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_uint64_to_native)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
#line 850 "Int64.xs"
    char *pv;
    uint64_t u64 = SvU64(aTHX_ self);
#line 1247 "Int64.c"
	SV *	RETVAL;
#line 853 "Int64.xs"
    RETVAL = newSV(9);
    SvPOK_on(RETVAL);
    SvCUR_set(RETVAL, 8);
    pv = SvPVX(RETVAL);
    Copy(&u64, pv, 8, char);
    pv[8] = '\0';
#line 1256 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_int64_to_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_int64_to_string)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, base = 10");
    {
	SV *	self = ST(0)
;
	int	base;
	SV *	RETVAL;

	if (items < 2)
	    base = 10;
	else {
	    base = (int)SvIV(ST(1))
;
	}
#line 867 "Int64.xs"
    RETVAL = i64_to_string(aTHX_ SvI64(aTHX_ self), base);
#line 1284 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_uint64_to_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_uint64_to_string)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, base = 10");
    {
	SV *	self = ST(0)
;
	int	base;
	SV *	RETVAL;

	if (items < 2)
	    base = 10;
	else {
	    base = (int)SvIV(ST(1))
;
	}
#line 876 "Int64.xs"
    RETVAL = u64_to_string_with_sign(aTHX_ SvU64(aTHX_ self), base, 0);
#line 1312 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_int64_to_hex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_int64_to_hex)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
	SV *	RETVAL;
#line 884 "Int64.xs"
    RETVAL = i64_to_string(aTHX_ SvI64(aTHX_ self), 16);
#line 1332 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_uint64_to_hex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_uint64_to_hex)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
	SV *	RETVAL;
#line 892 "Int64.xs"
    RETVAL = u64_to_string_with_sign(aTHX_ SvU64(aTHX_ self), 16, 0);
#line 1352 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_string_to_int64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_string_to_int64)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "str, base = 0");
    {
	const char *	str = (const char *)SvPV_nolen(ST(0))
;
	int	base;
	SV *	RETVAL;

	if (items < 2)
	    base = 0;
	else {
	    base = (int)SvIV(ST(1))
;
	}
#line 901 "Int64.xs"
    RETVAL = ( use_native
               ? newSViv(strtoint64(aTHX_ str, base, 1))
               : newSVi64(aTHX_ strtoint64(aTHX_ str, base, 1)) );
#line 1382 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_string_to_uint64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_string_to_uint64)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "str, base = 0");
    {
	const char *	str = (const char *)SvPV_nolen(ST(0))
;
	int	base;
	SV *	RETVAL;

	if (items < 2)
	    base = 0;
	else {
	    base = (int)SvIV(ST(1))
;
	}
#line 912 "Int64.xs"
    RETVAL = ( use_native
               ? newSVuv(strtoint64(aTHX_ str, base, 0))
               : newSVu64(aTHX_ strtoint64(aTHX_ str, base, 0)) );
#line 1412 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_hex_to_int64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_hex_to_int64)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "str");
    {
	const char *	str = (const char *)SvPV_nolen(ST(0))
;
	SV *	RETVAL;
#line 922 "Int64.xs"
    RETVAL = ( use_native
               ? newSViv(strtoint64(aTHX_ str, 16, 1))
               : newSVi64(aTHX_ strtoint64(aTHX_ str, 16, 1)) );
#line 1434 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_hex_to_uint64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_hex_to_uint64)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "str");
    {
	const char *	str = (const char *)SvPV_nolen(ST(0))
;
	SV *	RETVAL;
#line 932 "Int64.xs"
    RETVAL = ( use_native
               ? newSVuv(strtoint64(aTHX_ str, 16, 0))
               : newSVu64(aTHX_ strtoint64(aTHX_ str, 16, 0)) );
#line 1456 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_int64_rand); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_int64_rand)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 942 "Int64.xs"
    dMY_CXT;
    int64_t i64 = rand64(&(MY_CXT.is));
#line 1474 "Int64.c"
	SV *	RETVAL;
#line 945 "Int64.xs"
    RETVAL = ( use_native
               ? newSViv(i64)
               : newSVi64(aTHX_ i64) );
#line 1480 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_uint64_rand); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_uint64_rand)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 954 "Int64.xs"
    dMY_CXT;
    uint64_t u64 = rand64(&(MY_CXT.is));
#line 1498 "Int64.c"
	SV *	RETVAL;
#line 957 "Int64.xs"
    RETVAL = ( use_native
               ? newSViv(u64)
               : newSVu64(aTHX_ u64) );
#line 1504 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_int64_srand); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_int64_srand)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "seed=&PL_sv_undef");
    {
	SV *	seed;
#line 967 "Int64.xs"
    dMY_CXT;
    isaac64_state_t *is;
#line 1523 "Int64.c"

	if (items < 1)
	    seed = &PL_sv_undef;
	else {
	    seed = ST(0)
;
	}
#line 970 "Int64.xs"
    is = &(MY_CXT.is);
    if (SvOK(seed) && SvCUR(seed)) {
        STRLEN len;
        const char *pv = SvPV_const(seed, len);
        char *shadow = (char*)is->randrsl;
        int i;
        if (len > sizeof(is->randrsl)) len = sizeof(is->randrsl);
        Zero(shadow, sizeof(is->randrsl), char);
        Copy(pv, shadow, len, char);

        /* make the seed endianness agnostic */
        for (i = 0; i < RANDSIZ; i++) {
            char *p = shadow + i * sizeof(uint64_t);
            is->randrsl[i] = (((((((((((((((uint64_t)p[0]) << 8) + p[1]) << 8) + p[2]) << 8) + p[3]) << 8) +
                                   p[4]) << 8) + p[5]) << 8) + p[6]) << 8) + p[7];
    }
        randinit(is, 1);
    }
    else
        randinit(is, 0);
#line 1552 "Int64.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Math__Int64__inc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__inc)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1000 "Int64.xs"
    if (may_die_on_overflow && (SvI64x(self) == INT64_MAX)) overflow(aTHX_ inc_error);
    SvI64x(self)++;
    RETVAL = self;
    SvREFCNT_inc(RETVAL);
#line 1575 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__dec); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__dec)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1013 "Int64.xs"
    if (may_die_on_overflow && (SvI64x(self) == INT64_MIN)) overflow(aTHX_ dec_error);
    SvI64x(self)--;
    RETVAL = self;
    SvREFCNT_inc(RETVAL);
#line 1600 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__add)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1026 "Int64.xs"
    int64_t a = SvI64x(self);
    int64_t b = SvI64(aTHX_ other);
#line 1623 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1029 "Int64.xs"
    if ( may_die_on_overflow &&
         ( a > 0
           ? ( (b > 0) && (INT64_MAX - a < b) )
           : ( (b < 0) && (INT64_MIN - a > b) ) ) ) overflow(aTHX_ add_error);
    if (SvOK(rev))
        RETVAL = newSVi64(aTHX_ a + b);
    else {
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvI64x(self) = a + b;
    }
#line 1644 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__sub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__sub)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1049 "Int64.xs"
    int64_t a = SvI64x(self);
    int64_t b = SvI64(aTHX_ other);
#line 1667 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1052 "Int64.xs"
    if (SvTRUE(rev)) {
        int64_t tmp = a;
        a = b; b = tmp;
    }
    if ( may_die_on_overflow &&
         ( a > 0
           ? ( ( b < 0) && (a - INT64_MAX > b) )
           : ( ( b > 0) && (a - INT64_MIN < b) ) ) ) overflow(aTHX_ sub_error);
    if (SvOK(rev))
        RETVAL = newSVi64(aTHX_ a - b);
    else {
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvI64x(self) = a - b;
    }
#line 1692 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__mul); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__mul)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1076 "Int64.xs"
    int64_t a1 = SvI64x(self);
    int64_t b1 = SvI64(aTHX_ other);
#line 1715 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1079 "Int64.xs"
    if (may_die_on_overflow) {
        int neg = 0;
        uint64_t a, b;
        if (a1 < 0) {
            a = -a1;
            neg ^= 1;
        }
        else a = a1;
        if (b1 < 0) {
            b = -b1;
            neg ^= 1;
        }
        else b = b1;
        mul_check_overflow(aTHX_ a, b, mul_error);
        if (a * b > (neg ? (~(uint64_t)INT64_MIN + 1) : INT64_MAX)) overflow(aTHX_ mul_error);
    }
    if (SvOK(rev))
        RETVAL = newSVi64(aTHX_ a1 * b1);
    else {
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvI64x(self) = a1 * b1;
    }
#line 1748 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__div); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__div)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1111 "Int64.xs"
    int64_t up;
    int64_t down;
#line 1771 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1114 "Int64.xs"
    if (SvOK(rev)) {
        if (SvTRUE(rev)) {
            up = SvI64(aTHX_ other);
            down = SvI64x(self);
        }
        else {
            up = SvI64x(self);
            down = SvI64(aTHX_ other);
        }
        if (!down)
            croak_string(aTHX_ div_by_0_error);
        RETVAL = newSVi64(aTHX_ up/down);
    }
    else {
        down = SvI64(aTHX_ other);
        if (!down)
            croak_string(aTHX_ div_by_0_error);
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvI64x(self) /= down;
    }
#line 1802 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__rest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__rest)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1144 "Int64.xs"
    int64_t up;
    int64_t down;
#line 1825 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1147 "Int64.xs"
    if (SvOK(rev)) {
        if (SvTRUE(rev)) {
            up = SvI64(aTHX_ other);
            down = SvI64x(self);
        }
        else {
            up = SvI64x(self);
            down = SvI64(aTHX_ other);
        }
        if (!down)
            croak_string(aTHX_ div_by_0_error);
        RETVAL = newSVi64(aTHX_ up % down);
    }
    else {
        down = SvI64(aTHX_ other);
        if (!down)
            croak_string(aTHX_ div_by_0_error);
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvI64x(self) %= down;
    }
#line 1856 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__left); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__left)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1177 "Int64.xs"
    int64_t a, r;
    uint64_t b;
#line 1879 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1180 "Int64.xs"
    if (SvTRUE(rev)) {
        a = SvI64(aTHX_ other);
        b = SvU64x(self);
    }
    else {
        a = SvI64x(self);
        b = SvU64(aTHX_ other);
    }
    r = (b > 63 ? 0 : a << b);
    if (SvOK(rev))
        RETVAL = newSVi64(aTHX_ r);
    else {
        RETVAL = SvREFCNT_inc(self);
        SvI64x(self) = r;
    }
#line 1904 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__right); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__right)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1203 "Int64.xs"
    int64_t a, r;
    uint64_t b;
#line 1927 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1206 "Int64.xs"
    if (SvTRUE(rev)) {
        a = SvI64(aTHX_ other);
        b = SvU64x(self);
    }
    else {
        a = SvI64x(self);
        b = SvU64(aTHX_ other);
    }
    r = (b > 63 ? (a < 0 ? -1 : 0) : a >> b);
    if (SvOK(rev))
        RETVAL = newSVi64(aTHX_ r);
    else {
        RETVAL = SvREFCNT_inc(self);
        SvI64x(self) = r;
    }
#line 1952 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__pow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__pow)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1230 "Int64.xs"
    int sign;
    uint64_t r;
    int64_t a, b;
#line 1976 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1234 "Int64.xs"
    if (SvTRUE(rev)) {
        a = SvI64(aTHX_ other);
        b = SvI64x(self);
    }
    else {
        a = SvI64x(self);
        b = SvI64(aTHX_ other);
    }
    if (a < 0) {
        sign = ((b & 1) ? -1 : 1);
        a = -a;
    }
    else sign = 1;
    if (b < 0) {
        if      (a == 0) croak_string(aTHX_ div_by_0_error);
        else if (a == 1) r = sign;
        else             r = 0;
    }
    else {
        uint64_t u = powU64(aTHX_ a, b);
        if (may_die_on_overflow && (u > ((sign < 0) ? (~(uint64_t)INT64_MIN + 1) : INT64_MAX))) overflow(aTHX_ pow_error);
        r = ((sign > 0) ? u : -u);
    }
    if (SvOK(rev))
        RETVAL = newSVi64(aTHX_ r);
    else {
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvI64x(self) = r;
    }
#line 2016 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__spaceship); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__spaceship)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1273 "Int64.xs"
    int64_t left;
    int64_t right;
#line 2039 "Int64.c"
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1276 "Int64.xs"
    if (SvTRUE(rev)) {
        left = SvI64(aTHX_ other);
        right = SvI64x(self);
    }
    else {
        left = SvI64x(self);
        right = SvI64(aTHX_ other);
    }
    RETVAL = (left < right ? -1 : left > right ? 1 : 0);
#line 2059 "Int64.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__eqn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__eqn)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;
#line 1294 "Int64.xs"
    RETVAL = ( SvI64x(self) == SvI64(aTHX_ other)
               ? &PL_sv_yes
               : &PL_sv_no );
#line 2083 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__nen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__nen)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;
#line 1306 "Int64.xs"
    RETVAL = ( SvI64x(self) != SvI64(aTHX_ other)
               ? &PL_sv_yes
               : &PL_sv_no );
#line 2108 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__gtn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__gtn)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1318 "Int64.xs"
    if (SvTRUE(rev))
        RETVAL = SvI64x(self) < SvI64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
    else
        RETVAL = SvI64x(self) > SvI64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
#line 2141 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__ltn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__ltn)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1331 "Int64.xs"
    if (SvTRUE(rev))
        RETVAL = SvI64x(self) > SvI64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
    else
        RETVAL = SvI64x(self) < SvI64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
#line 2174 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__gen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__gen)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1344 "Int64.xs"
    if (SvTRUE(rev))
        RETVAL = SvI64x(self) <= SvI64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
    else
        RETVAL = SvI64x(self) >= SvI64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
#line 2207 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__len); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__len)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1357 "Int64.xs"
    if (SvTRUE(rev))
        RETVAL = SvI64x(self) >= SvI64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
    else
        RETVAL = SvI64x(self) <= SvI64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
#line 2240 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__and); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__and)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1370 "Int64.xs"
    if (SvOK(rev))
        RETVAL = newSVi64(aTHX_ SvI64x(self) & SvI64(aTHX_ other));
    else {
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvI64x(self) &= SvI64(aTHX_ other);
    }
#line 2276 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__or); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__or)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1386 "Int64.xs"
    if (SvOK(rev))
        RETVAL = newSVi64(aTHX_ SvI64x(self) | SvI64(aTHX_ other));
    else {
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvI64x(self) |= SvI64(aTHX_ other);
    }
#line 2312 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__xor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__xor)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1402 "Int64.xs"
    if (SvOK(rev))
        RETVAL = newSVi64(aTHX_ SvI64x(self) ^ SvI64(aTHX_ other));
    else {
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvI64x(self) ^= SvI64(aTHX_ other);
    }
#line 2348 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__not); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__not)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1418 "Int64.xs"
    RETVAL = SvI64x(self) ? &PL_sv_no : &PL_sv_yes;
#line 2370 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__bnot); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__bnot)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1428 "Int64.xs"
    RETVAL = newSVi64(aTHX_ ~SvI64x(self));
#line 2392 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__neg); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__neg)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1438 "Int64.xs"
    RETVAL = newSVi64(aTHX_ -SvI64x(self));
#line 2414 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__bool); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__bool)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1448 "Int64.xs"
    RETVAL = SvI64x(self) ? &PL_sv_yes : &PL_sv_no;
#line 2436 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__number); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__number)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1458 "Int64.xs"
    RETVAL = si64_to_number(aTHX_ self);
#line 2458 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__clone)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1468 "Int64.xs"
    RETVAL = newSVi64(aTHX_ SvI64x(self));
#line 2480 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64__string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64__string)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1478 "Int64.xs"
    RETVAL = i64_to_string(aTHX_ SvI64x(self), 10);
#line 2502 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__Int64_STORABLE_thaw); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_STORABLE_thaw)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "self, cloning, serialized, ...");
    {
	SV *	self = ST(0)
;
	SV *	cloning;
	SV *	serialized = ST(2)
;
#line 1488 "Int64.xs"
    if (SvROK(self) && sv_isa(self, "Math::Int64")) {
        SV *target = SvRV(self);
        SV *tmp = sv_2mortal(newSVu64(aTHX_ BER_to_int64(aTHX_ serialized)));
        sv_setsv(target, SvRV(tmp));
        SvREADONLY_on(target);
    }
    else
        croak_string(aTHX_ "Bad object for Math::Int64::STORABLE_thaw call");
#line 2531 "Int64.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Math__Int64_STORABLE_freeze); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__Int64_STORABLE_freeze)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cloning = NULL");
    {
	SV *	self = ST(0)
;
	SV *	cloning;
	SV *	RETVAL;
#line 1502 "Int64.xs"
    RETVAL = int64_to_BER(aTHX_ SvI64x(self));
#line 2550 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__inc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__inc)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1515 "Int64.xs"
    if (may_die_on_overflow && (SvU64x(self) == UINT64_MAX)) overflow(aTHX_ inc_error);
    SvU64x(self)++;
    RETVAL = SvREFCNT_inc(self);
#line 2574 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__dec); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__dec)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1527 "Int64.xs"
    if (may_die_on_overflow && (SvU64x(self) == 0)) overflow(aTHX_ dec_error);
    SvU64x(self)--;
    RETVAL = SvREFCNT_inc(self);
#line 2598 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__add)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1539 "Int64.xs"
    uint64_t a, b;
#line 2620 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1541 "Int64.xs"
    a = SvU64x(self);
    b = SvU64(aTHX_ other);
    if (may_die_on_overflow && (UINT64_MAX - a < b)) overflow(aTHX_ add_error);
    if (SvOK(rev)) 
        RETVAL = newSVu64(aTHX_ a + b);
    else {
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvU64x(self) = a + b;
    }
#line 2640 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__sub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__sub)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1560 "Int64.xs"
    uint64_t a, b;
#line 2662 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1562 "Int64.xs"
    if (SvTRUE(rev)) {
        a = SvU64(aTHX_ other);
        b = SvU64x(self);
    }
    else {
        a = SvU64x(self);
        b = SvU64(aTHX_ other);
    }
    if (may_die_on_overflow && (b > a)) overflow(aTHX_ sub_error);
    if (SvOK(rev))
        RETVAL = newSVu64(aTHX_ a - b);
    else {
        RETVAL = SvREFCNT_inc(self);
        SvU64x(self) = a - b;
    }
#line 2687 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__mul); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__mul)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1586 "Int64.xs"
    uint64_t a, b;
#line 2709 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1588 "Int64.xs"
    a = SvU64x(self);
    b = SvU64(aTHX_ other);
    if (may_die_on_overflow) mul_check_overflow(aTHX_ a, b, mul_error);
    if (SvOK(rev))
        RETVAL = newSVu64(aTHX_ a * b);
    else {
        RETVAL = SvREFCNT_inc(self);
        SvU64x(self) = a * b;
    }
#line 2728 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__div); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__div)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1606 "Int64.xs"
    uint64_t up, down;
#line 2750 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1608 "Int64.xs"
    if (SvOK(rev)) {
        if (SvTRUE(rev)) {
            up = SvU64(aTHX_ other);
            down = SvU64x(self);
        }
        else {
            up = SvU64x(self);
            down = SvU64(aTHX_ other);
        }
        if (!down)
            croak_string(aTHX_ div_by_0_error);
        RETVAL = newSVu64(aTHX_ up/down);
    }
    else {
        down = SvU64(aTHX_ other);
        if (!down)
            croak_string(aTHX_ div_by_0_error);
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvU64x(self) /= down;
    }
#line 2781 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__rest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__rest)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1638 "Int64.xs"
    uint64_t up;
    uint64_t down;
#line 2804 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1641 "Int64.xs"
    if (SvOK(rev)) {
        if (SvTRUE(rev)) {
            up = SvU64(aTHX_ other);
            down = SvU64x(self);
        }
        else {
            up = SvU64x(self);
            down = SvU64(aTHX_ other);
        }
        if (!down)
            croak_string(aTHX_ div_by_0_error);
        RETVAL = newSVu64(aTHX_ up % down);
    }
    else {
        down = SvU64(aTHX_ other);
        if (!down)
            croak_string(aTHX_ div_by_0_error);
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvU64x(self) %= down;
    }
#line 2835 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__left); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__left)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1670 "Int64.xs"
    uint64_t a, b, r;
#line 2857 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1672 "Int64.xs"
    if (SvTRUE(rev)) {
        a = SvU64(aTHX_ other);
        b = SvU64x(self);
    }
    else {
        a = SvU64x(self);
        b = SvU64(aTHX_ other);
    }
    r = (b > 63 ? 0 : a << b);
    if (SvOK(rev))
        RETVAL = newSVu64(aTHX_ r);
    else {
        RETVAL = SvREFCNT_inc(self);
        SvU64x(self) = r;
    }
#line 2882 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__right); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__right)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1695 "Int64.xs"
    uint64_t a, b, r;
#line 2904 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1697 "Int64.xs"
    if (SvTRUE(rev)) {
        a = SvU64(aTHX_ other);
        b = SvU64x(self);
    }
    else {
        a = SvU64x(self);
        b = SvU64(aTHX_ other);
    }
    r = (b > 63 ? 0 : a >> b);
    if (SvOK(rev))
        RETVAL = newSVu64(aTHX_ r);
    else {
        RETVAL = SvREFCNT_inc(self);
        SvU64x(self) = r;
    }
#line 2929 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__pow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__pow)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1721 "Int64.xs"
    uint64_t r;
    int64_t a, b;
#line 2952 "Int64.c"
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1724 "Int64.xs"
    if (SvTRUE(rev)) {
        a = SvU64(aTHX_ other);
        b = SvU64x(self);
    }
    else {
        a = SvU64x(self);
        b = SvU64(aTHX_ other);
    }
    r = powU64(aTHX_ a, b);
    if (SvOK(rev))
        RETVAL = newSVu64(aTHX_ r);
    else {
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvU64x(self) = r;
    }
#line 2978 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__spaceship); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__spaceship)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
#line 1749 "Int64.xs"
    uint64_t left;
    uint64_t right;
#line 3001 "Int64.c"
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1752 "Int64.xs"
    if (SvTRUE(rev)) {
        left = SvU64(aTHX_ other);
        right = SvU64x(self);
    }
    else {
        left = SvU64x(self);
        right = SvU64(aTHX_ other);
    }
    RETVAL = (left < right ? -1 : left > right ? 1 : 0);
#line 3021 "Int64.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__eqn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__eqn)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;
#line 1770 "Int64.xs"
    RETVAL = ( SvU64x(self) == SvU64(aTHX_ other)
               ? &PL_sv_yes
               : &PL_sv_no );
#line 3045 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__nen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__nen)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;
#line 1782 "Int64.xs"
    RETVAL = ( SvU64x(self) != SvU64(aTHX_ other)
               ? &PL_sv_yes
               : &PL_sv_no );
#line 3070 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__gtn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__gtn)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1794 "Int64.xs"
    if (SvTRUE(rev))
        RETVAL = SvU64x(self) < SvU64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
    else
        RETVAL = SvU64x(self) > SvU64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
#line 3103 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__ltn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__ltn)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1807 "Int64.xs"
    if (SvTRUE(rev))
        RETVAL = SvU64x(self) > SvU64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
    else
        RETVAL = SvU64x(self) < SvU64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
#line 3136 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__gen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__gen)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1820 "Int64.xs"
    if (SvTRUE(rev))
        RETVAL = SvU64x(self) <= SvU64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
    else
        RETVAL = SvU64x(self) >= SvU64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
#line 3169 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__len); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__len)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1833 "Int64.xs"
    if (SvTRUE(rev))
        RETVAL = SvU64x(self) >= SvU64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
    else
        RETVAL = SvU64x(self) <= SvU64(aTHX_ other) ? &PL_sv_yes : &PL_sv_no;
#line 3202 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__and); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__and)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1846 "Int64.xs"
    if (SvOK(rev))
        RETVAL = newSVu64(aTHX_ SvU64x(self) & SvU64(aTHX_ other));
    else {
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvU64x(self) &= SvU64(aTHX_ other);
    }
#line 3238 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__or); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__or)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1862 "Int64.xs"
    if (SvOK(rev))
        RETVAL = newSVu64(aTHX_ SvU64x(self) | SvU64(aTHX_ other));
    else {
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvU64x(self) |= SvU64(aTHX_ other);
    }
#line 3274 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__xor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__xor)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, other, rev = &PL_sv_no");
    {
	SV *	self = ST(0)
;
	SV *	other = ST(1)
;
	SV *	rev;
	SV *	RETVAL;

	if (items < 3)
	    rev = &PL_sv_no;
	else {
	    rev = ST(2)
;
	}
#line 1878 "Int64.xs"
    if (SvOK(rev))
        RETVAL = newSVu64(aTHX_ SvU64x(self) ^ SvU64(aTHX_ other));
    else {
        RETVAL = self;
        SvREFCNT_inc(RETVAL);
        SvU64x(self) ^= SvU64(aTHX_ other);
    }
#line 3310 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__not); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__not)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1894 "Int64.xs"
    RETVAL = SvU64x(self) ? &PL_sv_no : &PL_sv_yes;
#line 3332 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__bnot); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__bnot)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1904 "Int64.xs"
    RETVAL = newSVu64(aTHX_ ~SvU64x(self));
#line 3354 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__neg); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__neg)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1914 "Int64.xs"
    RETVAL = newSVu64(aTHX_ ~(SvU64x(self)-1));
#line 3376 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__bool); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__bool)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1924 "Int64.xs"
    RETVAL = SvU64x(self) ? &PL_sv_yes : &PL_sv_no;
#line 3398 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__number); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__number)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1934 "Int64.xs"
    RETVAL = su64_to_number(aTHX_ self);
#line 3420 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__clone)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1944 "Int64.xs"
    RETVAL = newSVu64(aTHX_ SvU64x(self));
#line 3442 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64__string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64__string)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, other = NULL, rev = NULL");
    {
	SV *	self = ST(0)
;
	SV *	other;
	SV *	rev;
	SV *	RETVAL;
#line 1954 "Int64.xs"
    RETVAL = u64_to_string_with_sign(aTHX_ SvU64x(self), 10, 0);
#line 3464 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__UInt64_STORABLE_thaw); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64_STORABLE_thaw)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "self, cloning, serialized, ...");
    {
	SV *	self = ST(0)
;
	SV *	cloning;
	SV *	serialized = ST(2)
;
#line 1964 "Int64.xs"
    if (SvROK(self) && sv_isa(self, "Math::UInt64")) {
        SV *target = SvRV(self);
        SV *tmp = sv_2mortal(newSVu64(aTHX_ BER_to_uint64(aTHX_ serialized)));
        sv_setsv(target, SvRV(tmp));
        SvREADONLY_on(target);
    }
    else
        croak_string(aTHX_ "Bad object for Math::UInt64::STORABLE_thaw call");
#line 3493 "Int64.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Math__UInt64_STORABLE_freeze); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__UInt64_STORABLE_freeze)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cloning = NULL");
    {
	SV *	self = ST(0)
;
	SV *	cloning;
	SV *	RETVAL;
#line 1978 "Int64.xs"
    RETVAL = uint64_to_BER(aTHX_ SvU64x(self));
#line 3512 "Int64.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Math__Int64); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Math__Int64)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Math::Int64::_backend", XS_Math__Int64__backend);
        newXS_deffile("Math::Int64::_set_may_die_on_overflow", XS_Math__Int64__set_may_die_on_overflow);
        newXS_deffile("Math::Int64::_set_may_use_native", XS_Math__Int64__set_may_use_native);
        newXS_deffile("Math::Int64::int64", XS_Math__Int64_int64);
        newXS_deffile("Math::Int64::uint64", XS_Math__Int64_uint64);
        newXS_deffile("Math::Int64::int64_to_number", XS_Math__Int64_int64_to_number);
        newXS_deffile("Math::Int64::uint64_to_number", XS_Math__Int64_uint64_to_number);
        newXS_deffile("Math::Int64::net_to_int64", XS_Math__Int64_net_to_int64);
        newXS_deffile("Math::Int64::net_to_uint64", XS_Math__Int64_net_to_uint64);
        newXS_deffile("Math::Int64::int64_to_net", XS_Math__Int64_int64_to_net);
        newXS_deffile("Math::Int64::uint64_to_net", XS_Math__Int64_uint64_to_net);
        newXS_deffile("Math::Int64::BER_to_int64", XS_Math__Int64_BER_to_int64);
        newXS_deffile("Math::Int64::BER_to_uint64", XS_Math__Int64_BER_to_uint64);
        newXS_deffile("Math::Int64::int64_to_BER", XS_Math__Int64_int64_to_BER);
        newXS_deffile("Math::Int64::uint64_to_BER", XS_Math__Int64_uint64_to_BER);
        newXS_deffile("Math::Int64::native_to_int64", XS_Math__Int64_native_to_int64);
        newXS_deffile("Math::Int64::BER_length", XS_Math__Int64_BER_length);
        newXS_deffile("Math::Int64::native_to_uint64", XS_Math__Int64_native_to_uint64);
        newXS_deffile("Math::Int64::int64_to_native", XS_Math__Int64_int64_to_native);
        newXS_deffile("Math::Int64::uint64_to_native", XS_Math__Int64_uint64_to_native);
        newXS_deffile("Math::Int64::int64_to_string", XS_Math__Int64_int64_to_string);
        newXS_deffile("Math::Int64::uint64_to_string", XS_Math__Int64_uint64_to_string);
        newXS_deffile("Math::Int64::int64_to_hex", XS_Math__Int64_int64_to_hex);
        newXS_deffile("Math::Int64::uint64_to_hex", XS_Math__Int64_uint64_to_hex);
        newXS_deffile("Math::Int64::string_to_int64", XS_Math__Int64_string_to_int64);
        newXS_deffile("Math::Int64::string_to_uint64", XS_Math__Int64_string_to_uint64);
        newXS_deffile("Math::Int64::hex_to_int64", XS_Math__Int64_hex_to_int64);
        newXS_deffile("Math::Int64::hex_to_uint64", XS_Math__Int64_hex_to_uint64);
        newXS_deffile("Math::Int64::int64_rand", XS_Math__Int64_int64_rand);
        newXS_deffile("Math::Int64::uint64_rand", XS_Math__Int64_uint64_rand);
        newXS_deffile("Math::Int64::int64_srand", XS_Math__Int64_int64_srand);
        newXS_deffile("Math::Int64::_inc", XS_Math__Int64__inc);
        newXS_deffile("Math::Int64::_dec", XS_Math__Int64__dec);
        newXS_deffile("Math::Int64::_add", XS_Math__Int64__add);
        newXS_deffile("Math::Int64::_sub", XS_Math__Int64__sub);
        newXS_deffile("Math::Int64::_mul", XS_Math__Int64__mul);
        newXS_deffile("Math::Int64::_div", XS_Math__Int64__div);
        newXS_deffile("Math::Int64::_rest", XS_Math__Int64__rest);
        newXS_deffile("Math::Int64::_left", XS_Math__Int64__left);
        newXS_deffile("Math::Int64::_right", XS_Math__Int64__right);
        newXS_deffile("Math::Int64::_pow", XS_Math__Int64__pow);
        newXS_deffile("Math::Int64::_spaceship", XS_Math__Int64__spaceship);
        newXS_deffile("Math::Int64::_eqn", XS_Math__Int64__eqn);
        newXS_deffile("Math::Int64::_nen", XS_Math__Int64__nen);
        newXS_deffile("Math::Int64::_gtn", XS_Math__Int64__gtn);
        newXS_deffile("Math::Int64::_ltn", XS_Math__Int64__ltn);
        newXS_deffile("Math::Int64::_gen", XS_Math__Int64__gen);
        newXS_deffile("Math::Int64::_len", XS_Math__Int64__len);
        newXS_deffile("Math::Int64::_and", XS_Math__Int64__and);
        newXS_deffile("Math::Int64::_or", XS_Math__Int64__or);
        newXS_deffile("Math::Int64::_xor", XS_Math__Int64__xor);
        newXS_deffile("Math::Int64::_not", XS_Math__Int64__not);
        newXS_deffile("Math::Int64::_bnot", XS_Math__Int64__bnot);
        newXS_deffile("Math::Int64::_neg", XS_Math__Int64__neg);
        newXS_deffile("Math::Int64::_bool", XS_Math__Int64__bool);
        newXS_deffile("Math::Int64::_number", XS_Math__Int64__number);
        newXS_deffile("Math::Int64::_clone", XS_Math__Int64__clone);
        newXS_deffile("Math::Int64::_string", XS_Math__Int64__string);
        newXS_deffile("Math::Int64::STORABLE_thaw", XS_Math__Int64_STORABLE_thaw);
        newXS_deffile("Math::Int64::STORABLE_freeze", XS_Math__Int64_STORABLE_freeze);
        newXS_deffile("Math::UInt64::_inc", XS_Math__UInt64__inc);
        newXS_deffile("Math::UInt64::_dec", XS_Math__UInt64__dec);
        newXS_deffile("Math::UInt64::_add", XS_Math__UInt64__add);
        newXS_deffile("Math::UInt64::_sub", XS_Math__UInt64__sub);
        newXS_deffile("Math::UInt64::_mul", XS_Math__UInt64__mul);
        newXS_deffile("Math::UInt64::_div", XS_Math__UInt64__div);
        newXS_deffile("Math::UInt64::_rest", XS_Math__UInt64__rest);
        newXS_deffile("Math::UInt64::_left", XS_Math__UInt64__left);
        newXS_deffile("Math::UInt64::_right", XS_Math__UInt64__right);
        newXS_deffile("Math::UInt64::_pow", XS_Math__UInt64__pow);
        newXS_deffile("Math::UInt64::_spaceship", XS_Math__UInt64__spaceship);
        newXS_deffile("Math::UInt64::_eqn", XS_Math__UInt64__eqn);
        newXS_deffile("Math::UInt64::_nen", XS_Math__UInt64__nen);
        newXS_deffile("Math::UInt64::_gtn", XS_Math__UInt64__gtn);
        newXS_deffile("Math::UInt64::_ltn", XS_Math__UInt64__ltn);
        newXS_deffile("Math::UInt64::_gen", XS_Math__UInt64__gen);
        newXS_deffile("Math::UInt64::_len", XS_Math__UInt64__len);
        newXS_deffile("Math::UInt64::_and", XS_Math__UInt64__and);
        newXS_deffile("Math::UInt64::_or", XS_Math__UInt64__or);
        newXS_deffile("Math::UInt64::_xor", XS_Math__UInt64__xor);
        newXS_deffile("Math::UInt64::_not", XS_Math__UInt64__not);
        newXS_deffile("Math::UInt64::_bnot", XS_Math__UInt64__bnot);
        newXS_deffile("Math::UInt64::_neg", XS_Math__UInt64__neg);
        newXS_deffile("Math::UInt64::_bool", XS_Math__UInt64__bool);
        newXS_deffile("Math::UInt64::_number", XS_Math__UInt64__number);
        newXS_deffile("Math::UInt64::_clone", XS_Math__UInt64__clone);
        newXS_deffile("Math::UInt64::_string", XS_Math__UInt64__string);
        newXS_deffile("Math::UInt64::STORABLE_thaw", XS_Math__UInt64_STORABLE_thaw);
        newXS_deffile("Math::UInt64::STORABLE_freeze", XS_Math__UInt64_STORABLE_freeze);

    /* Initialisation Section */

#line 600 "Int64.xs"
{
    MY_CXT_INIT;
    randinit(&(MY_CXT.is), 0);
    may_die_on_overflow = 0;
    may_use_native = 0;
    INIT_C_API;
}

#line 3648 "Int64.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

