/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.24 from the
 * contents of PangoAttributes.xs. Do not edit this file, edit PangoAttributes.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "xs/PangoAttributes.xs"
/*
 * Copyright (c) 2005-2006, 2013-2014 by the gtk2-perl team (see the AUTHORS
 * file for a full list of authors)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the LICENSE file in the top-level directory of this distribution for
 * the full license terms.
 *
 */

#include "pango-perl.h"

#define PANGO_PERL_ATTR_STORE_INDICES(offset, attr)	\
	if (items == offset + 2) {			\
		guint start = SvUV (ST (offset));	\
		guint end = SvUV (ST (offset + 1));	\
		attr->start_index = start;		\
		attr->end_index = end;			\
	}

/* ------------------------------------------------------------------------- */

static GPerlBoxedWrapperClass pango_color_wrapper_class;

static SV *
pango_color_wrap (GType gtype,
                  const char * package,
                  gpointer boxed,
		  gboolean own)
{
	PangoColor *color = boxed;
	AV *av;
	PERL_UNUSED_VAR (gtype);
	PERL_UNUSED_VAR (package);

	if (!color)
		return &PL_sv_undef;

	av = newAV ();

	av_push (av, newSVuv (color->red));
	av_push (av, newSVuv (color->green));
	av_push (av, newSVuv (color->blue));

	if (own)
		pango_color_free (color);

	return sv_bless (newRV_noinc ((SV *) av),
	       		 gv_stashpv ("Pango::Color", TRUE));
}

/* This uses gperl_alloc_temp so make sure you don't hold on to pointers
 * returned by SvPangoColor for too long. */
static gpointer
pango_color_unwrap (GType gtype,
		    const char * package,
		    SV * sv)
{
	PangoColor *color;
	AV * av;
	SV ** v;
	PERL_UNUSED_VAR (gtype);
	PERL_UNUSED_VAR (package);

	if (!gperl_sv_is_defined (sv))
		return NULL;

	if (!gperl_sv_is_array_ref (sv))
		croak ("a PangoColor must be an array reference with three values: "
		       "red, green, and blue");

	color = gperl_alloc_temp (sizeof (PangoColor));

	av = (AV *) SvRV (sv);

	v = av_fetch (av, 0, 0);
	if (v && gperl_sv_is_defined (*v))
		color->red = SvUV (*v);

	v = av_fetch (av, 1, 0);
	if (v && gperl_sv_is_defined (*v))
		color->green = SvUV (*v);

	v = av_fetch (av, 2, 0);
	if (v && gperl_sv_is_defined (*v))
		color->blue = SvUV (*v);

	return color;
}

static void
pango_color_destroy (SV * sv)
{
	/* We allocated nothing in wrap, so do nothing here. */
	PERL_UNUSED_VAR (sv);
}

/* ------------------------------------------------------------------------- */

GType
gtk2perl_pango_attribute_get_type (void)
{
	static GType t = 0;
	if (!t)
		t = g_boxed_type_register_static ("PangoAttribute",
		      (GBoxedCopyFunc) pango_attribute_copy,
		      (GBoxedFreeFunc) pango_attribute_destroy);
	return t;
}

static GHashTable *gtk2perl_pango_attribute_table = NULL;

/* Exported for Gtk2/xs/GdkPango.xs. */
void
gtk2perl_pango_attribute_register_custom_type (PangoAttrType type,
					       const char *package)
{
	if (!gtk2perl_pango_attribute_table)
		gtk2perl_pango_attribute_table =
			g_hash_table_new (g_direct_hash, g_direct_equal);
	g_hash_table_insert (gtk2perl_pango_attribute_table,
			     GINT_TO_POINTER (type), (gpointer) package);
}

static const char *
gtk2perl_pango_attribute_lookup_custom_type (PangoAttrType type)
{
	return g_hash_table_lookup (gtk2perl_pango_attribute_table,
	       			    GINT_TO_POINTER (type));
}

static const char *
gtk2perl_pango_attribute_get_package (PangoAttribute * attr)
{
	/* the interface is designed to allow extensibility by registering
	 * new PangoAttrType values, but pango doesn't allow us to query
	 * those.  but we have hacks in place, so we can try anyway. */
	switch (attr->klass->type) {
	    case PANGO_ATTR_INVALID:
		croak ("invalid PangoAttribute encountered; should not happen");
		return NULL;
	    case PANGO_ATTR_LANGUAGE:
		return "Pango::AttrLanguage";
	    case PANGO_ATTR_FAMILY:
		return "Pango::AttrFamily";
	    case PANGO_ATTR_STYLE:
	    	return "Pango::AttrStyle";
	    case PANGO_ATTR_WEIGHT:
		return "Pango::AttrWeight";
	    case PANGO_ATTR_VARIANT:
		return "Pango::AttrVariant";
	    case PANGO_ATTR_STRETCH:
		return "Pango::AttrStretch";
	    case PANGO_ATTR_SIZE:
#if PANGO_CHECK_VERSION (1, 8, 0)
	    case PANGO_ATTR_ABSOLUTE_SIZE:
#endif
		return "Pango::AttrSize";
	    case PANGO_ATTR_FONT_DESC:
		return "Pango::AttrFontDesc";
	    case PANGO_ATTR_FOREGROUND:
		return "Pango::AttrForeground";
	    case PANGO_ATTR_BACKGROUND:
		return "Pango::AttrBackground";
	    case PANGO_ATTR_UNDERLINE:
		return "Pango::AttrUnderline";
	    case PANGO_ATTR_STRIKETHROUGH:
		return "Pango::AttrStrikethrough";
	    case PANGO_ATTR_RISE:
		return "Pango::AttrRise";
	    case PANGO_ATTR_SHAPE:
		return "Pango::AttrShape";
	    case PANGO_ATTR_SCALE:
		return "Pango::AttrScale";
#if PANGO_CHECK_VERSION (1, 4, 0)
	    case PANGO_ATTR_FALLBACK:
		return "Pango::AttrFallback";
#endif
#if PANGO_CHECK_VERSION (1, 6, 0)
	    case PANGO_ATTR_LETTER_SPACING:
		return "Pango::AttrLetterSpacing";
#endif
#if PANGO_CHECK_VERSION (1, 8, 0)
	    case PANGO_ATTR_UNDERLINE_COLOR:
		return "Pango::AttrUnderlineColor";
	    case PANGO_ATTR_STRIKETHROUGH_COLOR:
		return "Pango::AttrStrikethroughColor";
#endif
#if PANGO_CHECK_VERSION (1, 16, 0)
	    case PANGO_ATTR_GRAVITY:
		return "Pango::AttrGravity";
	    case PANGO_ATTR_GRAVITY_HINT:
		return "Pango::AttrGravityHint";
#endif
	    default:
	    {
		const char *package =
			gtk2perl_pango_attribute_lookup_custom_type
				(attr->klass->type);
		if (package)
			return package;
		return "Pango::Attribute";
	    }
	}
}

static GPerlBoxedWrapperClass   gtk2perl_pango_attribute_wrapper_class;
static GPerlBoxedWrapperClass * default_wrapper_class;

static SV *
gtk2perl_pango_attribute_wrap (GType gtype,
                      	       const char * package,
                      	       gpointer boxed,
		      	       gboolean own)
{
	PangoAttribute * attr = boxed;
	HV * stash;
	SV * sv;

	sv = default_wrapper_class->wrap (gtype, package, boxed, own);

	/* Override the default package */
	package = gtk2perl_pango_attribute_get_package (attr);
	stash = gv_stashpv (package, TRUE);
	return sv_bless (sv, stash);
}

static gpointer
gtk2perl_pango_attribute_unwrap (GType gtype,
				 const char * package,
				 SV * sv)
{
	PangoAttribute * attr = default_wrapper_class->unwrap (gtype, package, sv);

	/* Override the default package */
	package = gtk2perl_pango_attribute_get_package (attr);

	if (!sv_derived_from (sv, package))
		croak ("%s is not of type %s",
		       gperl_format_variable_for_output (sv),
		       package);

	return attr;
}

/* ------------------------------------------------------------------------- */

GType
gtk2perl_pango_attr_iterator_get_type (void)
{
	static GType t = 0;
	if (!t)
		t = g_boxed_type_register_static ("PangoAttrIterator",
		      (GBoxedCopyFunc) pango_attr_iterator_copy,
		      (GBoxedFreeFunc) pango_attr_iterator_destroy);
	return t;
}

/* ------------------------------------------------------------------------- */

#if PANGO_CHECK_VERSION (1, 2, 0)

static GPerlCallback *
gtk2perl_pango_attr_filter_func_create (SV * func, SV * data)
{
	GType param_types [1];
	param_types[0] = PANGO_TYPE_ATTRIBUTE;
	return gperl_callback_new (func, data, G_N_ELEMENTS (param_types),
				   param_types, G_TYPE_BOOLEAN);
}

static gboolean
gtk2perl_pango_attr_filter_func (PangoAttribute *attribute,
			      	 gpointer data)
{
	GPerlCallback * callback = (GPerlCallback*)data;
	GValue value = {0,};
	gboolean retval;

	g_value_init (&value, callback->return_type);
	gperl_callback_invoke (callback, &value, attribute);
	retval = g_value_get_boolean (&value);
	g_value_unset (&value);

	return retval;
}

#endif

/* ------------------------------------------------------------------------- */

#line 310 "xs/PangoAttributes.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)    S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage        S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 452 "xs/PangoAttributes.c"

XS_EUPXS(XS_Pango__Color_parse); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__Color_parse)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, spec");
    {
#line 314 "xs/PangoAttributes.xs"
	PangoColor color;
#line 463 "xs/PangoAttributes.c"
	PangoColor *	RETVAL;
	const gchar *	spec;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	spec = (const gchar *)SvPV_nolen (ST(1))
;
#line 316 "xs/PangoAttributes.xs"
	if (! pango_color_parse (&color, spec))
		XSRETURN_UNDEF;
	RETVAL = &color;
#line 475 "xs/PangoAttributes.c"
	ST(0) = newSVPangoColor (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#if PANGO_CHECK_VERSION (1, 16, 0)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Pango__Color_to_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__Color_to_string)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
	gchar_own *	RETVAL;
#line 331 "xs/PangoAttributes.xs"
	if (items == 1)
		RETVAL = pango_color_to_string (SvPangoColor (ST (0)));
	else if (items == 2)
		RETVAL = pango_color_to_string (SvPangoColor (ST (1)));
	else
		croak ("Usage: Pango::Color::to_string($color)");
#line 500 "xs/PangoAttributes.c"
	ST(0) = sv_newmortal();
	/* used when we can directly own the returned string. */
	/* we have to copy in the case when perl's malloc != gtk's malloc,
         * so best copy all the time. */
	sv_setpv ((SV*)ST(0), RETVAL);
	SvUTF8_on (ST(0));
        g_free (RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Pango__Attribute_start_index); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__Attribute_start_index)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	guint	RETVAL;
	dXSTARG;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 361 "xs/PangoAttributes.xs"
	RETVAL = ix == 0 ? attr->start_index : attr->end_index;
	if (items > 1) {
		guint new_index = SvIV (ST (1));
		if (ix == 0)
			attr->start_index = new_index;
		else
			attr->end_index = new_index;
	}
#line 535 "xs/PangoAttributes.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__Attribute_equal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__Attribute_equal)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "attr1, attr2");
    {
	gboolean	RETVAL;
	PangoAttribute *	attr1 = SvPangoAttribute (ST(0))
;
	PangoAttribute *	attr2 = SvPangoAttribute (ST(1))
;

	RETVAL = pango_attribute_equal(attr1, attr2);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrString_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrString_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	gchar_own *	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 386 "xs/PangoAttributes.xs"
	RETVAL = g_strdup (((PangoAttrString*)attr)->value);
	if (items > 1) {
		/* this feels evil... */
		if (((PangoAttrString*)attr)->value)
			g_free (((PangoAttrString*)attr)->value);
		((PangoAttrString*)attr)->value = g_strdup (SvGChar (ST (1)));
	}
#line 580 "xs/PangoAttributes.c"
	ST(0) = sv_newmortal();
	/* used when we can directly own the returned string. */
	/* we have to copy in the case when perl's malloc != gtk's malloc,
         * so best copy all the time. */
	sv_setpv ((SV*)ST(0), RETVAL);
	SvUTF8_on (ST(0));
        g_free (RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrInt_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrInt_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	int	RETVAL;
	dXSTARG;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 406 "xs/PangoAttributes.xs"
	RETVAL = ((PangoAttrInt*)attr)->value;
	if (items > 1)
		((PangoAttrInt*)attr)->value = SvIV (ST (1));
#line 608 "xs/PangoAttributes.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrColor_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrColor_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
#line 427 "xs/PangoAttributes.xs"
	PangoColor copy;
#line 624 "xs/PangoAttributes.c"
	PangoColor *	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 429 "xs/PangoAttributes.xs"
	copy = ((PangoAttrColor*)attr)->color;
	RETVAL = &copy;
	if (items > 1) {
		PangoColor * color = SvPangoColor (ST (1));
		((PangoAttrColor*)attr)->color = *color;
	}
#line 635 "xs/PangoAttributes.c"
	ST(0) = newSVPangoColor (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrLanguage_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrLanguage_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, language, ...");
    {
	PangoAttribute_own *	RETVAL;
	PangoLanguage *	language = SvPangoLanguage (ST(1))
;

	RETVAL = pango_attr_language_new(language);
#line 457 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 657 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrLanguage_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrLanguage_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	PangoLanguage *	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 462 "xs/PangoAttributes.xs"
	RETVAL = ((PangoAttrLanguage*)attr)->value;
	if (items > 1) {
		/* from the pango source, this is all we need to do. */
		((PangoAttrLanguage*)attr)->value = SvPangoLanguage (ST (1));
	}
#line 681 "xs/PangoAttributes.c"
	ST(0) = newSVPangoLanguage (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrFamily_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrFamily_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, family, ...");
    {
	PangoAttribute_own *	RETVAL;
	const char *	family = (const char *)SvPV_nolen(ST(1))
;

	RETVAL = pango_attr_family_new(family);
#line 482 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 703 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrForeground_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrForeground_new)
{
    dVAR; dXSARGS;
    if (items < 4)
       croak_xs_usage(cv,  "class, red, green, blue, ...");
    {
	PangoAttribute_own *	RETVAL;
	guint16	red = (guint16)SvUV(ST(1))
;
	guint	green = (guint)SvUV(ST(2))
;
	guint16	blue = (guint16)SvUV(ST(3))
;

	RETVAL = pango_attr_foreground_new(red, green, blue);
#line 496 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (4, RETVAL);
#line 729 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrBackground_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrBackground_new)
{
    dVAR; dXSARGS;
    if (items < 4)
       croak_xs_usage(cv,  "class, red, green, blue, ...");
    {
	PangoAttribute_own *	RETVAL;
	guint16	red = (guint16)SvUV(ST(1))
;
	guint	green = (guint)SvUV(ST(2))
;
	guint16	blue = (guint16)SvUV(ST(3))
;

	RETVAL = pango_attr_background_new(red, green, blue);
#line 510 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (4, RETVAL);
#line 755 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrSize_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrSize_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, size, ...");
    {
	PangoAttribute_own *	RETVAL;
	int	size = (int)SvIV(ST(1))
;

	RETVAL = pango_attr_size_new(size);
#line 524 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 777 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#if PANGO_CHECK_VERSION (1, 8, 0)
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Pango__AttrSize_new_absolute); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrSize_new_absolute)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, size, ...");
    {
	PangoAttribute_own *	RETVAL;
	int	size = (int)SvIV(ST(1))
;

	RETVAL = pango_attr_size_new_absolute(size);
#line 532 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 802 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Pango__AttrStyle_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrStyle_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, style, ...");
    {
	PangoAttribute_own *	RETVAL;
	PangoStyle	style = SvPangoStyle (ST(1))
;

	RETVAL = pango_attr_style_new(style);
#line 552 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 825 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrStyle_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrStyle_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	PangoStyle	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 557 "xs/PangoAttributes.xs"
	RETVAL = ((PangoAttrInt*) attr)->value;
	if (items > 1)
		((PangoAttrInt*) attr)->value = SvPangoStyle (ST (1));
#line 847 "xs/PangoAttributes.c"
	ST(0) = newSVPangoStyle (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrWeight_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrWeight_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, weight, ...");
    {
	PangoAttribute_own *	RETVAL;
	PangoWeight	weight = SvPangoWeight (ST(1))
;

	RETVAL = pango_attr_weight_new(weight);
#line 575 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 869 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrWeight_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrWeight_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	PangoWeight	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 580 "xs/PangoAttributes.xs"
	RETVAL = ((PangoAttrInt*) attr)->value;
	if (items > 1)
		((PangoAttrInt*) attr)->value = SvPangoWeight (ST (1));
#line 891 "xs/PangoAttributes.c"
	ST(0) = newSVPangoWeight (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrVariant_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrVariant_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, variant, ...");
    {
	PangoAttribute_own *	RETVAL;
	PangoVariant	variant = SvPangoVariant (ST(1))
;

	RETVAL = pango_attr_variant_new(variant);
#line 598 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 913 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrVariant_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrVariant_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	PangoVariant	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 603 "xs/PangoAttributes.xs"
	RETVAL = ((PangoAttrInt*) attr)->value;
	if (items > 1)
		((PangoAttrInt*) attr)->value = SvPangoVariant (ST (1));
#line 935 "xs/PangoAttributes.c"
	ST(0) = newSVPangoVariant (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrStretch_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrStretch_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, stretch, ...");
    {
	PangoAttribute_own *	RETVAL;
	PangoStretch	stretch = SvPangoStretch (ST(1))
;

	RETVAL = pango_attr_stretch_new(stretch);
#line 621 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 957 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrStretch_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrStretch_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	PangoStretch	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 626 "xs/PangoAttributes.xs"
	RETVAL = ((PangoAttrInt*) attr)->value;
	if (items > 1)
		((PangoAttrInt*) attr)->value = SvPangoStretch (ST (1));
#line 979 "xs/PangoAttributes.c"
	ST(0) = newSVPangoStretch (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrUnderline_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrUnderline_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, underline, ...");
    {
	PangoAttribute_own *	RETVAL;
	PangoUnderline	underline = SvPangoUnderline (ST(1))
;

	RETVAL = pango_attr_underline_new(underline);
#line 644 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 1001 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrUnderline_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrUnderline_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	PangoUnderline	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 649 "xs/PangoAttributes.xs"
	RETVAL = ((PangoAttrInt*) attr)->value;
	if (items > 1)
		((PangoAttrInt*) attr)->value = SvPangoUnderline (ST (1));
#line 1023 "xs/PangoAttributes.c"
	ST(0) = newSVPangoUnderline (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrStrikethrough_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrStrikethrough_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, strikethrough, ...");
    {
	PangoAttribute_own *	RETVAL;
	gboolean	strikethrough = (bool)SvTRUE(ST(1))
;

	RETVAL = pango_attr_strikethrough_new(strikethrough);
#line 667 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 1045 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrStrikethrough_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrStrikethrough_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	gboolean	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 672 "xs/PangoAttributes.xs"
	RETVAL = ((PangoAttrInt*) attr)->value;
	if (items > 1)
		((PangoAttrInt*) attr)->value = SvTRUE (ST (1));
#line 1067 "xs/PangoAttributes.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrFontDesc_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrFontDesc_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, font_desc, ...");
    {
	PangoAttribute_own *	RETVAL;
	PangoFontDescription *	font_desc = SvPangoFontDescription (ST(1))
;

	RETVAL = pango_attr_font_desc_new(font_desc);
#line 690 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 1088 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrFontDesc_desc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrFontDesc_desc)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	PangoFontDescription_own *	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 695 "xs/PangoAttributes.xs"
	RETVAL = pango_font_description_copy (((PangoAttrFontDesc*) attr)->desc);
	if (items > 1) {
		if (((PangoAttrFontDesc*) attr)->desc)
			pango_font_description_free (((PangoAttrFontDesc*) attr)->desc);
		((PangoAttrFontDesc*) attr)->desc =
			pango_font_description_copy (SvPangoFontDescription (ST (1)));
	}
#line 1114 "xs/PangoAttributes.c"
	ST(0) = newSVPangoFontDescription_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrScale_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrScale_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, scale, ...");
    {
	PangoAttribute_own *	RETVAL;
	float	scale = (float)SvNV(ST(1))
;

	RETVAL = pango_attr_scale_new(scale);
#line 717 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 1136 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrScale_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrScale_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	double	RETVAL;
	dXSTARG;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 722 "xs/PangoAttributes.xs"
	RETVAL = ((PangoAttrFloat*) attr)->value;
	if (items > 1)
		((PangoAttrFloat*) attr)->value = SvNV (ST (1));
#line 1159 "xs/PangoAttributes.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrRise_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrRise_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, rise, ...");
    {
	PangoAttribute_own *	RETVAL;
	int	rise = (int)SvIV(ST(1))
;

	RETVAL = pango_attr_rise_new(rise);
#line 740 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 1180 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrShape_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrShape_new)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "class, ink_rect, logical_rect, ...");
    {
	PangoAttribute_own *	RETVAL;
	PangoRectangle *	ink_rect = SvPangoRectangle (ST(1))
;
	PangoRectangle *	logical_rect = SvPangoRectangle (ST(2))
;

	RETVAL = pango_attr_shape_new(ink_rect, logical_rect);
#line 754 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (3, RETVAL);
#line 1204 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrShape_ink_rect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrShape_ink_rect)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
#line 761 "xs/PangoAttributes.xs"
	PangoAttrShape * attrshape;
#line 1222 "xs/PangoAttributes.c"
	PangoRectangle *	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 763 "xs/PangoAttributes.xs"
	attrshape = (PangoAttrShape *) attr;
	RETVAL = ix == 0 ? &(attrshape->ink_rect) : &(attrshape->logical_rect);
	if (items > 1) {
		PangoRectangle * rect = SvPangoRectangle (ST (1));
		if (ix == 0)
			attrshape->ink_rect = *rect;
		else
			attrshape->logical_rect = *rect;
	}
#line 1236 "xs/PangoAttributes.c"
	ST(0) = newSVPangoRectangle (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#if PANGO_CHECK_VERSION (1, 4, 0)
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Pango__AttrFallback_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrFallback_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, enable_fallback, ...");
    {
	PangoAttribute_own *	RETVAL;
	gboolean	enable_fallback = (bool)SvTRUE(ST(1))
;

	RETVAL = pango_attr_fallback_new(enable_fallback);
#line 792 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 1261 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrFallback_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrFallback_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	gboolean	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 797 "xs/PangoAttributes.xs"
	RETVAL = ((PangoAttrInt*) attr)->value;
	if (items > 1)
		((PangoAttrInt*) attr)->value = SvTRUE (ST (1));
#line 1283 "xs/PangoAttributes.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#endif
#if PANGO_CHECK_VERSION (1, 6, 0)
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Pango__AttrLetterSpacing_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrLetterSpacing_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, letter_spacing, ...");
    {
	PangoAttribute_own *	RETVAL;
	int	letter_spacing = (int)SvIV(ST(1))
;

	RETVAL = pango_attr_letter_spacing_new(letter_spacing);
#line 819 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 1308 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif
#if PANGO_CHECK_VERSION (1, 8, 0)
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_Pango__AttrUnderlineColor_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrUnderlineColor_new)
{
    dVAR; dXSARGS;
    if (items < 4)
       croak_xs_usage(cv,  "class, red, green, blue, ...");
    {
	PangoAttribute_own *	RETVAL;
	guint16	red = (guint16)SvUV(ST(1))
;
	guint16	green = (guint16)SvUV(ST(2))
;
	guint16	blue = (guint16)SvUV(ST(3))
;

	RETVAL = pango_attr_underline_color_new(red, green, blue);
#line 837 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (4, RETVAL);
#line 1338 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif
#if PANGO_CHECK_VERSION (1, 8, 0)
#define XSubPPtmpAAAF 1


XS_EUPXS(XS_Pango__AttrStrikethroughColor_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrStrikethroughColor_new)
{
    dVAR; dXSARGS;
    if (items < 4)
       croak_xs_usage(cv,  "class, red, green, blue, ...");
    {
	PangoAttribute_own *	RETVAL;
	guint16	red = (guint16)SvUV(ST(1))
;
	guint16	green = (guint16)SvUV(ST(2))
;
	guint16	blue = (guint16)SvUV(ST(3))
;

	RETVAL = pango_attr_strikethrough_color_new(red, green, blue);
#line 855 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (4, RETVAL);
#line 1368 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif
#if PANGO_CHECK_VERSION (1, 16, 0)
#define XSubPPtmpAAAG 1


XS_EUPXS(XS_Pango__AttrGravity_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrGravity_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, gravity, ...");
    {
	PangoAttribute_own *	RETVAL;
	PangoGravity	gravity = SvPangoGravity (ST(1))
;

	RETVAL = pango_attr_gravity_new(gravity);
#line 873 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 1394 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrGravity_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrGravity_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	PangoGravity	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 878 "xs/PangoAttributes.xs"
	RETVAL = ((PangoAttrInt*)attr)->value;
	if (items > 1)
		((PangoAttrInt*)attr)->value = SvPangoGravity (ST (1));
#line 1416 "xs/PangoAttributes.c"
	ST(0) = newSVPangoGravity (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrGravityHint_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrGravityHint_new)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "class, hint, ...");
    {
	PangoAttribute_own *	RETVAL;
	PangoGravityHint	hint = SvPangoGravityHint (ST(1))
;

	RETVAL = pango_attr_gravity_hint_new(hint);
#line 893 "xs/PangoAttributes.xs"
	PANGO_PERL_ATTR_STORE_INDICES (2, RETVAL);
#line 1438 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttribute_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrGravityHint_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrGravityHint_value)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "attr, ...");
    {
	PangoGravityHint	RETVAL;
	PangoAttribute *	attr = SvPangoAttribute (ST(0))
;
#line 898 "xs/PangoAttributes.xs"
	RETVAL = ((PangoAttrInt*)attr)->value;
	if (items > 1)
		((PangoAttrInt*)attr)->value = SvPangoGravityHint (ST (1));
#line 1460 "xs/PangoAttributes.c"
	ST(0) = newSVPangoGravityHint (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Pango__AttrList_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrList_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	PangoAttrList_own *	RETVAL;

	RETVAL = pango_attr_list_new(/*void*/);
	ST(0) = newSVPangoAttrList_own (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrList_insert); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrList_insert)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "list, attr");
    {
	PangoAttrList *	list = SvPangoAttrList (ST(0))
;
	PangoAttribute *	attr = SvPangoAttribute (ST(1))
;

	pango_attr_list_insert(list, pango_attribute_copy (attr));
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Pango__AttrList_insert_before); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrList_insert_before)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "list, attr");
    {
	PangoAttrList *	list = SvPangoAttrList (ST(0))
;
	PangoAttribute *	attr = SvPangoAttribute (ST(1))
;

	pango_attr_list_insert_before(list, pango_attribute_copy (attr));
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Pango__AttrList_change); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrList_change)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "list, attr");
    {
	PangoAttrList *	list = SvPangoAttrList (ST(0))
;
	PangoAttribute *	attr = SvPangoAttribute (ST(1))
;

	pango_attr_list_change(list, pango_attribute_copy (attr));
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Pango__AttrList_splice); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrList_splice)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "list, other, pos, len");
    {
	PangoAttrList *	list = SvPangoAttrList (ST(0))
;
	PangoAttrList *	other = SvPangoAttrList (ST(1))
;
	gint	pos = (gint)SvIV(ST(2))
;
	gint	len = (gint)SvIV(ST(3))
;

	pango_attr_list_splice(list, other, pos, len);
    }
    XSRETURN_EMPTY;
}

#if PANGO_CHECK_VERSION (1, 2, 0)
#define XSubPPtmpAAAH 1


XS_EUPXS(XS_Pango__AttrList_filter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrList_filter)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "list, func, data= NULL");
    {
#line 946 "xs/PangoAttributes.xs"
	GPerlCallback *callback;
#line 1574 "xs/PangoAttributes.c"
	PangoAttrList_own_ornull *	RETVAL;
	PangoAttrList *	list = SvPangoAttrList (ST(0))
;
	SV *	func = ST(1)
;
	SV *	data;

	if (items < 3)
	    data = NULL;
	else {
	    data = ST(2)
;
	}
#line 948 "xs/PangoAttributes.xs"
	callback = gtk2perl_pango_attr_filter_func_create (func, data);
	RETVAL = pango_attr_list_filter (
	       	   list, gtk2perl_pango_attr_filter_func, callback);
	gperl_callback_destroy (callback);
#line 1593 "xs/PangoAttributes.c"
	ST(0) = newSVPangoAttrList_own_ornull (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Pango__AttrList_get_iterator); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrList_get_iterator)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "list");
    {
	PangoAttrIterator *	RETVAL;
	PangoAttrList *	list = SvPangoAttrList (ST(0))
;

	RETVAL = pango_attr_list_get_iterator(list);
	ST(0) = newSVPangoAttrIterator (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrIterator_range); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrIterator_range)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "iterator");
    {
	PangoAttrIterator *	iterator = SvPangoAttrIterator (ST(0))
;
	gint	start;
	gint	end;

	pango_attr_iterator_range(iterator, &start, &end);
	XSprePUSH;	EXTEND(SP,2);
	PUSHs(sv_newmortal());
	sv_setiv(ST(0), (IV)start);
	PUSHs(sv_newmortal());
	sv_setiv(ST(1), (IV)end);
    }
    XSRETURN(2);
}


XS_EUPXS(XS_Pango__AttrIterator_next); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrIterator_next)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "iterator");
    {
	gboolean	RETVAL;
	PangoAttrIterator *	iterator = SvPangoAttrIterator (ST(0))
;

	RETVAL = pango_attr_iterator_next(iterator);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrIterator_get); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrIterator_get)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "iterator, type");
    {
	PangoAttribute_ornull *	RETVAL;
	PangoAttrIterator *	iterator = SvPangoAttrIterator (ST(0))
;
	PangoAttrType	type = SvPangoAttrType (ST(1))
;

	RETVAL = pango_attr_iterator_get(iterator, type);
	ST(0) = newSVPangoAttribute_ornull (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Pango__AttrIterator_get_font); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrIterator_get_font)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "iterator");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 976 "xs/PangoAttributes.xs"
	PangoFontDescription *desc;
	PangoLanguage *language;
	GSList *extra_attrs, *i;
#line 1696 "xs/PangoAttributes.c"
	PangoAttrIterator *	iterator = SvPangoAttrIterator (ST(0))
;
#line 980 "xs/PangoAttributes.xs"
	desc = pango_font_description_new ();
	language = NULL;
	extra_attrs = NULL;
	pango_attr_iterator_get_font (iterator, desc, &language, &extra_attrs);
	XPUSHs (sv_2mortal (newSVPangoFontDescription_copy (desc)));
	XPUSHs (sv_2mortal (newSVPangoLanguage_ornull (language)));
	for (i = extra_attrs; i != NULL; i = i->next)
		XPUSHs (sv_2mortal (newSVPangoAttribute_own (i->data)));
	if (extra_attrs)
		g_slist_free (extra_attrs);
#line 1710 "xs/PangoAttributes.c"
	PUTBACK;
	return;
    }
}

#if PANGO_CHECK_VERSION (1, 2, 0)
#define XSubPPtmpAAAI 1


XS_EUPXS(XS_Pango__AttrIterator_get_attrs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango__AttrIterator_get_attrs)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "iterator");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 997 "xs/PangoAttributes.xs"
	GSList *result, *i;
#line 1731 "xs/PangoAttributes.c"
	PangoAttrIterator *	iterator = SvPangoAttrIterator (ST(0))
;
#line 999 "xs/PangoAttributes.xs"
	result = pango_attr_iterator_get_attrs (iterator);
	for (i = result; i != NULL; i = i->next)
		XPUSHs (sv_2mortal (newSVPangoAttribute_own (i->data)));
	g_slist_free (result);
#line 1739 "xs/PangoAttributes.c"
	PUTBACK;
	return;
    }
}

#endif

XS_EUPXS(XS_Pango_parse_markup); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Pango_parse_markup)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "class, markup_text, accel_marker=0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1036 "xs/PangoAttributes.xs"
	PangoAttrList * attr_list;
	char * text;
	gunichar accel_char;
	GError * error = NULL;
#line 1761 "xs/PangoAttributes.c"
	STRLEN	STRLEN_length_of_markup_text;
	int	XSauto_length_of_markup_text;
	const gchar_length *	markup_text;
	gunichar	accel_marker;

	XSauto_length_of_markup_text = STRLEN_length_of_markup_text;

	sv_utf8_upgrade (ST(1));
	markup_text = (const gchar_length *)SvPV (ST(1), STRLEN_length_of_markup_text);
        XSauto_length_of_markup_text = STRLEN_length_of_markup_text
;

	if (items < 3)
	    accel_marker = 0;
	else {
	    accel_marker = g_utf8_get_char (SvGChar (ST(2)))
;
	}
#line 1041 "xs/PangoAttributes.xs"
	if (! pango_parse_markup (markup_text, XSauto_length_of_markup_text,
				  accel_marker, &attr_list, &text,
				  &accel_char, &error))
		gperl_croak_gerror (NULL, error);
	EXTEND (SP, 3);
	PUSHs (sv_2mortal (newSVPangoAttrList (attr_list)));
	PUSHs (sv_2mortal (newSVGChar (text)));
	g_free (text);
	if (accel_char) {
		/* adapted from Glib/typemap */
		gchar temp[6];
		gint length = g_unichar_to_utf8 (accel_char, temp);
		PUSHs (sv_2mortal (newSVpv (temp, length)));
		SvUTF8_on (ST (2));
	}
#line 1796 "xs/PangoAttributes.c"
	PUTBACK;
	return;
    }
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Pango__Attributes); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Pango__Attributes)
{
    dVAR; dXSARGS;
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK;

        newXS("Pango::Color::parse", XS_Pango__Color_parse, file);
#if XSubPPtmpAAAA
        newXS("Pango::Color::to_string", XS_Pango__Color_to_string, file);
#endif
        cv = newXS("Pango::Attribute::end_index", XS_Pango__Attribute_start_index, file);
        XSANY.any_i32 = 1;
        cv = newXS("Pango::Attribute::start_index", XS_Pango__Attribute_start_index, file);
        XSANY.any_i32 = 0;
        newXS("Pango::Attribute::equal", XS_Pango__Attribute_equal, file);
        newXS("Pango::AttrString::value", XS_Pango__AttrString_value, file);
        newXS("Pango::AttrInt::value", XS_Pango__AttrInt_value, file);
        newXS("Pango::AttrColor::value", XS_Pango__AttrColor_value, file);
        newXS("Pango::AttrLanguage::new", XS_Pango__AttrLanguage_new, file);
        newXS("Pango::AttrLanguage::value", XS_Pango__AttrLanguage_value, file);
        newXS("Pango::AttrFamily::new", XS_Pango__AttrFamily_new, file);
        newXS("Pango::AttrForeground::new", XS_Pango__AttrForeground_new, file);
        newXS("Pango::AttrBackground::new", XS_Pango__AttrBackground_new, file);
        newXS("Pango::AttrSize::new", XS_Pango__AttrSize_new, file);
#if XSubPPtmpAAAB
        newXS("Pango::AttrSize::new_absolute", XS_Pango__AttrSize_new_absolute, file);
#endif
        newXS("Pango::AttrStyle::new", XS_Pango__AttrStyle_new, file);
        newXS("Pango::AttrStyle::value", XS_Pango__AttrStyle_value, file);
        newXS("Pango::AttrWeight::new", XS_Pango__AttrWeight_new, file);
        newXS("Pango::AttrWeight::value", XS_Pango__AttrWeight_value, file);
        newXS("Pango::AttrVariant::new", XS_Pango__AttrVariant_new, file);
        newXS("Pango::AttrVariant::value", XS_Pango__AttrVariant_value, file);
        newXS("Pango::AttrStretch::new", XS_Pango__AttrStretch_new, file);
        newXS("Pango::AttrStretch::value", XS_Pango__AttrStretch_value, file);
        newXS("Pango::AttrUnderline::new", XS_Pango__AttrUnderline_new, file);
        newXS("Pango::AttrUnderline::value", XS_Pango__AttrUnderline_value, file);
        newXS("Pango::AttrStrikethrough::new", XS_Pango__AttrStrikethrough_new, file);
        newXS("Pango::AttrStrikethrough::value", XS_Pango__AttrStrikethrough_value, file);
        newXS("Pango::AttrFontDesc::new", XS_Pango__AttrFontDesc_new, file);
        newXS("Pango::AttrFontDesc::desc", XS_Pango__AttrFontDesc_desc, file);
        newXS("Pango::AttrScale::new", XS_Pango__AttrScale_new, file);
        newXS("Pango::AttrScale::value", XS_Pango__AttrScale_value, file);
        newXS("Pango::AttrRise::new", XS_Pango__AttrRise_new, file);
        newXS("Pango::AttrShape::new", XS_Pango__AttrShape_new, file);
        cv = newXS("Pango::AttrShape::ink_rect", XS_Pango__AttrShape_ink_rect, file);
        XSANY.any_i32 = 0;
        cv = newXS("Pango::AttrShape::logical_rect", XS_Pango__AttrShape_ink_rect, file);
        XSANY.any_i32 = 1;
#if XSubPPtmpAAAC
        newXS("Pango::AttrFallback::new", XS_Pango__AttrFallback_new, file);
        newXS("Pango::AttrFallback::value", XS_Pango__AttrFallback_value, file);
#endif
#if XSubPPtmpAAAD
        newXS("Pango::AttrLetterSpacing::new", XS_Pango__AttrLetterSpacing_new, file);
#endif
#if XSubPPtmpAAAE
        newXS("Pango::AttrUnderlineColor::new", XS_Pango__AttrUnderlineColor_new, file);
#endif
#if XSubPPtmpAAAF
        newXS("Pango::AttrStrikethroughColor::new", XS_Pango__AttrStrikethroughColor_new, file);
#endif
#if XSubPPtmpAAAG
        newXS("Pango::AttrGravity::new", XS_Pango__AttrGravity_new, file);
        newXS("Pango::AttrGravity::value", XS_Pango__AttrGravity_value, file);
        newXS("Pango::AttrGravityHint::new", XS_Pango__AttrGravityHint_new, file);
        newXS("Pango::AttrGravityHint::value", XS_Pango__AttrGravityHint_value, file);
#endif
        newXS("Pango::AttrList::new", XS_Pango__AttrList_new, file);
        newXS("Pango::AttrList::insert", XS_Pango__AttrList_insert, file);
        newXS("Pango::AttrList::insert_before", XS_Pango__AttrList_insert_before, file);
        newXS("Pango::AttrList::change", XS_Pango__AttrList_change, file);
        newXS("Pango::AttrList::splice", XS_Pango__AttrList_splice, file);
#if XSubPPtmpAAAH
        newXS("Pango::AttrList::filter", XS_Pango__AttrList_filter, file);
#endif
        newXS("Pango::AttrList::get_iterator", XS_Pango__AttrList_get_iterator, file);
        newXS("Pango::AttrIterator::range", XS_Pango__AttrIterator_range, file);
        newXS("Pango::AttrIterator::next", XS_Pango__AttrIterator_next, file);
        newXS("Pango::AttrIterator::get", XS_Pango__AttrIterator_get, file);
        newXS("Pango::AttrIterator::get_font", XS_Pango__AttrIterator_get_font, file);
#if XSubPPtmpAAAI
        newXS("Pango::AttrIterator::get_attrs", XS_Pango__AttrIterator_get_attrs, file);
#endif
        newXS("Pango::parse_markup", XS_Pango_parse_markup, file);

    /* Initialisation Section */

#line 303 "xs/PangoAttributes.xs"
	PERL_UNUSED_VAR (file);
	pango_color_wrapper_class.wrap = pango_color_wrap;
	pango_color_wrapper_class.unwrap = pango_color_unwrap;
	pango_color_wrapper_class.destroy = pango_color_destroy;
	gperl_register_boxed (PANGO_TYPE_COLOR, "Pango::Color",
	                      &pango_color_wrapper_class);

#if XSubPPtmpAAAA
#endif
#line 349 "xs/PangoAttributes.xs"
	default_wrapper_class = gperl_default_boxed_wrapper_class ();
	gtk2perl_pango_attribute_wrapper_class = * default_wrapper_class;
	gtk2perl_pango_attribute_wrapper_class.wrap = gtk2perl_pango_attribute_wrap;
	gtk2perl_pango_attribute_wrapper_class.unwrap = gtk2perl_pango_attribute_unwrap;
	gperl_register_boxed (PANGO_TYPE_ATTRIBUTE, "Pango::Attribute",
	                      &gtk2perl_pango_attribute_wrapper_class);

#line 381 "xs/PangoAttributes.xs"
	gperl_set_isa ("Pango::AttrString", "Pango::Attribute");

#line 401 "xs/PangoAttributes.xs"
	gperl_set_isa ("Pango::AttrInt", "Pango::Attribute");

#line 417 "xs/PangoAttributes.xs"
	gperl_set_isa ("Pango::AttrColor", "Pango::Attribute");

#line 445 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrLanguage");
	gperl_set_isa ("Pango::AttrLanguage", "Pango::Attribute");

#line 475 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrFamily");
	gperl_set_isa ("Pango::AttrFamily", "Pango::AttrString");

#line 489 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrForeground");
	gperl_set_isa ("Pango::AttrForeground", "Pango::AttrColor");

#line 503 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrBackground");
	gperl_set_isa ("Pango::AttrBackground", "Pango::AttrColor");

#line 517 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrSize");
	gperl_set_isa ("Pango::AttrSize", "Pango::AttrInt");

#if XSubPPtmpAAAB
#endif
#line 545 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrStyle");
	gperl_set_isa ("Pango::AttrStyle", "Pango::Attribute");

#line 568 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrWeight");
	gperl_set_isa ("Pango::AttrWeight", "Pango::Attribute");

#line 591 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrVariant");
	gperl_set_isa ("Pango::AttrVariant", "Pango::Attribute");

#line 614 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrStretch");
	gperl_set_isa ("Pango::AttrStretch", "Pango::Attribute");

#line 637 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrUnderline");
	gperl_set_isa ("Pango::AttrUnderline", "Pango::Attribute");

#line 660 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrStrikethrough");
	gperl_set_isa ("Pango::AttrStrikethrough", "Pango::Attribute");

#line 683 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrFontDesc");
	gperl_set_isa ("Pango::AttrFontDesc", "Pango::Attribute");

#line 710 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrScale");
	gperl_set_isa ("Pango::AttrScale", "Pango::Attribute");

#line 733 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrRise");
	gperl_set_isa ("Pango::AttrRise", "Pango::AttrInt");

#line 747 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrShape");
	gperl_set_isa ("Pango::AttrShape", "Pango::Attribute");

#if XSubPPtmpAAAC
#line 785 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrFallback");
	gperl_set_isa ("Pango::AttrFallback", "Pango::Attribute");

#endif
#if XSubPPtmpAAAD
#line 812 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrLetterSpacing");
	gperl_set_isa ("Pango::AttrLetterSpacing", "Pango::AttrInt");

#endif
#if XSubPPtmpAAAE
#line 830 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrUnderlineColor");
	gperl_set_isa ("Pango::AttrUnderlineColor", "Pango::AttrColor");

#endif
#if XSubPPtmpAAAF
#line 848 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrStrikethroughColor");
	gperl_set_isa ("Pango::AttrStrikethroughColor", "Pango::AttrColor");

#endif
#if XSubPPtmpAAAG
#line 866 "xs/PangoAttributes.xs"
	gperl_register_boxed_alias (PANGO_TYPE_ATTRIBUTE, "Pango::AttrGravity");
	gperl_set_isa ("Pango::AttrGravity", "Pango::Attribute");

#line 887 "xs/PangoAttributes.xs"
	gperl_set_isa ("Pango::AttrGravityHint", "Pango::Attribute");

#endif
#if XSubPPtmpAAAH
#endif
#if XSubPPtmpAAAI
#endif
#line 2030 "xs/PangoAttributes.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

