# config file for phonon library

# known at buildtime
set(PHONON_VERSION "4.8.2")

get_filename_component(currentDir ${CMAKE_CURRENT_LIST_FILE} PATH) # get the directory where I myself am
get_filename_component(rootDir ${currentDir}/../../../ ABSOLUTE) # get the chosen install prefix

        # Use original install prefix when loaded through a "/usr move"
        # cross-prefix symbolic link such as /lib -> /usr/lib.
        get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
        get_filename_component(_realOrig "/usr/lib/cmake/phonon" REALPATH)
        if(_realCurr STREQUAL _realOrig)
            set(rootDir "/usr")
        endif()
        unset(_realOrig)
        unset(_realCurr)

set(PHONON_NO_GRAPHICSVIEW true)
set(PHONON_PULSESUPPORT OFF)
set(PHONON_FOUND_EXPERIMENTAL ON)

# install locations
set(PHONON_INCLUDE_DIR "${rootDir}/include")

set(PHONON_LIBRARY_DIR "${rootDir}/lib")
set(PHONON_BUILDSYSTEM_DIR "${rootDir}/share/phonon/buildsystem/")
set(PHONON_LIB_SONAME "phonon")

if(NOT TARGET Phonon::phonon)
  include(${currentDir}/PhononTargets.cmake)
endif()

set(PHONON_LIBRARY Phonon::phonon)
if(PHONON_FOUND_EXPERIMENTAL)
    set(PHONON_EXPERIMENTAL_LIBRARY Phonon::phononexperimental)
endif(PHONON_FOUND_EXPERIMENTAL)
set(PHONON_LIBRARIES ${PHONON_LIBRARY} ${PHONON_EXPERIMENTAL_LIBRARY})
# The following one is only for compatiblity
set(PHONON_LIBS ${PHONON_LIBRARIES})

set(PHONON_INCLUDES ${PHONON_INCLUDE_DIR} ${PHONON_INCLUDE_DIR}/KDE )

# Find Internal is included in the backends' finders rather than here.
# http://lists.kde.org/?l=kde-multimedia&m=135934335320148&w=2
