'''OpenGL extension NVX.conditional_render

This module customises the behaviour of the 
OpenGL.raw.GL.NVX.conditional_render to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NVX/conditional_render.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NVX.conditional_render import *
from OpenGL.raw.GL.NVX.conditional_render import _EXTENSION_NAME

def glInitConditionalRenderNVX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION