#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
#include <openssl/dh.h>
#endif
DH *get_dh2048()
	{
	static unsigned char dh2048_p[]={
		0xEE,0x13,0x2F,0x18,0x7C,0x97,0xB2,0x07,0x33,0x99,0x9B,0xFD,
		0x3F,0x96,0x2A,0x9D,0x52,0x24,0x61,0x2A,0x9A,0x7A,0xAA,0x6A,
		0xBC,0x0F,0x9E,0x8A,0x45,0xA1,0xFE,0xA8,0xFC,0x42,0xC5,0x36,
		0x30,0x17,0xE5,0xDD,0xC7,0xD2,0x82,0x83,0x0F,0x5E,0x5D,0x8A,
		0xA4,0x55,0x38,0xE4,0xDD,0x89,0xD2,0xA3,0x1B,0x8C,0x02,0x98,
		0x6B,0xD9,0x76,0xE5,0x43,0x9F,0x47,0xE4,0x77,0xF0,0x5F,0x94,
		0x65,0x4D,0xEE,0xB8,0x27,0x98,0x24,0xB7,0xFB,0xFE,0x1D,0xD9,
		0xAD,0xF6,0x9B,0x2C,0xF4,0x23,0xC0,0x16,0xC6,0xB1,0x50,0x67,
		0x4F,0x78,0xE5,0x3F,0x2E,0xDC,0xBD,0xD0,0xB3,0x02,0x4F,0xD0,
		0xF2,0xAE,0x2F,0xDC,0xFF,0x03,0x1C,0x18,0xA3,0x9E,0xA5,0x34,
		0xB0,0xD8,0x81,0xB0,0x5D,0x59,0x86,0x2A,0x5F,0x86,0x7F,0xA7,
		0x7F,0x3F,0xD6,0x09,0xB2,0x7A,0x10,0x5E,0x56,0x74,0x8E,0x6B,
		0x29,0x01,0xAE,0x27,0xBA,0x90,0xF8,0x49,0xAB,0xB7,0x33,0xB8,
		0xF4,0x22,0xCA,0x27,0x95,0xA5,0xAE,0x5F,0xC9,0xE5,0x9E,0x09,
		0x33,0x35,0xF3,0x6B,0xD7,0xD8,0x2A,0x4B,0x76,0xEF,0x95,0xAC,
		0x1A,0x10,0x25,0x39,0x8A,0x00,0x9A,0x1B,0xF9,0xC9,0x59,0x79,
		0x68,0x47,0xB8,0x4A,0x9B,0xFF,0x91,0x8E,0x8A,0xC2,0xCD,0xF4,
		0x2E,0x08,0xC7,0x77,0xC0,0x92,0xEB,0x0A,0x57,0x91,0x0D,0xAA,
		0xAD,0x90,0xEF,0x5B,0xAE,0xEB,0x77,0x09,0x7E,0x78,0xF7,0x5B,
		0xD8,0x36,0x64,0xFA,0x79,0x34,0x93,0x3C,0x48,0x9B,0x48,0x58,
		0x76,0x5E,0xC2,0x93,0xD4,0x27,0xDE,0x98,0x2C,0x3E,0xD6,0xBB,
		0x79,0x8B,0x1B,0x0B,
		};
	static unsigned char dh2048_g[]={
		0x02,
		};
	DH *dh;

	if ((dh=DH_new()) == NULL) return(NULL);
	dh->p=BN_bin2bn(dh2048_p,sizeof(dh2048_p),NULL);
	dh->g=BN_bin2bn(dh2048_g,sizeof(dh2048_g),NULL);
	if ((dh->p == NULL) || (dh->g == NULL))
		{ DH_free(dh); return(NULL); }
	return(dh);
	}
#endif /* OPENSSL_NO_DH */
