###############################################################################
# Name: lisptags.py                                                           #
# Purpose: Generate Tags for Lisp                                             #
# Author: Cody Precord <cprecord@editra.org>                                  #
# Copyright: (c) 2008 Cody Precord <staff@editra.org>                         #
# License: wxWindows License                                                  #
###############################################################################

"""
FILE: lisptags.py
AUTHOR: Cody Precord
LANGUAGE: Python
SUMMARY:
  Generate a DocStruct object that captures the structure of Lisp code

"""

__author__ = "Cody Precord <cprecord@editra.org>"
__svnid__ = "$Id: lisptags.py 52031 2008-02-24 12:12:37Z CJP $"
__revision__ = "$Revision: 52031 $"

#--------------------------------------------------------------------------#
# Dependancies
import taglib

#--------------------------------------------------------------------------#

def GenerateTags(buff):
    """Create a DocStruct object that represents a Lisp document
    @param buff: a file like buffer object (StringIO)

    """
    rtags = taglib.DocStruct()
    rtags.SetElementDescription('function', "Function Definitions")

    for lnum, line in enumerate(buff):
        line = line.strip()

        # Skip comment and empty lines
        if line.startswith(u";") or not line:
            continue

        # Check Function Definitions
        if line.startswith('(') and u'defun' in line:
            dend = line.find(u'defun') + 5
            if dend < len(line) and line[dend].isspace():
                parts = line[dend:].split()
                if len(parts) > 1 and parts[1].startswith('('):
                    rtags.AddFunction(taglib.Function(parts[0], lnum))

    return rtags

#-----------------------------------------------------------------------------#
# Test
if __name__ == '__main__':
    import sys
    import StringIO
    fhandle = open(sys.argv[1])
    txt = fhandle.read()
    fhandle.close()
    tags = GenerateTags(StringIO.StringIO(txt))
    print "\n\nElements:"
    for element in tags.GetElements():
        print "\n%s:" % element.keys()[0]
        for val in element.values()[0]:
            print "%s [%d]" % (val.GetName(), val.GetLine())
    print "END"
