{$N-,W-,G+,V-}

Unit wbibole;

Interface

Uses
  WObjects,WinTypes,WinProcs,Strings,Ole,WinDos,wbibdisp,bibvars,lfnunit,
  rc_strng,bibstrg,bibfile,wbibbmp,wbibgif,wbibjpeg,wbibgui,wbibTGA,wbibPCX,
  graphio,ShellApi,wbibbin,wHugeMem,LZSSUnit,rc_id;

type
  UnitsRec = record
    U: string[2];
    f: real;
  end;

const
  NUnits = 10;   { Conversion from various TeX units to HiMetric (0.01 mm) }
  Units: array[1..NUnits] of UnitsRec = (
      (U: 'mm'; f: 100),(U: 'cm'; F: 1000),(U: 'in'; F: 2540),
      (U: 'pt'; F: 2540.0/72.27),   (U: 'bp'; F: 2540./72.0),
      (U: 'pc'; F: 2540.0/72.27*12),(U: 'dd'; F: 2540.0/72.27/1157.*1238),
      (U: 'cc'; F: 2540.0/72.27/1157.0*1238*12),
      (U: 'em'; F: 1.0),(U: 'ex'; F: 1.0)
  );
  EmUnit = 9; ExUnit = 10;  { These are determined at runtime }
  InUnits=3;  mmUnits=1;

  OleProtocol: PChar = 'StdFileEditing';
  OleObjPre = 'Obj';

  ObjAlign_Inline = 0; ObjAlign_Left = 1; ObjAlign_Center = 2;
  ObjAlign_Right  = 3;
  ObjIcon_Std = 0; ObjIcon_Custom = 1; ObjIcon_Render = 2;

  ObjBin_Compressed = 1;
  ImgBin_Metafile   = 2;

  ObjBin_Version    = 1;
  ImgBin_Version    = 1;

  IcoSepChar = ':';

type
  TObjBinFlags   = word;
  TObjBinVersion = word;
  ObjDimenRec=record
    Num: real;
    U: integer;
    S: array[0..15] of char;
  end;
  ObjInfoRec=record
    Fname,IcoName: array[0..255] of char;
    Class,Part: array[0..255] of char;
    halign: integer;
    FlipUD,FlipLR,BaseTop,BaseMid,BaseBottom,Active,DefW,DefH: boolean;
    Height,Width,Base: ObjDimenRec;
  end;
  ObjInfoPtr=^ObjInfoRec;

  TOleClientExt = record
    lpvtbl: POleClientVTBL;
    H: HWnd;
    Closed: boolean;
  end;
  POleClientExt = ^TOleClientExt; 
  TOleStreamExt = record
    lpstbl: POleStreamVTbl;
    Strm  : PStream;
  end;
  POleStreamExt = ^TOleStreamExt;

  POleObj = ^TOleObj;
  TOleObj = object(TObject)
    O        : POleObject;
    Client   : TOleClientExt;
    Parent   : PWindowsObject;
    BinObject: PBinObject;
    BinList  : PBinList;
    DIB      : THandle;
    Metafile : LPictInfo;
    BaseDir  : String;
    halign,IconIndex: integer;
    StartInd,EndInd : longint;
    Height,Width,DefHeight,DefWidth,Left,Base: real;
    ok,FlipUD,FlipLR,IsGraphic,IsEmbedded,IconImage: boolean;
    Name,Class,Fname,Part,FullFName,IcoName,FullIcoName: PChar;
    {--}
    constructor init(W: PWindowsObject; AClass,AFname,APart,AIcoName: PChar;
                     ABit,AIconImage: Boolean; BaseDirFile: Pstring;
                     ABinList: PBinList; ABinObject: PBinObject);
    procedure   Renew(AClass,AFname,APart,AIcoName: PChar;
                      ABit,AIconImage: Boolean;
                      ABinList: PBinList; ABinObject: PBinObject);
    procedure   LoadObject(ForceObject: boolean);
    procedure   GetRect(var R: TRect; XMove,YMove,FactX,FactY: real);
    function    Display(H: HWnd; DC: HDC; var R: TRect; ShowIt: boolean): integer;
    procedure   Activate(W: PWindowsObject; R: PRect);
    procedure   CopyToClip(H: HWnd);
    procedure   GetObjClass(F: PChar; MaxLen: integer);
    function    IsIconized: integer;
    destructor  Done; virtual;
  end;

var
  CFObjectLink,CFOwnerLink,CFNative: Word;
  ClientDoc: LHClientDoc;
  ObjectCounter: word;
  OleVerbatim,LockOleServers,CompressObjects,CompressImages: boolean;
  ImageIconDIB: THandle;
  ImageIconHeight,ImageIconWidth: real;
  OleClientVTbl: TOleClientVTbl;
  OleStreamVtbl: TOleStreamVtbl;

  LZInpStr,LZOutStr: PStream;

function  IsClipEmbeddedObj: boolean;
function  IsClipLinkedObj  : boolean;
function  IsClipObject: boolean;
function  IsClipImage : boolean;
function  LZReadProc(var ReadBuf; var NumRead: word): word;
function  LZWriteProc(var WriteBuf; Count: word; var NumWritten: word): word;

procedure OleError(H: HWnd; Status: Word);
function  OleCheck(H: HWnd; Obj: POleObject; OleStatus: TOleStatus): TOleStatus;
procedure OleWaitUntilClosed(Client: POleClientExt);
function  OleFree(Obj: POleObject): TOleStatus;
procedure UnlockOleServers;
function  ParseObjectString(S: Pchar; Slen: word; var R: ObjInfoRec): word;
procedure PlayObject(W: PWindowsObject; FName,Class,Part: PChar);
function  FindOleExe(Fl,Class,Exe: PChar; ExeSize: word): boolean;
function  FindOleIcon(Fl,Class,Exe: PChar; ExeSize: word): integer;


Implementation

const
  lbrace =#123; rbrace = #125; { Can't write these explicitly in the code! }

type
  PServerObj = ^TServerObj;
  TServerObj = object(TObject)
    Class: PChar;
    Server: LHServer;
    constructor init(AObj: POleObj);
    destructor  Done; virtual;
  end;

  PServerCollection = ^TServerCollection;
  TServerCollection = object(TCollection)
    procedure AddServer(Obj: POleObj);
  end;


var
  OleServers: PServerCollection;

procedure UnlockOleServers;
begin OleServers^.FreeAll; end;

procedure AHIncr; far; external 'KERNEL' index 114;

function LoadGraphicDIB(W: PWindowsObject; FName: PChar;
                        IconIndex: integer;
                        var Width,Height: longint): THandle;
begin
  LoadGraphicDIB:=0;
  if (FName=Nil) or (StrLen(FName)<5) or
              not LFNFileExist(StrPas(FName)) then Exit;

  case ImageType(FName) of
    GrExt_BMP: LoadGraphicDIB:=LoadBMPDIB  (FName,Width,Height);
    GrExt_PCX: LoadGraphicDIB:=LoadPCXDIB  (FName,Width,Height);
    GrExt_GIF: LoadGraphicDIB:=LoadGifDIB  (FName,Width,Height);
    GrExt_TGA: LoadGraphicDIB:=LoadTargaDIB(FName,Width,Height);
    GrExt_JPG: LoadGraphicDIB:=LoadJPEGDIB (W,FName,Width,Height);
    GrExt_ICO: LoadGraphicDIB:=LoadIcoDIB  (FName,IconIndex,Width,Height);
  end;
end;                       { LoadGraphicDIB }

function IsClipEmbeddedObj: boolean;
begin
  IsClipEmbeddedObj:=IsClipboardFormatAvailable(cfOwnerLink) and
                     IsClipboardFormatAvailable(CFNative);
end;

function IsClipLinkedObj: boolean;
begin
  IsClipLinkedObj:=IsClipboardFormatAvailable(CFObjectLink);
end;

function IsClipObject: boolean;
begin
  IsClipObject:=IsClipLinkedObj or IsClipEmbeddedObj;
end;

function IsClipImage: boolean;
begin
  IsClipImage:=IsClipboardFormatAvailable(CF_MetafilePict   ) or
               IsClipboardFormatAvailable(CF_DSPMetafilePict) or
               IsClipboardFormatAvailable(CF_DIB            ) or
               IsClipboardFormatAvailable(CF_Bitmap         ) or
               IsClipboardFormatAvailable(CF_DSPBitmap      );
end;

{ --------- OLE CallBack functions -------------}

{$F+}
function ClientCallBack(Client: POleClient; Notification: TOle_Notification;
         OleObj: POleObject): Integer; Export;
begin
  if POleClientExt(Client)^.H<>0 then
      PostMessage(POleClientExt(Client)^.H,bib_ObjectMsg,Notification,longint(OleObj));
  if Notification=Ole_Closed then POleClientExt(Client)^.Closed:=true;
  ClientCallBack:=1;
end;               { ClientCallBack }

const
  OneReadMax = $8000;

function OleStreamGet(Stream: POleStream; Buffer: PChar;
                      Size: Longint): Longint; Export;
var
  Strm: PStream;
  CurPos,CurSize: longint;
  OneRead: word;
  Buf: LongType;
begin
  OleStreamGet:=-1;
  Strm:=POleStreamExt(Stream)^.Strm;
  if (Strm=Nil) then Exit;
  if Size<=0 then
  begin
    OleStreamGet:=0; Exit;
  end;
  CurPos:=Strm^.GetPos; CurSize:=Strm^.GetSize;
{  message('Size = '+num2str(CurSize)+', Pos = '+num2str(CurPos));}
  if Size>CurSize-CurPos then
  begin
    Size:=CurSize-CurPos; OleStreamGet:=0;
{    message('Returning 0');}
  end else
  begin
    OleStreamGet:=Size;
{    message('Returning '+num2str(Size));}
  end;
  Buf.Ptr:=Buffer;
  { Read the data, taking care of segment boundaries }
  repeat
    if Size>OneReadMax then OneRead:=OneReadMax else OneRead:=Size;
    Strm^.read(Buf.Ptr^,OneRead); Size:=Size-OneRead;
{    message('Now '+num2str(OneRead)+', left '+num2str(Size));}
    if Size>0 then
    begin
      Buf.Ptr:=Buf.Ptr+OneReadMax;
      if Size>OneReadMax then OneRead:=OneReadMax else OneRead:=Size;
      Strm^.read(Buf.Ptr^,OneRead); Size:=Size-OneRead;
      if Size>0 then
      begin
        Buf.Lo:=0; Buf.Hi:=Buf.Hi+Ofs(AHIncr);
      end;
    end;
  until Size<=0;
end;                  { OleStreamGet }

function OleStreamPut(Stream: POleStream; Buffer: PChar;
                      Size: Longint): Longint; Export;
var
  Strm: PStream;
  CurPos,CurSize,OrigSize: longint;
  OneWrite: word;
  Buf: LongType;
begin
  OleStreamPut:=0;
  Strm:=POleStreamExt(Stream)^.Strm;
  if (Strm=Nil) or (Size<=0) then Exit;
  CurPos:=Strm^.GetPos;
{  message(num2str(CurPos)+','+num2str(Size));}
  Buf.Ptr:=Buffer;
  OrigSize:=Size;
  repeat
    if Size>OneReadMax then OneWrite:=OneReadMax else OneWrite:=Size;
    Strm^.write(Buf.Ptr^,OneWrite);
    Size:=Size-OneWrite;
    if Size>0 then
    begin
      Buf.Ptr:=Buf.Ptr+OneReadMax;
      if Size>OneReadMax then OneWrite:=OneReadMax else OneWrite:=Size;
      Strm^.write(Buf.Ptr^,OneWrite); Size:=Size-OneWrite;
      if Size>0 then
      begin
        Buf.Lo:=0; Buf.Hi:=Buf.Hi+Ofs(AHIncr);
      end;
    end;
  until Size<=0;
  {
  message('OleStreamPut, asked for '+num2str(OrigSize)+
                  ', written '+num2str(Strm^.GetPos-CurPos));
  }   
  OleStreamPut:=Strm^.GetPos-CurPos;
end;                       { OleStreamPut }
{F-}

{var
  LZInpStr,LZOutStr: PStream;}

Function LZReadProc(var ReadBuf; var NumRead: word): word;
var
  CurPos: longint;
Begin
  NumRead:=LZRWBufSize;
  CurPos:=LZInpStr^.GetPos;
  if CurPos+NumRead>LZInpStr^.GetSize then NumRead:=LZInpStr^.GetSize-CurPos;
  if NumRead>0 then LZInpStr^.Read(ReadBuf,NumRead);
End; { LZReadProc }

Function LZWriteProc(var WriteBuf; Count: word; var NumWritten: word): word;
var
  CurPos: longint;
Begin
  CurPos:=LZOutStr^.GetPos;
  if Count>0 then LZOutStr^.write(WriteBuf,Count);
  NumWritten:=LZOutStr^.GetPos-CurPos;
End; { LZWriteProc }
{$F-}

{ Display OLE operation error message. }

procedure OleError(H: HWnd; Status: Word);
var
  id: integer;
  F: Pchar;
begin
  if (not OleVerbatim) or (Status=Ole_ok) then Exit;
  id:=0;
  if Status=ole_Warn_Delete_Data then id:=OleWarn_Delete_Data
  else if (Status>=Ole_Busy) and (Status<=ole_Error_Static_From_Other_OS) then
    id:=OleErr_Busy+(Status-Ole_Busy);
  GetMem(F,256);
  if id=0 then StrPCopy(F,'OLE error #'+num2str(Status))
  else LoadString(HInstance,id,F,255);
  MessageBox(H,F,Nil,mb_ok or mb_IconExclamation);
  FreeMem(F,256);
end;                 { OleError }

{ Check the status of an OLE operation. If an OLE operation returns
  ole_Wait_For_Release, indicating that it is executing acsynchronously,
  the Check method will enter a message loop, waiting for the OLE object
  to be released by the server. }

function OleCheck(H: HWnd; Obj: POleObject; OleStatus: TOleStatus): TOleStatus;
var
  M: TMsg;
begin
  OleCheck:=Ole_ok;
  if Obj=Nil then Exit;
  if (OleStatus = ole_Wait_For_Release) or (OleStatus=ole_Busy) then
  begin
    repeat
      OleStatus := OleQueryReleaseStatus(Obj);
      if OleStatus = ole_Busy then
      begin
        if GetMessage(M, 0, 0, 0) and not
          ((M.Message>=wm_KeyFirst) and (M.Message<=wm_KeyLast)) and not
          ((M.Message>=wm_MouseFirst) and (M.Message<=wm_MouseLast)) then
        begin
          TranslateMessage(M);
          DispatchMessage(M);
        end;
      end;
    until OleStatus <> ole_Busy;
  end;
  if (H<>0) and (OleStatus <> ole_Ok) then OleError(H,OleStatus);
  OleCheck:=OleStatus;
end;                  { OleCheck }

procedure OleWaitUntilClosed(Client: POleClientExt);
var
  M: TMsg;
begin
  while not Client^.Closed do
  begin
    if GetMessage(M, 0, 0, 0) and not
      ((M.Message>=wm_KeyFirst) and (M.Message<=wm_KeyLast)) and not
      ((M.Message>=wm_MouseFirst) and (M.Message<=wm_MouseLast)) then
    begin
      TranslateMessage(M);
      DispatchMessage(M);
    end;
  end;
end;                  { OleWaitUntilClosed }

{ Wait until the object is free }

function OleFree(Obj: POleObject): TOleStatus;
var
  M: TMsg;
  OleStatus: TOleStatus;
begin
  OleFree:=Ole_Error_Object;
  if Obj=Nil then Exit;
  repeat
    OleStatus := OleQueryOpen(Obj);
    if OleStatus = ole_ok then
    begin
      if GetMessage(M, 0, 0, 0) and not
        ((M.Message>=wm_KeyFirst) and (M.Message<=wm_KeyLast)) and not
        ((M.Message>=wm_MouseFirst) and (M.Message<=wm_MouseLast)) then
      begin
        TranslateMessage(M);
        DispatchMessage(M);
      end;
    end;
  until OleStatus <> ole_ok;
  OleFree:=OleStatus;
end;                  { OleFree }

{ TOleObj methods }

constructor TOleObj.init(W: PWindowsObject; AClass,AFname,APart,AIcoName: PChar;
                         ABit,AIconImage: Boolean; BaseDirFile: Pstring;
                         ABinList: PBinList; ABinObject: PBinObject);
var
  F: array[0..10] of char;
  N,E: string;
begin
  TObject.init;
  Parent:=W;
  BinObject:=Nil; BinList:=Nil;
  O:=Nil; Name:=Nil; Class:=Nil; fname:=Nil; Part:=Nil; FullFName:=Nil;
  IcoName:=Nil; FullIcoName:=Nil;
  ok:=false; IsEmbedded:=false;
  Halign:=ObjAlign_Inline;
  left:=0; Height:=0; Width:=0; Base:=0;
  DefHeight:=0; DefWidth:=0;
  DIB:=0; IconIndex:=0;
  Fillchar(Metafile,sizeof(Metafile),0);
  FlipLR:=false; FlipUD:=false; IsGraphic:=ABit;
  IconImage:=AIconImage and IsGraphic;
  StartInd:=0; EndInd:=0;
  Client.lpvtbl:=@OleClientVTbl;
  if W=Nil then Client.H:=0 else Client.H:=W^.HWindow;

  BaseDir:='';
  if BaseDirFile<>Nil then LFNFSplit(BaseDirFile^,@BaseDir,@N,@E);

  if IsGraphic then Renew(Nil,AFName,Nil,AIcoName,true,IconImage,
                          ABinList,ABinObject)
  else begin
    StrPCopy(F,OleObjPre+num2str(ObjectCounter+1));
    Name:=StrNew(F);
    Renew(AClass,AFName,APart,AIcoName,ABit,IconImage,ABinList,ABinObject);
  end;
  if ok then
  begin
    Height:=DefHeight; Width:=DefWidth;
    inc(ObjectCounter);
  end;
end;               { TOleObj.init }

function TOleObj.IsIconized: integer;
begin
  IsIconized:=ObjIcon_Render;
  if IsGraphic and IconImage then IsIconized:=ObjIcon_Std
  else if not IsGraphic then
  begin
    if (IcoName=Nil) or ((StrIComp(IcoName,'on')=0) or (StrIComp(IcoName,'yes')=0)
      or (StrIComp(IcoName,'1')=0)) then IsIconized:=ObjIcon_Std   { Explicit file }
    else if (StrIComp(IcoName,'off')=0) or (StrIComp(IcoName,'no')=0) or
       (StrIComp(IcoName,'0')=0) then IsIconized:=ObjIcon_Render  { Explicit file }
    else IsIconized:=ObjIcon_Custom;
  end;
end;           { TOleObj.IsIconized }

procedure TOleObj.Renew(AClass,AFname,APart,AIcoName: PChar;
                        ABit,AIconImage: Boolean;
                        ABinList: PBinList; ABinObject: PBinObject);
var
  tmp: PString;
  P: Pchar;
  N,E: string;
  H: HWnd;
  i,Icode: integer;
begin
  if Parent=Nil then H:=0 else H:=Parent^.HWindow;
  if O<>Nil then
  begin
    if (OleQueryOpen(O) = ole_Ok) then OleCheck(H,O,OleClose(O));
    OleCheck(H,O,OleRelease(O));
  end;
  BinList:=ABinList; BinObject:=ABinObject;
  Client.lpvtbl:=@OleClientVTbl;
  O:=Nil;
  if IcoName     <>Nil then StrDispose(IcoName);     IcoName    :=Nil;
  if FullIcoName <>Nil then StrDispose(FullIcoName); FullIcoName:=Nil;
  if Class       <>Nil then StrDispose(Class);       Class      :=Nil;
  if Fname       <>Nil then StrDispose(FName);       FName      :=Nil;
  if FullFname   <>Nil then StrDispose(FullFName);   FullFName  :=Nil;
  if Part        <>Nil then StrDispose(Part);        Part       :=Nil;
  if (DIB<>0) and (DIB<>ImageIconDIB) then GlobalFree(DIB); DIB :=0;
  if Metafile.hmf<>0   then DeleteMetafile(Metafile.hmf);
  FillChar(Metafile,sizeof(Metafile),0);
  IsGraphic:=ABit;
  DefHeight:=0; DefWidth:=0; FlipLR:=false; FlipUD:=false; Base:=0;
  Height:=0; Width:=0; IconIndex:=0;
  IsEmbedded:=false;
  IconImage:=AIconImage and IsGraphic;
  if AFname=Nil then Exit;

  if (AClass<>Nil) and (AClass[0]=#0) then AClass:=Nil;
  if (APart <>Nil) and (APart[0] =#0) then APart :=Nil;

  New(tmp); GetMem(P,256);
  P[0]:=#0;
  tmp^:=StrPas(AFName);
  I:=ChrPosR(tmp^,IcoSepChar,1);
  if i<>0 then while (i<length(tmp^)) and (tmp^[i]=' ') do inc(i);
  if i>length(tmp^) then i:=0; 
  if IsGraphic and (i>0) and (i>length(tmp^)-7) then
  begin
    Val(Copy(tmp^,i+1,255),IconIndex,Icode);
    if Icode=0 then tmp^[0]:=Chr(i-1)
    else IconIndex:=0;
  end;
  if {(not IsGraphic) and} (tmp^[1]='<') and (tmp^[length(tmp^)]='>') then
  begin                     { Embedded object or image }
    IsEmbedded:=true;
    StrPCopy(P,copy(tmp^,2,length(tmp^)-2));
{    message('Embedded, "'+StrPas(P)+'"');}
  end else if (BaseDir<>'') and (Pos(':',tmp^)<>2) then
  begin
    LFNFSplit(tmp^,tmp,@N,@E);
    if (tmp^='') or (tmp^[1]<>'\') then StrPCopy(P,BaseDir+tmp^+N+E)
    else StrPCopy(P,BaseDir[1]+':'+tmp^+N+E);
  end else StrPCopy(P,tmp^);
  FullFName:=StrNew(P);

  if AFname<>Nil then Fname:=StrNew(AFname);
  if AClass<>Nil then Class:=StrNew(AClass);
  if APart <>Nil then Part :=StrNew(APart);

  { For objects, find icon }
  if not IsGraphic then
  begin
    if (AIcoName<>Nil) and (AIcoName[0]<>#0) then IcoName:=StrNew(AIcoName);
    if IsIconized=ObjIcon_Std then    { Default server Icon }
    begin
      IconIndex:=FindOleIcon(FName,Class,P,255);
      if IconIndex>-1 then FullIcoName:=StrNew(P);
{      if FullIcoName<>Nil then LogString(StrPas(FullIcoName));}
    end else if IsIconized=ObjIcon_Custom then   { Explicit file }
    begin
      P[0]:=#0;
      tmp^:=StrPas(IcoName);
      if (length(tmp^)>1) and (BaseDir<>'') and (Pos(':',tmp^)<>2) then
      begin
        LFNFSplit(tmp^,tmp,@N,@E);
        if (tmp^='') or (tmp^[1]<>'\') then StrPCopy(P,BaseDir+tmp^+N+E)
        else StrPCopy(P,BaseDir[1]+':'+tmp^+N+E);
      end else StrCopy(P,IcoName);
      FullIcoName:=StrNew(P);
    end;
  end;
  FreeMem(P,256); Dispose(tmp);

  LoadObject(false);
end;                   { TOleObj.Renew }

procedure TOleObj.LoadObject(ForceObject: boolean);
var
  BitWidth,BitHeight,ObjSize: longint;
  i         : integer;
  ObjectOffset: word;
  OStatus   : word;
  X         : real;
  Ptmp      : PString;
  F,F0      : PChar;
  Size      : TRect;
  DC        : HDC;
  H         : HWnd;
  OldWaiting: boolean;
  IcoData   : PCursorIconInfo;
  Icon      : HIcon;
  InpBinObj : PBinObject;
  OleStream : TOleStreamExt;
  ObjVer    : TObjBinVersion;
  ObjFlags  : TObjBinFlags;
  TempStream: PHugeMemStream;
  TempHandle: THandle;
  TMeta     : LPictInfo;
  DIBHeader : PBitmapInfoHeader;
begin
  OldWaiting:=AmWaiting;
  if Parent=Nil then H:=0 else H:=Parent^.HWindow;
  InpBinObj:=Nil; ObjVer:=0; ObjFlags:=0; Icon:=0;

  if IsEmbedded and not IconImage then   { Find binary object or image }
  begin
    New(Ptmp); Ptmp^:=StrPas(FName); ChrDel(Ptmp^,'<'); ChrDel(Ptmp^,'>');
    { First, look for the named object }
    if (BinObject<>Nil) and (StrCmpI(Ptmp^,BinObject^.Name,1,1,255)=0) then
        InpBinObj:=BinObject
    else if BinList<>Nil then    { Search the list }
    begin
      if IsGraphic then
        InpBinObj:=BinList^.FindName(Ptmp,BinTyp_Image)
      else
        InpBinObj:=BinList^.FindName(Ptmp,BinTyp_Object);
    end;
    Dispose(Ptmp);

    { Get embedded object header }
    if (InpBinObj<>Nil) and InpBinObj^.IsOk then
    begin
      if Class<>Nil then StrDispose(Class);
      if Part <>Nil then StrDispose(Part);
      InpBinObj^.P^.seek(0);
      InpBinObj^.P^.read(ObjectOffset,sizeof(word));
      GetMem(F0,ObjectOffset); F:=F0;
      InpBinObj^.P^.read(F^,ObjectOffset-sizeof(Word));
      Move(F^,ObjSize, sizeof(longint));  F:=F+sizeof(longint);
      Move(F^,ObjVer,  sizeof(ObjVer));   F:=F+sizeof(ObjVer);
      Move(F^,ObjFlags,sizeof(ObjFlags)); F:=F+sizeof(ObjFlags);
      if IsGraphic then
      begin
        if ObjFlags and ImgBin_Metafile <> 0 then
          Move(F^,TMeta,sizeof(LPictInfo));
        FreeMem(F0,ObjectOffset);
      end else
      begin
        Class:=StrNew(F); F:=F+StrLen(F)+1;
        Part :=StrNew(F);
        FreeMem(F0,ObjectOffset);
        if (FullIcoName=Nil) then
        begin
          GetMem(F0,256);
          if FindOleExe(FName,Class,F0,255) then FullIcoName:=StrNew(F0);
          FreeMem(F0,256);
        end;
      end;
      {
      message('ver = '+num2str(ObjVer)+', flags = '+num2str(ObjFlags)
          +', Class = "'+StrPas(Class)+', item = "'+StrPas(Part)+'"');
      }
    end;
  end;
  if (DIB=0) and (not IsGraphic) and (IsIconized<>ObjIcon_Render) then
  begin                { Iconized object }
    if IsIconized=ObjIcon_Custom then
    begin
      DIB:=LoadIcoDIB(FullIcoName,IconIndex,BitWidth,BitHeight);
      if DIB<>0 then
      begin
        DefWidth :=(Units[InUnits].F*BitWidth /ScreenResX);
        DefHeight:=(Units[InUnits].F*BitHeight/ScreenResY);
        ok:=true;
      end;
    end else if (FullIcoName=Nil) or (FullIcoName[0]=#0) then   { the default icon }
    begin
      Icon:=StdObjectIcon;
    end else                                                    { the server icon }
    begin
      Icon:=ExtractIcon(HInstance,FullIcoName,0);
      if Icon=1 then Icon:=0;
    end;
    if Icon<>0 then   { size }
    begin
      IcoData:=LockResource(THandle(Icon));
      if IcoData<>Nil then
      begin
        DefWidth :=(Units[InUnits].F*IcoData^.wWidth /ScreenResX);
        DefHeight:=(Units[InUnits].F*IcoData^.wHeight/ScreenResY);
{        logstring(num2str(round(DefWidth))+'x'+num2str(round(DefHeight)));}
        UnlockResource(THandle(Icon));
      end;
    end;
    if Icon<>0 then
    begin
      ok:=true;
      DIB:=IconToDIB(Icon,BitWidth,BitHeight);
    end;
    if (Icon<>0) and (Icon<>StdObjectIcon) then DestroyIcon(Icon);
  end;

  if IsGraphic and (Metafile.hmf=0) and (DIB=0) and IsEmbedded
     and not IconImage then  { Embedded Image }
  begin
    WaitingMessage('Resolving...');
    ok:=false;
    if (InpBinObj<>Nil) and InpBinObj^.IsOk then
    begin                { Load the image from a binary object }
      if ObjFlags and ImgBin_Metafile <> 0 then   { Metafile }
        Metafile:=TMeta;
      New(TempStream,Init(ObjSize));
      TempStream^.seek(0);
      if ObjFlags and ObjBin_Compressed <> 0 then  { Compressed }
      begin
        LZInpStr:=InpBinObj^.P;
        LZOutStr:=TempStream;
        LZInit;
        LzUnSquash(LZReadProc,LZWriteProc);
        LzDone;
      end else
      begin
        TempStream^.CopyFrom(InpBinObj^.P^,ObjSize);
      end;
      TempHandle:=TempStream^.Handle;
      TempStream^.Owner:=false; Dispose(TempStream,Done);
      if ObjFlags and ImgBin_Metafile <> 0 then   { Metafile }
      begin
        Metafile.hmf:=SetMetafileBits(TempHandle);
        if Metafile.hmf=0 then GlobalFree(TempHandle);
      end else DIB:=TempHandle;                   { DIB }
      ok:=true;
      { Get image dimensions }
      if (DIB<>0) then
      begin
        DIBHeader:=GlobalLock(DIB);
        BitWidth:=DIBHeader^.biWidth; BitHeight:=DIBHeader^.biHeight;
        GlobalUnlock(DIB);
      end else if Metafile.hmf<>0 then
      begin
        BitWidth :=(Metafile.bbox.Right-Metafile.bbox.left);
        BitHeight:=(Metafile.bbox.bottom-Metafile.bbox.top);
      end else ok:=false;
      if ok then
      begin
        DefWidth :=(Units[InUnits].F*BitWidth /ScreenResX);
        DefHeight:=(Units[InUnits].F*BitHeight/ScreenResY);
      end;
    end;
  end else if IsGraphic and IconImage then  { Image icon }
  begin
    if (DIB<>0) and (DIB<>ImageIconDIB) then GlobalFree(DIB);
    if Metafile.hmf<>0 then DeleteMetafile(Metafile.hmf);
    FillChar(Metafile,sizeof(Metafile),0);
    DIB:=ImageIconDIB;
    DefWidth:=ImageIconWidth;
    DefHeight:=ImageIconHeight;
    ok:=true;
  end else if IsGraphic and (Metafile.hmf=0) and (DIB=0) then  { Image file }
  begin
    WaitingMessage('Resolving...');
    ok:=false;

    DIB:=LoadGraphicDIB(Parent,FullFName,IconIndex,BitWidth,BitHeight);  { load a DIB }
    if DIB<>0 then ok:=true;

    if (not ok) and UseGraphicsFilters then
    begin               { Use a graphics filter }
      DC:=GetDC(H);
      i:=Import_Graphic(DC,H,FullFName,@Metafile,0,GRFilt_IniSection);
      ReleaseDC(H,DC);
      if i = GRImp_OK then
      begin
        ok:=true;
        BitWidth :=(Metafile.bbox.Right-Metafile.bbox.left);
        BitHeight:=(Metafile.bbox.bottom-Metafile.bbox.top);
      end else Metafile.hmf:=0;
    end;
    if ok then
    begin
      DefWidth :=(Units[InUnits].F*BitWidth /ScreenResX);
      DefHeight:=(Units[InUnits].F*BitHeight/ScreenResY);
    end;
  end else if (not IsGraphic) and (O=Nil) and
           (ForceObject or ((Icon=0) and (DIB=0))) then  { Object }
  begin
    WaitingMessage('Resolving...');
    if IsEmbedded then
    begin
      if (InpBinObj<>Nil) and InpBinObj^.IsOk then 
      begin                { Load the object from a binary object }
        OleStream.lpstbl:=@OleStreamVTbl;
        if ObjFlags and ObjBin_Compressed <>0 then  { Compressed }
        begin
          OleStream.Strm:=New(PHugeMemStream,Init(ObjSize));
          OleStream.Strm^.seek(0);
          LZInpStr:=InpBinObj^.P;
          LZOutStr:=OleStream.Strm;
          LZInit;
          LzUnSquash(LZReadProc,LzWriteProc);
          LzDone;
          OleStream.Strm^.seek(0);
          OStatus:=OleLoadFromStream(POleStream(@OleStream),OleProtocol,
                   POleClient(@Client),ClientDoc,Name,O);
          Dispose(OleStream.Strm,Done);
        end else                                   { Uncompressed }
        begin
          OleStream.Strm:=InpBinObj^.P;
          OStatus:=OleLoadFromStream(POleStream(@OleStream),OleProtocol,
                   POleClient(@Client),ClientDoc,Name,O);
        end;
        ok:=(OleCheck(H,O,OStatus)=Ole_Ok);
      end else Ok:=false;
    end else           { Link }
    begin
      OStatus:=OleCreateLinkFromFile(OleProtocol,POleClient(@Client),
               Class,FullFName,Part,
               ClientDoc,Name,O,OleRender_Draw,0);
      ok:=(OleCheck(H,O,OStatus)=Ole_Ok);
    end;
    if Ok then
    begin
      {
      if IsEmbedded then
      begin
        OleQuerySize(O,ObjSize);
        message('Loaded from stream, size = '+num2str(ObjSize));
      end;
      }
      if LockOleServers then OleServers^.AddServer(@Self);
      if (DefWidth=0) or (DefHeight=0) then
      begin
        OleQueryBounds(O,Size);
        DefHeight:=Size.top-Size.bottom; DefWidth:=Size.Right-Size.Left;
      end;
    end;
  end;
  if not OldWaiting then WaitingOff;
end;                      { TOleObj.LoadObject }

procedure TOleObj.GetRect(var R: TRect; XMove,YMove,FactX,FactY: real);
var
  i: integer;

function MakeInt(r: real): integer;  { Guard against overflow }
begin
  if r>32767 then MakeInt:=32767
  else if r<-32768 then MakeInt:=-32768
  else MakeInt:=round(r);
end;

begin           { GetRect }
  R.Left  :=MakeInt(XMove);
  R.Right :=MakeInt(Width*FactX+XMove);
  if IsGraphic and (IsIconized=ObjIcon_Std) then
  begin
    R.Top:=MakeInt(-ImageIconHeight*FactY+YMove);
    R.Bottom:=MakeInt(YMove);
  end else
  begin 
    R.Top   :=MakeInt(-(Base+Height)*FactY+YMove);
    R.Bottom:=MakeInt(-Base*FactY+YMove);
    if FlipUD then
    begin
      i:=R.Top; R.Top:=R.Bottom; R.Bottom:=i;
    end;
    if FlipLR then
    begin
      i:=R.Left; R.Left:=R.Right; R.Right:=i;
    end;
  end;
end;                      { TOleObj.GetRect }

function TOleObj.Display(H: HWnd; DC: HDC; var R: TRect; ShowIt: boolean): integer;
const
  Stretch_DeleteScans = 3;
var
  print: boolean;
  Xres,YRes,SavedDCState,OldStretchMode: integer;
  XFact,YFact: real;
  DIBheight,DIBWidth,DIBX0,DIBY0: word;  
  BInfo: PBitmapInfo;
  BInfoHeader: PBitmapInfoHeader;
  BBits: PChar;
  NewDIB: THandle;

function imin(a,b: longint): longint;
begin
  if a<=b then imin:=a else imin:=b;
end;

begin
  if R.Left<R.Right then Display:=R.Left else Display:=R.Right;
  if not ok or (IsGraphic and (Metafile.hmf=0) and (DIB=0))
            or ((not IsGraphic) and (O=Nil) and (DIB=0)) then Exit;
  if ShowIt then
  begin
    print:=GetMapMode(DC)=mm_AnIsotropic;
    XRes:=1; YRes:=1;
    if (IsGraphic or (DIB<>0)) and Print then
    begin
      XRes:=GetDeviceCaps(DC,LogPixelsX);
      YRes:=GetDeviceCaps(DC,LogPixelsY);
    end;
    if IsGraphic and (Metafile.hmf<>0) then     { Metafile or filter }
    with Metafile do
    begin
      SavedDCState:=SaveDC(DC);
      XFact:=1; YFact:=1;
      if print then
      begin        
        XFact:=1.0/720.0*XRes;
        YFact:=1.0/720.0*YRes;
      end else SetMapMode(DC,MM_AnIsotropic);
      SetViewportOrg(DC,round(XFact*R.left),round(YFact*R.top));
      SetViewportExt(DC,round(XFact*(R.right-R.left)),
                        round(YFact*(R.bottom-R.top)));
{      SetWindowExt(DC,
        MulDiv(bbox.right-bbox.left,Inch,ScreenResX),
        MulDiv(bbox.bottom-bbox.top,Inch,ScreenResY));  }
      PlayMetafile(DC,Metafile.hmf);
      RestoreDC(DC,SavedDCState);
    end else if (DIB<>0) then
       { Device-independent bitmap }
    begin
      if print and (FlipUD or FlipLR) and not IconImage then
      begin
        NewDIB:=FlipDIB(DIB,FlipLR,FlipUD);
        DIBX0:=word(imin(R.Left,R.Right));
        DIBY0:=word(imin(R.Top,R.Bottom));
        DIBWidth:=abs(R.Right-R.Left); DIBHeight:=abs(R.bottom-R.top);
      end else
      begin
        NewDIB:=DIB;
        if IconImage then
        begin
          DIBX0:=word(imin(R.Left,R.Right));
          DIBY0:=word(imin(R.Top,R.Bottom));
          DIBWidth:=abs(R.Right-R.Left); DIBHeight:=abs(R.bottom-R.top);
        end else
        begin
          DIBX0:=R.left; DIBY0:=R.Top;
          DIBWidth:=word(R.Right-R.Left); DIBHeight:=word(R.Bottom-R.Top);
        end;
      end; 
      BInfoHeader:=GlobalLock(NewDIB);
      BBits:=PChar(BInfoHeader)+BInfoHeader^.biSize;
      case BInfoHeader^.biBitCount of
        1 : BBits:=BBits+  2*sizeof(TRGBQuad);
        4 : BBits:=BBits+ 16*sizeof(TRGBQuad);
        8 : BBits:=BBits+256*sizeof(TRGBQuad);
        24: ;
      end;
      StretchDIBits(DC,DIBX0,DIBY0,DIBWidth,DIBHeight,
                    0,0,BInfoHeader^.biWidth,BInfoHeader^.biHeight,
                    BBits,PBitmapInfo(BInfoHeader)^,DIB_RGB_Colors,srcCopy);
      GlobalUnlock(NewDIB);
      if NewDIB<>DIB then GlobalFree(NewDIB);
    end else if O<>Nil then OleCheck(H,O,OleDraw(O, DC, R, R, 0));  { Object }
  end;
  if R.Left>R.Right then Display:=R.Left else Display:=R.Right;
end;                     { TOleObj.Display }

procedure TOleObj.Activate(W: PWindowsObject; R: PRect);
var
  PT: TPoint;
  LocalR: PRect;
  Stat: TOleStatus;
begin
  if IsGraphic then Exit;
  LoadObject(true);
  LocalR:=Nil;
  if R<>Nil then
  begin
    PT.X:=R^.left; PT.Y:=R^.top;
    ClientToScreen(W^.HWindow,PT);
    New(LocalR); LocalR^.left:=PT.X; LocalR^.top:=PT.Y;
    PT.X:=R^.right; PT.Y:=R^.bottom;
    ClientToScreen(W^.HWindow,PT);
    LocalR^.right:=PT.X; LocalR^.bottom:=PT.Y;
    {
    ClientToScreen(W^.HWindow,PPoint(R^.right)^);
    }
  end;
  OleSetHostNames(O,'WBibDB',FName);
  Client.Closed:=false;
  WaitingMessage('Edit object...');
  Stat:=OleCheck(W^.HWindow,O,OleActivate(O,0,true,true,W^.HWindow,LocalR));
  if Stat<>Ole_ok then messagebeep(0)
  else OleWaitUntilClosed(@Client);
  WaitingOff;
  if LocalR<>Nil then Dispose(LocalR);
end;           { TOleObj.Activate }

procedure TOleObj.CopyToClip(H: HWnd);
var
  PT: TPoint;
  LocalR: PRect;
  InStrm,OutStrm: PHugeMemStream;
  T: THandle;
  Meta: PMetafilePict;
  Bitmap: HBitmap;
  BInfoHeader: PBitmapInfoHeader;
  BBits: PChar;
  DC: HDC;
  MF: THandle;
  xMeta,yMeta,MetaMapMode: longint;
begin
  if (not ok) or (IsGraphic and (DIB=0) and (Metafile.hmf=0)) or
     ((not IsGraphic) and (O=Nil)) then
  begin
    messagebeep(0); Exit;
  end;
  OpenClipboard(H);
  EmptyClipboard;
  InStrm:=Nil; OutStrm:=Nil; MF:=0;
  if IsGraphic then
  begin
    if DIB<>0 then   { DIB }
    begin
      { First the CF_DIB clipboard format }
      New(InStrm,InitExt(DIB,GlobalSize(DIB),false)); InStrm^.Seek(0);
      New(OutStrm,Init(GlobalSize(DIB))); OutStrm^.seek(0);
      OutStrm^.CopyFrom(InStrm^,Instrm^.Size);
      Dispose(InStrm,Done);
      T:=OutStrm^.Handle; OutStrm^.Owner:=false; dispose(OutStrm,Done);
      if (SetClipboardData(CF_DIB,T)=0) then GlobalFree(T);
      { Now the CF_Bitmap clipboard format }
      BInfoHeader:=GlobalLock(DIB);
      BBits:=PChar(BInfoHeader)+BInfoHeader^.biSize;
      case BInfoHeader^.biBitCount of
        1 : BBits:=BBits+  2*sizeof(TRGBQuad);
        4 : BBits:=BBits+ 16*sizeof(TRGBQuad);
        8 : BBits:=BBits+256*sizeof(TRGBQuad);
        24: ;
      end;
      DC:=GetDC(0);
      Bitmap:=CreateDIBitmap(DC,BInfoHeader^,CBM_Init,BBits,
                         PBitmapInfo(BInfoHeader)^,DIB_RGB_COLORS);
      ReleaseDC(0,DC);
      if (SetClipboardData(CF_Bitmap,Bitmap)=0) then DeleteObject(Bitmap);
      { CF_MetafilePict }
      MF:=CreateMetafile(Nil);
      StretchDIBits(MF,0,0,BInfoHeader^.biWidth,BInfoHeader^.biHeight,
                    0,0,BInfoHeader^.biWidth,BInfoHeader^.biHeight,
                    BBits,PBitmapInfo(BInfoHeader)^,DIB_RGB_Colors,srcCopy);
      MF:=CloseMetafile(MF);
      xMeta:=BInfoHeader^.biWidth; yMeta:=BInfoHeader^.biHeight;
      MetaMapMode:=mm_Text;
      GlobalUnlock(DIB);
    end else if Metafile.hmf<>0 then    { Metafile }
    begin
      { Make a copy of the metafile data }
      MF:=CopyMetafile(Metafile.hmf,Nil);
      xMeta:=MulDiv(Metafile.bbox.Right-Metafile.bbox.left,
                                  Round(Units[InUnits].F),ScreenResX);
      yMeta:=MulDiv(Metafile.bbox.bottom-Metafile.bbox.top,
                                  Round(Units[InUnits].F),ScreenResX);
      MetaMapMode:=mm_AnIsotropic;
    end;
    if MF<>0 then   { Copy the metafile to the clipboard }
    begin
      T:=GlobalAlloc(GHND,sizeof(TMetafilePict));
      Meta:=GlobalLock(T);      
      with Meta^ do
      begin
        mm  :=MetaMapMode;
        xExt:=xMeta; yExt:=yMeta;
        hMF :=MF;
      end;
      GlobalUnlock(T);
      if (SetClipboardData(CF_MetafilePict,T)=0) then GlobalFree(T);
    end;
  end else
  begin
    LoadObject(true);
    OleCopyToClipboard(O);
  end;
  CloseClipboard;
end;           { TOleObj.CopyToClip }

procedure TOleObj.GetObjClass(F: PChar; MaxLen: integer);
var
  T: THandle;
  P: PChar;
  ClearData: boolean;
  len: longint;
begin
  F[0]:=#0;
  if IsGraphic or not ok then Exit;
  if Class<>Nil then StrLCat(F,Class,MaxLen)
  else if O=Nil then       { Look directly in registry }
  begin
    P:=Fname+StrLen(Fname);
    while (P>Fname) and (P^<>'.') do dec(P);
    if P^<>'.' then Exit;
    len:=MaxLen;
    if RegQueryValue(hKey_Classes_Root,P,F,len)<>Error_Success then
      F[0]:=#0;
  end else                { Extract from the object }
  begin
    ClearData:=OleGetData(O,cfObjectLink,T)=Ole_Warn_Delete_Data;
    P:=GlobalLock(T);
    StrLCat(F,P,MaxLen);
    GlobalUnlock(T);
    if ClearData then GlobalFree(T);
  end;
end;                      { TOleObj.GetObjClass }

destructor TOleObj.Done;
begin
  Renew(Nil,Nil,Nil,Nil,false,false,Nil,Nil);
  if Name<>Nil then StrDispose(Name);
  TObject.done;
end;                { TOleObj.Done }

  { Server collection }

constructor TServerObj.init(AObj: POleObj);
var
  P: PChar;
begin
  TObject.init;
  Class:=Nil; Server:=0;
  if (AObj<>Nil) and (AObj^.ok) then
  begin
    GetMem(P,256);
    AObj^.GetObjClass(P,255);
    Class:=StrNew(P);
    FreeMem(P,256);
    OleLockServer(AObj^.O,Server);
  end;
end;                       { TServerObj.init }

destructor TServerObj.Done;
begin
  if Server<>0  then OleUnlockServer(Server);
  if Class<>Nil then StrDispose(Class);
  TObject.Done;
end;

procedure TServerCollection.AddServer(Obj: POleObj);
var
  TempClass: PChar;

function matches(P: Pointer): boolean; far;
begin
  matches:=StrIComp(PServerObj(P)^.Class,TempClass)=0;
end;

begin
  if (Obj=Nil) or not Obj^.ok then Exit;
  GetMem(TempClass,256); Obj^.GetObjClass(TempClass,255);
  if FirstThat(@Matches)=Nil then
  begin
    FreeMem(TempClass,256);
    Insert(New(PServerObj,init(Obj)));
  end else FreeMem(TempClass,256);
end;                       { TServerCollection.AddServer }

function ParseObjectString(S: Pchar; Slen: word; var R: ObjInfoRec): word;
var
  nbr,k,icode: integer;
  pl: word;
  j: byte;
  i: word;
  tmp,tmp2: Pstring;
  pre: string[2];
  o_k,quote: boolean;

procedure PutStrg(P: PChar; var S: string);
begin
  ChrDelL(S,' '); ChrDelR(S,' ');
  if S<>'' then StrPCopy(P,S);
  S:='';
end;

procedure PutDimen(var S: string; var ans: ObjDimenRec);
var
  rtmp: real;
  i,j: integer;

function GetFact(Ind: integer): boolean;
var
  i: integer;
begin
  GetFact:=false;
  with Units[Ind] do
  begin
    i:=Pos(U,S);
    if i>0 then
    begin
      Delete(S,i,length(U)); ChrDel(S,' ');
      GetFact:=true;
    end;
  end;
end;    { GetFact }

begin   { PutDimen }
  if S='' then Exit;
  ans.U:=mmUnits;
  for i:=1 to NUnits do if GetFact(i) then
  begin
    if length(S)>15 then S[0]:=Chr(15);
    ans.U:=i; StrPCopy(ans.S,S);
    Val(S,rtmp,j);
    if j=0 then ans.num:=Units[i].f*rtmp;
  end;
end;              { PutDimen }

begin               { ParseObjectString }
  ParseObjectString:=0;
  New(tmp); New(tmp2);
  with R do
  begin
    Fname[0]:=#0; Class[0]:=#0; Part[0]:=#0; IcoName[0]:=#0;
    with Height do
    begin
      Num:=0; U:=mmUnits; S[0]:=#0;
    end;
    with Width do
    begin
      Num:=0; U:=mmUnits; S[0]:=#0;
    end;
    with Base do
    begin
      Num:=0; U:=mmUnits; S[0]:=#0;
    end;
    HAlign:=ObjAlign_Inline;
    BaseTop:=false; BaseMid:=false; BaseBottom:=false;
    FlipLR:=false; FlipUD:=false; Active:=false;
    DefW:=true; DefH:=true;

    pl:=0; i:=pl; nbr:=0;
    while (i<SLen) and (nbr>=0) do
    begin
      if S[i]=lbrace then inc(nbr) else if S[i]=rbrace then dec(nbr);
      if nbr>=0 then inc(i);
    end;
    if (nbr>0) or (i>254) then Exit;   { wrong syntax or too long }
    Move(S[0],tmp^[1],i); tmp^[0]:=Chr(i);

    j:=1;
    repeat    { read all flags }
      o_k:=false; tmp2^:='';
      while (j<=length(tmp^)) and (tmp^[j] in [' ',',']) do inc(j);
      k:=ChrPosX(tmp^,'=',j);
      if (j=1) and ((k=0) or (k>Pos(',',tmp^))) then tmp2^:='F'
      else begin
        tmp2^:=Copy(tmp^,j,k-j); j:=k+1;
      end;
      if (tmp2^<>'') then
      begin
        o_k:=true;
        pre:=Copy(tmp2^,1,2); StrUpr(pre);
        quote:=(tmp^[j]='"'); if quote then inc(j);
        k:=j;
        while (k<=length(tmp^)) and ((quote and (tmp^[k]<>'"'))
          or ((not quote) and (tmp^[k]<>','))) do inc(k);
        tmp2^:=Copy(tmp^,j,k-j); ChrDelL(tmp2^,' '); ChrDelR(tmp2^,' ');
        if pre='FL' then
        begin
          StrUpr(tmp2^);
          FlipLR:=Pos('H',tmp2^)>0; FlipUD:=Pos('V',tmp2^)>0;
        end else if pre='AC' then Active:=IsOn(tmp2^)
        else case pre[1] of
          'F': PutStrg(fname,tmp2^);
          'C': PutStrg(Class,tmp2^);
          'P': PutStrg(Part,tmp2^);
          'I': PutStrg(IcoName,tmp2^);
          'H': begin
                 PutDimen(tmp2^,Height); DefH:=false;
               end;
          'W': begin
                 PutDimen(tmp2^,Width); DefW:=false;
               end;
          'A': begin
                 StrLwr(tmp2^);
                 if      tmp2^[1]='l' then HAlign:=ObjAlign_Left
                 else if tmp2^[1]='r' then HAlign:=ObjAlign_right
                 else if tmp2^[1]='c' then HAlign:=ObjAlign_center
                 else begin
                   HAlign:=ObjAlign_Inline;
                   if      tmp2^[1]='t' then BaseTop:=true
                   else if tmp2^[1]='b' then BaseBottom:=true
                   else if tmp2^[1]='m' then BaseMid:=true
                   else PutDimen(tmp2^,Base);
                 end;
               end;
          else o_k:=false;
        end;
        inc(k); if k<length(tmp^) then j:=k else j:=0;
      end;
    until (j=0) or (j>=length(tmp^)) or (not o_k);
    if fname[0]<>#0 then ParseObjectString:=i+1;
  end;
  Dispose(tmp2); Dispose(tmp);
end;                 { ParseObjectString }

procedure PlayObject(W: PWindowsObject; FName,Class,Part: PChar);
var
  Name: array[0..15] of char;
  Client: POleClientExt;
  OStatus: TOleStatus;
  O: POleObject;
  H: HWnd;
begin
  H:=0; if W<>Nil then H:=W^.HWindow;
  if (fname=Nil)  or  (fname[0]=#0) then Exit;
  if (Class<>Nil) and (Class[0]=#0) then Class:=Nil;
  if (Part<>Nil)  and (part[0]=#0)  then Part:=Nil;
  O:=Nil;
  inc(ObjectCounter);
  StrPCopy(Name,OleObjPre+num2str(ObjectCounter));
  New(Client);
  Client^.lpvtbl:=@OleClientVTbl;
  Client^.H:=H;
  OStatus:=OleCreateLinkFromFile(OleProtocol,POleClient(Client),
               Class,FName,Part,
               ClientDoc, Name, O, OleRender_none, 0);
  if OleCheck(H,O,OStatus)=Ole_ok then
  begin
    OleSetHostNames(O,'BibDB',Name);
    OleCheck(H,O,OleActivate(O,0,true,true,0,Nil));
{    OleFree(O);}
    OleCheck(0,O,OleRelease(O));
  end;
  Dispose(Client);
end;            { PlayObject }

function FindOleExe(Fl,Class,Exe: PChar; ExeSize: word): boolean;
var
  P:  PChar;
  F: array[0..255] of char;
  len: longint;
  ClassKey,Protocol,StdFileEditing: HKey;
begin
  FindOleExe:=false;
  Exe[0]:=#0;
  if Class=Nil then
  begin
    P:=Fl+StrLen(Fl);
    while (P>Fl) and (P^<>'.') do dec(P);
    if P^<>'.' then Exit;
    len:=255;
    if RegQueryValue(hKey_Classes_Root,P,F,len)<>Error_Success then Exit;
    Class:=@F[0];
  end;
  if RegOpenKey(hKey_Classes_Root,Class,ClassKey)=Error_Success then
  begin
    if RegOpenKey(ClassKey,'Protocol',Protocol)=Error_Success then
    begin
      if RegOpenKey(Protocol,OleProtocol,StdFileEditing)=Error_Success then
      begin
        len:=255;
        if RegQueryValue(StdFileEditing,'server',F,len)=Error_Success then
          StrLCat(Exe,F,ExeSize);
        RegCloseKey(StdFileEditing);
      end;
      RegCloseKey(Protocol);
    end;
    RegCloseKey(ClassKey);
  end;
  if Exe[0]<>#0 then FindOleExe:=true;
{  if Exe[0]<>#0 then logstring('Found "'+StrPas(Exe)+'"');}
end;                       { FindOleExe }

function FindOleIcon(Fl,Class,Exe: PChar; ExeSize: word): integer;
var
  P,F: PChar;
  tmp: PString;
  len,i,j: longint;
  IconIndex,icode: word;
  ClassKey,Protocol,StdFileEditing: HKey;
begin
  FindOleIcon:=-1; IconIndex:=0;
  Exe[0]:=#0;
  New(tmp); F:=PChar(@tmp^[1]);
  if Class=Nil then
  begin
    P:=Fl+StrLen(Fl);
    while (P>Fl) and (P^<>'.') do dec(P);
    if P^<>'.' then Exit;
    len:=254;
    if RegQueryValue(hKey_Classes_Root,P,F,len)<>Error_Success then Exit;
    Class:=@F[0];
  end;
  if RegOpenKey(hKey_Classes_Root,Class,ClassKey)=Error_Success then
  begin
    len:=254;
    if RegQueryValue(ClassKey,'DefaultIcon',F,len)=Error_Success then
    begin
      tmp^[0]:=chr(StrLen(F));
      i:=Pos(',',tmp^);
      if i>0 then
      begin
        j:=i+1;
        while (j<=length(tmp^)) and (tmp^[j]=' ') do inc(j);
        Val(Copy(tmp^,j,255),IconIndex,Icode);
        if Icode<>0 then IconIndex:=1;
      end;
      tmp^[length(tmp^)+1]:=#0;
      StrLCat(Exe,F,ExeSize);
    end else if RegOpenKey(ClassKey,'Protocol',Protocol)=Error_Success then
    begin
      if RegOpenKey(Protocol,OleProtocol,StdFileEditing)=Error_Success then
      begin
        len:=254;
        if RegQueryValue(StdFileEditing,'server',F,len)=Error_Success then
          StrLCat(Exe,F,ExeSize);
        RegCloseKey(StdFileEditing);
      end;
      RegCloseKey(Protocol);
    end;
    RegCloseKey(ClassKey);
  end;
  Dispose(tmp);
  if (Exe[0]<>#0) then FindOleIcon:=IconIndex;
{  message(StrPas(EXE)+', Ind = '+num2str(IconIndex));}
{  if Exe[0]<>#0 then logstring('Found "'+StrPas(Exe)+'"');}
end;                       { FindOleIcon }

{ Exit procedure }

var
  OldExitProc: Pointer;

procedure OleExitProc; far;
begin
  ExitProc:=OldExitProc;
  GlobalFree(ImageIconDIB);
  Dispose(OleServers,Done);
  if ClientDoc<>0 then OleRevokeClientDoc(ClientDoc);
  FreeProcInstance(@OleClientVTbl.Callback);
  FreeProcInstance(@OleStreamVTbl.Get);
  FreeProcInstance(@OleStreamVTbl.Put);
end;

procedure InitOle;
var
  Icon: HIcon;
  BitWidth,BitHeight: longint;
begin
  @OleClientVTbl.Callback := MakeProcInstance(@ClientCallback,HInstance);
  @OleStreamVTbl.Get      := MakeProcInstance(@OleStreamGet,  HInstance);
  @OleStreamVTbl.Put      := MakeProcInstance(@OleStreamPut,  HInstance);
  CFObjectLink := RegisterClipboardFormat('ObjectLink');
  CFOwnerLink  := RegisterClipboardFormat('OwnerLink');
  CFNative     := RegisterClipboardFormat('Native');
  ClientDoc:=0;
  ObjectCounter:=0;
  OleVerbatim:=false; CompressObjects:=false; CompressImages:=false;
  New(OleServers,init(10,10)); LockOleServers:=false;

  Icon:=LoadIcon(HInstance,PChar(rc_HouseIcon));
  ImageIconDIB:=IconToDIB(Icon,BitWidth,BitHeight);
  ImageIconWidth :=(Units[InUnits].F*BitWidth /ScreenResX);
  ImageIconHeight:=(Units[InUnits].F*BitHeight/ScreenResY);
  DestroyIcon(Icon);
end;                { InitOle }

begin
  InitOle;
  OldExitProc:=ExitProc; ExitProc:=@OleExitProc;
 end.
