// Copyright (c) 1991 by Parag Patel.  All Rights Reserved.
static const char rcsid[] = "$Header: global.C,v 1.24 91/02/22 15:56:57 hmgr Exp $";

// Global variables for DVI filter.
// All globally visible variables are here.
//
// by Parag Patel

#include "defs.h"
#include "hp2686.h"
#include "hp33440.h"
#include "hp2684.h"


// implement macros for the declare in "extern.h"
implement_array(Fontlist, fontptr);
implement_array(Pageinfo, pageinfo);
implement_array(Pagespec, pagespec);


// command-line argument values:
char *fontpath = NULL;			// default font library path
char *dviinput = NULL;			// default special file search path
int debuglevel = 0;			// this is only for debugging
boolean verbose = FALSE;		// this is just for the hell of it
boolean dochecksum = TRUE;		// actually check the checksums?
char *devname = NULL;			// default device
boolean reverse = TRUE;			// reverse pages?
boolean landscape = FALSE;		// landscape mode
boolean duplexh = FALSE;		// double-sided printing (duplex) mode
boolean duplexv = FALSE;		// - horizontal and vertical binding
boolean duparg  = FALSE;		// got a duplex option on command-line?
long usermag = 0;			// user-specified mag value

Device *device = NULL;			// particular device for output
font *currfont = NULL;			// current font being used
Fontlist fontlist;			// list of all fonts for this file
Bitvec **fontbits = NULL;		// draw fonts into this space
double H, V, W, X, Y, Z;		// DVI stack vars


void init_globals()
{
    // convert the device name to lower-case for comparing
    for (char *s = devname; s != NULL && *s != '\0'; s++)
	if (isupper(*s))
	    *s = tolower(*s);

    // default is LaserJetII
    if (devname == NULL || *devname == '\0' || streq("default", devname))
	devname = "hp33440";

    // heuristics for figuring out Devices from device names
    if (streq("hp2684", devname)
	    || streq("laser2000", devname)
	    || streq("lj2000", devname)
	    || streq("jumbojet", devname)
	    || streq("lj2k", devname))
    {
	reverse = !reverse;
	if (!duparg && !duplexv && !duplexh)
	    duplexv = TRUE;
	device = new HP2684;
	mesg("HP LaserJet 2000 (HP2684)");
    }
    else if (streq("hp33447", devname)
		|| streq("laserjetiid", devname)
		|| streq("laserjet2d", devname)
		|| streq("laseriid", devname)
		|| streq("laser2d", devname)
		|| streq("ljiid", devname)
		|| streq("lj2d", devname))
    {
	reverse = !reverse;
	if (!duparg && !duplexv && !duplexh)
	    duplexv = TRUE;
	device = new HP33447;
	mesg("HP LaserJet IID (HP33447)");
    }
    else if (streq("hp33440", devname)
		|| streq("laserjetii", devname)
		|| streq("laserjet2", devname)
		|| streq("laserii", devname)
		|| streq("laser2", devname)
		|| streq("ljii", devname)
		|| streq("lj2", devname))
    {
	reverse = !reverse;
	device = new HP33440;
	mesg("HP LaserJet II (HP33440)");
	if (duparg && (duplexv || duplexh))
	    warn("Cannot do double-sided for HP33440");
    }
    else if (streq("hp2686", devname)
		|| streq("laserjet+", devname)
		|| streq("laserjet", devname)
		|| streq("laser", devname)
		|| streq("ljet", devname)
		|| streq("lj+", devname)
		|| streq("lj", devname))
    {
	device = new HP2686;
	mesg("HP LaserJet+ (HP2686)");
	if (duparg && (duplexv || duplexh))
	    warn("Cannot do double-sided for HP2686");
    }

    if (duplexh && duplexv)
	quit("Must choose only ONE type of double-sided binding");

    if (device == NULL)
    {
	if (!streq("help", devname) && !streq("?", devname))
	    error("Sorry - don't know device ``%s''", devname);
	error("Currently supported devices are: HP2686 HP33440 HP33447 HP2684");
	quit("No point in continuing, eh?");
    }

    char *str;
    if (fontpath == NULL)
    {
	str = getenv("FONTPATH");
	if (str != NULL && *str != '\0')
	    fontpath = str;
    }
    if (fontpath == NULL)
	fontpath = DEFFONTPATH;

    if (dviinput == NULL)
    {
	str = getenv("DVIINPUT");
	if (str != NULL && *str != '\0')
	    dviinput = str;
    }

    debug(3, "MAXFONTS=%d  MAXCHARS=%d  MAXONPAGE=%d  MAXLOADED=%d",
	    MAXFONTS, MAXCHARS, MAXONPAGE, MAXLOADED);
}

void fini_globals()
{
    delete device;
}
