(* 12/18/1991 Dan Dill dan@chem.bu.edu *)

(* This version assumes the Mathematica prolog file will be avilable in the
   printer.  The current prolog is mma.pro-2.0 and is specific to version 2.0
   of Mathematica.  It has changed from version 1.2.  PSTeXpro.m is a version
   of PSTeX that includes the prolog in the file, using psfix, and so should
   work unchanged in version 2.0 and 1.2 *)

Unprotect[System`PSTeX]

System`PSTeX::usage = "PSTeX[-graphics-, \"file\"].  Process a graphics object
to a PostScript file for inclusion in a TeX document (using \\psfig).  Quotes
are required around the file name and suffix `.ps' is added.  The graphic
object is scaled and shifted so that it can be included in the TeX document
directly (for example, with \\psfig{figure=file.ps}).  The height of the
scaled graphic is PSTeXHeight (default 100) in big points (72 bp per inch).
For example,
\n
\n
\t PSTeX[myplot, \"p4/myplot\"]
\n
\n
  will convert the graphics object myplot to the PostScript file myplot.ps in
the subdirectory p4 of the current directory.  If PSTeXCompress is True (the
default is False), then the graphics object is converted to the compressed
PostScript file myplot.ps.Z; in either case, the PostScript bounding box
information is duplicated in the file myplot.ps.bb.

\n
\n
  Notes: The Mathematica PostScript prolog is *not* included in the file and
the prolog must be downloaded before the file can be printed.  PSTeX yields a
graphic with PSTeXHeight and without centering or margins, and so is not
generally suitable for printing.  Use PSFile to produce a graphic in a file,
centered and scaled to fill the whole page."

If[ !ValueQ[PSTeXHeight], PSTeXHeight = 100 ];

If[ !ValueQ[PSTeXCompress], PSTeXCompress = False ];

System`PSTeX::file = "Graphics being processed (without prolog) to file \"`1`\".";

Begin["System`Private`"]
PSTeX[g_, f_String] := Block[{filename},
    filename = StringJoin[f, ".ps"];
    Message[PSTeX::file,
	If[ PSTeXCompress,
	    StringJoin[filename, ".Z"],
	    filename
	]
    ];
    Display[StringJoin[
	"! ",
	"addBBox",
	" ",
	filename,
	" ",
	ToString[PSTeXHeight],
	" ",
	If[ PSTeXCompress, "compress", "nocompress"]
	], g]
]
End[]

Protect[PSTeX]
