#include <sys/stat.h>
#include <mbstring.h>
#include <kpathsea/kpathsea.h>
#include <win32dll/win32lib.h>
/* File search */

#pragma optimize("g", off)

#define DEFAULT_WRAPPER_DLL "texdllse.dll"
#define SEARCH_WINDOW_CLASS_NAME_PREFIX "6048A3E0-A282-11d0-BAA0-FE0C77D16A5C"

static HANDLE hSearchDLL = NULL;

int *p_win32_make_tex_discard_errors;
unsigned int *p_win32_kpathsea_debug;

const char* win32_kpathsea_version_string = "Unknown";
const char* win32_kpathsea_bug_address  = "Unknown";
const char** p_win32_fallback_resolutions_string;
kpse_format_info_type* win32_format_info;

char *win32_program_short_name = NULL;
char *win32_program_name;

static LPVOID (WINAPI *g_init)(VOID);
static BOOL (WINAPI *g_set_progname)(LPVOID, LPCSTR );
static BOOL (WINAPI *g_init_prog)(LPVOID, LPCSTR pfx, ULONG dpi,
				  LPCSTR mode, LPCSTR fb);
static LPSTR (WINAPI *g_find_file)(LPVOID, LPCSTR, DWORD, BOOL);
static LPSTR (WINAPI *g_var_value)(LPVOID, LPCSTR);
static LPSTR (WINAPI *g_var_expand)(LPVOID, LPCSTR);
static LPSTR (WINAPI *g_path_expand)(LPVOID, LPCSTR);
static VOID (WINAPI *g_free_mem)(LPVOID, LPVOID );
static BOOL (WINAPI *g_set_enabled)(LPVOID, DWORD, BOOL, DWORD);
static LPSTR (WINAPI *g_path_search)(LPVOID, LPCSTR, LPCSTR, BOOL);
static BOOL (WINAPI *g_set_callback)(LPVOID, Win32Context* );
static BOOL (WINAPI *g_uninit)(LPVOID);
static BOOL (WINAPI *g_set_current_dir)(LPVOID, LPCSTR );

// for dvips
static LPSTR (WINAPI *g_find_glyph)(LPVOID,
				    LPCTSTR font_name, UINT dpi, 
				    kpse_file_format_type format,
				    kpse_glyph_file_type *glyph_file);
static BOOL (WINAPI *g_tex_hush)(LPVOID, LPCSTR );
static UINT (WINAPI *g_magstep_fix)(LPVOID, UINT, UINT, LPINT);
static BOOL (WINAPI *g_bitmap_tolerance)(LPVOID, double, double);

static char searchWndClass[100];
static HWND hSearchWnd = NULL;
static HANDLE hSearchThread = NULL;
static DWORD idSearchThread = 0;
static HANDLE hSearchInitEvent = NULL;

#define WM_KPSE_SET_PROGNAME (WM_USER + 100)
#define WM_KPSE_INIT_PROG    (WM_USER + 101)
#define WM_KPSE_FIND_FILE    (WM_USER + 102)
#define WM_KPSE_VAR_VALUE    (WM_USER + 103)
#define WM_KPSE_VAR_EXPAND   (WM_USER + 104)
#define WM_KPSE_SET_ENABLED  (WM_USER + 105)
#define WM_KPSE_PATH_SEARCH  (WM_USER + 106)
#define WM_KPSE_UNINIT       (WM_USER + 107)
#define WM_KPSE_SET_CURDIR   (WM_USER + 108)
#define WM_KPSE_INIT         (WM_USER + 109)
#define WM_KPSE_FIND_GLYPH   (WM_USER + 110)
#define WM_KPSE_TEX_HUSH     (WM_USER + 111)
#define WM_KPSE_MAGSTEP_FIX  (WM_USER + 112)
#define WM_KPSE_BITMAP_TOLERANCE (WM_USER + 113)
#define WM_KPSE_PATH_EXPAND  (WM_USER + 114)

#define WM_KPSE_INITIALIZE   (WM_USER + 201)
#define WM_KPSE_TERMINATE    (WM_USER + 200)

static LPSTR return_string_value(LPVOID pc, LPSTR p)
{
  if (p) {
    LPSTR q = win32_strdup(p);
    (*g_free_mem)(pc, p);
    return q;
  }
  return NULL;
}

static LRESULT CALLBACK SearchWndProc(HWND hWnd, UINT uMsg,
				      WPARAM wParam, LPARAM lParam)
{
  DWORD* args = (DWORD*)lParam;
  
  switch (uMsg) {
  case WM_KPSE_INITIALIZE:
    {
      Win32Context* pContext = (Win32Context*)lParam;
      LPVOID pInfo;
      pInfo = pContext->lpvKpseInfo = (*g_init)();
      if (!pInfo) {
	puts("aaa");
	return 0;
      }
      
      {
	BOOL* (WINAPI *get)(LPVOID);
	(FARPROC)get =
	  GetProcAddress(hSearchDLL, "KpseGetMakeTeXDiscardErrors");
	p_win32_make_tex_discard_errors = get ? (*get)(pInfo) : NULL;
      }
      {
	UINT* (WINAPI *get)(LPVOID);
	(FARPROC)get = GetProcAddress(hSearchDLL, "KpseGetDebug");
	p_win32_kpathsea_debug = get ? (*get)(pInfo) : NULL;
      }
      {
	LPCSTR (WINAPI *get)(LPVOID);
	(FARPROC)get =
	  GetProcAddress(hSearchDLL, "KpseGetFallbackResolutionsString");
	p_win32_fallback_resolutions_string = get ? (*get)(pInfo) : NULL;
      }
      {
	kpse_format_info_type* (WINAPI *get)(LPVOID);
	(FARPROC)get =
	  GetProcAddress(hSearchDLL, "KpseGetFormatInfo");
	win32_format_info = get ? (*get)(pInfo) : NULL;
      }
      {
	LPCSTR (WINAPI *get_str)(LPVOID);
	(FARPROC)get_str = GetProcAddress(hSearchDLL, "KpseGetVersionString");
	win32_kpathsea_version_string =
	  get_str ? (*get_str)(pInfo) : "Unknown";
	(FARPROC)get_str = GetProcAddress(hSearchDLL, "KpseGetBugAddress");
	win32_kpathsea_bug_address = get_str ? (*get_str)(pInfo) : "Unknown";
      }
      
      return 1;
    }
  case WM_KPSE_SET_PROGNAME:
    {
      LPCSTR name = (LPCSTR)args[0];
      char *s;
      s = win32_program_short_name = win32_strdup(win32_basename(name));
      s = _mbsrchr(s, '.');
      if (s) *s = '\0';
      win32_program_name = win32_strdup(name);
      (*g_set_progname)((LPVOID)wParam, name);
      if (g_set_callback) (*g_set_callback)(win32_dll_context->lpvKpseInfo,
					    win32_dll_context);
      return 0;
    }
  case WM_KPSE_INIT_PROG:
    (*g_init_prog)((LPVOID)wParam, 
		   (LPCSTR)args[0], (ULONG)args[1],
		   (LPCSTR)args[2], (LPCSTR)args[3]);
    return 0;
  case WM_KPSE_FIND_FILE:
    {
      LPSTR p =
	return_string_value((LPVOID)wParam,
			    (*g_find_file)((LPVOID)wParam,
					   (LPCSTR)args[0], (DWORD)args[1],
					   (BOOL)args[2]));
      if (p) win32_unix2dos(p);
      return (LRESULT)p;
    }
  case WM_KPSE_VAR_VALUE:
    return (LRESULT)return_string_value((LPVOID)wParam,
					(*g_var_value)((LPVOID)wParam,
						       (LPCSTR)args[0]));
  case WM_KPSE_VAR_EXPAND:
    return (LRESULT)return_string_value((LPVOID)wParam,
					(*g_var_expand)((LPVOID)wParam,
							(LPCSTR)args[0]));
  case WM_KPSE_PATH_EXPAND:
    return (LRESULT)return_string_value((LPVOID)wParam,
					(*g_path_expand)((LPVOID)wParam,
							 (LPCSTR)args[0]));
  case WM_KPSE_SET_ENABLED:
    (*g_set_enabled)((LPVOID)wParam,
		     (DWORD)args[0], (BOOL)args[1], (DWORD)args[2]);
    return 0;
  case WM_KPSE_PATH_SEARCH:
    {
      LPSTR p = return_string_value((LPVOID)wParam,
				    (*g_path_search)((LPVOID)wParam,
						     (LPCSTR)args[0],
						     (LPCSTR)args[1],
						     (BOOL)args[2]));
      if (p) win32_unix2dos(p);
      return (LRESULT)p;
    }
  case WM_KPSE_SET_CURDIR:
    return (*g_set_current_dir)((LPVOID)wParam,
				(LPCSTR)args[0]);
  case WM_KPSE_UNINIT:
    return (*g_uninit)((LPVOID)wParam);
  case WM_KPSE_FIND_GLYPH:
    {
      LPSTR p =
	return_string_value((LPVOID)wParam,
			    (*g_find_glyph)((LPVOID)wParam,
					    (LPCSTR)args[0],
					    (UINT)args[1],
					    (kpse_file_format_type)args[2],
					    (kpse_glyph_file_type*)args[3]));
      if (p) win32_unix2dos(p);
      return (LRESULT)p;
    }
  case WM_KPSE_TEX_HUSH:
    return (*g_tex_hush)((LPVOID)wParam, (LPCSTR)args[0]);
  case WM_KPSE_MAGSTEP_FIX:
    return (*g_magstep_fix)((LPVOID)wParam,
			    (UINT)args[0], (UINT)args[1], (LPINT)(args+2));
  case WM_KPSE_BITMAP_TOLERANCE:
    return (*g_bitmap_tolerance)((LPVOID)wParam,
				 *(double*)args[0], *(double*)args[1]);
  default:
    return DefWindowProc(hWnd, uMsg, wParam, lParam);
  }
}

static LPSTR fix_filename(LPSTR name)
{
  LPCSTR p = win32_unix2dos(name);
  LPCSTR q = name;
  LPSTR r = name;
  while (p = _mbschr(p, '\\')) {
    while (q < p) *r++ = *q++;
    *r++ = '\\';
    while (*p == '\\') p++;
    q = p;
  }
  while (*q) *r++ = *q++;
  *r = 0;
#if 0
  r = win32_find_suffix(name);
  if (r) _mbslwr(r);
#endif
  if (win32_dll_context->bShortFileName) {
    char buf[1000];
    GetShortPathName(name, buf, 1000);
    r = win32_strdup(buf);
    win32_free(name);
    name = r;
  }
  return name;
}

void win32_set_progname(LPCSTR name)
{
  DWORD *args = win32_malloc(sizeof(DWORD) * 1);
  args[0] = (DWORD)win32_strdup(name);
  SendMessage(hSearchWnd, WM_KPSE_SET_PROGNAME,
	      (WPARAM)win32_dll_context->lpvKpseInfo, (LPARAM)args);
  win32_free((LPSTR)args[0]);
  {
    LPSTR pCurDir = NULL;
    if (win32_dll_context->lpszWorkDir)
      args[0] = (DWORD)win32_dll_context->lpszWorkDir;
    else {
      char buf[1000];
      GetCurrentDirectory(1000, buf);
      args[0] = (DWORD)(pCurDir = win32_strdup(buf));
    }
    SendMessage(hSearchWnd, WM_KPSE_SET_CURDIR,
		(WPARAM)win32_dll_context->lpvKpseInfo, (LPARAM)args);
    if (pCurDir) win32_free(pCurDir);
  }
  win32_free(args);
}

void win32_init_prog(LPCSTR pfx, ULONG dpi, LPCSTR mode, LPCSTR fb)
{
  DWORD *args = win32_malloc(sizeof(DWORD) * 4);
  LPSTR code;
  args[0] = (DWORD)(pfx ? win32_strdup(pfx) : NULL);
  args[1] = (DWORD)dpi;
  args[2] = (DWORD)(mode ? win32_strdup(mode) : NULL);
  args[3] = (DWORD)(fb ? win32_strdup(fb) : NULL);
  SendMessage(hSearchWnd, WM_KPSE_INIT_PROG,
	      (WPARAM)win32_dll_context->lpvKpseInfo, (LPARAM)args);
  if (args[0]) win32_free((LPSTR)args[0]);
  if (args[2]) win32_free((LPSTR)args[2]);
  if (args[3]) win32_free((LPSTR)args[3]);
  win32_free(args);
}

LPSTR win32_find_file(LPCSTR name, DWORD fmt, BOOL must_exist)
{
  DWORD *args = win32_malloc(sizeof(DWORD) * 3);
  LPSTR code;
  args[0] = (DWORD)win32_strdup(name);
  args[1] = (DWORD)fmt;
  args[2] = (DWORD)must_exist;
  code =
    (LPSTR)SendMessage(hSearchWnd, WM_KPSE_FIND_FILE,
		       (WPARAM)win32_dll_context->lpvKpseInfo, (LPARAM)args);
  win32_free((LPSTR)args[0]);
  win32_free(args);
  if (code) code = fix_filename(code);
  return code;
}

LPSTR win32_var_value(LPCSTR name)
{
  DWORD *args = win32_malloc(sizeof(DWORD) * 1);
  LPSTR code;
  if (!win32_program_name) return NULL;
  args[0] = (DWORD)win32_strdup(name);
  code =
    (LPSTR)SendMessage(hSearchWnd, WM_KPSE_VAR_VALUE,
		       (WPARAM)win32_dll_context->lpvKpseInfo, (LPARAM)args);
  win32_free((LPSTR)args[0]);
  win32_free(args);
  return code;
}

LPSTR win32_var_expand(LPCSTR name)
{
  DWORD *args = win32_malloc(sizeof(DWORD) * 1);
  LPSTR code;
  args[0] = (DWORD)win32_strdup(name);
  code =
    (LPSTR)SendMessage(hSearchWnd, WM_KPSE_VAR_EXPAND,
		       (WPARAM)win32_dll_context->lpvKpseInfo, (LPARAM)args);
  win32_free((LPSTR)args[0]);
  win32_free(args);
  return code;
}

LPSTR win32_path_expand(LPCSTR name)
{
  DWORD *args = win32_malloc(sizeof(DWORD) * 1);
  LPSTR code;
  args[0] = (DWORD)win32_strdup(name);
  code =
    (LPSTR)SendMessage(hSearchWnd, WM_KPSE_PATH_EXPAND,
		       (WPARAM)win32_dll_context->lpvKpseInfo, (LPARAM)args);
  win32_free((LPSTR)args[0]);
  win32_free(args);
  return code;
}

VOID win32_set_program_enabled(DWORD fmt, BOOL bydef, DWORD srctype)
{
  DWORD *args = win32_malloc(sizeof(DWORD) * 3);
  args[0] = (DWORD)fmt;
  args[1] = (DWORD)bydef;
  args[2] = (DWORD)srctype;
  SendMessage(hSearchWnd, WM_KPSE_SET_ENABLED,
	      (WPARAM)win32_dll_context->lpvKpseInfo, (LPARAM)args);
  win32_free(args);
}

LPSTR win32_path_search(LPCSTR path, LPCSTR name, BOOL must_exist)
{
  DWORD *args = win32_malloc(sizeof(DWORD) * 3);
  LPSTR code;
  args[0] = (DWORD)win32_strdup(path);
  args[1] = (DWORD)win32_strdup(name);
  args[2] = (DWORD)must_exist;
  code =
    (LPSTR)SendMessage(hSearchWnd, WM_KPSE_PATH_SEARCH,
		       (WPARAM)win32_dll_context->lpvKpseInfo, (LPARAM)args);
  win32_free((LPSTR)args[0]);
  win32_free((LPSTR)args[1]);
  win32_free(args);
  if (code) code = fix_filename(code);
  return code;
}

LPSTR win32_find_glyph(LPTSTR font_name,
		      UINT dpi, 
		      int format,
		      LPVOID glyph_file)
{
  LPSTR code;
  DWORD *args = win32_malloc(sizeof(DWORD)*4);
  args[0] = (DWORD)win32_strdup(font_name);
  args[1] = dpi;
  args[2] = format;
  args[3] = (DWORD)win32_malloc(sizeof(kpse_glyph_file_type));
  memcpy((LPVOID)args[3], glyph_file, sizeof(kpse_glyph_file_type));
  code = (LPSTR)SendMessage(hSearchWnd, WM_KPSE_FIND_GLYPH,
		       (WPARAM)win32_dll_context->lpvKpseInfo, (LPARAM)args);
  memcpy(glyph_file, (LPVOID)args[3], sizeof(kpse_glyph_file_type));
  if ((LPSTR)args[0] == ((kpse_glyph_file_type*)glyph_file)->name)
    ((kpse_glyph_file_type*)glyph_file)->name = font_name;
  win32_free((LPSTR)args[0]);
  win32_free((kpse_glyph_file_type*)args[3]);
  win32_free(args);
  if (code) code = fix_filename(code);
  return code;
}

BOOL win32_tex_hush(LPCSTR what)
{
  BOOL code;
  DWORD *args = win32_malloc(sizeof(DWORD));
  args[0] = (DWORD)win32_strdup(what);
  code = SendMessage(hSearchWnd, WM_KPSE_TEX_HUSH,
		     (WPARAM)win32_dll_context->lpvKpseInfo,
		     (LPARAM)args);
  win32_free((LPSTR)args[0]);
  win32_free(args);
  return code;
}

UINT win32_magstep_fix(UINT dpi, UINT bdpi, LPINT pret)
{
  UINT code;
  DWORD *args = win32_malloc(sizeof(DWORD)*3);
  args[0] = dpi;
  args[1] = bdpi;
  code = SendMessage(hSearchWnd, WM_KPSE_MAGSTEP_FIX,
		     (WPARAM)win32_dll_context->lpvKpseInfo,
		     (LPARAM)args);
  if (pret) *pret = args[2];
  win32_free(args);
  return code;
}

BOOL win32_bitmap_tolerance(double dpi1, double dpi2)
{
  BOOL code;
  DWORD *args = win32_malloc(sizeof(DWORD)*2);
  args[0] = (DWORD)win32_malloc(sizeof(double));
  args[1] = (DWORD)win32_malloc(sizeof(double));
  *(double*)args[0] = dpi1;
  *(double*)args[1] = dpi2;
  code = SendMessage(hSearchWnd, WM_KPSE_MAGSTEP_FIX,
		     (WPARAM)win32_dll_context->lpvKpseInfo,
		     (LPARAM)args);
  win32_free((double*)args[0]);
  win32_free((double*)args[1]);
  win32_free(args);
  return code;
}

void win32_uninit_prog(void)
{
  SendMessage(hSearchWnd, WM_KPSE_UNINIT,
	      (WPARAM)win32_dll_context->lpvKpseInfo, 0);
}

BOOL win32_readable_file(LPCSTR name)
{
  struct stat st;
  return
    access (name, 4) == 0 &&
      stat (name, &(st)) == 0 && !(st.st_mode & _S_IFDIR);
}

FILE *
win32_open_file(const char* name,  DWORD type)
{
  LPSTR fullname = win32_find_file (name, type, TRUE);
  LPCSTR mode;
  FILE *f;

  if (fullname == NULL) {
    win32_console_printf("File `%s' not found.\n", name);
    win32_exit(1);
  }

  switch (type) {
  case kpse_gf_format:
  case kpse_pk_format:
  case kpse_any_glyph_format:
  case kpse_base_format:
  case kpse_fmt_format:
  case kpse_mem_format:
  case kpse_mfpool_format:
  case kpse_mppool_format:
  case kpse_ocp_format:
  case kpse_ofm_format:
  case kpse_ovf_format:
  case kpse_pict_format:
  case kpse_texpool_format:
  case kpse_tfm_format:
  case kpse_type1_format:
  case kpse_vf_format:
    mode = "rb";
    break;
  default:
    mode = "r";
    break;
  }

  win32_unix2dos(fullname);
  f = win32_fopen (fullname, mode);
  if (!f) {
    win32_perror(fullname);
    win32_exit(1);
  }

  win32_free(fullname);
  
  return f;
}

VOID win32_return_short_filename(BOOL bYes)
{
  win32_dll_context->bShortFileName = bYes;
}

static BOOL win32_load_search_library(LPCSTR name)
{
  HANDLE hDLL;
  
  hDLL = win32_load_tex_library(name);
  if (!hDLL) return FALSE;
  
  (FARPROC)g_init = GetProcAddress(hDLL, "KpseInitialize");
  (FARPROC)g_set_progname = GetProcAddress(hDLL, "KpseSetProgName");
  (FARPROC)g_init_prog = GetProcAddress(hDLL, "KpseInitProg");
  (FARPROC)g_find_file = GetProcAddress(hDLL, "KpseFindFile");
  (FARPROC)g_path_search = GetProcAddress(hDLL, "KpsePathSearch");
  (FARPROC)g_var_value = GetProcAddress(hDLL, "KpseVarValue");
  (FARPROC)g_var_expand = GetProcAddress(hDLL, "KpseVarExpand");
  (FARPROC)g_path_expand = GetProcAddress(hDLL, "KpsePathExpand");
  (FARPROC)g_set_enabled = GetProcAddress(hDLL, "KpseSetProgramEnabled");
  (FARPROC)g_set_callback = GetProcAddress(hDLL, "KpseSetCallback");
  (FARPROC)g_find_glyph = GetProcAddress(hDLL, "KpseFindGlyph");;
  (FARPROC)g_tex_hush = GetProcAddress(hDLL, "KpseTeXHush");;
  (FARPROC)g_bitmap_tolerance = GetProcAddress(hDLL, "KpseBitmapTolerance");;
  (FARPROC)g_magstep_fix = GetProcAddress(hDLL, "KpseMagstepFix");;
  (FARPROC)g_free_mem = GetProcAddress(hDLL, "KpseFree");
  (FARPROC)g_uninit = GetProcAddress(hDLL, "KpseUninitialize");
  (FARPROC)g_set_current_dir = GetProcAddress(hDLL, "KpseSetCurrentDirectory");
  
  if (!g_init ||
      !g_set_progname ||
      !g_init_prog ||
      !g_find_file ||
      !g_var_value ||
      !g_var_expand ||
      !g_path_expand ||
      !g_set_enabled ||
      !g_path_search ||
      !g_uninit ||
      !g_set_current_dir ||
      !g_find_glyph ||
      !g_tex_hush ||
      !g_bitmap_tolerance ||
      !g_magstep_fix ||
      !g_free_mem) {
    FreeLibrary(hDLL);
    return FALSE;
  }
  
  hSearchDLL = hDLL;
  
  return TRUE;
}

static BOOL win32_register_search_window_class()
{
  BOOL code;
  WNDCLASS wc;

  sprintf(searchWndClass, "TeXDLL." SEARCH_WINDOW_CLASS_NAME_PREFIX
                          ".%08lx%08lx%08lx",
	  (ULONG)GetCurrentTime(),
	  (ULONG)GetCurrentThreadId(),
	  (ULONG)win32_get_module_handle());
  
  wc.style = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc = SearchWndProc;
  wc.cbClsExtra = 0;
  wc.cbWndExtra = 0;
  wc.hInstance = GetModuleHandle(NULL);
  wc.hIcon = NULL;
  wc.hCursor = NULL;
  wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
  wc.lpszMenuName = searchWndClass;
  wc.lpszClassName = searchWndClass;
  
  code = (RegisterClass(&wc) != 0);
  if (!code) searchWndClass[0] = '\0';
  return code;
}

static BOOL win32_create_search_window()
{
  if (searchWndClass[0] == 0) {
    if (!win32_register_search_window_class())
      return FALSE;
  }
  hSearchWnd = CreateWindow(searchWndClass, "Unknown",
			    WS_POPUP,
			    CW_USEDEFAULT, 0,
			    CW_USEDEFAULT, 0,
			    NULL,
			    NULL,
			    GetModuleHandle(NULL),
			    NULL);
  return hSearchWnd != NULL;
}

static UINT CALLBACK SearchThreadFunc(LPVOID p)
{
  BOOL code;
  MSG msg;
  code = win32_create_search_window();

  SetEvent(hSearchInitEvent);

  if (!code) return 0;
  
  while (GetMessage(&msg, NULL, 0, 0)) {
    if (msg.message == WM_KPSE_TERMINATE)
      break;
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  DestroyWindow(hSearchWnd);
  hSearchWnd = NULL;
  _endthreadex(0);
  return 0;
}

static BOOL win32_create_search_thread()
{
  hSearchInitEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
  if (!hSearchInitEvent) return FALSE;
  hSearchThread = (HANDLE)_beginthreadex(NULL, 0, SearchThreadFunc, NULL,
					 0, &idSearchThread);
  if (!hSearchThread) {
    CloseHandle(hSearchInitEvent);
    return FALSE;
  }
  
  WaitForSingleObject(hSearchInitEvent, INFINITE);
  return TRUE;
}

static BOOL win32_destroy_search_thread()
{
  if (hSearchThread) {
    PostThreadMessage(idSearchThread,
		      WM_KPSE_TERMINATE,
		      WM_KPSE_TERMINATE,
		      WM_KPSE_TERMINATE);
    WaitForSingleObject(hSearchThread, INFINITE);
    CloseHandle(hSearchInitEvent);
    CloseHandle(hSearchThread);
    hSearchThread = NULL;
  }
}

static BOOL win32_unload_search_library()
{
  if (hSearchDLL) {
    FreeLibrary(hSearchDLL);
    hSearchDLL = NULL;
  }
  return TRUE;
}

BOOL win32_init_search(void)
{
  win32_program_short_name = NULL;
  win32_program_name = NULL;
  hSearchThread = NULL;
  
  if (!win32_load_search_library(DEFAULT_WRAPPER_DLL))
    return FALSE;

  if (!win32_create_search_thread()) {
    win32_unload_search_library();
    return FALSE;
  }

  if (!SendMessage(hSearchWnd, WM_KPSE_INITIALIZE, 0,
		   (LPARAM)win32_dll_context)) {
    win32_uninit_prog();
    win32_destroy_search_thread();
    win32_unload_search_library();
    return FALSE;
  }
  if (g_set_callback) (*g_set_callback)(win32_dll_context->lpvKpseInfo,
					win32_dll_context);
  
  *p_win32_kpathsea_debug = 0;
  win32_dll_context->bShortFileName = FALSE;
  
  return TRUE;
}

BOOL win32_uninit_search(void)
{
  if (g_set_callback) (*g_set_callback)(win32_dll_context->lpvKpseInfo, NULL);
  win32_uninit_prog();
  if (hSearchThread) win32_destroy_search_thread();
  return win32_unload_search_library();
}
