#include <stdio.h>
#include <setjmp.h>
#include <win32dll/win32lib.h>


/* system */

jmp_buf win32_exit_jmp;

BOOL win32_call_editor(LPCSTR fn, DWORD ln)
{
  BOOL code;
  LPSTR path = win32_make_fullpath(fn);
  code = (*win32_dll_context->lpfCallback)(TeXDLL_INVOKE_EDITOR,
					   (DWORD)path, ln,
					   win32_dll_context->lpvCallbackData)
    ? TRUE : FALSE;
  win32_free(path);
  return code;
}

void win32_true_exit(int code)
{
  exit(code);
}

void win32_exit(int c)
{
  if (win32_dll_context) {
    win32_fclose_all();
    if (c >= 0) c++;
    longjmp(win32_exit_jmp, c);
  }
  else {
    win32_true_exit(c);
  }
}

void win32_notify_page_begin(int n)
{
  (*win32_dll_context->lpfCallback)(TeXDLL_NOTIFY_PAGE_BEGIN, n, 0,
				    win32_dll_context->lpvCallbackData);
}

void win32_notify_page_end(int n)
{
  (*win32_dll_context->lpfCallback)(TeXDLL_NOTIFY_PAGE_END, n, 0,
				    win32_dll_context->lpvCallbackData);
}

/* Initialize */

static void win32_init_getopt(void)
{
  extern int optind, opterr, __getopt_initialized, optopt;
  
  __getopt_initialized = 0;
  opterr = 1;
  optopt = '?';
  optind = 1;
}

static LONG WINAPI default_callback(TeXDLLMessage msg,
				    DWORD dwParam1, DWORD dwParam2,
				    LPVOID lpAppData)
{
  if (msg == TeXDLL_CONSOLE_GET)
    return -1;
  else
    return 0;
}

BOOL win32_init_main(TeXCallbackProc callback, LPVOID callback_data,
		     LPCSTR workdir)
{
  if (!win32_init_malloc())
    return FALSE;
  
  win32_init_getopt();
  
  if (!win32_init_io()) {
    win32_uninit_malloc();
    return FALSE;
  }
  
  win32_dll_context = win32_malloc(sizeof(Win32Context));
  win32_dll_context->lpfCallback = callback ? callback : default_callback;
  win32_dll_context->lpvCallbackData = callback_data;
  {
    char buf[1000];
    if (!workdir) {
      GetCurrentDirectory(1000, buf);
      workdir = buf;
    }
    else {
      LPSTR p;
      GetFullPathName(workdir, 1000, buf, &p);
    }
    win32_dll_context->lpszWorkDir = win32_unix2dos(win32_strdup(buf));
  }
  if (!win32_init_search()) {
    win32_uninit_io();
    win32_uninit_malloc();
    return FALSE;
  }
  
  return TRUE;
}

void win32_uninit_main(void)
{
  win32_flush(WIN32_STDOUT);
  win32_flush(WIN32_STDERR);
  win32_uninit_search();
  win32_uninit_io();
  win32_free(win32_dll_context);
  win32_uninit_malloc();
}
