#ifndef win32lib_h_included
#define win32lib_h_included

#include <win32dll/texdll.h>
#include <stdio.h>

#define WIN32_STDIN  ((FILE*)1)
#define WIN32_STDOUT ((FILE*)2)
#define WIN32_STDERR ((FILE*)3)

extern void* win32_malloc(size_t );
extern void* win32_realloc(void* , size_t );
extern void win32_free(void* );
extern char* win32_strdup(const char*);

extern void win32_printf(FILE *fp, const char* fmt, ...);
extern void win32_console_printf(const char* fmt, ...);
extern void win32_flush(FILE* );
extern int win32_getc(FILE* );
extern void win32_ungetc(int , FILE* );
extern int win32_putc(int, FILE *);
extern int win32_puts(const char*, FILE *);
extern int win32_feof(FILE *);
extern long win32_tell(FILE *);
extern char *win32_gets(char *, int, FILE* );

extern FILE* win32_fopen(const char*, const char*);
extern FILE* win32_xfopen(const char*, const char*);
extern int win32_fclose(FILE * );

extern void win32_perror(const char*);
extern int win32_ferror(FILE *fp);

extern char* win32_program_name;
extern char* win32_program_short_name;
extern char *win32_find_file(const char *n, DWORD , BOOL);
extern char *win32_path_search(const char *n, const char* , BOOL);
extern char *win32_var_value(const char *n);
extern char *win32_var_expand(const char *n);
extern char *win32_path_expand(const char *n);
extern FILE* win32_open_file(const char*, DWORD );
extern void win32_init_prog(const char* prefix,
			    unsigned long dpi,
			    const char* mode,
			    const char* fallback);
extern void win32_set_program_enabled (DWORD, BOOL, DWORD);
extern BOOL win32_tex_hush(LPCSTR what);
extern int *p_win32_make_tex_discard_errors;
extern unsigned int *p_win32_kpathsea_debug;
const extern char* win32_kpathsea_bug_address;
const extern char* win32_kpathsea_version_string;

extern VOID win32_return_short_filename(BOOL);

#ifdef WIN32_DLL_DRIVER
extern LPSTR win32_find_glyph(LPSTR font_name,
			      UINT dpi, 
			      int format,
			      LPVOID glyph_file);
extern UINT win32_magstep_fix(UINT dpi, UINT bdpi, LPINT pret);
extern BOOL win32_bitmap_tolerance(double dpi1, double dpi2);
extern const char** p_win32_fallback_resolutions_string;
#if defined(KPSE_API_H) || defined(KPATHSEA_TEX_FILE_H)
extern kpse_format_info_type* win32_format_info;
#endif
#endif /* WIN32_DLL_DRIVER */

extern char* win32_get_registry_string(const char *key, const char *val,
				       const char *default_value);
extern LONG win32_get_registry_int(const char *key, const char *val,
				   LONG default_value);

extern void win32_exit(int);

extern LPSTR win32_concat(LPCSTR, LPCSTR);
extern LPSTR win32_concat3(LPCSTR, LPCSTR, LPCSTR);
extern LPSTR win32_concat_filename(LPCSTR, LPCSTR);
/* extern _declspec(dllimport) LPSTR win32_concatn(LPCSTR, ...); */
extern LPCSTR win32_basename(const char*);
extern LPSTR win32_extend_filename(const char*, const char*);
extern LPSTR win32_make_suffix(const char* s, const char* suffix);
extern LPSTR win32_find_suffix(const char* name);
extern int win32_atou(const char* );

extern LPSTR win32_unix2dos(LPSTR path);
extern LPSTR win32_dos2unix(LPSTR path);
extern LPSTR win32_make_fullpath(LPCSTR fn);

extern BOOL win32_mkdir_recursively(LPCSTR dirName);

extern BOOL win32_init_main(TeXCallbackProc , LPVOID , LPCSTR );
extern VOID win32_uninit_main(void);

extern BOOL win32_init_module(HANDLE hModule);
extern HMODULE win32_get_module_handle(void);
extern LPCSTR win32_module_filename(void);
extern LPCSTR win32_module_path(void);
extern HINSTANCE win32_load_library_in_same_directory(LPCSTR dllname);
extern HINSTANCE win32_load_library_just_in_same_directory(LPCSTR dllname);
extern HINSTANCE win32_load_tex_library(LPCSTR dllname);
extern HINSTANCE win32_load_just_registry_library(LPCSTR key, LPCSTR value,
						  LPCSTR dllname);
extern HINSTANCE win32_load_registry_library(LPCSTR key, LPCSTR value,
					     LPCSTR dllname);

extern BOOL win32_call_editor(LPCSTR fn, DWORD ln);

extern char* win32_bug_address;
extern char* win32_versionstring;

extern void win32_notify_page_begin(int n);
extern void win32_notify_page_end(int n);

typedef struct {
  LPFTeXCallbackProc lpfCallback;
  LPVOID lpvCallbackData;
  LPSTR lpszWorkDir;
  LPVOID lpvKpseInfo;
  BOOL bShortFileName;
} Win32Context;
extern Win32Context* win32_dll_context;

/* For CUI */
extern VOID win32_init_cui_callback(VOID);
extern TeXCallbackProc win32_standard_cui_callback;
extern VOID win32_write_stdout_text(LPCSTR lpszStr, LONG lLenTotal);
extern VOID win32_write_stderr_text(LPCSTR lpszStr, LONG lLenTotal);

#endif /* win32lib_h_included */
