# Generated by default/object.tt
package Paws::SecurityHub::Record;
  use Moose;
  has JsonPath => (is => 'ro', isa => 'Str');
  has RecordIndex => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::Record

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::Record object:

  $service_obj->Method(Att1 => { JsonPath => $value, ..., RecordIndex => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::Record object:

  $result = $service_obj->Method(...);
  $result->Att1->JsonPath

=head1 DESCRIPTION

An occurrence of sensitive data in an Apache Avro object container or
an Apache Parquet file.

=head1 ATTRIBUTES


=head2 JsonPath => Str

The path, as a JSONPath expression, to the field in the record that
contains the data. If the field name is longer than 20 characters, it
is truncated. If the path is longer than 250 characters, it is
truncated.


=head2 RecordIndex => Int

The record index, starting from 0, for the record that contains the
data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

