# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package JobAd::GEN::AuthGroupMembers;

use strict;

use base 'JobAd';

use JobAd::Model::auth_group_members qw(
    $AUTH_GROUP_MEMBERS
);

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Auth Group Members' );

    my $retval = {
        headings       => [
            'User Id',
            'Group Id',
        ],
        header_options => [
            {
                text => 'Add',
                link => $self->location() . "/add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $AUTH_GROUP_MEMBERS->get_listing( { schema => $schema } );

    foreach my $row ( @rows ) {
        my $id = $row->id;
        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->user_id->foreign_display(),
                    $row->group_id->foreign_display(),
                ],
                options => [
                    {
                        text => 'Edit',
                        link => $self->location() . "/edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $self->location() . "/delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $AUTH_GROUP_MEMBERS->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        fields     => [
            {
                options => $selections->{auth_users},
                name => 'user_id',
                label => 'User Id',
                type => 'select',
                is => 'int4',
            },
            {
                options => $selections->{auth_groups},
                name => 'group_id',
                label => 'Group Id',
                type => 'select',
                is => 'int4',
            },
        ],
    };
} # END form


1;

=head1 NAME

JobAd::GEN::AuthGroupMembers - generated support module for JobAd::AuthGroupMembers

=head1 SYNOPSIS

In JobAd::AuthGroupMembers:

    use JobAd::GEN::AuthGroupMembers qw(
        do_main
        form
    );

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in JobAd::AuthGroupMembers to provide the methods below.
They are exported by default.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

