#!/usr/bin/env perl
use Object::Pad;
use CAD::OpenSCAD::Math;
use Test::Simple tests => 14;
ok(  $foo = new CAD::OpenSCAD::Math,          'creating OpenSCAD::Math object ');
ok(  $foo ->equal([2,3],[2,3]) ,             'test equals '                    );
ok(! $foo ->equal([1,1],[1,2]) ,             'test not equals '                );
ok( $foo ->equal([1,[2,3]],[1,[2,3]]) ,      'test nested mixed equals '       );
ok( $foo->equal( $foo ->add  ([1,1],[1,2]),[2,3] ),'test add '                 );
ok( $foo->equal( $foo ->add  ([1,1,2],[1,2,4]),[2,3,6] ),'test add '           );
ok( $foo->serialise([-1,1]) eq $foo->serialise($foo->rotate([1,1],$foo->pi/2)),'test 2d rotate ' );
ok( $foo->serialise([-1,1,-2]) eq $foo->serialise($foo->rotate([1,1,2],[0,$foo->pi,0])),'test 3d rotate ' );
ok( $foo->equal( $foo ->meanPoint  ([[1,1],[1,2]]),[1,1.5] ),'test meanPoint ' );
ok( $foo->equal(
        $foo->closest( [0,0],[[1,1],[1,2],[3,-4],[-4,5]])->{point},
        [1,1] ),'test closest ' );   
ok ( $foo->equal(
        $foo->normal([[3,2,0],[1,1,0],[2,2,0]]),[0,0,1]),
          'get normal');  
ok ( $foo->equal(
        $foo->acos(0.5),$foo->pi/3),
          'acos test');
ok ( $foo->equal($foo->asin(0.5),$foo->pi/6),
          'asin test');
ok ( $foo->equal($foo->angle([0,10,0]),$foo->pi/2),
          '3d angle test');



