#!/usr/bin/perl

package eBay::API::XML::DataType::WishListType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. WishListType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::WishListType

=head1 DESCRIPTION

This type contains the data for one eBay Express wish list.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::WishListType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::WishListEntryType;


my @gaProperties = ( [ 'Description', 'xs:string', '', '', '' ]
	, [ 'FirstName', 'xs:string', '', '', '' ]
	, [ 'LastName', 'xs:string', '', '', '' ]
	, [ 'Name', 'xs:string', '', '', '' ]
	, [ 'UserLocation', 'xs:string', '', '', '' ]
	, [ 'WishListEntry', 'ns:WishListEntryType', '1'
	     ,'eBay::API::XML::DataType::WishListEntryType', '1' ]
	, [ 'WishListID', 'xs:string', '', '', '' ]
	, [ 'WishListURL', 'xs:anyURI', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDescription()

User-entered description of the wish list.

#    Argument: 'xs:string'

=cut

sub setDescription {
  my $self = shift;
  $self->{'Description'} = shift
}

=head2 getDescription()

  Calls: GetExpressWishList
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getDescription {
  my $self = shift;
  return $self->{'Description'};
}


=head2 setFirstName()

eBay user first name.

#    Argument: 'xs:string'

=cut

sub setFirstName {
  my $self = shift;
  $self->{'FirstName'} = shift
}

=head2 getFirstName()

  Calls: GetExpressWishList
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getFirstName {
  my $self = shift;
  return $self->{'FirstName'};
}


=head2 setLastName()

eBay user last name.

#    Argument: 'xs:string'

=cut

sub setLastName {
  my $self = shift;
  $self->{'LastName'} = shift
}

=head2 getLastName()

  Calls: GetExpressWishList
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getLastName {
  my $self = shift;
  return $self->{'LastName'};
}


=head2 setName()

The user-assigned name of the wish list.

#    Argument: 'xs:string'

=cut

sub setName {
  my $self = shift;
  $self->{'Name'} = shift
}

=head2 getName()

  Calls: GetExpressWishList
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getName {
  my $self = shift;
  return $self->{'Name'};
}


=head2 setUserLocation()

Location of the creator of the wish list (Example: CA, United States).

#    Argument: 'xs:string'

=cut

sub setUserLocation {
  my $self = shift;
  $self->{'UserLocation'} = shift
}

=head2 getUserLocation()

  Calls: GetExpressWishList
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getUserLocation {
  my $self = shift;
  return $self->{'UserLocation'};
}


=head2 setWishListEntry()

Product or item the user has added to the wish list. Returned only if request specifies
WishListID.

#    Argument: reference to an array  
                      of 'ns:WishListEntryType'

=cut

sub setWishListEntry {
  my $self = shift;
  $self->{'WishListEntry'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getWishListEntry()

  Calls: GetExpressWishList
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:WishListEntryType'

=cut

sub getWishListEntry {
  my $self = shift;
  return $self->_getDataTypeArray('WishListEntry');
}


=head2 setWishListID()

ID that uniquely identifies an eBay Express wish list.

#    Argument: 'xs:string'

=cut

sub setWishListID {
  my $self = shift;
  $self->{'WishListID'} = shift
}

=head2 getWishListID()

  Calls: GetExpressWishList
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getWishListID {
  my $self = shift;
  return $self->{'WishListID'};
}


=head2 setWishListURL()

The URL of the wish list.

#    Argument: 'xs:anyURI'

=cut

sub setWishListURL {
  my $self = shift;
  $self->{'WishListURL'} = shift
}

=head2 getWishListURL()

  Calls: GetExpressWishList
  Returned: Always

#    Returns: 'xs:anyURI'

=cut

sub getWishListURL {
  my $self = shift;
  return $self->{'WishListURL'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
