use Test::More;
use Standup::Diary;

my $d = Standup::Diary->new( data_dir => 'foo', project_name => 'bar' );
isa_ok $d, 'Object::Pad::UNIVERSAL', "Diary $_";
isa_ok $d, 'Standup::Diary', "Diary $_";

my @attributes = qw/
  config
  daily_data_path
  data_dir
  date
  project_name
  template
/;

my @methods    = qw/
  init_daily_data_path
  write
  build_full_file_path
  build_path
  should_create_dir
  create_directories_tree
/;

can_ok $d, $_ for @attributes;
can_ok $d, $_ for @methods;

# ok $d->DOES('Diary::Role::Date');
# ok $d->DOES('Diary::Role::Project');

is $d->data_dir, 'foo', 'We have a correct project directory for data';
is $d->project_name, 'bar', 'We have a correct project name';

isa_ok $d->date, 'Time::Piece', "We have a date attribute that $_";

$d->write;

use Time::Piece;
my $today = localtime;

my ($year_month) = $today->ymd('/') =~ m/ \d{4} \/ \d{2} /gx;

is $d->daily_data_path, $d->data_dir . '/' . $year_month, 'Daily data path match today\'s date';

# Revert data_dir foo and all data after tests

done_testing();
