# -*- mode: perl; -*-

use strict;
use warnings;

use Test::More tests => 929;

use Math::BigFloat;

while (<DATA>) {
    s/#.*$//;                   # remove comments
    s/\s+$//;                   # remove trailing whitespace
    next unless length;         # skip empty lines

    my ($x_str, $expected) = split /:/;
    my ($x, $str);

    for my $accu ("undef", "20") {
        my $test = qq|Math::BigFloat -> accuracy($accu);|
                 . qq| \$x = Math::BigFloat -> new("$x_str");|
                 . qq| \$str = \$x -> bnstr();|;

        note "\n$test\n\n";
        eval $test;
        die $@ if $@;           # should never happen

        is($str, $expected, qq|output is "$expected"|);
        if ($x_str eq 'NaN') {
            ok($x -> is_nan(), "input object is unmodified");
        } else {
            cmp_ok($x, "==", $x_str, "input object is unmodified");
        }
    }
}

# Reset accuracy and precision.

Math::BigFloat -> accuracy(undef);
Math::BigFloat -> precision(undef);

# 355/113 rounded to 40 digits.

my $str = '3.141592920353982300884955752212389380531';

# Default rounding.

note(qq|\nMath::BigFloat -> new("$str") -> bnstr();\n\n|);
is(Math::BigFloat -> new($str) -> bnstr(),
   '3.141592920353982300884955752212389380531e+0');

# Accuracy as argument.

note(qq|\nMath::BigFloat -> new("$str") -> bnstr(3);\n\n|);
is(Math::BigFloat -> new($str) -> bnstr(3), '3.14e+0');

# Precision as argument.

note(qq|\nMath::BigFloat -> new("$str") -> bnstr(undef, -3);\n\n|);
is(Math::BigFloat -> new($str) -> bnstr(undef, -3), '3.142e+0');

# Accuracy as class variable.

note(qq|\nMath::BigFloat -> accuracy(5); Math::BigFloat -> new("$str") -> bnstr();\n\n|);
Math::BigFloat -> accuracy(5);
is(Math::BigFloat -> new($str) -> bnstr(), '3.1416e+0');

# Precision as class variable.

note(qq|\nMath::BigFloat -> precision(-5); Math::BigFloat -> new("$str") -> bnstr();\n\n|);
Math::BigFloat -> precision(-5);
is(Math::BigFloat -> new($str) -> bnstr(), '3.14159e+0');

__DATA__

NaN:NaN

inf:inf
-inf:-inf

0:0e+0
-0:0e+0

# positive numbers

0.000000000001:1e-12
0.00000000001:1e-11
0.0000000001:1e-10
0.000000001:1e-9
0.00000001:1e-8
0.0000001:1e-7
0.000001:1e-6
0.00001:1e-5
0.0001:1e-4
0.001:1e-3
0.01:1e-2
0.1:1e-1
1:1e+0
10:1e+1
100:1e+2
1000:1e+3
10000:1e+4
100000:1e+5
1000000:1e+6
10000000:1e+7
100000000:1e+8
1000000000:1e+9
10000000000:1e+10
100000000000:1e+11
1000000000000:1e+12

0.0000000000012:1.2e-12
0.000000000012:1.2e-11
0.00000000012:1.2e-10
0.0000000012:1.2e-9
0.000000012:1.2e-8
0.00000012:1.2e-7
0.0000012:1.2e-6
0.000012:1.2e-5
0.00012:1.2e-4
0.0012:1.2e-3
0.012:1.2e-2
0.12:1.2e-1
1.2:1.2e+0
12:1.2e+1
120:1.2e+2
1200:1.2e+3
12000:1.2e+4
120000:1.2e+5
1200000:1.2e+6
12000000:1.2e+7
120000000:1.2e+8
1200000000:1.2e+9
12000000000:1.2e+10
120000000000:1.2e+11
1200000000000:1.2e+12

0.00000000000123:1.23e-12
0.0000000000123:1.23e-11
0.000000000123:1.23e-10
0.00000000123:1.23e-9
0.0000000123:1.23e-8
0.000000123:1.23e-7
0.00000123:1.23e-6
0.0000123:1.23e-5
0.000123:1.23e-4
0.00123:1.23e-3
0.0123:1.23e-2
0.123:1.23e-1
1.23:1.23e+0
12.3:1.23e+1
123:1.23e+2
1230:1.23e+3
12300:1.23e+4
123000:1.23e+5
1230000:1.23e+6
12300000:1.23e+7
123000000:1.23e+8
1230000000:1.23e+9
12300000000:1.23e+10
123000000000:1.23e+11
1230000000000:1.23e+12

0.000000000001234:1.234e-12
0.00000000001234:1.234e-11
0.0000000001234:1.234e-10
0.000000001234:1.234e-9
0.00000001234:1.234e-8
0.0000001234:1.234e-7
0.000001234:1.234e-6
0.00001234:1.234e-5
0.0001234:1.234e-4
0.001234:1.234e-3
0.01234:1.234e-2
0.1234:1.234e-1
1.234:1.234e+0
12.34:1.234e+1
123.4:1.234e+2
1234:1.234e+3
12340:1.234e+4
123400:1.234e+5
1234000:1.234e+6
12340000:1.234e+7
123400000:1.234e+8
1234000000:1.234e+9
12340000000:1.234e+10
123400000000:1.234e+11
1234000000000:1.234e+12

0.000003141592:3.141592e-6
0.00003141592:3.141592e-5
0.0003141592:3.141592e-4
0.003141592:3.141592e-3
0.03141592:3.141592e-2
0.3141592:3.141592e-1
3.141592:3.141592e+0
31.41592:3.141592e+1
314.1592:3.141592e+2
3141.592:3.141592e+3
31415.92:3.141592e+4
314159.2:3.141592e+5
3141592:3.141592e+6

# negative numbers

-0.000000000001:-1e-12
-0.00000000001:-1e-11
-0.0000000001:-1e-10
-0.000000001:-1e-9
-0.00000001:-1e-8
-0.0000001:-1e-7
-0.000001:-1e-6
-0.00001:-1e-5
-0.0001:-1e-4
-0.001:-1e-3
-0.01:-1e-2
-0.1:-1e-1
-1:-1e+0
-10:-1e+1
-100:-1e+2
-1000:-1e+3
-10000:-1e+4
-100000:-1e+5
-1000000:-1e+6
-10000000:-1e+7
-100000000:-1e+8
-1000000000:-1e+9
-10000000000:-1e+10
-100000000000:-1e+11
-1000000000000:-1e+12

-0.0000000000012:-1.2e-12
-0.000000000012:-1.2e-11
-0.00000000012:-1.2e-10
-0.0000000012:-1.2e-9
-0.000000012:-1.2e-8
-0.00000012:-1.2e-7
-0.0000012:-1.2e-6
-0.000012:-1.2e-5
-0.00012:-1.2e-4
-0.0012:-1.2e-3
-0.012:-1.2e-2
-0.12:-1.2e-1
-1.2:-1.2e+0
-12:-1.2e+1
-120:-1.2e+2
-1200:-1.2e+3
-12000:-1.2e+4
-120000:-1.2e+5
-1200000:-1.2e+6
-12000000:-1.2e+7
-120000000:-1.2e+8
-1200000000:-1.2e+9
-12000000000:-1.2e+10
-120000000000:-1.2e+11
-1200000000000:-1.2e+12

-0.00000000000123:-1.23e-12
-0.0000000000123:-1.23e-11
-0.000000000123:-1.23e-10
-0.00000000123:-1.23e-9
-0.0000000123:-1.23e-8
-0.000000123:-1.23e-7
-0.00000123:-1.23e-6
-0.0000123:-1.23e-5
-0.000123:-1.23e-4
-0.00123:-1.23e-3
-0.0123:-1.23e-2
-0.123:-1.23e-1
-1.23:-1.23e+0
-12.3:-1.23e+1
-123:-1.23e+2
-1230:-1.23e+3
-12300:-1.23e+4
-123000:-1.23e+5
-1230000:-1.23e+6
-12300000:-1.23e+7
-123000000:-1.23e+8
-1230000000:-1.23e+9
-12300000000:-1.23e+10
-123000000000:-1.23e+11
-1230000000000:-1.23e+12

-0.000000000001234:-1.234e-12
-0.00000000001234:-1.234e-11
-0.0000000001234:-1.234e-10
-0.000000001234:-1.234e-9
-0.00000001234:-1.234e-8
-0.0000001234:-1.234e-7
-0.000001234:-1.234e-6
-0.00001234:-1.234e-5
-0.0001234:-1.234e-4
-0.001234:-1.234e-3
-0.01234:-1.234e-2
-0.1234:-1.234e-1
-1.234:-1.234e+0
-12.34:-1.234e+1
-123.4:-1.234e+2
-1234:-1.234e+3
-12340:-1.234e+4
-123400:-1.234e+5
-1234000:-1.234e+6
-12340000:-1.234e+7
-123400000:-1.234e+8
-1234000000:-1.234e+9
-12340000000:-1.234e+10
-123400000000:-1.234e+11
-1234000000000:-1.234e+12

-0.000003141592:-3.141592e-6
-0.00003141592:-3.141592e-5
-0.0003141592:-3.141592e-4
-0.003141592:-3.141592e-3
-0.03141592:-3.141592e-2
-0.3141592:-3.141592e-1
-3.141592:-3.141592e+0
-31.41592:-3.141592e+1
-314.1592:-3.141592e+2
-3141.592:-3.141592e+3
-31415.92:-3.141592e+4
-314159.2:-3.141592e+5
-3141592:-3.141592e+6
