/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.sql.IdentifierGenerator;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.CodeList;

public class MetadataWriter
extends MetadataSource {
    private static final String CODE_COLUMN = "CODE";
    private static final int MINIMAL_LIMIT = 5;
    private final int maximumIdentifierLength;
    private final int maximumValueLength;
    private final ValueExistencePolicy columnCreationPolicy;

    public MetadataWriter(MetadataStandard metadataStandard, DataSource dataSource, String string, Map<String, ?> map) {
        super(metadataStandard, dataSource, string, map);
        Integer n = Containers.property(map, "maximumIdentifierLength", Integer.class);
        Integer n2 = Containers.property(map, "maximumValueLength", Integer.class);
        ValueExistencePolicy valueExistencePolicy = Containers.property(map, "columnCreationPolicy", ValueExistencePolicy.class);
        if (n != null) {
            ArgumentChecks.ensureBetween("maximumIdentifierLength", 5, 100, n);
            this.maximumIdentifierLength = n;
        } else {
            this.maximumIdentifierLength = 24;
        }
        if (n2 != null) {
            ArgumentChecks.ensureBetween("maximumValueLength", 5, Short.MAX_VALUE, n2);
            this.maximumValueLength = n2;
        } else {
            this.maximumValueLength = 1000;
        }
        this.columnCreationPolicy = valueExistencePolicy != null ? valueExistencePolicy : ValueExistencePolicy.NON_EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String add(Object object) throws MetadataStoreException {
        String string = this.proxy(object);
        if (string == null) {
            try {
                MetadataWriter metadataWriter = this;
                synchronized (metadataWriter) {
                    Connection connection = this.connection();
                    connection.setAutoCommit(false);
                    boolean bl = false;
                    try {
                        try (Statement statement = connection.createStatement();){
                            string = object instanceof CodeList ? this.addCode(statement, (CodeList)object) : this.add(statement, object, new IdentityHashMap<Object, String>(), null);
                        }
                        bl = true;
                    }
                    finally {
                        if (bl) {
                            connection.commit();
                        } else {
                            connection.rollback();
                        }
                        connection.setAutoCommit(true);
                    }
                }
            }
            catch (ClassCastException classCastException) {
                throw new MetadataStoreException(Errors.format((short)42, "metadata", object.getClass()));
            }
            catch (SQLException sQLException) {
                throw new MetadataStoreException(sQLException.getLocalizedMessage(), Exceptions.unwrap(sQLException));
            }
        }
        return string;
    }

    private String add(Statement statement, Object object, Map<Object, String> map, String string) throws ClassCastException, SQLException {
        Object object2;
        Object object3;
        String string2;
        int n;
        int clazz4;
        Object object4;
        Object object52;
        Object object6;
        Set<String> set;
        SQLBuilder sQLBuilder = this.helper();
        Map<String, Object> map2 = this.asValueMap(object);
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> clazz2 : map2.entrySet()) {
            linkedHashMap.put(clazz2.getKey(), MetadataWriter.extractFromCollection(clazz2.getValue()));
        }
        Class<?> clazz3 = object.getClass();
        Class clazz = this.standard.getInterface(clazz3);
        String string3 = MetadataWriter.getTableName(clazz);
        String string4 = this.search(string3, set = this.getExistingColumns(string3), linkedHashMap, statement, sQLBuilder);
        if (string4 != null) {
            if (map.put(object, string4) != null) {
                throw new AssertionError(object);
            }
            return string4;
        }
        if (this.columnCreationPolicy != ValueExistencePolicy.ALL) {
            object6 = linkedHashMap.values().iterator();
            while (object6.hasNext()) {
                if (object6.next() != null) continue;
                object6.remove();
            }
        }
        if ((object6 = this.createTable(statement, clazz, string3, set)) == null) {
            object6 = this.isChildTable(clazz);
        }
        Map<String, Class<?>> map3 = null;
        Map<String, Class<?>> map4 = null;
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        for (Object object52 : linkedHashMap.keySet()) {
            Class throwable;
            if (set.contains(object52)) continue;
            if (map3 == null) {
                map3 = this.standard.asTypeMap(clazz3, NAME_POLICY, TypeValuePolicy.ELEMENT_TYPE);
                map4 = this.standard.asTypeMap(clazz3, NAME_POLICY, TypeValuePolicy.DECLARING_INTERFACE);
            }
            object4 = string3;
            if (sQLBuilder.dialect.isTableInheritanceSupported && !clazz.isAssignableFrom(throwable = (Class)map4.get(object52))) {
                object4 = MetadataWriter.getTableName(throwable);
            }
            clazz4 = this.maximumValueLength;
            Class<?> clazz2 = map3.get(object52);
            boolean clazz6 = CodeList.class.isAssignableFrom(clazz2);
            if (clazz6 || this.standard.isMetadata(clazz2)) {
                if (!(clazz6 && Modifier.isAbstract(clazz2.getModifiers()) || linkedHashMap2.put(object52, new FKey((String)object4, clazz2, null)) == null)) {
                    throw new AssertionError(object52);
                }
                clazz2 = null;
                clazz4 = this.maximumIdentifierLength;
            } else if (clazz2.isEnum()) {
                clazz4 = this.maximumIdentifierLength;
            }
            statement.executeUpdate(sQLBuilder.createColumn(this.schema(), (String)object4, (String)object52, clazz2, clazz4));
            set.add((String)object52);
        }
        string4 = MetadataWriter.nonEmpty(MetadataWriter.removeReservedChars(this.suggestIdentifier(object, map2), null));
        if (string4 == null && (string4 = string) == null) {
            string4 = "unknown";
            for (Object object52 : linkedHashMap.values()) {
                if (object52 == null || this.standard.isMetadata(object52.getClass())) continue;
                string4 = MetadataWriter.abbreviation(object52.toString());
                break;
            }
        }
        if (((Boolean)object6).booleanValue()) {
            string4 = '{' + string3 + '}' + string4;
            n = string3.length() + 2;
        } else {
            n = 0;
        }
        object52 = new IdentifierGenerator(this, this.schema(), string3, "ID", sQLBuilder);
        object4 = null;
        try {
            for (clazz4 = 0; clazz4 < 4; ++clazz4) {
                int object7 = this.maximumIdentifierLength - clazz4;
                if (object7 < n) {
                } else {
                    if (string4.length() > object7) {
                        string4 = string4.substring(0, object7);
                    }
                    if ((string4 = ((IdentifierGenerator)object52).identifier(string4)).length() > this.maximumIdentifierLength) continue;
                }
                break;
            }
        }
        catch (Throwable entry) {
            object4 = entry;
            throw entry;
        }
        finally {
            if (object52 != null) {
                if (object4 != null) {
                    try {
                        ((IdentifierGenerator)object52).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object4).addSuppressed(throwable);
                    }
                } else {
                    ((IdentifierGenerator)object52).close();
                }
            }
        }
        if (map.put(object, string4) != null) {
            throw new AssertionError(object);
        }
        object52 = null;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            Object fKey = entry.getValue();
            Class<?> clazz7 = fKey.getClass();
            if (CodeList.class.isAssignableFrom(clazz7)) {
                fKey = this.addCode(statement, (CodeList)fKey);
            } else if (clazz7.isEnum()) {
                fKey = ((Enum)fKey).name();
            } else if (this.standard.isMetadata(clazz7)) {
                String bl = this.proxy(fKey);
                if (bl == null && (bl = map.get(fKey)) == null) {
                    bl = this.add(statement, fKey, map, string4);
                    assert (map.get(fKey) == bl);
                    ((Object)((Object)sQLBuilder.dialect)).getClass();
                    string2 = (String)entry.getKey();
                    object3 = this.standard.getInterface(fKey.getClass());
                    object2 = (FKey)linkedHashMap2.get(string2);
                    if (object2 != null && !((Class)object3).isAssignableFrom(((FKey)object2).tableType)) {
                        ((FKey)object2).tableType = object3;
                    }
                    if (object2 == null) {
                        if (object52 == null) {
                            object52 = new HashMap<String, FKey>();
                            try (ResultSet resultSet = statement.getConnection().getMetaData().getImportedKeys(this.catalog, this.schema(), string3);){
                                while (resultSet.next()) {
                                    if (this.schema() != null && !this.schema().equals(resultSet.getString("PKTABLE_SCHEM")) || this.catalog != null && !this.catalog.equals(resultSet.getString("PKTABLE_CAT"))) continue;
                                    object52.put(resultSet.getString("FKCOLUMN_NAME"), new FKey(resultSet.getString("PKTABLE_NAME"), null, resultSet.getString("FK_NAME")));
                                }
                            }
                        }
                        if ((object2 = (FKey)object52.remove(string2)) != null && !((FKey)object2).tableName.equals(MetadataWriter.getTableName(object3))) {
                            statement.executeUpdate(sQLBuilder.clear().append("ALTER TABLE ").appendIdentifier(this.schema(), string3).append(" DROP CONSTRAINT ").appendIdentifier(((FKey)object2).keyName).toString());
                            this.warning(MetadataWriter.class, "add", Messages.getResources(null).getLogRecord(Level.WARNING, (short)32, string3 + '.' + string2 + " \u21d2 " + ((FKey)object2).tableName + '.' + "ID"));
                        }
                    }
                }
                fKey = bl;
            }
            entry.setValue(fKey);
        }
        if (!linkedHashMap2.isEmpty()) {
            for (Map.Entry string6 : linkedHashMap2.entrySet()) {
                FKey fKey = (FKey)string6.getValue();
                Class<?> clazz5 = fKey.tableType;
                boolean bl = CodeList.class.isAssignableFrom(clazz5);
                if (bl) {
                    string2 = CODE_COLUMN;
                } else {
                    string2 = "ID";
                    clazz5 = this.standard.getInterface(clazz5);
                }
                object3 = (String)string6.getKey();
                object2 = MetadataWriter.getTableName(clazz5);
                statement.executeUpdate(sQLBuilder.createForeignKey(this.schema(), fKey.tableName, (String)object3, (String)object2, string2, !bl));
                ((Object)((Object)sQLBuilder.dialect)).getClass();
                if (string3.equals(fKey.tableName)) continue;
                statement.executeUpdate(sQLBuilder.createForeignKey(this.schema(), string3, (String)object3, (String)object2, string2, !bl));
            }
        }
        sQLBuilder.clear().append("INSERT INTO ").appendIdentifier(this.schema(), string3).append(" (").append("ID");
        for (String entry : linkedHashMap.keySet()) {
            sQLBuilder.append(", ").appendIdentifier(entry);
        }
        sQLBuilder.append(") VALUES (").appendValue(string4);
        for (Map.Entry entry : linkedHashMap.values()) {
            sQLBuilder.append(", ").appendValue(entry);
        }
        object4 = sQLBuilder.append(')').toString();
        if (statement.executeUpdate((String)object4) != 1) {
            throw new SQLException(Errors.format((short)174, 0, string3, string4));
        }
        return string4;
    }

    private static Class<?>[] getParentTypes(Class<?> clazz) {
        Class<?>[] classArray;
        if (clazz.isInterface()) {
            classArray = clazz.getInterfaces();
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz.getSuperclass();
        }
        return classArray;
    }

    private Boolean isChildTable(Class<?> clazz) {
        for (Class<?> clazz2 : MetadataWriter.getParentTypes(clazz)) {
            if (!this.standard.isMetadata(clazz2)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - void declaration
     */
    private Boolean createTable(Statement statement, Class<?> clazz, String string, Set<String> set) throws SQLException {
        Boolean bl = null;
        if (set.isEmpty()) {
            void var7_10;
            bl = Boolean.FALSE;
            StringBuilder stringBuilder = null;
            for (Class<?> clazz2 : MetadataWriter.getParentTypes(clazz)) {
                if (!this.standard.isMetadata(clazz2)) continue;
                bl = Boolean.TRUE;
                SQLBuilder sQLBuilder = this.helper();
                if (!sQLBuilder.dialect.isTableInheritanceSupported) continue;
                String string2 = MetadataWriter.getTableName(clazz2);
                this.createTable(statement, clazz2, string2, this.getExistingColumns(string2));
                if (stringBuilder == null) {
                    sQLBuilder.clear().append("CREATE TABLE ").appendIdentifier(this.schema(), string);
                    ((Object)((Object)sQLBuilder.dialect)).getClass();
                    sQLBuilder.append("(CONSTRAINT ").appendIdentifier(string + "_pkey").append(" PRIMARY KEY (").append("ID").append(")) ");
                    stringBuilder = new StringBuilder(sQLBuilder.append(" INHERITS (").toString());
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(sQLBuilder.clear().appendIdentifier(this.schema(), string2));
            }
            if (stringBuilder != null) {
                String string3 = stringBuilder.append(')').toString();
            } else {
                String string4 = this.createTable(string, "ID");
            }
            statement.executeUpdate((String)var7_10);
            set.add("ID");
        }
        return bl;
    }

    private String createTable(String string, String string2) throws SQLException {
        return this.helper().clear().append("CREATE TABLE ").appendIdentifier(this.schema(), string).append(" (").append(string2).append(" VARCHAR(").append(this.maximumIdentifierLength).append(") NOT NULL PRIMARY KEY)").toString();
    }

    private String addCode(Statement statement, CodeList<?> codeList) throws SQLException {
        boolean bl;
        assert (Thread.holdsLock(this));
        String string = MetadataWriter.getTableName(codeList.getClass());
        Set<String> set = this.getExistingColumns(string);
        if (set.isEmpty()) {
            statement.executeUpdate(this.createTable(string, CODE_COLUMN));
            set.add(CODE_COLUMN);
        }
        String string2 = Types.getCodeName(codeList);
        String string3 = this.helper().clear().append("SELECT ").append(CODE_COLUMN).append(" FROM ").appendIdentifier(this.schema(), string).append(" WHERE ").append(CODE_COLUMN).appendCondition(string2).toString();
        try (Object object = statement.executeQuery(string3);){
            bl = object.next();
        }
        if (!bl && statement.executeUpdate((String)(object = this.helper().clear().append("INSERT INTO ").appendIdentifier(this.schema(), string).append(" (").append(CODE_COLUMN).append(") VALUES (").appendValue(string2).append(')').toString())) != 1) {
            throw new SQLException(Errors.format((short)174, 0, string, string2));
        }
        return string2;
    }

    protected String suggestIdentifier(Object object, Map<String, Object> map) throws SQLException {
        Object object2;
        Object object3;
        Object object4 = null;
        if (object instanceof Identifier) {
            object4 = MetadataWriter.nonEmpty(((Identifier)object).getCode());
            if (object instanceof ReferenceIdentifier && (object3 = MetadataWriter.nonEmpty(((ReferenceIdentifier)object).getCodeSpace())) != null) {
                Object object5 = object4 = object4 != null ? (String)object3 + ':' + (String)object4 : object3;
            }
        }
        if (object4 == null && object instanceof Citation) {
            object4 = MetadataWriter.nonEmpty(Citations.getIdentifier((Citation)object));
        }
        if (object4 == null && (object3 = object.getClass().getAnnotation(TitleProperty.class)) != null && (object2 = map.get(MetadataWriter.nonEmpty(object3.name()))) != null) {
            object4 = MetadataWriter.nonEmpty(object2.toString());
        }
        if (object4 != null && ((String)object4).length() >= 8) {
            object4 = MetadataWriter.abbreviation((String)object4);
        }
        return object4;
    }

    private static String abbreviation(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            int n = stringTokenizer.nextToken().codePointAt(0);
            if (MetadataWriter.isReservedChar(n)) continue;
            stringBuilder.appendCodePoint(n);
        }
        if (stringBuilder.length() >= 3) {
            return stringBuilder.toString();
        }
        stringBuilder.setLength(0);
        return MetadataWriter.removeReservedChars(string, stringBuilder.append(string));
    }

    private static String removeReservedChars(String string, StringBuilder stringBuilder) {
        if (string != null) {
            boolean bl = false;
            int n = string.length();
            while (--n >= 0) {
                char c = string.charAt(n);
                if (!MetadataWriter.isReservedChar(c)) continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string);
                }
                stringBuilder.deleteCharAt(n);
                bl = true;
            }
            if (bl) {
                return stringBuilder.toString();
            }
        }
        return string;
    }

    private static boolean isReservedChar(int n) {
        return n == 123 || n == 125;
    }

    private static String nonEmpty(String string) {
        if (string != null && (string = string.trim()).isEmpty()) {
            string = null;
        }
        return string;
    }

    private static final class FKey {
        final String tableName;
        Class<?> tableType;
        final String keyName;

        FKey(String string, Class<?> clazz, String string2) {
            this.tableName = string;
            this.tableType = clazz;
            this.keyName = string2;
        }
    }
}

