/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.GridLayout;
import java.awt.Panel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;
import junit.swingui.StatusLine;

public class CounterPanel
extends Panel {
    private JTextField fNumberOfErrors;
    private JTextField fNumberOfFailures;
    private JTextField fNumberOfRuns;
    private int fTotal;

    public CounterPanel() {
        super(new GridLayout(2, 3));
        this.add(new JLabel("Runs:"));
        this.add(new JLabel("Errors:"));
        this.add(new JLabel("Failures: "));
        this.fNumberOfErrors = this.createOutputField();
        this.fNumberOfFailures = this.createOutputField();
        this.fNumberOfRuns = this.createOutputField();
        this.add(this.fNumberOfRuns);
        this.add(this.fNumberOfErrors);
        this.add(this.fNumberOfFailures);
    }

    private String asString(int value) {
        return Integer.toString(value);
    }

    private JTextField createOutputField() {
        JTextField field = new JTextField("0", 4);
        field.setHorizontalAlignment(2);
        field.setFont(StatusLine.BOLD_FONT);
        field.setEditable(false);
        field.setBorder(BorderFactory.createEmptyBorder());
        return field;
    }

    public void reset() {
        this.setLabelValue(this.fNumberOfErrors, 0);
        this.setLabelValue(this.fNumberOfFailures, 0);
        this.setLabelValue(this.fNumberOfRuns, 0);
        this.fTotal = 0;
    }

    public void setErrorValue(int value) {
        this.setLabelValue(this.fNumberOfErrors, value);
    }

    public void setFailureValue(int value) {
        this.setLabelValue(this.fNumberOfFailures, value);
    }

    private void setLabelValue(JTextField label, int value) {
        label.setText(Integer.toString(value));
    }

    public void setRunValue(int value) {
        this.fNumberOfRuns.setText(String.valueOf(Integer.toString(value)) + "/" + this.fTotal);
    }

    public void setTotal(int value) {
        this.fTotal = value;
    }
}

