/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.complex.ComplexColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexValue;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.CalculatedColumnUtil;
import com.healthmarketscience.jackcess.impl.ComplexColumnImpl;
import com.healthmarketscience.jackcess.impl.CustomToStringStyle;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.LongValueColumnImpl;
import com.healthmarketscience.jackcess.impl.MemoColumnImpl;
import com.healthmarketscience.jackcess.impl.NumericColumnImpl;
import com.healthmarketscience.jackcess.impl.OleUtil;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.PropertyMapImpl;
import com.healthmarketscience.jackcess.impl.TableCreator;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.TableMutator;
import com.healthmarketscience.jackcess.impl.TextColumnImpl;
import com.healthmarketscience.jackcess.impl.UnsupportedColumnImpl;
import com.healthmarketscience.jackcess.impl.UsageMap;
import com.healthmarketscience.jackcess.impl.complex.ComplexValueForeignKeyImpl;
import com.healthmarketscience.jackcess.util.ColumnValidator;
import com.healthmarketscience.jackcess.util.SimpleColumnValidator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnImpl
implements Column,
Comparable<ColumnImpl> {
    protected static final Log LOG = LogFactory.getLog(ColumnImpl.class);
    public static final Object RETURN_ROW_ID = "<RETURN_ROW_ID>";
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    static final long MILLIS_BETWEEN_EPOCH_AND_1900 = 2209161600000L;
    public static final byte FIXED_LEN_FLAG_MASK = 1;
    public static final byte AUTO_NUMBER_FLAG_MASK = 4;
    public static final byte AUTO_NUMBER_GUID_FLAG_MASK = 64;
    public static final byte HYPERLINK_FLAG_MASK = -128;
    public static final byte UPDATABLE_FLAG_MASK = 2;
    protected static final byte COMPRESSED_UNICODE_EXT_FLAG_MASK = 1;
    private static final byte CALCULATED_EXT_FLAG_MASK = -64;
    static final byte NUMERIC_NEGATIVE_BYTE = -128;
    private static final short GENERAL_SORT_ORDER_VALUE = 1033;
    public static final SortOrder GENERAL_LEGACY_SORT_ORDER = new SortOrder(1033, 0);
    public static final SortOrder GENERAL_SORT_ORDER = new SortOrder(1033, 1);
    private static final Pattern GUID_PATTERN = Pattern.compile("\\s*[{]?([\\p{XDigit}]{8})-([\\p{XDigit}]{4})-([\\p{XDigit}]{4})-([\\p{XDigit}]{4})-([\\p{XDigit}]{12})[}]?\\s*");
    private static final byte[] TEXT_COMPRESSION_HEADER = new byte[]{-1, -2};
    private static final char MIN_COMPRESS_CHAR = '\u0001';
    private static final char MAX_COMPRESS_CHAR = '\u00ff';
    static final int INVALID_AUTO_NUMBER = 0;
    private final TableImpl _table;
    private final boolean _variableLength;
    private final boolean _autoNumber;
    private final boolean _calculated;
    private final DataType _type;
    private final short _columnLength;
    private final short _columnNumber;
    private int _columnIndex;
    private final int _displayIndex;
    private final String _name;
    private final int _fixedDataOffset;
    private final int _varLenTableIndex;
    private final AutoNumberGenerator _autoNumberGenerator;
    private PropertyMap _props;
    private ColumnValidator _validator = SimpleColumnValidator.INSTANCE;

    protected ColumnImpl(TableImpl table, String name, DataType type, int colNumber, int fixedOffset, int varLenIndex) {
        this._table = table;
        this._name = name;
        this._type = type;
        this._columnLength = !this._type.isVariableLength() ? (short)type.getFixedSize() : (short)type.getMaxSize();
        this._variableLength = type.isVariableLength();
        this._autoNumber = false;
        this._calculated = false;
        this._autoNumberGenerator = null;
        this._columnNumber = (short)colNumber;
        this._columnIndex = colNumber;
        this._displayIndex = colNumber;
        this._fixedDataOffset = fixedOffset;
        this._varLenTableIndex = varLenIndex;
    }

    ColumnImpl(InitArgs args) throws IOException {
        this._table = args.table;
        this._name = args.name;
        this._displayIndex = args.displayIndex;
        this._type = args.type;
        this._columnNumber = args.buffer.getShort(args.offset + this.getFormat().OFFSET_COLUMN_NUMBER);
        this._columnLength = args.buffer.getShort(args.offset + this.getFormat().OFFSET_COLUMN_LENGTH);
        this._variableLength = (args.flags & 1) == 0;
        this._autoNumber = (args.flags & 0x44) != 0;
        this._calculated = (args.extFlags & 0xFFFFFFC0) != 0;
        this._autoNumberGenerator = this.createAutoNumberGenerator();
        if (this._variableLength) {
            this._varLenTableIndex = args.buffer.getShort(args.offset + this.getFormat().OFFSET_COLUMN_VARIABLE_TABLE_INDEX);
            this._fixedDataOffset = 0;
        } else {
            this._fixedDataOffset = args.buffer.getShort(args.offset + this.getFormat().OFFSET_COLUMN_FIXED_DATA_OFFSET);
            this._varLenTableIndex = 0;
        }
    }

    public static ColumnImpl create(TableImpl table, ByteBuffer buffer, int offset, String name, int displayIndex) throws IOException {
        PropertyMapImpl colProps;
        Byte resultType;
        InitArgs args = new InitArgs(table, buffer, offset, name, displayIndex);
        boolean calculated = (args.extFlags & 0xFFFFFFC0) != 0;
        byte colType = args.colType;
        if (calculated && (resultType = (Byte)(colProps = table.getPropertyMaps().get(name)).getValue("ResultType")) != null) {
            colType = resultType;
        }
        try {
            args.type = DataType.fromByte(colType);
        }
        catch (IOException e) {
            LOG.warn(ColumnImpl.withErrorContext("Unsupported column type " + colType, table.getDatabase(), table.getName(), name));
            boolean variableLength = (args.flags & 1) == 0;
            args.type = variableLength ? DataType.UNSUPPORTED_VARLEN : DataType.UNSUPPORTED_FIXEDLEN;
            return new UnsupportedColumnImpl(args);
        }
        if (calculated) {
            return CalculatedColumnUtil.create(args);
        }
        switch (args.type) {
            case TEXT: {
                return new TextColumnImpl(args);
            }
            case MEMO: {
                return new MemoColumnImpl(args);
            }
            case COMPLEX_TYPE: {
                return new ComplexColumnImpl(args);
            }
        }
        if (args.type.getHasScalePrecision()) {
            return new NumericColumnImpl(args);
        }
        if (args.type.isLongValue()) {
            return new LongValueColumnImpl(args);
        }
        return new ColumnImpl(args);
    }

    void setUsageMaps(UsageMap ownedPages, UsageMap freeSpacePages) {
    }

    void collectUsageMapPages(Collection<Integer> pages) {
    }

    void postTableLoadInit() throws IOException {
    }

    @Override
    public TableImpl getTable() {
        return this._table;
    }

    @Override
    public DatabaseImpl getDatabase() {
        return this.getTable().getDatabase();
    }

    public JetFormat getFormat() {
        return this.getDatabase().getFormat();
    }

    public PageChannel getPageChannel() {
        return this.getDatabase().getPageChannel();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean isVariableLength() {
        return this._variableLength;
    }

    @Override
    public boolean isAutoNumber() {
        return this._autoNumber;
    }

    public short getColumnNumber() {
        return this._columnNumber;
    }

    @Override
    public int getColumnIndex() {
        return this._columnIndex;
    }

    public void setColumnIndex(int newColumnIndex) {
        this._columnIndex = newColumnIndex;
    }

    public int getDisplayIndex() {
        return this._displayIndex;
    }

    @Override
    public DataType getType() {
        return this._type;
    }

    @Override
    public int getSQLType() throws SQLException {
        return this._type.getSQLType();
    }

    @Override
    public boolean isCompressedUnicode() {
        return false;
    }

    @Override
    public byte getPrecision() {
        return (byte)this.getType().getDefaultPrecision();
    }

    @Override
    public byte getScale() {
        return (byte)this.getType().getDefaultScale();
    }

    public SortOrder getTextSortOrder() {
        return null;
    }

    public short getTextCodePage() {
        return 0;
    }

    @Override
    public short getLength() {
        return this._columnLength;
    }

    @Override
    public short getLengthInUnits() {
        return (short)this.getType().toUnitSize(this.getLength());
    }

    @Override
    public boolean isCalculated() {
        return this._calculated;
    }

    public int getVarLenTableIndex() {
        return this._varLenTableIndex;
    }

    public int getFixedDataOffset() {
        return this._fixedDataOffset;
    }

    protected Charset getCharset() {
        return this.getDatabase().getCharset();
    }

    protected Calendar getCalendar() {
        return this.getDatabase().getCalendar();
    }

    @Override
    public boolean isAppendOnly() {
        return this.getVersionHistoryColumn() != null;
    }

    @Override
    public ColumnImpl getVersionHistoryColumn() {
        return null;
    }

    public int getOwnedPageCount() {
        return 0;
    }

    public void setVersionHistoryColumn(ColumnImpl versionHistoryCol) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHyperlink() {
        return false;
    }

    @Override
    public ComplexColumnInfo<? extends ComplexValue> getComplexInfo() {
        return null;
    }

    @Override
    public ColumnValidator getColumnValidator() {
        return this._validator;
    }

    @Override
    public void setColumnValidator(ColumnValidator newValidator) {
        if (this.isAutoNumber()) {
            if (newValidator != null) {
                throw new IllegalArgumentException(this.withErrorContext("Cannot set ColumnValidator for autonumber columns"));
            }
            return;
        }
        if (newValidator == null && (newValidator = this.getDatabase().getColumnValidatorFactory().createValidator(this)) == null) {
            newValidator = SimpleColumnValidator.INSTANCE;
        }
        this._validator = newValidator;
    }

    byte getOriginalDataType() {
        return this._type.getValue();
    }

    private AutoNumberGenerator createAutoNumberGenerator() {
        if (!this._autoNumber || this._type == null) {
            return null;
        }
        switch (this._type) {
            case LONG: {
                return new LongAutoNumberGenerator();
            }
            case GUID: {
                return new GuidAutoNumberGenerator();
            }
            case COMPLEX_TYPE: {
                return new ComplexTypeAutoNumberGenerator();
            }
        }
        LOG.warn(this.withErrorContext("Unknown auto number column type " + (Object)((Object)this._type)));
        return new UnsupportedAutoNumberGenerator(this._type);
    }

    public AutoNumberGenerator getAutoNumberGenerator() {
        return this._autoNumberGenerator;
    }

    @Override
    public PropertyMap getProperties() throws IOException {
        if (this._props == null) {
            this._props = this.getTable().getPropertyMaps().get(this.getName());
        }
        return this._props;
    }

    @Override
    public Object setRowValue(Object[] rowArray, Object value) {
        rowArray[this._columnIndex] = value;
        return value;
    }

    @Override
    public Object setRowValue(Map<String, Object> rowMap, Object value) {
        rowMap.put(this._name, value);
        return value;
    }

    @Override
    public Object getRowValue(Object[] rowArray) {
        return rowArray[this._columnIndex];
    }

    @Override
    public Object getRowValue(Map<String, ?> rowMap) {
        return rowMap.get(this._name);
    }

    public boolean storeInNullMask() {
        return this.getType() == DataType.BOOLEAN;
    }

    public boolean writeToNullMask(Object value) {
        return ColumnImpl.toBooleanValue(value);
    }

    public Object readFromNullMask(boolean isNull) {
        return !isNull;
    }

    public Object read(byte[] data) throws IOException {
        return this.read(data, PageChannel.DEFAULT_BYTE_ORDER);
    }

    public Object read(byte[] data, ByteOrder order) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(order);
        switch (this.getType()) {
            case BOOLEAN: {
                throw new IOException(this.withErrorContext("Tried to read a boolean from data instead of null mask."));
            }
            case BYTE: {
                return buffer.get();
            }
            case INT: {
                return buffer.getShort();
            }
            case LONG: {
                return buffer.getInt();
            }
            case DOUBLE: {
                return buffer.getDouble();
            }
            case FLOAT: {
                return Float.valueOf(buffer.getFloat());
            }
            case SHORT_DATE_TIME: {
                return this.readDateValue(buffer);
            }
            case BINARY: {
                return data;
            }
            case TEXT: {
                return this.decodeTextValue(data);
            }
            case MONEY: {
                return this.readCurrencyValue(buffer);
            }
            case NUMERIC: {
                return this.readNumericValue(buffer);
            }
            case GUID: {
                return ColumnImpl.readGUIDValue(buffer, order);
            }
            case UNKNOWN_0D: 
            case UNKNOWN_11: {
                return data;
            }
            case COMPLEX_TYPE: {
                return new ComplexValueForeignKeyImpl(this, buffer.getInt());
            }
            case BIG_INT: {
                return buffer.getLong();
            }
        }
        throw new IOException(this.withErrorContext("Unrecognized data type: " + (Object)((Object)this._type)));
    }

    private BigDecimal readCurrencyValue(ByteBuffer buffer) throws IOException {
        if (buffer.remaining() != 8) {
            throw new IOException(this.withErrorContext("Invalid money value"));
        }
        return new BigDecimal(BigInteger.valueOf(buffer.getLong(0)), 4);
    }

    private void writeCurrencyValue(ByteBuffer buffer, Object value) throws IOException {
        Object inValue = value;
        try {
            BigDecimal decVal = ColumnImpl.toBigDecimal(value);
            inValue = decVal;
            decVal = decVal.setScale(4);
            buffer.putLong(decVal.movePointRight(4).longValueExact());
        }
        catch (ArithmeticException e) {
            throw (IOException)new IOException(this.withErrorContext("Currency value '" + inValue + "' out of range")).initCause(e);
        }
    }

    private BigDecimal readNumericValue(ByteBuffer buffer) {
        boolean negate = buffer.get() != 0;
        byte[] tmpArr = ByteUtil.getBytes(buffer, 16);
        if (buffer.order() != ByteOrder.BIG_ENDIAN) {
            ColumnImpl.fixNumericByteOrder(tmpArr);
        }
        return ColumnImpl.toBigDecimal(tmpArr, negate, this.getScale());
    }

    static BigDecimal toBigDecimal(byte[] bytes, boolean negate, int scale) {
        if ((bytes[0] & 0x80) != 0) {
            bytes = ByteUtil.copyOf(bytes, 0, bytes.length + 1, 1);
        }
        BigInteger intVal = new BigInteger(bytes);
        if (negate) {
            intVal = intVal.negate();
        }
        return new BigDecimal(intVal, scale);
    }

    private void writeNumericValue(ByteBuffer buffer, Object value) throws IOException {
        Object inValue = value;
        try {
            BigDecimal decVal = ColumnImpl.toBigDecimal(value);
            inValue = decVal;
            int signum = decVal.signum();
            if (signum < 0) {
                decVal = decVal.negate();
            }
            buffer.put(signum < 0 ? (byte)-128 : 0);
            decVal = decVal.setScale(this.getScale());
            if (decVal.precision() > this.getPrecision()) {
                throw new IOException(this.withErrorContext("Numeric value is too big for specified precision " + this.getPrecision() + ": " + decVal));
            }
            byte[] intValBytes = this.toUnscaledByteArray(decVal, this.getType().getFixedSize() - 1);
            if (buffer.order() != ByteOrder.BIG_ENDIAN) {
                ColumnImpl.fixNumericByteOrder(intValBytes);
            }
            buffer.put(intValBytes);
        }
        catch (ArithmeticException e) {
            throw (IOException)new IOException(this.withErrorContext("Numeric value '" + inValue + "' out of range")).initCause(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte[] toUnscaledByteArray(BigDecimal decVal, int maxByteLen) throws IOException {
        byte[] intValBytes = decVal.unscaledValue().toByteArray();
        if (intValBytes.length > maxByteLen) {
            if (intValBytes[0] != 0) throw new IOException(this.withErrorContext("Too many bytes for valid BigInteger?"));
            if (intValBytes.length - 1 != maxByteLen) throw new IOException(this.withErrorContext("Too many bytes for valid BigInteger?"));
            return ByteUtil.copyOf(intValBytes, 1, maxByteLen);
        }
        if (intValBytes.length >= maxByteLen) return intValBytes;
        return ByteUtil.copyOf(intValBytes, 0, maxByteLen, maxByteLen - intValBytes.length);
    }

    private Date readDateValue(ByteBuffer buffer) {
        long dateBits = buffer.getLong();
        long time = this.fromDateDouble(Double.longBitsToDouble(dateBits));
        return new DateExt(time, dateBits);
    }

    public long fromDateDouble(double value) {
        long localTime = ColumnImpl.fromLocalDateDouble(value);
        return localTime - this.getFromLocalTimeZoneOffset(localTime);
    }

    static long fromLocalDateDouble(double value) {
        long datePart = (long)value * 86400000L;
        long timePart = Math.round(Math.abs(value) % 1.0 * 8.64E7);
        long time = datePart + timePart;
        return time -= 2209161600000L;
    }

    private void writeDateValue(ByteBuffer buffer, Object value) {
        if (value == null) {
            buffer.putDouble(0.0);
        } else if (value instanceof DateExt) {
            buffer.putLong(((DateExt)value).getDateBits());
        } else {
            buffer.putDouble(this.toDateDouble(value));
        }
    }

    public double toDateDouble(Object value) {
        long time = ColumnImpl.toDateLong(value);
        time += this.getToLocalTimeZoneOffset(time);
        return ColumnImpl.toLocalDateDouble(time);
    }

    static double toLocalDateDouble(long time) {
        long timePart;
        if ((time += 2209161600000L) < 0L && (timePart = -time % 86400000L) > 0L) {
            time -= 2L * (86400000L - timePart);
        }
        return (double)time / 8.64E7;
    }

    private static long toDateLong(Object value) {
        return value instanceof Date ? ((Date)value).getTime() : (value instanceof Calendar ? ((Calendar)value).getTimeInMillis() : ((Number)value).longValue());
    }

    private long getToLocalTimeZoneOffset(long time) {
        Calendar c = this.getCalendar();
        c.setTimeInMillis(time);
        return (long)c.get(15) + (long)c.get(16);
    }

    private long getFromLocalTimeZoneOffset(long time) {
        Calendar c = this.getCalendar();
        c.setTimeInMillis(time);
        c.setTimeInMillis(time - (long)c.get(15));
        return (long)c.get(15) + (long)c.get(16);
    }

    private static String readGUIDValue(ByteBuffer buffer, ByteOrder order) {
        if (order != ByteOrder.BIG_ENDIAN) {
            byte[] tmpArr = ByteUtil.getBytes(buffer, 16);
            ByteUtil.swap4Bytes(tmpArr, 0);
            ByteUtil.swap2Bytes(tmpArr, 4);
            ByteUtil.swap2Bytes(tmpArr, 6);
            buffer = ByteBuffer.wrap(tmpArr);
        }
        StringBuilder sb = new StringBuilder(22);
        sb.append("{");
        sb.append(ByteUtil.toHexString(buffer, 0, 4, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 4, 2, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 6, 2, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 8, 2, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 10, 6, false));
        sb.append("}");
        return sb.toString();
    }

    private void writeGUIDValue(ByteBuffer buffer, Object value) throws IOException {
        Matcher m = GUID_PATTERN.matcher(ColumnImpl.toCharSequence(value));
        if (!m.matches()) {
            throw new IOException(this.withErrorContext("Invalid GUID: " + value));
        }
        ByteBuffer origBuffer = null;
        byte[] tmpBuf = null;
        if (buffer.order() != ByteOrder.BIG_ENDIAN) {
            origBuffer = buffer;
            tmpBuf = new byte[16];
            buffer = ByteBuffer.wrap(tmpBuf);
        }
        ByteUtil.writeHexString(buffer, m.group(1));
        ByteUtil.writeHexString(buffer, m.group(2));
        ByteUtil.writeHexString(buffer, m.group(3));
        ByteUtil.writeHexString(buffer, m.group(4));
        ByteUtil.writeHexString(buffer, m.group(5));
        if (tmpBuf != null) {
            ByteUtil.swap4Bytes(tmpBuf, 0);
            ByteUtil.swap2Bytes(tmpBuf, 4);
            ByteUtil.swap2Bytes(tmpBuf, 6);
            origBuffer.put(tmpBuf);
        }
    }

    static boolean isGUIDValue(Object value) throws IOException {
        return GUID_PATTERN.matcher(ColumnImpl.toCharSequence(value)).matches();
    }

    public Object validate(Object obj) throws IOException {
        return this._validator.validate(this, obj);
    }

    public ByteBuffer write(Object obj, int remainingRowLength) throws IOException {
        return this.write(obj, remainingRowLength, PageChannel.DEFAULT_BYTE_ORDER);
    }

    public ByteBuffer write(Object obj, int remainingRowLength, ByteOrder order) throws IOException {
        if (ColumnImpl.isRawData(obj)) {
            return ByteBuffer.wrap(((RawData)obj).getBytes());
        }
        return this.writeRealData(obj, remainingRowLength, order);
    }

    protected ByteBuffer writeRealData(Object obj, int remainingRowLength, ByteOrder order) throws IOException {
        if (!this.isVariableLength() || !this.getType().isVariableLength()) {
            return this.writeFixedLengthField(obj, order);
        }
        switch (this.getType()) {
            case NUMERIC: {
                ByteBuffer buffer = PageChannel.createBuffer(this.getType().getFixedSize(), order);
                this.writeNumericValue(buffer, obj);
                buffer.flip();
                return buffer;
            }
            case TEXT: {
                return this.encodeTextValue(obj, 0, this.getLengthInUnits(), false).order(order);
            }
            case BINARY: 
            case UNKNOWN_0D: 
            case UNSUPPORTED_VARLEN: {
                break;
            }
            default: {
                throw new RuntimeException(this.withErrorContext("unexpected inline var length type: " + (Object)((Object)this.getType())));
            }
        }
        ByteBuffer buffer = ByteBuffer.wrap(ColumnImpl.toByteArray(obj)).order(order);
        return buffer;
    }

    protected ByteBuffer writeFixedLengthField(Object obj, ByteOrder order) throws IOException {
        int size = this.getType().getFixedSize(this._columnLength);
        ByteBuffer buffer = this.writeFixedLengthField(obj, PageChannel.createBuffer(size, order));
        buffer.flip();
        return buffer;
    }

    protected ByteBuffer writeFixedLengthField(Object obj, ByteBuffer buffer) throws IOException {
        obj = ColumnImpl.booleanToInteger(obj);
        switch (this.getType()) {
            case BOOLEAN: {
                break;
            }
            case BYTE: {
                buffer.put(ColumnImpl.toNumber(obj).byteValue());
                break;
            }
            case INT: {
                buffer.putShort(ColumnImpl.toNumber(obj).shortValue());
                break;
            }
            case LONG: {
                buffer.putInt(ColumnImpl.toNumber(obj).intValue());
                break;
            }
            case MONEY: {
                this.writeCurrencyValue(buffer, obj);
                break;
            }
            case FLOAT: {
                buffer.putFloat(ColumnImpl.toNumber(obj).floatValue());
                break;
            }
            case DOUBLE: {
                buffer.putDouble(ColumnImpl.toNumber(obj).doubleValue());
                break;
            }
            case SHORT_DATE_TIME: {
                this.writeDateValue(buffer, obj);
                break;
            }
            case TEXT: {
                short numChars = this.getLengthInUnits();
                buffer.put(this.encodeTextValue(obj, numChars, numChars, true));
                break;
            }
            case GUID: {
                this.writeGUIDValue(buffer, obj);
                break;
            }
            case NUMERIC: {
                this.writeNumericValue(buffer, obj);
                break;
            }
            case COMPLEX_TYPE: 
            case BINARY: 
            case UNKNOWN_0D: 
            case UNKNOWN_11: {
                buffer.putInt(ColumnImpl.toNumber(obj).intValue());
                break;
            }
            case BIG_INT: {
                buffer.putLong(ColumnImpl.toNumber(obj).longValue());
                break;
            }
            case UNSUPPORTED_FIXEDLEN: {
                byte[] bytes = ColumnImpl.toByteArray(obj);
                if (bytes.length != this.getLength()) {
                    throw new IOException(this.withErrorContext("Invalid fixed size binary data, size " + this.getLength() + ", got " + bytes.length));
                }
                buffer.put(bytes);
                break;
            }
            default: {
                throw new IOException(this.withErrorContext("Unsupported data type: " + (Object)((Object)this.getType())));
            }
        }
        return buffer;
    }

    String decodeTextValue(byte[] data) throws IOException {
        boolean isCompressed;
        boolean bl = isCompressed = data.length > 1 && data[0] == TEXT_COMPRESSION_HEADER[0] && data[1] == TEXT_COMPRESSION_HEADER[1];
        if (isCompressed) {
            int dataStart;
            StringBuilder textBuf = new StringBuilder(data.length);
            int dataEnd = dataStart = TEXT_COMPRESSION_HEADER.length;
            boolean inCompressedMode = true;
            while (dataEnd < data.length) {
                if (data[dataEnd] == 0) {
                    this.decodeTextSegment(data, dataStart, dataEnd, inCompressedMode, textBuf);
                    inCompressedMode = !inCompressedMode;
                    dataStart = ++dataEnd;
                    continue;
                }
                ++dataEnd;
            }
            this.decodeTextSegment(data, dataStart, dataEnd, inCompressedMode, textBuf);
            return textBuf.toString();
        }
        return ColumnImpl.decodeUncompressedText(data, this.getCharset());
    }

    private void decodeTextSegment(byte[] data, int dataStart, int dataEnd, boolean inCompressedMode, StringBuilder textBuf) {
        if (dataEnd <= dataStart) {
            return;
        }
        int dataLength = dataEnd - dataStart;
        if (inCompressedMode) {
            byte[] tmpData = new byte[dataLength * 2];
            int tmpIdx = 0;
            for (int i = dataStart; i < dataEnd; ++i) {
                tmpData[tmpIdx] = data[i];
                tmpIdx += 2;
            }
            data = tmpData;
            dataStart = 0;
            dataLength = data.length;
        }
        textBuf.append(ColumnImpl.decodeUncompressedText(data, dataStart, dataLength, this.getCharset()));
    }

    private static CharBuffer decodeUncompressedText(byte[] textBytes, int startPos, int length, Charset charset) {
        return charset.decode(ByteBuffer.wrap(textBytes, startPos, length));
    }

    ByteBuffer encodeTextValue(Object obj, int minChars, int maxChars, boolean forceUncompressed) throws IOException {
        CharSequence text = ColumnImpl.toCharSequence(obj);
        if (text.length() > maxChars || text.length() < minChars) {
            throw new IOException(this.withErrorContext("Text is wrong length for " + (Object)((Object)this.getType()) + " column, max " + maxChars + ", min " + minChars + ", got " + text.length()));
        }
        if (!forceUncompressed && this.isCompressedUnicode() && text.length() <= this.getFormat().MAX_COMPRESSED_UNICODE_SIZE && ColumnImpl.isUnicodeCompressible(text)) {
            byte[] encodedChars = new byte[TEXT_COMPRESSION_HEADER.length + text.length()];
            encodedChars[0] = TEXT_COMPRESSION_HEADER[0];
            encodedChars[1] = TEXT_COMPRESSION_HEADER[1];
            for (int i = 0; i < text.length(); ++i) {
                encodedChars[i + ColumnImpl.TEXT_COMPRESSION_HEADER.length] = (byte)text.charAt(i);
            }
            return ByteBuffer.wrap(encodedChars);
        }
        return ColumnImpl.encodeUncompressedText(text, this.getCharset());
    }

    private static boolean isUnicodeCompressible(CharSequence text) {
        if (text.length() <= TEXT_COMPRESSION_HEADER.length) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= '\u0001' && c <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    private static byte getColumnBitFlags(ColumnBuilder col) {
        byte flags = 2;
        if (!col.isVariableLength()) {
            flags = (byte)(flags | 1);
        }
        if (col.isAutoNumber()) {
            int autoNumFlags = 0;
            switch (col.getType()) {
                case COMPLEX_TYPE: 
                case LONG: {
                    autoNumFlags = 4;
                    break;
                }
                case GUID: {
                    autoNumFlags = 64;
                    break;
                }
            }
            flags = (byte)(flags | autoNumFlags);
        }
        if (col.isHyperlink()) {
            flags = (byte)(flags | 0xFFFFFF80);
        }
        return flags;
    }

    public String toString() {
        ToStringBuilder sb = CustomToStringStyle.builder(this).append("name", "(" + this._table.getName() + ") " + this._name);
        byte typeValue = this.getOriginalDataType();
        sb.append("type", "0x" + Integer.toHexString(typeValue) + " (" + (Object)((Object)this._type) + ")").append("number", this._columnNumber).append("length", this._columnLength).append("variableLength", this._variableLength);
        if (this._calculated) {
            sb.append("calculated", this._calculated);
        }
        if (this._type.isTextual()) {
            sb.append("compressedUnicode", this.isCompressedUnicode()).append("textSortOrder", this.getTextSortOrder());
            if (this.getTextCodePage() > 0) {
                sb.append("textCodePage", this.getTextCodePage());
            }
            if (this.isAppendOnly()) {
                sb.append("appendOnly", this.isAppendOnly());
            }
            if (this.isHyperlink()) {
                sb.append("hyperlink", this.isHyperlink());
            }
        }
        if (this._type.getHasScalePrecision()) {
            sb.append("precision", this.getPrecision()).append("scale", this.getScale());
        }
        if (this._autoNumber) {
            sb.append("lastAutoNumber", this._autoNumberGenerator.getLast());
        }
        if (this.getComplexInfo() != null) {
            sb.append("complexInfo", this.getComplexInfo());
        }
        return sb.toString();
    }

    public static String decodeUncompressedText(byte[] textBytes, Charset charset) {
        return ColumnImpl.decodeUncompressedText(textBytes, 0, textBytes.length, charset).toString();
    }

    public static ByteBuffer encodeUncompressedText(CharSequence text, Charset charset) {
        CharBuffer cb = text instanceof CharBuffer ? (CharBuffer)text : CharBuffer.wrap(text);
        return charset.encode(cb);
    }

    @Override
    public int compareTo(ColumnImpl other) {
        if (this._columnNumber > other.getColumnNumber()) {
            return 1;
        }
        if (this._columnNumber < other.getColumnNumber()) {
            return -1;
        }
        return 0;
    }

    public static short countVariableLength(List<ColumnBuilder> columns) {
        short rtn = 0;
        for (ColumnBuilder col : columns) {
            if (!col.isVariableLength()) continue;
            rtn = (short)(rtn + 1);
        }
        return rtn;
    }

    static BigDecimal toBigDecimal(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        return new BigDecimal(value.toString());
    }

    private static Number toNumber(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        return Double.valueOf(value.toString());
    }

    public static CharSequence toCharSequence(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        if (value instanceof Clob) {
            try {
                Clob c = (Clob)value;
                return c.getSubString(1L, (int)c.length());
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        if (value instanceof Reader) {
            char[] buf = new char[8192];
            StringBuilder sout = new StringBuilder();
            Reader in = (Reader)value;
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                sout.append(buf, 0, read);
            }
            return sout;
        }
        return value.toString();
    }

    public static byte[] toByteArray(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof OleUtil.OleBlobImpl) {
            return ((OleUtil.OleBlobImpl)value).getBytes();
        }
        if (value instanceof Blob) {
            try {
                Blob b = (Blob)value;
                return b.getBytes(1L, (int)b.length());
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        if (value instanceof RawData) {
            return ((RawData)value).getBytes();
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (value instanceof InputStream) {
            ByteUtil.copy((InputStream)value, bout);
        } else {
            ObjectOutputStream oos = new ObjectOutputStream(bout);
            oos.writeObject(value);
            oos.close();
        }
        return bout.toByteArray();
    }

    public static boolean toBooleanValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    private static void fixNumericByteOrder(byte[] bytes) {
        for (int i = 0; i < bytes.length; i += 4) {
            ByteUtil.swap4Bytes(bytes, i);
        }
    }

    protected static Object booleanToInteger(Object obj) {
        if (obj instanceof Boolean) {
            obj = (Boolean)obj != false ? 1 : 0;
        }
        return obj;
    }

    public static RawData rawDataWrapper(byte[] bytes) {
        return new RawData(bytes);
    }

    public static boolean isRawData(Object value) {
        return value instanceof RawData;
    }

    protected static void writeDefinitions(TableCreator creator, ByteBuffer buffer) throws IOException {
        short longVariableOffset = creator.countNonLongVariableLength();
        creator.setColumnOffsets(0, 0, longVariableOffset);
        for (ColumnBuilder col : creator.getColumns()) {
            ColumnImpl.writeDefinition(creator, col, buffer);
        }
        for (ColumnBuilder col : creator.getColumns()) {
            TableImpl.writeName(buffer, col.getName(), creator.getCharset());
        }
    }

    protected static void writeDefinition(TableMutator mutator, ColumnBuilder col, ByteBuffer buffer) throws IOException {
        TableMutator.ColumnOffsets colOffsets = mutator.getColumnOffsets();
        buffer.put(col.getType().getValue());
        buffer.putInt(1625);
        buffer.putShort(col.getColumnNumber());
        if (col.isVariableLength()) {
            buffer.putShort(colOffsets.getNextVariableOffset(col));
        } else {
            buffer.putShort((short)0);
        }
        buffer.putShort(col.getColumnNumber());
        if (col.getType().isTextual()) {
            ColumnImpl.writeSortOrder(buffer, col.getTextSortOrder(), mutator.getFormat());
        } else {
            if (col.getType().getHasScalePrecision() && !col.isCalculated()) {
                buffer.put(col.getPrecision());
                buffer.put(col.getScale());
            } else {
                buffer.put((byte)0);
                buffer.put((byte)0);
            }
            buffer.putShort((short)0);
        }
        buffer.put(ColumnImpl.getColumnBitFlags(col));
        if (col.isCalculated()) {
            buffer.put((byte)-64);
        } else if (col.isCompressedUnicode()) {
            buffer.put((byte)1);
        } else {
            buffer.put((byte)0);
        }
        buffer.putInt(0);
        if (col.isVariableLength()) {
            buffer.putShort((short)0);
        } else {
            buffer.putShort(colOffsets.getNextFixedOffset(col));
        }
        if (!col.getType().isLongValue()) {
            int length = col.getLength();
            if (col.isCalculated()) {
                length = !col.getType().isVariableLength() || col.getType().getHasScalePrecision() ? 39 : (int)((short)(length + 23));
            }
            buffer.putShort((short)length);
        } else {
            buffer.putShort((short)0);
        }
    }

    protected static void writeColUsageMapDefinitions(TableCreator creator, ByteBuffer buffer) throws IOException {
        for (ColumnBuilder lvalCol : creator.getLongValueColumns()) {
            ColumnImpl.writeColUsageMapDefinition(creator, lvalCol, buffer);
        }
    }

    protected static void writeColUsageMapDefinition(TableMutator creator, ColumnBuilder lvalCol, ByteBuffer buffer) throws IOException {
        TableMutator.ColumnState colState = creator.getColumnState(lvalCol);
        buffer.putShort(lvalCol.getColumnNumber());
        buffer.put(colState.getUmapOwnedRowNumber());
        ByteUtil.put3ByteInt(buffer, colState.getUmapPageNumber());
        buffer.put(colState.getUmapFreeRowNumber());
        ByteUtil.put3ByteInt(buffer, colState.getUmapPageNumber());
    }

    static SortOrder readSortOrder(ByteBuffer buffer, int position, JetFormat format) {
        short value = buffer.getShort(position);
        byte version = 0;
        if (format.SIZE_SORT_ORDER == 4) {
            version = buffer.get(position + 3);
        }
        if (value == 0) {
            return format.DEFAULT_SORT_ORDER;
        }
        if (value == 1033) {
            if (version == GENERAL_LEGACY_SORT_ORDER.getVersion()) {
                return GENERAL_LEGACY_SORT_ORDER;
            }
            if (version == GENERAL_SORT_ORDER.getVersion()) {
                return GENERAL_SORT_ORDER;
            }
        }
        return new SortOrder(value, version);
    }

    static short readCodePage(ByteBuffer buffer, int offset, JetFormat format) {
        int cpOffset = format.OFFSET_COLUMN_CODE_PAGE;
        return cpOffset >= 0 ? buffer.getShort(offset + cpOffset) : (short)0;
    }

    static byte readExtraFlags(ByteBuffer buffer, int offset, JetFormat format) {
        int extFlagsOffset = format.OFFSET_COLUMN_EXT_FLAGS;
        return extFlagsOffset >= 0 ? buffer.get(offset + extFlagsOffset) : (byte)0;
    }

    private static void writeSortOrder(ByteBuffer buffer, SortOrder sortOrder, JetFormat format) {
        if (sortOrder == null) {
            sortOrder = format.DEFAULT_SORT_ORDER;
        }
        buffer.putShort(sortOrder.getValue());
        if (format.SIZE_SORT_ORDER == 4) {
            buffer.put((byte)0);
            buffer.put(sortOrder.getVersion());
        }
    }

    static boolean isImmutableValue(Object value) {
        return !(value instanceof byte[]);
    }

    public static Object toInternalValue(DataType dataType, Object value) throws IOException {
        if (value == null) {
            return null;
        }
        switch (dataType) {
            case BOOLEAN: {
                return value instanceof Boolean ? value : Boolean.valueOf(ColumnImpl.toBooleanValue(value));
            }
            case BYTE: {
                return value instanceof Byte ? value : Byte.valueOf(ColumnImpl.toNumber(value).byteValue());
            }
            case INT: {
                return value instanceof Short ? value : Short.valueOf(ColumnImpl.toNumber(value).shortValue());
            }
            case LONG: {
                return value instanceof Integer ? value : Integer.valueOf(ColumnImpl.toNumber(value).intValue());
            }
            case MONEY: {
                return ColumnImpl.toBigDecimal(value);
            }
            case FLOAT: {
                return value instanceof Float ? value : Float.valueOf(ColumnImpl.toNumber(value).floatValue());
            }
            case DOUBLE: {
                return value instanceof Double ? value : Double.valueOf(ColumnImpl.toNumber(value).doubleValue());
            }
            case SHORT_DATE_TIME: {
                return value instanceof DateExt ? value : new Date(ColumnImpl.toDateLong(value));
            }
            case TEXT: 
            case MEMO: 
            case GUID: {
                return value instanceof String ? value : ((Object)ColumnImpl.toCharSequence(value)).toString();
            }
            case NUMERIC: {
                return ColumnImpl.toBigDecimal(value);
            }
            case COMPLEX_TYPE: {
                return value;
            }
            case BIG_INT: {
                return value instanceof Long ? value : Long.valueOf(ColumnImpl.toNumber(value).longValue());
            }
        }
        return ColumnImpl.toByteArray(value);
    }

    String withErrorContext(String msg) {
        return ColumnImpl.withErrorContext(msg, this.getDatabase(), this.getTable().getName(), this.getName());
    }

    private static String withErrorContext(String msg, DatabaseImpl db, String tableName, String colName) {
        return msg + " (Db=" + db.getName() + ";Table=" + tableName + ";Column=" + colName + ")";
    }

    static final class InitArgs {
        public final TableImpl table;
        public final ByteBuffer buffer;
        public final int offset;
        public final String name;
        public final int displayIndex;
        public final byte colType;
        public final byte flags;
        public final byte extFlags;
        public DataType type;

        InitArgs(TableImpl table, ByteBuffer buffer, int offset, String name, int displayIndex) {
            this.table = table;
            this.buffer = buffer;
            this.offset = offset;
            this.name = name;
            this.displayIndex = displayIndex;
            this.colType = buffer.get(offset + table.getFormat().OFFSET_COLUMN_TYPE);
            this.flags = buffer.get(offset + table.getFormat().OFFSET_COLUMN_FLAGS);
            this.extFlags = ColumnImpl.readExtraFlags(buffer, offset, table.getFormat());
        }
    }

    public static final class SortOrder {
        private final short _value;
        private final byte _version;

        public SortOrder(short value, byte version) {
            this._value = value;
            this._version = version;
        }

        public short getValue() {
            return this._value;
        }

        public byte getVersion() {
            return this._version;
        }

        public int hashCode() {
            return this._value;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this._value == ((SortOrder)o)._value && this._version == ((SortOrder)o)._version;
        }

        public String toString() {
            return CustomToStringStyle.valueBuilder(this).append(null, this._value + "(" + this._version + ")").toString();
        }
    }

    private final class UnsupportedAutoNumberGenerator
    extends AutoNumberGenerator {
        private final DataType _genType;

        private UnsupportedAutoNumberGenerator(DataType genType) {
            this._genType = genType;
        }

        public Object getLast() {
            return null;
        }

        public Object getNext(TableImpl.WriteRowState writeRowState) {
            throw new UnsupportedOperationException();
        }

        public Object handleInsert(TableImpl.WriteRowState writeRowState, Object inRowValue) {
            throw new UnsupportedOperationException();
        }

        public void restoreLast(Object last) {
            throw new UnsupportedOperationException();
        }

        public DataType getType() {
            return this._genType;
        }
    }

    private final class ComplexTypeAutoNumberGenerator
    extends AutoNumberGenerator {
        private ComplexTypeAutoNumberGenerator() {
        }

        public Object getLast() {
            return ColumnImpl.this.getTable().getLastComplexTypeAutoNumber();
        }

        public Object getNext(TableImpl.WriteRowState writeRowState) {
            int nextComplexAutoNum = writeRowState.getComplexAutoNumber();
            if (nextComplexAutoNum <= 0) {
                nextComplexAutoNum = ColumnImpl.this.getTable().getNextComplexTypeAutoNumber();
                writeRowState.setComplexAutoNumber(nextComplexAutoNum);
            }
            return new ComplexValueForeignKeyImpl(ColumnImpl.this, nextComplexAutoNum);
        }

        public Object handleInsert(TableImpl.WriteRowState writeRowState, Object inRowValue) throws IOException {
            ComplexValueForeignKey inComplexFK = null;
            inComplexFK = inRowValue instanceof ComplexValueForeignKey ? (ComplexValueForeignKey)inRowValue : new ComplexValueForeignKeyImpl(ColumnImpl.this, ColumnImpl.toNumber(inRowValue).intValue());
            if (inComplexFK.getColumn() != ColumnImpl.this) {
                throw new IOException(ColumnImpl.this.withErrorContext("Wrong column for complex value foreign key, found " + inComplexFK.getColumn().getName()));
            }
            if (inComplexFK.get() < 1) {
                throw new IOException(ColumnImpl.this.withErrorContext("Invalid complex value foreign key value " + inComplexFK.get()));
            }
            int prevRowValue = writeRowState.getComplexAutoNumber();
            if (prevRowValue <= 0) {
                writeRowState.setComplexAutoNumber(inComplexFK.get());
            } else if (prevRowValue != inComplexFK.get()) {
                throw new IOException(ColumnImpl.this.withErrorContext("Inconsistent complex value foreign key values: found " + prevRowValue + ", given " + inComplexFK));
            }
            ColumnImpl.this.getTable().adjustComplexTypeAutoNumber(inComplexFK.get());
            return inComplexFK;
        }

        public void restoreLast(Object last) {
            if (last instanceof ComplexValueForeignKey) {
                ColumnImpl.this.getTable().restoreLastComplexTypeAutoNumber(((ComplexValueForeignKey)last).get());
            }
        }

        public DataType getType() {
            return DataType.COMPLEX_TYPE;
        }
    }

    private final class GuidAutoNumberGenerator
    extends AutoNumberGenerator {
        private Object _lastAutoNumber;

        private GuidAutoNumberGenerator() {
        }

        public Object getLast() {
            return this._lastAutoNumber;
        }

        public Object getNext(TableImpl.WriteRowState writeRowState) {
            this._lastAutoNumber = "{" + UUID.randomUUID() + "}";
            return this._lastAutoNumber;
        }

        public Object handleInsert(TableImpl.WriteRowState writeRowState, Object inRowValue) throws IOException {
            this._lastAutoNumber = ColumnImpl.toCharSequence(inRowValue);
            return this._lastAutoNumber;
        }

        public void restoreLast(Object last) {
            this._lastAutoNumber = null;
        }

        public DataType getType() {
            return DataType.GUID;
        }
    }

    private final class LongAutoNumberGenerator
    extends AutoNumberGenerator {
        private LongAutoNumberGenerator() {
        }

        public Object getLast() {
            return ColumnImpl.this.getTable().getLastLongAutoNumber();
        }

        public Object getNext(TableImpl.WriteRowState writeRowState) {
            return ColumnImpl.this.getTable().getNextLongAutoNumber();
        }

        public Object handleInsert(TableImpl.WriteRowState writeRowState, Object inRowValue) throws IOException {
            int inAutoNum = ColumnImpl.toNumber(inRowValue).intValue();
            if (inAutoNum <= 0 && !ColumnImpl.this.getTable().isAllowAutoNumberInsert()) {
                throw new IOException(ColumnImpl.this.withErrorContext("Invalid auto number value " + inAutoNum));
            }
            ColumnImpl.this.getTable().adjustLongAutoNumber(inAutoNum);
            return inAutoNum;
        }

        public void restoreLast(Object last) {
            if (last instanceof Integer) {
                ColumnImpl.this.getTable().restoreLastLongAutoNumber((Integer)last);
            }
        }

        public DataType getType() {
            return DataType.LONG;
        }
    }

    public abstract class AutoNumberGenerator {
        protected AutoNumberGenerator() {
        }

        public abstract Object getLast();

        public abstract Object getNext(TableImpl.WriteRowState var1);

        public abstract Object handleInsert(TableImpl.WriteRowState var1, Object var2) throws IOException;

        public abstract void restoreLast(Object var1);

        public abstract DataType getType();
    }

    private static class RawData
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final byte[] _bytes;

        private RawData(byte[] bytes) {
            this._bytes = bytes;
        }

        private byte[] getBytes() {
            return this._bytes;
        }

        public String toString() {
            return CustomToStringStyle.valueBuilder(this).append((String)null, this.getBytes()).toString();
        }

        private Object writeReplace() throws ObjectStreamException {
            return this.getBytes();
        }
    }

    private static final class DateExt
    extends Date {
        private static final long serialVersionUID = 0L;
        private final transient long _dateBits;

        private DateExt(long time, long dateBits) {
            super(time);
            this._dateBits = dateBits;
        }

        public long getDateBits() {
            return this._dateBits;
        }

        private Object writeReplace() throws ObjectStreamException {
            return new Date(super.getTime());
        }
    }
}

