/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.complex;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.IndexCursor;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.RowId;
import com.healthmarketscience.jackcess.RuntimeIOException;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexDataType;
import com.healthmarketscience.jackcess.complex.ComplexValue;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.CustomToStringStyle;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.complex.ComplexValueForeignKeyImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComplexColumnInfoImpl<V extends ComplexValue>
implements ComplexColumnInfo<V> {
    private static final int INVALID_ID_VALUE = -1;
    public static final ComplexValue.Id INVALID_ID = new ComplexValueIdImpl(-1, null);
    public static final ComplexValueForeignKey INVALID_FK = new ComplexValueForeignKeyImpl(null, -1);
    private final Column _column;
    private final int _complexTypeId;
    private final Table _flatTable;
    private final List<Column> _typeCols;
    private final Column _pkCol;
    private final Column _complexValFkCol;
    private IndexCursor _complexValIdCursor;

    protected ComplexColumnInfoImpl(Column column, int complexTypeId, Table typeObjTable, Table flatTable) throws IOException {
        this._column = column;
        this._complexTypeId = complexTypeId;
        this._flatTable = flatTable;
        ArrayList<Column> typeCols = new ArrayList<Column>();
        ArrayList<Column> otherCols = new ArrayList<Column>();
        ComplexColumnInfoImpl.diffFlatColumns(typeObjTable, flatTable, typeCols, otherCols);
        this._typeCols = Collections.unmodifiableList(typeCols);
        Column pkCol = null;
        Column complexValFkCol = null;
        for (Column col : otherCols) {
            if (col.isAutoNumber()) {
                pkCol = col;
                continue;
            }
            if (col.getType() != DataType.LONG) continue;
            complexValFkCol = col;
        }
        if (pkCol == null || complexValFkCol == null) {
            throw new IOException("Could not find expected columns in flat table " + flatTable.getName() + " for complex column with id " + complexTypeId);
        }
        this._pkCol = pkCol;
        this._complexValFkCol = complexValFkCol;
    }

    public void postTableLoadInit() throws IOException {
    }

    public Column getColumn() {
        return this._column;
    }

    public Database getDatabase() {
        return this.getColumn().getDatabase();
    }

    public Column getPrimaryKeyColumn() {
        return this._pkCol;
    }

    public Column getComplexValueForeignKeyColumn() {
        return this._complexValFkCol;
    }

    protected List<Column> getTypeColumns() {
        return this._typeCols;
    }

    @Override
    public int countValues(int complexValueFk) throws IOException {
        return this.getRawValues(complexValueFk, Collections.singleton(this._complexValFkCol.getName())).size();
    }

    @Override
    public List<Row> getRawValues(int complexValueFk) throws IOException {
        return this.getRawValues(complexValueFk, null);
    }

    private Iterator<Row> getComplexValFkIter(int complexValueFk, Collection<String> columnNames) throws IOException {
        if (this._complexValIdCursor == null) {
            this._complexValIdCursor = this._flatTable.newCursor().setIndexByColumns(this._complexValFkCol).toIndexCursor();
        }
        return this._complexValIdCursor.newEntryIterable(complexValueFk).setColumnNames(columnNames).iterator();
    }

    @Override
    public List<Row> getRawValues(int complexValueFk, Collection<String> columnNames) throws IOException {
        Iterator<Row> entryIter = this.getComplexValFkIter(complexValueFk, columnNames);
        if (!entryIter.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<Row> values = new ArrayList<Row>();
        while (entryIter.hasNext()) {
            values.add(entryIter.next());
        }
        return values;
    }

    @Override
    public List<V> getValues(ComplexValueForeignKey complexValueFk) throws IOException {
        List<Row> rawValues = this.getRawValues(complexValueFk.get());
        if (rawValues.isEmpty()) {
            return Collections.emptyList();
        }
        return this.toValues(complexValueFk, rawValues);
    }

    protected List<V> toValues(ComplexValueForeignKey complexValueFk, List<Row> rawValues) throws IOException {
        ArrayList<V> values = new ArrayList<V>();
        for (Row rawValue : rawValues) {
            values.add(this.toValue(complexValueFk, rawValue));
        }
        return values;
    }

    @Override
    public ComplexValue.Id addRawValue(Map<String, ?> rawValue) throws IOException {
        Object[] row = ((TableImpl)this._flatTable).asRowWithRowId(rawValue);
        this._flatTable.addRow(row);
        return this.getValueId(row);
    }

    @Override
    public ComplexValue.Id addValue(V value) throws IOException {
        Object[] row = this.asRow(this.newRowArray(), value);
        this._flatTable.addRow(row);
        ComplexValueIdImpl id = this.getValueId(row);
        value.setId(id);
        return id;
    }

    @Override
    public void addValues(Collection<? extends V> values) throws IOException {
        for (ComplexValue value : values) {
            this.addValue(value);
        }
    }

    @Override
    public ComplexValue.Id updateRawValue(Row rawValue) throws IOException {
        this._flatTable.updateRow(rawValue);
        return this.getValueId(rawValue);
    }

    @Override
    public ComplexValue.Id updateValue(V value) throws IOException {
        ComplexValue.Id id = value.getId();
        this.updateRow(id, this.asRow(this.newRowArray(), value));
        return id;
    }

    @Override
    public void updateValues(Collection<? extends V> values) throws IOException {
        for (ComplexValue value : values) {
            this.updateValue(value);
        }
    }

    @Override
    public void deleteRawValue(Row rawValue) throws IOException {
        this.deleteRow(rawValue.getId());
    }

    @Override
    public void deleteValue(V value) throws IOException {
        this.deleteRow(value.getId().getRowId());
    }

    @Override
    public void deleteValues(Collection<? extends V> values) throws IOException {
        for (ComplexValue value : values) {
            this.deleteValue(value);
        }
    }

    @Override
    public void deleteAllValues(int complexValueFk) throws IOException {
        Iterator<Row> entryIter = this.getComplexValFkIter(complexValueFk, Collections.<String>emptySet());
        try {
            while (entryIter.hasNext()) {
                entryIter.next();
                entryIter.remove();
            }
        }
        catch (RuntimeIOException e) {
            throw (IOException)e.getCause();
        }
    }

    @Override
    public void deleteAllValues(ComplexValueForeignKey complexValueFk) throws IOException {
        this.deleteAllValues(complexValueFk.get());
    }

    private void updateRow(ComplexValue.Id id, Object[] row) throws IOException {
        ((TableImpl)this._flatTable).updateRow(id.getRowId(), row);
    }

    private void deleteRow(RowId rowId) throws IOException {
        ((TableImpl)this._flatTable).deleteRow(rowId);
    }

    protected ComplexValueIdImpl getValueId(Row row) {
        int idVal = (Integer)this.getPrimaryKeyColumn().getRowValue(row);
        return new ComplexValueIdImpl(idVal, row.getId());
    }

    protected ComplexValueIdImpl getValueId(Object[] row) {
        int idVal = (Integer)this.getPrimaryKeyColumn().getRowValue(row);
        return new ComplexValueIdImpl(idVal, ((TableImpl)this._flatTable).getRowId(row));
    }

    protected Object[] asRow(Object[] row, V value) throws IOException {
        ComplexValue.Id id = value.getId();
        this._pkCol.setRowValue(row, id != INVALID_ID ? id : Column.AUTO_NUMBER);
        ComplexValueForeignKey cFk = value.getComplexValueForeignKey();
        this._complexValFkCol.setRowValue(row, cFk != INVALID_FK ? cFk : Column.AUTO_NUMBER);
        return row;
    }

    private Object[] newRowArray() {
        Object[] row = new Object[this._flatTable.getColumnCount() + 1];
        row[row.length - 1] = ColumnImpl.RETURN_ROW_ID;
        return row;
    }

    public String toString() {
        return CustomToStringStyle.valueBuilder(this).append("complexType", (Object)this.getType()).append("complexTypeId", this._complexTypeId).toString();
    }

    protected static void diffFlatColumns(Table typeObjTable, Table flatTable, List<Column> typeCols, List<Column> otherCols) {
        for (Column column : flatTable.getColumns()) {
            if (((TableImpl)typeObjTable).hasColumn(column.getName())) {
                typeCols.add(column);
                continue;
            }
            otherCols.add(column);
        }
    }

    @Override
    public abstract ComplexDataType getType();

    protected abstract V toValue(ComplexValueForeignKey var1, Row var2) throws IOException;

    private static final class ComplexValueIdImpl
    extends ComplexValue.Id {
        private static final long serialVersionUID = 20130318L;
        private final int _value;
        private final RowId _rowId;

        protected ComplexValueIdImpl(int value, RowId rowId) {
            this._value = value;
            this._rowId = rowId;
        }

        public int get() {
            return this._value;
        }

        public RowId getRowId() {
            return this._rowId;
        }
    }

    protected static abstract class ComplexValueImpl
    implements ComplexValue {
        private ComplexValue.Id _id;
        private ComplexValueForeignKey _complexValueFk;

        protected ComplexValueImpl(ComplexValue.Id id, ComplexValueForeignKey complexValueFk) {
            this._id = id;
            this._complexValueFk = complexValueFk;
        }

        public ComplexValue.Id getId() {
            return this._id;
        }

        public void setId(ComplexValue.Id id) {
            if (this._id == id) {
                return;
            }
            if (this._id != INVALID_ID) {
                throw new IllegalStateException("id may not be reset");
            }
            this._id = id;
        }

        public ComplexValueForeignKey getComplexValueForeignKey() {
            return this._complexValueFk;
        }

        public void setComplexValueForeignKey(ComplexValueForeignKey complexValueFk) {
            if (this._complexValueFk == complexValueFk) {
                return;
            }
            if (this._complexValueFk != INVALID_FK) {
                throw new IllegalStateException("complexValueFk may not be reset");
            }
            this._complexValueFk = complexValueFk;
        }

        public Column getColumn() {
            return this._complexValueFk.getColumn();
        }

        public int hashCode() {
            return this._id.get() * 37 ^ this._complexValueFk.hashCode();
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this._id == ((ComplexValueImpl)o)._id && this._complexValueFk.equals(((ComplexValueImpl)o)._complexValueFk);
        }
    }
}

