/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.complex;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.complex.Attachment;
import com.healthmarketscience.jackcess.complex.AttachmentColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexDataType;
import com.healthmarketscience.jackcess.complex.ComplexValue;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.complex.MultiValueColumnInfo;
import com.healthmarketscience.jackcess.complex.SingleValue;
import com.healthmarketscience.jackcess.complex.UnsupportedColumnInfo;
import com.healthmarketscience.jackcess.complex.UnsupportedValue;
import com.healthmarketscience.jackcess.complex.Version;
import com.healthmarketscience.jackcess.complex.VersionHistoryColumnInfo;
import com.healthmarketscience.jackcess.impl.complex.AttachmentColumnInfoImpl;
import com.healthmarketscience.jackcess.impl.complex.MultiValueColumnInfoImpl;
import com.healthmarketscience.jackcess.impl.complex.UnsupportedColumnInfoImpl;
import com.healthmarketscience.jackcess.impl.complex.VersionHistoryColumnInfoImpl;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexValueForeignKeyImpl
extends ComplexValueForeignKey {
    private static final long serialVersionUID = 20110805L;
    private final transient Column _column;
    private final int _value;
    private transient List<? extends ComplexValue> _values;

    public ComplexValueForeignKeyImpl(Column column, int value) {
        this._column = column;
        this._value = value;
    }

    @Override
    public int get() {
        return this._value;
    }

    @Override
    public Column getColumn() {
        return this._column;
    }

    @Override
    public ComplexDataType getComplexType() {
        return this.getComplexInfo().getType();
    }

    protected ComplexColumnInfo<? extends ComplexValue> getComplexInfo() {
        return this._column.getComplexInfo();
    }

    protected VersionHistoryColumnInfo getVersionInfo() {
        return (VersionHistoryColumnInfo)this.getComplexInfo();
    }

    protected AttachmentColumnInfo getAttachmentInfo() {
        return (AttachmentColumnInfo)this.getComplexInfo();
    }

    protected MultiValueColumnInfo getMultiValueInfo() {
        return (MultiValueColumnInfo)this.getComplexInfo();
    }

    protected UnsupportedColumnInfo getUnsupportedInfo() {
        return (UnsupportedColumnInfo)this.getComplexInfo();
    }

    @Override
    public int countValues() throws IOException {
        return this.getComplexInfo().countValues(this.get());
    }

    public List<Row> getRawValues() throws IOException {
        return this.getComplexInfo().getRawValues(this.get());
    }

    @Override
    public List<? extends ComplexValue> getValues() throws IOException {
        if (this._values == null) {
            this._values = this.getComplexInfo().getValues(this);
        }
        return this._values;
    }

    @Override
    public List<Version> getVersions() throws IOException {
        if (this.getComplexType() != ComplexDataType.VERSION_HISTORY) {
            throw new UnsupportedOperationException();
        }
        return this.getValues();
    }

    @Override
    public List<Attachment> getAttachments() throws IOException {
        if (this.getComplexType() != ComplexDataType.ATTACHMENT) {
            throw new UnsupportedOperationException();
        }
        return this.getValues();
    }

    @Override
    public List<SingleValue> getMultiValues() throws IOException {
        if (this.getComplexType() != ComplexDataType.MULTI_VALUE) {
            throw new UnsupportedOperationException();
        }
        return this.getValues();
    }

    @Override
    public List<UnsupportedValue> getUnsupportedValues() throws IOException {
        if (this.getComplexType() != ComplexDataType.UNSUPPORTED) {
            throw new UnsupportedOperationException();
        }
        return this.getValues();
    }

    @Override
    public void reset() {
        this._values = null;
    }

    @Override
    public Version addVersion(String value) throws IOException {
        return this.addVersion(value, new Date());
    }

    @Override
    public Version addVersion(String value, Date modifiedDate) throws IOException {
        this.reset();
        Version v = VersionHistoryColumnInfoImpl.newVersion(this, value, modifiedDate);
        this.getVersionInfo().addValue(v);
        return v;
    }

    @Override
    public Attachment addAttachment(byte[] data) throws IOException {
        return this.addAttachment(null, null, null, data, null, null);
    }

    @Override
    public Attachment addAttachment(String url, String name, String type, byte[] data, Date timeStamp, Integer flags) throws IOException {
        this.reset();
        Attachment a = AttachmentColumnInfoImpl.newAttachment(this, url, name, type, data, timeStamp, flags);
        this.getAttachmentInfo().addValue(a);
        return a;
    }

    @Override
    public Attachment addEncodedAttachment(byte[] encodedData) throws IOException {
        return this.addEncodedAttachment(null, null, null, encodedData, null, null);
    }

    @Override
    public Attachment addEncodedAttachment(String url, String name, String type, byte[] encodedData, Date timeStamp, Integer flags) throws IOException {
        this.reset();
        Attachment a = AttachmentColumnInfoImpl.newEncodedAttachment(this, url, name, type, encodedData, timeStamp, flags);
        this.getAttachmentInfo().addValue(a);
        return a;
    }

    @Override
    public Attachment updateAttachment(Attachment attachment) throws IOException {
        this.reset();
        this.getAttachmentInfo().updateValue(attachment);
        return attachment;
    }

    @Override
    public Attachment deleteAttachment(Attachment attachment) throws IOException {
        this.reset();
        this.getAttachmentInfo().deleteValue(attachment);
        return attachment;
    }

    @Override
    public SingleValue addMultiValue(Object value) throws IOException {
        this.reset();
        SingleValue v = MultiValueColumnInfoImpl.newSingleValue(this, value);
        this.getMultiValueInfo().addValue(v);
        return v;
    }

    @Override
    public SingleValue updateMultiValue(SingleValue value) throws IOException {
        this.reset();
        this.getMultiValueInfo().updateValue(value);
        return value;
    }

    @Override
    public SingleValue deleteMultiValue(SingleValue value) throws IOException {
        this.reset();
        this.getMultiValueInfo().deleteValue(value);
        return value;
    }

    @Override
    public UnsupportedValue addUnsupportedValue(Map<String, ?> values) throws IOException {
        this.reset();
        UnsupportedValue v = UnsupportedColumnInfoImpl.newValue(this, values);
        this.getUnsupportedInfo().addValue(v);
        return v;
    }

    @Override
    public UnsupportedValue updateUnsupportedValue(UnsupportedValue value) throws IOException {
        this.reset();
        this.getUnsupportedInfo().updateValue(value);
        return value;
    }

    @Override
    public UnsupportedValue deleteUnsupportedValue(UnsupportedValue value) throws IOException {
        this.reset();
        this.getUnsupportedInfo().deleteValue(value);
        return value;
    }

    @Override
    public void deleteAllValues() throws IOException {
        this.reset();
        this.getComplexInfo().deleteAllValues(this);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this._column == ((ComplexValueForeignKeyImpl)o)._column;
    }
}

