/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;

public final class DefinitionURI {
    public static final String PREFIX = "urn:ogc:def";
    public static final char SEPARATOR = ':';
    public static final char COMPONENT_SEPARATOR = ',';
    private static final char COMPONENT_SEPARATOR_1 = '?';
    private static final char COMPONENT_SEPARATOR_2 = '&';
    private static final char KEY_VALUE_SEPARATOR = '=';
    public static final String DOMAIN = "www.opengis.net";
    private static final Map<String, String> PATHS = Collections.singletonMap("crs", "//www.opengis.net/gml/srs/");
    public static final String NO_VERSION = "0";
    public boolean isHTTP;
    public boolean isGML;
    public String type;
    public String authority;
    public String version;
    public String code;
    public String[] parameters;
    public DefinitionURI[] components;

    private DefinitionURI() {
    }

    public static DefinitionURI parse(String string) {
        ArgumentChecks.ensureNonNull("uri", string);
        return DefinitionURI.parse(string, false, -1, string.length());
    }

    private static DefinitionURI parse(String string, boolean bl, int n, int n2) {
        DefinitionURI definitionURI = null;
        int n3 = 58;
        int n4 = 44;
        block14: for (int i = 0; i <= 6; ++i) {
            int n5 = n + 1;
            if (((n = string.indexOf(n3, n5)) < 0 || n >= n2) && n5 > (n = n2)) {
                return definitionURI;
            }
            switch (i) {
                case 0: {
                    if (DefinitionURI.regionMatches("http", string, n5, n)) {
                        definitionURI = new DefinitionURI();
                        definitionURI.isHTTP = true;
                        if (DefinitionURI.codeForGML(null, null, string, ++n, definitionURI) != null) {
                            return definitionURI;
                        }
                        if (!string.regionMatches(n, "//", 0, 2)) {
                            return null;
                        }
                        ++n;
                        n3 = 47;
                        n4 = 63;
                        bl = false;
                        continue block14;
                    }
                    if (DefinitionURI.regionMatches("urn", string, n5, n)) {
                        bl = false;
                        continue block14;
                    }
                    if (!bl) {
                        return null;
                    }
                    ++i;
                }
                case 1: {
                    int n6 = n3 != 58 ? 1 : 0;
                    if (DefinitionURI.regionMatches(n6 != 0 ? DOMAIN : "ogc", string, n5, n) || n6 == 0 && DefinitionURI.regionMatches("x-ogc", string, n5, n)) {
                        bl = false;
                        continue block14;
                    }
                    if (!bl) {
                        return null;
                    }
                    ++i;
                }
                case 2: {
                    if (DefinitionURI.regionMatches("def", string, n5, n)) {
                        bl = false;
                        continue block14;
                    }
                    if (!bl) {
                        return null;
                    }
                    ++i;
                }
                case 3: {
                    int n6 = string.indexOf(n4, n5);
                    if (n6 >= 0 && n6 < n2) {
                        boolean bl2;
                        int n7 = n2;
                        n2 = n6;
                        if (n2 < n) {
                            n = n2;
                        }
                        if (n4 == 63) {
                            n4 = 38;
                        }
                        if (definitionURI == null) {
                            definitionURI = new DefinitionURI();
                        }
                        boolean bl3 = !definitionURI.isHTTP;
                        TreeMap<Integer, DefinitionURI> treeMap = new TreeMap<Integer, DefinitionURI>();
                        do {
                            int n8;
                            boolean bl4 = bl2 = (n8 = string.indexOf(n4, n6 + 1)) >= 0 && n8 < n7;
                            if (!bl2) {
                                n8 = n7;
                            }
                            int n9 = treeMap.size() + 1;
                            int n10 = DefinitionURI.splitKeyValue(string, n6 + 1, n8);
                            if (n10 >= 0) {
                                try {
                                    n9 = Integer.parseInt(CharSequences.trimWhitespaces(string, n6 + 1, n10).toString());
                                    n6 = n10;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.factory"), DefinitionURI.class, "parse", numberFormatException);
                                }
                            }
                            treeMap.put(n9, DefinitionURI.parse(string, bl3, n6, n8));
                            n6 = n8;
                        } while (bl2);
                        definitionURI.components = treeMap.values().toArray(new DefinitionURI[treeMap.size()]);
                    }
                }
                default: {
                    String string2 = CharSequences.trimWhitespaces(string, n5, n).toString();
                    if (string2.isEmpty() || i == 5 && NO_VERSION.equals(string2)) continue block14;
                    if (definitionURI == null) {
                        definitionURI = new DefinitionURI();
                    }
                    switch (i) {
                        case 3: {
                            definitionURI.type = string2;
                            continue block14;
                        }
                        case 4: {
                            definitionURI.authority = string2;
                            continue block14;
                        }
                        case 5: {
                            definitionURI.version = string2;
                            continue block14;
                        }
                        case 6: {
                            definitionURI.code = string2;
                            continue block14;
                        }
                    }
                    throw new AssertionError(i);
                }
            }
        }
        if (definitionURI != null && ++n < n2) {
            definitionURI.parameters = (String[])CharSequences.split(string.substring(n), (char)n3);
        }
        return definitionURI;
    }

    static boolean regionMatches(String string, String string2, int n, int n2) {
        int n3 = (n2 = CharSequences.skipTrailingWhitespaces(string2, n = CharSequences.skipLeadingWhitespaces(string2, n, n2), n2)) - n;
        return n3 == string.length() && string2.regionMatches(true, n, string, 0, n3);
    }

    private static int splitKeyValue(String string, int n, int n2) {
        while (n < n2) {
            int n3 = string.codePointAt(n);
            if (!(n3 >= 48 && n3 <= 57 || Character.isWhitespace(n3))) {
                if (n3 != 61) break;
                return n;
            }
            n += Character.charCount(n3);
        }
        return -1;
    }

    private static String codeIgnoreVersion(String string, int n) {
        int n2 = string.length();
        if ((n = CharSequences.skipLeadingWhitespaces(string, n, n2)) >= n2) {
            return null;
        }
        int n3 = string.indexOf(58, n);
        if (n3 >= 0 && ((n = CharSequences.skipLeadingWhitespaces(string, n3 + 1, n2)) >= n2 || string.indexOf(58, n) >= 0)) {
            return null;
        }
        return string.substring(n, CharSequences.skipTrailingWhitespaces(string, n, n2));
    }

    public static String codeOf(String string, String string2, String string3) {
        String string4;
        ArgumentChecks.ensureNonNull("type", string);
        ArgumentChecks.ensureNonNull("authority", string2);
        ArgumentChecks.ensureNonNull("uri", string3);
        int n = string3.indexOf(58);
        if (n < 0) {
            return CharSequences.trimWhitespaces(string3);
        }
        int n2 = CharSequences.skipLeadingWhitespaces(string3, 0, n);
        int n3 = CharSequences.skipTrailingWhitespaces(string3, n2, n) - n2;
        if (n3 == string2.length() && string3.regionMatches(true, n2, string2, 0, n3)) {
            return DefinitionURI.codeIgnoreVersion(string3, n + 1);
        }
        switch (n3) {
            case 3: {
                string4 = "urn";
                break;
            }
            case 4: {
                string4 = "http";
                break;
            }
            default: {
                return null;
            }
        }
        if (!string3.regionMatches(true, n2, string4, 0, n3)) {
            return null;
        }
        if (n3 == 4) {
            return DefinitionURI.codeForGML(string, string2, string3, n + 1, null);
        }
        block10: for (int i = 0; i != 4; ++i) {
            n2 = n + 1;
            if ((n = string3.indexOf(58, n2)) < 0) {
                return null;
            }
            switch (i) {
                case 0: {
                    if (DefinitionURI.regionMatches("ogc", string3, n2, n)) continue block10;
                    string4 = "x-ogc";
                    break;
                }
                case 1: {
                    string4 = "def";
                    break;
                }
                case 2: {
                    string4 = string;
                    break;
                }
                case 3: {
                    string4 = string2;
                    break;
                }
                default: {
                    throw new AssertionError(i);
                }
            }
            if (DefinitionURI.regionMatches(string4, string3, n2, n)) continue;
            return null;
        }
        return DefinitionURI.codeIgnoreVersion(string3, n + 1);
    }

    private static String codeForGML(String string, String string2, String string3, int n, DefinitionURI definitionURI) {
        Object object;
        Map<String, String> map = PATHS;
        if (string != null && (object = map.get(string)) == null) {
            return null;
        }
        block4: for (Map.Entry entry : map.entrySet()) {
            int n2;
            String string4 = (String)entry.getValue();
            if (!string3.regionMatches(true, n, string4, 0, string4.length())) continue;
            n = CharSequences.skipLeadingWhitespaces(string3, n + string4.length(), string3.length());
            if (string2 == null) {
                string2 = string3.substring(n, DefinitionURI.skipIdentifierPart(string3, n));
            } else if (!string3.regionMatches(true, n, string2, 0, string2.length())) continue;
            if ((n += string2.length()) >= (n2 = string3.length())) continue;
            switch (string3.charAt(n)) {
                case '.': {
                    n = string3.indexOf(35, n + 1);
                    if (n < 0) continue block4;
                }
                case '#': {
                    String string5 = CharSequences.trimWhitespaces(string3, n + 1, n2).toString();
                    if (definitionURI != null) {
                        definitionURI.isGML = true;
                        definitionURI.type = (String)entry.getKey();
                        definitionURI.authority = string2;
                        definitionURI.code = string5;
                    }
                    return string5;
                }
            }
        }
        return null;
    }

    private static int skipIdentifierPart(String string, int n) {
        int n2;
        while (n < string.length() && Character.isUnicodeIdentifierPart(n2 = string.codePointAt(n))) {
            n += Character.charCount(n2);
        }
        return n;
    }

    public String toString() {
        CharSequence charSequence;
        if (this.isGML && (charSequence = PATHS.get(this.type)) != null) {
            return "http:" + (String)charSequence + this.authority + ".xml#" + this.code;
        }
        charSequence = new StringBuilder(40);
        if (!this.isHTTP) {
            ((StringBuilder)charSequence).append(PREFIX);
        }
        this.toString((StringBuilder)charSequence, ':');
        return ((StringBuilder)charSequence).toString();
    }

    private void toString(StringBuilder stringBuilder, char c) {
        int n;
        if (this.isHTTP) {
            stringBuilder.append("http://").append(DOMAIN).append("/def");
            c = (char)47;
        }
        int n2 = 4;
        if (this.parameters != null) {
            n2 += this.parameters.length;
        }
        for (n = 0; n < n2; ++n) {
            String string;
            switch (n) {
                case 0: {
                    string = this.type;
                    break;
                }
                case 1: {
                    string = this.authority;
                    break;
                }
                case 2: {
                    string = this.version;
                    break;
                }
                case 3: {
                    string = this.code;
                    break;
                }
                default: {
                    string = this.parameters[n - 4];
                }
            }
            stringBuilder.append(c);
            if (this.isHTTP) {
                if (string == null) {
                    string = NO_VERSION;
                }
            } else {
                c = (char)58;
                if (string == null) continue;
            }
            stringBuilder.append(string);
        }
        n = stringBuilder.length();
        int n3 = n2 = this.isHTTP ? 2 : 1;
        while (!((n -= n2) < 0 || stringBuilder.charAt(n) != c || this.isHTTP && stringBuilder.charAt(n + 1) != NO_VERSION.charAt(0))) {
            stringBuilder.setLength(n);
        }
        if (this.components != null) {
            int n4 = 0;
            while (n4 < this.components.length) {
                DefinitionURI definitionURI = this.components[n4++];
                if (this.isHTTP) {
                    stringBuilder.append(n4 == 1 ? (char)'?' : '&').append(n4).append('=');
                }
                definitionURI.toString(stringBuilder, ',');
            }
        }
    }
}

