/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xwpf;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XWPFStylesShim {
    public static XWPFStylesShim EMPTY_STYLES = new EmptyXWPFStyles();
    private Map<String, String> styles = new HashMap<String, String>();

    private XWPFStylesShim() {
    }

    public XWPFStylesShim(PackagePart part, ParseContext parseContext) throws IOException, TikaException, SAXException {
        try (InputStream is = part.getInputStream();){
            this.onDocumentLoad(parseContext, is);
        }
    }

    private void onDocumentLoad(ParseContext parseContext, InputStream stream) throws TikaException, IOException, SAXException {
        XMLReaderUtils.parseSAX(stream, new OfflineContentHandler(new StylesStripper()), parseContext);
    }

    public String getStyleName(String styleId) {
        if (styleId == null) {
            return null;
        }
        return this.styles.get(styleId);
    }

    private class StylesStripper
    extends DefaultHandler {
        String currentStyleId = null;

        private StylesStripper() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (uri == null || "http://schemas.openxmlformats.org/wordprocessingml/2006/main".equals(uri)) {
                if ("style".equals(localName)) {
                    this.currentStyleId = atts.getValue("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "styleId");
                } else if ("name".equals(localName)) {
                    String name = atts.getValue("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "val");
                    if (this.currentStyleId != null && name != null) {
                        XWPFStylesShim.this.styles.put(this.currentStyleId, name);
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ((uri == null || "http://schemas.openxmlformats.org/wordprocessingml/2006/main".equals(uri)) && "style".equals(localName)) {
                this.currentStyleId = null;
            }
        }
    }

    private static class EmptyXWPFStyles
    extends XWPFStylesShim {
        private EmptyXWPFStyles() {
        }

        @Override
        public String getStyleName(String styleId) {
            return null;
        }
    }
}

