/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp4;

import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class DirectFileReadDataSource
implements DataSource {
    private static final int TRANSFER_SIZE = 8192;
    private RandomAccessFile raf;

    public DirectFileReadDataSource(File f) throws IOException {
        this.raf = new RandomAccessFile(f, "r");
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int bytesToRead;
        int totalRead;
        int len = byteBuffer.remaining();
        int bytesRead = 0;
        byte[] buf = new byte[8192];
        for (totalRead = 0; totalRead < len && (bytesRead = this.raf.read(buf, 0, bytesToRead = Math.min(len - totalRead, 8192))) >= 0; totalRead += bytesRead) {
            byteBuffer.put(buf, 0, bytesRead);
        }
        if (bytesRead < 0 && this.position() == this.size() && byteBuffer.hasRemaining()) {
            throw new IOException("End of stream reached earlier than expected");
        }
        return bytesRead < 0 && totalRead == 0 ? -1 : totalRead;
    }

    public int readAllInOnce(ByteBuffer byteBuffer) throws IOException {
        if ((long)byteBuffer.remaining() > this.raf.length()) {
            throw new IOException("trying to readAllInOnce past end of stream");
        }
        byte[] buf = new byte[byteBuffer.remaining()];
        int read = this.raf.read(buf);
        byteBuffer.put(buf, 0, read);
        return read;
    }

    @Override
    public long size() throws IOException {
        return this.raf.length();
    }

    @Override
    public long position() throws IOException {
        return this.raf.getFilePointer();
    }

    @Override
    public void position(long nuPos) throws IOException {
        if (nuPos > this.raf.length()) {
            throw new IOException("requesting seek past end of stream");
        }
        this.raf.seek(nuPos);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return target.write(this.map(position, count));
    }

    @Override
    public ByteBuffer map(long startPosition, long size) throws IOException {
        if (startPosition < 0L || size < 0L) {
            throw new IOException("startPosition and size must both be >= 0");
        }
        BigInteger end = BigInteger.valueOf(startPosition);
        if ((end = end.add(BigInteger.valueOf(size))).compareTo(BigInteger.valueOf(this.raf.length())) > 0) {
            throw new IOException("requesting read past end of stream");
        }
        this.raf.seek(startPosition);
        int payLoadSize = CastUtils.l2i(size);
        if (Long.MAX_VALUE - (long)payLoadSize < startPosition || Long.MAX_VALUE - (long)payLoadSize > this.raf.length()) {
            throw new IOException("requesting read past end of stream");
        }
        byte[] payload = new byte[payLoadSize];
        this.raf.readFully(payload);
        return ByteBuffer.wrap(payload);
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }
}

