/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.List;
import org.couchbase.mock.memcached.BinaryProtocolHandler;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.OutputContext;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.CommandFactory;

class MemcachedConnection {
    private final BinaryProtocolHandler protocolHandler;
    private final byte[] header;
    private BinaryCommand command;
    private final ByteBuffer input;
    private List<ByteBuffer> pending = new LinkedList<ByteBuffer>();
    private boolean authenticated;
    private boolean closed = false;

    public MemcachedConnection(MemcachedServer server) {
        this.authenticated = server.getBucket().getPassword().length() <= 0;
        this.header = new byte[24];
        this.input = ByteBuffer.wrap(this.header);
        this.protocolHandler = server.getProtocolHandler();
    }

    public void step() throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (this.input.position() == this.header.length) {
            if (this.command == null) {
                this.command = CommandFactory.create(this.input);
            }
            if (this.command.complete()) {
                this.command.process();
                this.protocolHandler.execute(this.command, this);
                this.command = null;
                this.input.rewind();
            }
        }
    }

    public synchronized void sendResponse(BinaryResponse response) {
        if (this.pending == null) {
            this.pending = new LinkedList<ByteBuffer>();
        }
        this.pending.add(response.getBuffer());
    }

    boolean hasOutput() {
        if (this.pending == null) {
            return false;
        }
        if (this.pending.isEmpty()) {
            return false;
        }
        return this.pending.get(0).hasRemaining();
    }

    public ByteBuffer getInputBuffer() {
        if (this.command == null) {
            return this.input;
        }
        return this.command.getInputBuffer();
    }

    public OutputContext borrowOutputContext() {
        if (!this.hasOutput()) {
            return null;
        }
        OutputContext ctx = new OutputContext(this.pending);
        this.pending = null;
        return ctx;
    }

    public void returnOutputContext(OutputContext ctx) {
        List<ByteBuffer> remaining = ctx.releaseRemaining();
        if (this.pending == null) {
            this.pending = remaining;
        } else {
            List<ByteBuffer> tmp = this.pending;
            this.pending = remaining;
            this.pending.addAll(tmp);
        }
    }

    void shutdown() {
        this.closed = true;
    }

    void setAuthenticated() {
        this.authenticated = true;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }
}

