package IO::K8s::Api::Batch::V1::CronJobStatus;
# ABSTRACT: CronJobStatus represents the current state of a cron job.
our $VERSION = '1.000';
use IO::K8s::Resource;

k8s active => ['Core::V1::ObjectReference'];


k8s lastScheduleTime => Str;


k8s lastSuccessfulTime => Str;


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::K8s::Api::Batch::V1::CronJobStatus - CronJobStatus represents the current state of a cron job.

=head1 VERSION

version 1.000

=head2 active

A list of pointers to currently running jobs.

=head2 lastScheduleTime

Information when was the last time the job was successfully scheduled.

=head2 lastSuccessfulTime

Information when was the last time the job successfully completed.

=head1 SUPPORT

=head2 Issues

Please report bugs and feature requests on GitHub at
L<https://github.com/pplu/io-k8s-p5/issues>.

=head2 IRC

Join C<#kubernetes> on C<irc.perl.org> or message Getty directly.

=head1 CONTRIBUTING

Contributions are welcome! Please fork the repository and submit a pull request.

=head1 AUTHORS

=over 4

=item *

Torsten Raudssus <torsten@raudssus.de>

=item *

Jose Luis Martinez <jlmartinez@capside.com> (original author, inactive)

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by CAPSiDE.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
