use v6;

use Test;

use LibCurl::Test;
use LibCurl::Easy;

plan 6;

my $outjar will leave { unlink $_ } = 'jar61.txt';

my $server = LibCurl::Test.new;

$server.start;

my $curl = LibCurl::Easy.new(URL => "http://$HOSTIP:$HTTPPORT/we/want/61",
                             Host => 'www.host.foo.com',
                             cookiejar => $outjar).perform;

is $curl.response-code, 200, 'response-code';

is $curl.statusline, 'HTTP/1.1 200 OK', 'statusline';

is $server.input,
"GET /we/want/61 HTTP/1.1
Accept: */*
Host: www.host.foo.com

", 'input';

is $curl.content, "boo\n", 'content';

is $curl.cookielist,
[
    "#HttpOnly_.foo.com	TRUE	/we/want/	FALSE	2054030187	test	yes",
    ".host.foo.com	TRUE	/we/want/	FALSE	2054030187	test2	yes",
    ".foo.com	TRUE	/moo	TRUE	0	test3	maybe"
], 'cookie list';

$curl.cleanup;  # Force write of cookie jar

is $outjar.IO.slurp, 
"# Netscape HTTP Cookie File
# http://curl.haxx.se/docs/http-cookies.html
# This file was generated by libcurl! Edit at your own risk.

#HttpOnly_.foo.com	TRUE	/we/want/	FALSE	2054030187	test	yes
.host.foo.com	TRUE	/we/want/	FALSE	2054030187	test2	yes
.foo.com	TRUE	/moo	TRUE	0	test3	maybe
", 'cookie jar';

done-testing;
