#! perl

use v5.20;
use strict;
use experimental 'signatures';

use Term::Table;
use Ref::Util 'is_hashref', 'is_arrayref';
use CXC::Data::Visitor 'visit', -results;
use DDP;

my %struct = (
    fruit => {
        berry  => 'purple',
        apples => [ 'fuji', 'macoun' ],
    } );

my @rows;
my $revisit = 0;
visit(
    \%struct,
    sub ( $, $vref, $, $metadata ) {
        my $path;
        my $ref = \%struct;
        for my $kydx ( $metadata->{path}->@* ) {
            if ( is_hashref( $ref ) ) {
                $path .= "{$kydx}";
                $ref = $ref->{$kydx};
            }
            elsif ( is_arrayref( $ref ) ) {
                $path .= "[$kydx]";
                $ref = $ref->[$kydx];
            }
        }
        push @rows, [ '$struct' . $path, $vref->$* ];
        return $path eq '{fruit}{apples}[1]' && !$revisit++ ? RESULT_REVISIT_CONTAINER : RESULT_CONTINUE;
    } );

my $table = Term::Table->new(
    header => [ 'Path', 'Value' ],
    rows   => \@rows,
);

say "  $_" for $table->render;
