#!/usr/bin/perl
#
# make_Config.pl for Mail::SpamCannibal
# version 1.00, 7-30-03
#
# Copyright 2003, Michael Robinton <michael@bizsystems.com>
# rc.dbtarpit is free software; you can redistribute it and/or
# modify it under the terms of the GPL software license.
#
use strict;
use lib qw(blib/lib);
use IPTables::IPv4::DBTarpit::Inst qw(hard_fail);

my $conf = 'config.db';
my $perlmod = 'SiteConfig';

hard_fail("could not find $conf")
	unless -e $conf;

hard_fail("could not open $conf")
	unless open(R,$conf);

unless (open(W,'>'.$perlmod.'.pm')) {
  close R;
  hard_fail("could not open $perlmod.pm for write");
}

my $txt = '';
while ($_ = <R>) {
   last if $_ =~ /CONFIG/;
}
do {
  $txt .= '  '. $_;
} while ($_ = <R>);

close R;

print W qq|package Mail::SpamCannibal::$perlmod;
#
# |, scalar localtime(), qq|
#
# This file was automatically generated by $0
#
# Don't edit this file, edit $0 instead.
#|, q|
use strict;
use vars qw($VERSION);

$VERSION = '0.01';	# 7-23-03

sub new {
  my($proto) = @_;
  my $class = ref($proto) |. '||'. q| $proto;
|, $txt, q
|  bless ($CONFIG,$class);
  return $CONFIG;
}

=head1 NAME

Mail::SpamCannibal::SiteConfig - configuration info for SpamCannibal

=head1 SYNOPSIS

  use Mail::SpamCannibal::SiteConfig;

  $hashref = new Mail::SpamCannibal::SiteConfig;

=head1 DESCRIPTION

This module returns a hash pointer to the configuration information used to
intall SpamCannibal. The values shown below are what was configured when
SpamCannibal was installed for this site.

|, $txt, q|
=head1 EXPORT

	none

=head1 COPYRIGHT

Copyright 2003, Michael Robinton <michael@bizsystems.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

=head1 AUTHOR

Michael Robinton <michael@bizsystems.com>

=head1 SEE ALSO

L<Mail::SpamCannibal>,
L<IPTables::IPv4::DBTarpit>
|;
close W;
1;
