/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * WARNING: This file is automatically generated by
 * generate_GrFreqXlatingFIRfilterXXX.py Any changes made to this file
 * will be overwritten.
 */

#include <@NAME@.h>
#include <gr_fir_util.h>
#include <@FIR_TYPE@.h>

@NAME@::@NAME@ (

	int decimation_factor,
	const std::vector<@TAP_TYPE@> &taps,
	float center_freq)

  : VrDecimatingSigProc<@I_TYPE@, @O_TYPE@>(1, decimation_factor),
    d_builder (0), d_proto_taps (taps), d_center_freq (center_freq),
    d_updated (0)
{
  std::vector<VrComplex>	dummy_taps;
  d_composite_fir = gr_fir_util::create_@FIR_TYPE@ (dummy_taps);
}

@NAME@::@NAME@ (

	int decimation_factor,
	@FIR_BUILDER@ *builder,
	float center_freq)

  : VrDecimatingSigProc<@I_TYPE@, @O_TYPE@>(1, decimation_factor),
    d_builder (builder), d_center_freq (center_freq),
    d_updated (0)
{
  std::vector<VrComplex>	dummy_taps;
  d_composite_fir = gr_fir_util::create_@FIR_TYPE@ (dummy_taps);
}

@NAME@::~@NAME@ ()
{
  delete d_composite_fir;
  delete d_builder;
}

void
@NAME@::initialize ()
{
  if (d_builder)
    d_proto_taps = d_builder->taps (getInputSamplingFrequencyN (0));

  history = d_proto_taps.size ();
  build_composite_fir ();
}

void
@NAME@::build_composite_fir ()
{
  std::vector<VrComplex> ctaps (d_proto_taps.size ());

  float fwT0 = 2 * M_PI * d_center_freq / getInputSamplingFrequencyN (0);
  for (unsigned int i = 0; i < d_proto_taps.size (); i++)
    ctaps[i] = d_proto_taps[i] * exp (VrComplex (0, i * fwT0));

  d_composite_fir->set_taps (ctaps);
  d_r.set_phase_incr (exp (VrComplex (0, fwT0 * decimation)));
}

void
@NAME@::setCenterFreq (float center_freq)
{
  d_center_freq = center_freq;
  d_updated = 1;
}

void
@NAME@::setTaps (const std::vector<@TAP_TYPE@> &taps)
{
  delete d_builder;		// if you're setting taps, you're not using the builder
  d_builder = 0;
  d_proto_taps = taps;
  d_updated = 1;
}

int
@NAME@::work (VrSampleRange output, void *ao[],
		           VrSampleRange inputs[], void *ai[])
{
  @I_TYPE@     *in  = (@I_TYPE@ *) ai[0];
  @O_TYPE@     *out = (@O_TYPE@ *) ao[0];

  // rebuild composite FIR if the center freq has changed

  if (d_updated){
    initialize ();
    d_updated = 0;
  }

  unsigned j = 0;
  for (unsigned i = 0; i < output.size; i++){
    out[i] = d_r.rotate (d_composite_fir->filter (&in[j]));
    j += decimation;
  }
  
  return output.size;
}
