/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gr_fir_SIS_generic.h>

#if (4 == 4)

int
gr_fir_SIS_generic::filter (const short input[])
{
  static const int N_UNROLL = 4;

  int	acc0 = 0;
  int	acc1 = 0;
  int	acc2 = 0;
  int	acc3 = 0;


  unsigned	i = 0;
  unsigned	n = (ntaps () / N_UNROLL) * N_UNROLL;

  for (i = 0; i < n; i += N_UNROLL){
    acc0 += d_taps[i + 0] * input[i + 0];
    acc1 += d_taps[i + 1] * input[i + 1];
    acc2 += d_taps[i + 2] * input[i + 2];
    acc3 += d_taps[i + 3] * input[i + 3];
  }

  for (; i < ntaps (); i++)
    acc0 += d_taps[i] * input[i];

  return (int) (acc0 + acc1 + acc2 + acc3);
}

#else 

int
gr_fir_SIS_generic::filter (const short input[])
{
  static const int N_UNROLL = 2;

  int	acc0 = 0;
  int	acc1 = 0;

  unsigned	i = 0;
  unsigned	n = (ntaps () / N_UNROLL) * N_UNROLL;

  for (i = 0; i < n; i += N_UNROLL){
    acc0 += d_taps[i + 0] * input[i + 0];
    acc1 += d_taps[i + 1] * input[i + 1];
  }

  for (; i < ntaps (); i++)
    acc0 += d_taps[i] * input[i];

  return (int) (acc0 + acc1);
}

#endif // N_UNROLL

void 
gr_fir_SIS_generic::filterN (int output[],
			     const short input[],
			     unsigned long n)
{
  for (unsigned i = 0; i < n; i++)
    output[i] = filter (&input[i]);
}

void 
gr_fir_SIS_generic::filterNdec (int output[],
				const short input[],
				unsigned long n,
				unsigned decimate)
{
  unsigned j = 0;
  for (unsigned i = 0; i < n; i++){
    output[i] = filter (&input[j]);
    j += decimate;
  }
}
