/* -*- Mode: c++ -*- 
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRQUADRATUREDEMOD_H_
#define _VRQUADRATUREDEMOD_H_

#include <VrHistoryProc.h>
#include <math.h>

template<class oType> 
class VrQuadratureDemod : public VrHistoryProc<complex,oType> {
protected:
  float gain;
public:
  virtual const char *name() { return "VrQuadratureDemod"; }
  void setGain(float g){ gain = g; return;}
  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);
  virtual void initialize();
  VrQuadratureDemod(oType g);
  VrQuadratureDemod();
};

template<class oType> int
VrQuadratureDemod<oType>::work(VrSampleRange output, void *ao[],
				VrSampleRange inputs[], void *ai[])
{
  complex **i = (complex **)ai;
  oType **o = (oType **)ao;
  complex product,val;
  complex lastVal = *i[0]++;
  unsigned int size=output.size;

  for (; size>0; i[0]++,size--) {
    val = *i[0];
    product = val * conj(lastVal);
    lastVal = val;
    *o[0]++=(oType)(gain * arg(product));
  }
  return output.size;
}

template<class oType> void
VrQuadratureDemod<oType>::initialize()
{
  history=2;
}

template<class oType> 
VrQuadratureDemod<oType>::VrQuadratureDemod(oType g)
  : VrHistoryProc<complex, oType>(1), gain(g)
{
}

#if 0 /* jca */
template<class oType> 
VrQuadratureDemod<oType>::VrQuadratureDemod()
  :gain(1)
{
}
#endif
#endif
