#include "TVTuner.h"

const double audioOffset = 1.25;

const double channelMap[82] =
{
  58.5, 64.5, 70.5, 80.5, 86.5,
  178.5, 184.5, 190.5, 196.5, 202.5, 
  208.5, 214.5, 474.5, 480.5, 486.5,
  492.5, 498.5, 504.5, 510.5, 516.5, 
  522.5, 528.5, 534.5, 540.5, 546.5, 
  552.5, 558.5, 564.5, 570.5, 576.5, 
  582.5, 588.5, 594.5, 600.5, 606.5, 
  612.5, 618.5, 624.5, 630.5, 636.5, 
  642.5, 648.5, 654.5, 660.5, 666.5, 
  672.5, 678.5, 684.5, 690.5, 696.5, 
  702.5, 708.5, 714.5, 720.5, 726.5,
  732.5, 738.5, 744.5, 750.5, 756.5,
  762.5, 768.5, 774.5, 780.5, 786.5,
  792.5, 798.5, 804.5, 810.5, 816.5,
  822.5, 828.5, 834.5, 838.5, 846.5,
  852.5, 858.5, 864.5, 868.8, 876.5,
  882.5, 888.5
};

TVTuner::TVTuner(QObject *parent, const char *name) :
  Tuner(2, 83, 2, parent, name)
{}

double
TVTuner::frequency() const
{ return channelMap[chan-2]; }

double
TVTuner::audioFrequency() const
{ return frequency() + audioOffset; }
