/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools.jcore;

import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.jvm.hotspot.interpreter.Bytecodes;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.ConstantPoolCache;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.Bytes;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Assert;

public class ByteCodeRewriter {
    private Method method;
    private ConstantPool cpool;
    private ConstantPoolCache cpCache;
    private byte[] code;
    private Bytes bytes;
    private static final int jintSize = 4;
    public static final boolean DEBUG;

    protected void debugMessage(String message) {
        System.out.println(message);
    }

    public ByteCodeRewriter(Method method, ConstantPool cpool, byte[] code) {
        this.method = method;
        this.cpool = cpool;
        this.cpCache = cpool.getCache();
        this.code = code;
        this.bytes = VM.getVM().getBytes();
    }

    protected short getConstantPoolIndexFromRefMap(int rawcode, int bci) {
        int refIndex;
        String fmt = Bytecodes.format(rawcode);
        switch (fmt.length()) {
            case 2: {
                refIndex = 0xFF & this.method.getBytecodeByteArg(bci);
                break;
            }
            case 3: {
                refIndex = 0xFFFF & this.bytes.swapShort(this.method.getBytecodeShortArg(bci));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return (short)this.cpool.objectToCPIndex(refIndex);
    }

    protected short getConstantPoolIndex(int rawcode, int bci) {
        int cpCacheIndex;
        String fmt = Bytecodes.format(rawcode);
        switch (fmt.length()) {
            case 2: {
                cpCacheIndex = this.method.getBytecodeByteArg(bci);
                break;
            }
            case 3: {
                cpCacheIndex = this.method.getBytecodeShortArg(bci);
                break;
            }
            case 5: {
                if (fmt.indexOf("__") >= 0) {
                    cpCacheIndex = this.method.getBytecodeShortArg(bci);
                    break;
                }
                cpCacheIndex = this.method.getBytecodeIntArg(bci);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (this.cpCache == null) {
            return (short)cpCacheIndex;
        }
        if (fmt.indexOf("JJJJ") >= 0) {
            cpCacheIndex ^= 0xFFFFFFFF;
            cpCacheIndex = this.bytes.swapInt(cpCacheIndex);
            return (short)this.cpCache.getEntryAt(cpCacheIndex).getConstantPoolIndex();
        }
        if (fmt.indexOf("JJ") >= 0) {
            return (short)this.cpCache.getEntryAt(0xFFFF & this.bytes.swapShort((short)cpCacheIndex)).getConstantPoolIndex();
        }
        if (fmt.indexOf("j") >= 0) {
            return (short)this.cpCache.getEntryAt(0xFF & cpCacheIndex).getConstantPoolIndex();
        }
        return (short)cpCacheIndex;
    }

    private static void writeShort(byte[] buf, int index, short value) {
        buf[index] = (byte)(value >> 8 & 0xFF);
        buf[index + 1] = (byte)(value & 0xFF);
    }

    public void rewrite() {
        int bytecode = -1;
        int hotspotcode = -1;
        int len = 0;
        if (DEBUG) {
            String msg = this.method.getMethodHolder().getName().asString() + "." + this.method.getName().asString() + this.method.getSignature().asString();
            this.debugMessage(msg);
        }
        for (int bci = 0; bci < this.code.length; bci += len) {
            hotspotcode = Bytecodes.codeAt(this.method, bci);
            bytecode = Bytecodes.javaCode(hotspotcode);
            if (Assert.ASSERTS_ENABLED) {
                int code_from_buffer = 0xFF & this.code[bci];
                Assert.that(code_from_buffer == hotspotcode || code_from_buffer == 202, "Unexpected bytecode found in method bytecode buffer!");
            }
            this.code[bci] = (byte)(0xFF & bytecode);
            short cpoolIndex = 0;
            switch (bytecode) {
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    cpoolIndex = this.getConstantPoolIndex(hotspotcode, bci + 1);
                    ByteCodeRewriter.writeShort(this.code, bci + 1, cpoolIndex);
                    break;
                }
                case 186: {
                    cpoolIndex = this.getConstantPoolIndex(hotspotcode, bci + 1);
                    ByteCodeRewriter.writeShort(this.code, bci + 1, cpoolIndex);
                    ByteCodeRewriter.writeShort(this.code, bci + 3, (short)0);
                    break;
                }
                case 19: {
                    if (hotspotcode == bytecode) break;
                    cpoolIndex = this.getConstantPoolIndexFromRefMap(hotspotcode, bci + 1);
                    ByteCodeRewriter.writeShort(this.code, bci + 1, cpoolIndex);
                    break;
                }
                case 18: {
                    if (hotspotcode == bytecode) break;
                    cpoolIndex = this.getConstantPoolIndexFromRefMap(hotspotcode, bci + 1);
                    this.code[bci + 1] = (byte)cpoolIndex;
                }
            }
            len = Bytecodes.lengthFor(bytecode);
            if (len <= 0) {
                len = Bytecodes.lengthAt(this.method, bci);
            }
            if (!DEBUG) continue;
            String operand = "";
            switch (len) {
                case 2: {
                    operand = operand + this.code[bci + 1];
                    break;
                }
                case 3: {
                    operand = operand + (cpoolIndex != 0 ? cpoolIndex : this.method.getBytecodeShortArg(bci + 1));
                    break;
                }
                case 5: {
                    operand = operand + this.method.getBytecodeIntArg(bci + 1);
                }
            }
            String message = "\t\t" + bci + " " + Bytecodes.name(bytecode);
            if (hotspotcode != bytecode) {
                message = message + " [" + Bytecodes.name(hotspotcode) + "]";
            }
            if (operand != "") {
                message = message + " #" + operand;
            }
            if (!DEBUG) continue;
            this.debugMessage(message);
        }
    }

    static {
        String debug = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("sun.jvm.hotspot.tools.jcore.ByteCodeRewriter.DEBUG");
            }
        });
        DEBUG = debug != null ? debug.equalsIgnoreCase("true") : false;
    }
}

