/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import com.southernstorm.noise.protocol.ChaChaPolyCipherState;
import com.southernstorm.noise.protocol.HandshakeState;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.i2p.crypto.HKDF;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Payload;
import net.i2p.router.transport.udp.SSU2Util;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.time.BuildTime;
import net.i2p.util.Addresses;
import net.i2p.util.HexDump;

class OutboundEstablishState2
extends OutboundEstablishState
implements SSU2Payload.PayloadCallback {
    private InetSocketAddress _bobSocketAddress;
    private final UDPTransport _transport;
    private final long _sendConnID;
    private final long _rcvConnID;
    private final RouterAddress _routerAddress;
    private final Map<Hash, IntroState> _introducers;
    private long _token;
    private HandshakeState _handshakeState;
    private final byte[] _headerEncryptKey1;
    private byte[] _sendHeaderEncryptKey2;
    private byte[] _rcvHeaderEncryptKey2;
    private final byte[] _rcvRetryHeaderEncryptKey2;
    private final int _mtu;
    private byte[] _sessReqForReTX;
    private byte[][] _sessConfForReTX;
    private long _timeReceived;
    private long _skew;
    private PeerState2 _pstate;
    private static final boolean SET_TOKEN = false;
    private static final long MAX_SKEW = 120000L;

    public OutboundEstablishState2(RouterContext ctx, UDPTransport transport, RemoteHostId claimedAddress, RemoteHostId remoteHostId, RouterIdentity remotePeer, boolean needIntroduction, SessionKey introKey, RouterAddress ra, UDPAddress addr) throws IllegalArgumentException {
        super(ctx, claimedAddress, remoteHostId, remotePeer, needIntroduction, introKey, addr);
        long rcid;
        int mtu;
        this._transport = transport;
        if (claimedAddress != null) {
            try {
                this._bobSocketAddress = new InetSocketAddress(InetAddress.getByAddress(this._bobIP), this._bobPort);
            }
            catch (UnknownHostException uhe) {
                throw new IllegalArgumentException("bad IP", uhe);
            }
        }
        if ((mtu = addr.getMTU()) == 0) {
            mtu = ra.getTransportStyle().equals("SSU2") ? 1500 : (this._bobIP != null && this._bobIP.length == 16 ? 1280 : 1484);
        } else {
            if (mtu < 1280) {
                throw new IllegalArgumentException("MTU " + mtu + " too small for " + remotePeer.getHash());
            }
            mtu = ra.getTransportStyle().equals("SSU2") ? Math.min(mtu, 1500) : (this._bobIP != null && this._bobIP.length == 16 ? Math.min(Math.max(mtu, 1280), 1488) : Math.min(Math.max(mtu, 1292), 1484));
        }
        this._mtu = mtu;
        this._routerAddress = ra;
        int intros = addr.getIntroducerCount();
        if (intros > 0) {
            this._currentState = OutboundEstablishState.OutboundState.OB_STATE_PENDING_INTRO;
            this._introducers = new HashMap<Hash, IntroState>(4);
            for (int i = 0; i < intros; ++i) {
                Hash h = addr.getIntroducerHash(i);
                if (h == null) continue;
                long exp = addr.getIntroducerExpiration(i);
                IntroState istate = exp != 0L && exp < this._establishBegin ? IntroState.INTRO_STATE_EXPIRED : (h.equals(this._context.routerHash()) ? IntroState.INTRO_STATE_US : (this._context.banlist().isBanlisted(h) ? IntroState.INTRO_STATE_REJECTED : IntroState.INTRO_STATE_INIT));
                this._introducers.put(h, istate);
            }
        } else if (claimedAddress != null) {
            this._token = this._transport.getEstablisher().getOutboundToken(this._remoteHostId);
            if (this._token != 0L) {
                this._currentState = OutboundEstablishState.OutboundState.OB_STATE_UNKNOWN;
                this.createNewState(ra);
            } else {
                this._currentState = OutboundEstablishState.OutboundState.OB_STATE_NEEDS_TOKEN;
            }
            this._introducers = null;
        } else {
            throw new IllegalArgumentException("No address and no introducers for " + remotePeer.getHash());
        }
        this._sendConnID = ctx.random().nextLong();
        while (this._sendConnID == (rcid = ctx.random().nextLong())) {
        }
        this._rcvConnID = rcid;
        byte[] ik = introKey.getData();
        this._headerEncryptKey1 = ik;
        this._sendHeaderEncryptKey2 = ik;
        this._rcvRetryHeaderEncryptKey2 = ik;
        if (this._log.shouldDebug()) {
            this._log.debug("New " + this);
        }
    }

    public synchronized void introduced(byte[] ip, int port, long token) {
        if (this._currentState != OutboundEstablishState.OutboundState.OB_STATE_PENDING_INTRO) {
            return;
        }
        this.introduced(ip, port);
        try {
            this._bobSocketAddress = new InetSocketAddress(InetAddress.getByAddress(ip), port);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException("bad IP", uhe);
        }
        this._token = token;
        this.createNewState(this._routerAddress);
    }

    private void createNewState(RouterAddress addr) {
        String ss = addr.getOption("s");
        if (ss == null) {
            throw new IllegalArgumentException("no SSU2 S");
        }
        byte[] publicKey = Base64.decode(ss);
        if (publicKey == null) {
            throw new IllegalArgumentException("bad SSU2 S");
        }
        if (publicKey.length != 32) {
            throw new IllegalArgumentException("bad SSU2 S len");
        }
        try {
            this._handshakeState = new HandshakeState("XK-SSU2", 1, this._transport.getXDHFactory());
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("bad proto", gse);
        }
        this._handshakeState.getRemotePublicKey().setPublicKey(publicKey, 0);
        this._handshakeState.getLocalKeyPair().setKeys(this._transport.getSSU2StaticPrivKey(), 0, this._transport.getSSU2StaticPubKey(), 0);
        this._sessReqForReTX = null;
    }

    private void processPayload(byte[] payload, int offset, int length, boolean isHandshake) throws GeneralSecurityException {
        try {
            int blocks = SSU2Payload.processPayload(this._context, this, payload, offset, length, isHandshake, null);
            if (this._log.shouldDebug()) {
                this._log.debug("Processed " + blocks + " blocks on " + this);
            }
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Retry or Session Created payload error", e);
        }
    }

    @Override
    public void gotDateTime(long time) {
        this._timeReceived = time;
    }

    @Override
    public void gotOptions(byte[] options, boolean isHandshake) {
        if (this._log.shouldDebug()) {
            this._log.debug("Got OPTIONS block");
        }
    }

    @Override
    public void gotRI(RouterInfo ri, boolean isHandshake, boolean flood) throws DataFormatException {
        throw new DataFormatException("RI in Sess Created");
    }

    @Override
    public void gotRIFragment(byte[] data, boolean isHandshake, boolean flood, boolean isGzipped, int frag, int totalFrags) {
        throw new IllegalStateException("RI in Sess Created");
    }

    @Override
    public void gotAddress(byte[] ip, int port) {
        if (this._log.shouldDebug()) {
            this._log.debug("Got Address: " + Addresses.toString(ip, port));
        }
        this._aliceIP = ip;
        this._alicePort = port;
    }

    @Override
    public void gotRelayTagRequest() {
        throw new IllegalStateException("Relay tag req in Sess Created");
    }

    @Override
    public void gotRelayTag(long tag) {
        if (this._log.shouldDebug()) {
            this._log.debug("Got relay tag " + tag);
        }
        this._receivedRelayTag = tag;
    }

    @Override
    public void gotRelayRequest(byte[] data) {
    }

    @Override
    public void gotRelayResponse(int status, byte[] data) {
    }

    @Override
    public void gotRelayIntro(Hash aliceHash, byte[] data) {
    }

    @Override
    public void gotPeerTest(int msg, int status, Hash h, byte[] data) {
    }

    @Override
    public void gotToken(long token, long expires) {
        if (this._log.shouldDebug()) {
            this._log.debug("Got token: " + token + " expires " + DataHelper.formatTime(expires) + " on " + this);
        }
        this._transport.getEstablisher().addOutboundToken(this._remoteHostId, token, expires);
    }

    @Override
    public void gotI2NP(I2NPMessage msg) {
        throw new IllegalStateException("I2NP in Sess Created");
    }

    @Override
    public void gotFragment(byte[] data, int off, int len, long messageId, int frag, boolean isLast) throws DataFormatException {
        throw new DataFormatException("I2NP in Sess Created");
    }

    @Override
    public void gotACK(long ackThru, int acks, byte[] ranges) {
        throw new IllegalStateException("ACK in Sess Created");
    }

    @Override
    public void gotTermination(int reason, long count) {
        if (this._log.shouldWarn()) {
            this._log.warn("Got TERMINATION block, reason: " + reason + " count: " + count + " on " + this);
        }
        this.fail();
        this._transport.getEstablisher().receiveSessionDestroy(this._remoteHostId, this);
        Hash bob = this._remotePeer.calculateHash();
        if (reason == 17) {
            this._context.banlist().banlistRouter(bob, "They banned us", null, null, this._context.clock().now() + 0x6DDD00L);
        } else if (reason == 11) {
            this._context.banlist().banlistRouter(bob, "They banned us", null, null, this._context.clock().now() + 1200000L);
        } else if (reason == 7) {
            long sendOn = this._timeReceived;
            long recvOn = this._establishBegin;
            long skew = recvOn - sendOn;
            String skewString = DataHelper.formatDuration(Math.abs(skew));
            if (this._log.shouldWarn()) {
                this._log.warn("Failed, clock skew " + skewString + " on " + this);
            }
            if (sendOn != 0L) {
                if (sendOn < BuildTime.getEarliestTime() || sendOn > BuildTime.getLatestTime()) {
                    this._context.banlist().banlistRouter(skewString, bob, OutboundEstablishState2._x("Excessive clock skew: {0}"));
                } else if (!this._context.clock().getUpdatedSuccessfully()) {
                    this._context.clock().setOffset(0L - skew, true);
                    if (skew != 0L) {
                        this._log.logAlways(30, "NTP failure, SSU2 adjusted clock by " + skewString + " source router: " + bob.toBase64());
                    }
                    if (!this._context.clock().getUpdatedSuccessfully()) {
                        this._context.banlist().banlistRouter(bob, OutboundEstablishState2._x("Excessive clock skew: {0}"), skewString, null, this._context.clock().now() + 300000L);
                    }
                } else {
                    this._context.banlist().banlistRouter(skewString, bob, OutboundEstablishState2._x("Excessive clock skew: {0}"));
                }
            }
            this._context.statManager().addRateData("udp.destroyedInvalidSkew", skew);
        }
    }

    @Override
    public void gotPathChallenge(RemoteHostId from, byte[] data) {
    }

    @Override
    public void gotPathResponse(RemoteHostId from, byte[] data) {
    }

    @Override
    public synchronized void fail() {
        if (this._handshakeState != null) {
            this._handshakeState.destroy();
        }
        super.fail();
    }

    @Override
    public synchronized boolean validateSessionCreated() {
        boolean rv = this._currentState == OutboundEstablishState.OutboundState.OB_STATE_CREATED_RECEIVED || this._currentState == OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY;
        return rv;
    }

    @Override
    synchronized boolean receiveHolePunch() {
        long now;
        if (this._currentState == OutboundEstablishState.OutboundState.OB_STATE_PENDING_INTRO) {
            this._currentState = OutboundEstablishState.OutboundState.OB_STATE_INTRODUCED;
        } else if (this._currentState != OutboundEstablishState.OutboundState.OB_STATE_INTRODUCED) {
            return false;
        }
        if (this._requestSentCount > 0) {
            return false;
        }
        this._nextSend = now = this._context.clock().now();
        return true;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    public long getSendConnID() {
        return this._sendConnID;
    }

    public long getRcvConnID() {
        return this._rcvConnID;
    }

    public long getToken() {
        return this._token;
    }

    public EstablishmentManager.Token getNextToken() {
        if (this._bobIP != null && this._bobIP.length == 4 && this._transport.isSymNatted()) {
            return null;
        }
        return this._transport.getEstablisher().getInboundToken(this._remoteHostId);
    }

    public HandshakeState getHandshakeState() {
        return this._handshakeState;
    }

    public byte[] getSendHeaderEncryptKey1() {
        return this._headerEncryptKey1;
    }

    public byte[] getRcvHeaderEncryptKey1() {
        return this._headerEncryptKey1;
    }

    public byte[] getSendHeaderEncryptKey2() {
        return this._sendHeaderEncryptKey2;
    }

    public byte[] getRcvHeaderEncryptKey2() {
        return this._rcvHeaderEncryptKey2;
    }

    public byte[] getRcvRetryHeaderEncryptKey2() {
        return this._rcvRetryHeaderEncryptKey2;
    }

    public InetSocketAddress getSentAddress() {
        return this._bobSocketAddress;
    }

    public int getMTU() {
        if (this._bobIP == null || this._bobIP.length == 16) {
            return 1280;
        }
        return this._mtu;
    }

    public synchronized void receiveRetry(UDPPacket packet) throws GeneralSecurityException {
        try {
            this.locked_receiveRetry(packet);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldDebug()) {
                this._log.debug("Retry error", gse);
            }
            this.fail();
            throw gse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locked_receiveRetry(UDPPacket packet) throws GeneralSecurityException {
        DatagramPacket pkt = packet.getPacket();
        SocketAddress from = pkt.getSocketAddress();
        if (!from.equals(this._bobSocketAddress)) {
            throw new GeneralSecurityException("Address mismatch: req: " + this._bobSocketAddress + " conf: " + from);
        }
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] data = pkt.getData();
        long rid = DataHelper.fromLong8(data, off);
        if (rid != this._rcvConnID) {
            throw new GeneralSecurityException("Conn ID mismatch: 1: " + this._rcvConnID + " 2: " + rid);
        }
        long sid = DataHelper.fromLong8(data, off + 16);
        if (sid != this._sendConnID) {
            throw new GeneralSecurityException("Conn ID mismatch: 1: " + this._sendConnID + " 2: " + sid);
        }
        long token = DataHelper.fromLong8(data, off + 24);
        if (token != 0L && token != this._token) {
            if (this._currentState == OutboundEstablishState.OutboundState.OB_STATE_REQUEST_SENT_NEW_TOKEN) {
                throw new GeneralSecurityException("Token mismatch: expected: " + this._token + " got: " + token);
            }
            this._token = token;
        }
        this._timeReceived = 0L;
        ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
        chacha.initializeKey(this._headerEncryptKey1, 0);
        long n = DataHelper.fromLong(data, off + 8, 4);
        chacha.setNonce(n);
        try {
            chacha.decryptWithAd(data, off, 32, data, off + 32, data, off + 32, len - 32);
            this.processPayload(data, off + 32, len - 48, true);
        }
        finally {
            chacha.destroy();
        }
        this.packetReceived();
        if (this._currentState == OutboundEstablishState.OutboundState.OB_STATE_VALIDATION_FAILED) {
            return;
        }
        if (token == 0L) {
            throw new GeneralSecurityException("Bad token 0 in retry");
        }
        if (this._currentState != OutboundEstablishState.OutboundState.OB_STATE_TOKEN_REQUEST_SENT && this._currentState != OutboundEstablishState.OutboundState.OB_STATE_REQUEST_SENT) {
            if (this._log.shouldWarn()) {
                this._log.warn("Got out-of-order Retry with token " + token + " on: " + this);
            }
            this._nextSend = Math.max(this._context.clock().now(), this._lastSend + 750L);
            return;
        }
        if (this._timeReceived == 0L) {
            throw new GeneralSecurityException("No DateTime block in Retry");
        }
        this._skew = this._nextSend - this._timeReceived;
        if (this._skew > 120000L || this._skew < -120000L) {
            throw new GeneralSecurityException("Skew exceeded in Retry: " + this._skew);
        }
        this.createNewState(this._routerAddress);
        if (this._log.shouldDebug()) {
            this._log.debug("Received a retry token " + token + " on " + this);
        }
        this._currentState = OutboundEstablishState.OutboundState.OB_STATE_RETRY_RECEIVED;
    }

    public synchronized void receiveSessionCreated(UDPPacket packet) throws GeneralSecurityException {
        try {
            this.locked_receiveSessionCreated(packet);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldDebug()) {
                DatagramPacket pkt = packet.getPacket();
                byte[] data = pkt.getData();
                int off = pkt.getOffset();
                int len = pkt.getLength();
                this._log.debug("Session create error, State at failure: " + this._handshakeState + '\n' + HexDump.dump(data, off, len), gse);
            }
            this.fail();
            throw gse;
        }
    }

    private void locked_receiveSessionCreated(UDPPacket packet) throws GeneralSecurityException {
        DatagramPacket pkt;
        SocketAddress from;
        if (this._currentState != OutboundEstablishState.OutboundState.OB_STATE_REQUEST_SENT && this._currentState != OutboundEstablishState.OutboundState.OB_STATE_REQUEST_SENT_NEW_TOKEN) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid state for session created: " + this);
            }
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Received a session created on " + this);
        }
        if (!(from = (pkt = packet.getPacket()).getSocketAddress()).equals(this._bobSocketAddress)) {
            throw new GeneralSecurityException("Address mismatch: req: " + this._bobSocketAddress + " created: " + from);
        }
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] data = pkt.getData();
        long rid = DataHelper.fromLong8(data, off);
        if (rid != this._rcvConnID) {
            throw new GeneralSecurityException("Conn ID mismatch: 1: " + this._rcvConnID + " 2: " + rid);
        }
        long sid = DataHelper.fromLong8(data, off + 16);
        if (sid != this._sendConnID) {
            throw new GeneralSecurityException("Conn ID mismatch: 1: " + this._sendConnID + " 2: " + sid);
        }
        this._handshakeState.mixHash(data, off, 32);
        this._handshakeState.readMessage(data, off + 32, len - 32, data, off + 32);
        this._timeReceived = 0L;
        this.processPayload(data, off + 32, len - (32 + SSU2Util.KEY_LEN + 16), true);
        this.packetReceived();
        if (this._currentState == OutboundEstablishState.OutboundState.OB_STATE_VALIDATION_FAILED) {
            return;
        }
        if (this._timeReceived == 0L) {
            throw new GeneralSecurityException("No DateTime block in Session Created");
        }
        if (this._aliceIP == null) {
            throw new GeneralSecurityException("No Address block in Session Created");
        }
        if (this._requestSentCount == 1) {
            this._rtt = (int)(this._nextSend - this._requestSentTime);
        }
        this._skew = this._nextSend - this._timeReceived - (long)(this._rtt / 2);
        if (!this._context.clock().getUpdatedSuccessfully() && this._timeReceived > BuildTime.getEarliestTime() && this._timeReceived < BuildTime.getLatestTime()) {
            this._context.clock().setOffset(0L - this._skew, true);
            if (this._skew != 0L) {
                String skewString = DataHelper.formatDuration(Math.abs(this._skew));
                Hash bob = this._remotePeer.calculateHash();
                this._log.logAlways(30, "NTP failure, SSU2 adjusted clock by " + skewString + " source router: " + bob.toBase64());
            }
        }
        if (this._skew > 120000L || this._skew < -120000L) {
            throw new GeneralSecurityException("Skew exceeded in Session Created: " + this._skew);
        }
        this._sessReqForReTX = null;
        this._sendHeaderEncryptKey2 = SSU2Util.hkdf(this._context, this._handshakeState.getChainingKey(), "SessionConfirmed");
        this._currentState = OutboundEstablishState.OutboundState.OB_STATE_CREATED_RECEIVED;
    }

    public synchronized void tokenRequestSent(DatagramPacket packet) {
        OutboundEstablishState.OutboundState old = this._currentState;
        this.requestSent();
        if (old == OutboundEstablishState.OutboundState.OB_STATE_NEEDS_TOKEN) {
            this._currentState = OutboundEstablishState.OutboundState.OB_STATE_TOKEN_REQUEST_SENT;
        }
    }

    public synchronized void requestSent(DatagramPacket pkt) {
        OutboundEstablishState.OutboundState old = this._currentState;
        this.requestSent();
        if (this._sessReqForReTX == null) {
            byte[] data = pkt.getData();
            int off = pkt.getOffset();
            int len = pkt.getLength();
            this._sessReqForReTX = new byte[len];
            System.arraycopy(data, off, this._sessReqForReTX, 0, len);
            if (this._requestSentCount > 1) {
                this._requestSentCount = 1;
                this._nextSend = this._lastSend + 1250L;
            }
        }
        if (this._rcvHeaderEncryptKey2 == null) {
            this._rcvHeaderEncryptKey2 = SSU2Util.hkdf(this._context, this._handshakeState.getChainingKey(), "SessCreateHeader");
        }
        if (old == OutboundEstablishState.OutboundState.OB_STATE_RETRY_RECEIVED) {
            this._currentState = OutboundEstablishState.OutboundState.OB_STATE_REQUEST_SENT_NEW_TOKEN;
        }
    }

    public synchronized PeerState2 confirmedPacketsSent(UDPPacket[] packets) {
        if (this._sessConfForReTX == null) {
            this._sessConfForReTX = new byte[packets.length][];
            for (int i = 0; i < packets.length; ++i) {
                DatagramPacket pkt = packets[i].getPacket();
                byte[] data = pkt.getData();
                int off = pkt.getOffset();
                int len = pkt.getLength();
                byte[] save = new byte[len];
                System.arraycopy(data, off, save, 0, len);
                this._sessConfForReTX[i] = save;
                if (!this._log.shouldDebug()) continue;
                this._log.debug("Sess conf pkt " + i + '/' + packets.length + " bytes: " + len);
            }
            if (this._rcvHeaderEncryptKey2 == null) {
                this._rcvHeaderEncryptKey2 = SSU2Util.hkdf(this._context, this._handshakeState.getChainingKey(), "SessCreateHeader");
            }
            byte[] ckd = this._handshakeState.getChainingKey();
            byte[] k_ab = new byte[32];
            byte[] k_ba = new byte[32];
            HKDF hkdf = new HKDF(this._context);
            hkdf.calculate(ckd, SSU2Util.ZEROLEN, k_ab, k_ba, 0);
            byte[] d_ab = new byte[32];
            byte[] h_ab = new byte[32];
            byte[] d_ba = new byte[32];
            byte[] h_ba = new byte[32];
            hkdf.calculate(k_ab, SSU2Util.ZEROLEN, "HKDFSSU2DataKeys", d_ab, h_ab, 0);
            hkdf.calculate(k_ba, SSU2Util.ZEROLEN, "HKDFSSU2DataKeys", d_ba, h_ba, 0);
            ChaChaPolyCipherState sender = new ChaChaPolyCipherState();
            sender.initializeKey(d_ab, 0);
            ChaChaPolyCipherState rcvr = new ChaChaPolyCipherState();
            rcvr.initializeKey(d_ba, 0);
            Arrays.fill(ckd, (byte)0);
            Arrays.fill(k_ab, (byte)0);
            Arrays.fill(k_ba, (byte)0);
            Arrays.fill(d_ab, (byte)0);
            Arrays.fill(d_ba, (byte)0);
            this._handshakeState.destroy();
            if (this._requestSentCount == 1) {
                this._rtt = (int)(this._context.clock().now() - this._lastSend);
            }
            this._pstate = new PeerState2(this._context, this._transport, this._bobSocketAddress, this._remotePeer.calculateHash(), false, this._rtt, sender, rcvr, this._sendConnID, this._rcvConnID, this._headerEncryptKey1, h_ab, h_ba);
            this._currentState = OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY;
            this._pstate.confirmedPacketsSent(this._sessConfForReTX);
            this._pstate.adjustClockSkew(this._skew - (long)(this._rtt / 2) - 100L);
            this._pstate.setHisMTU(this._mtu);
            this._pstate.setOurAddress(this._aliceIP, this._alicePort);
        }
        this.confirmedPacketsSent();
        return this._pstate;
    }

    public synchronized UDPPacket getRetransmitSessionRequestPacket() {
        if (this._sessReqForReTX == null) {
            return null;
        }
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        System.arraycopy(this._sessReqForReTX, 0, data, off, this._sessReqForReTX.length);
        pkt.setLength(this._sessReqForReTX.length);
        pkt.setSocketAddress(this._bobSocketAddress);
        packet.setMessageType(72);
        packet.setPriority(550);
        this.requestSent();
        return packet;
    }

    public synchronized PeerState2 getPeerState() {
        this._currentState = OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY;
        return this._pstate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntroState getIntroState(Hash h) {
        IntroState rv;
        if (this._introducers == null) {
            rv = IntroState.INTRO_STATE_INVALID;
        } else {
            Map<Hash, IntroState> map = this._introducers;
            synchronized (map) {
                rv = this._introducers.get(h);
            }
            if (rv == null) {
                rv = IntroState.INTRO_STATE_INVALID;
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntroState(Hash h, IntroState state) {
        IntroState old;
        if (this._introducers == null) {
            return;
        }
        Map<Hash, IntroState> map = this._introducers;
        synchronized (map) {
            old = this._introducers.put(h, state);
        }
        if (old != state && this._log.shouldDebug()) {
            this._log.debug("Change state for introducer " + h.toBase64() + " from " + (Object)((Object)old) + " to " + (Object)((Object)state) + " on " + this);
        }
    }

    public void introSent(Hash h) {
        this.setIntroState(h, IntroState.INTRO_STATE_RELAY_REQUEST_SENT);
        this.introSent();
    }

    @Override
    public String toString() {
        return "OES2 " + this._remotePeer.getHash().toBase64().substring(0, 6) + ' ' + this._remoteHostId + " lifetime: " + DataHelper.formatDuration(this.getLifetime()) + " Rcv ID: " + this._rcvConnID + " Send ID: " + this._sendConnID + " Token: " + this._token + ' ' + (Object)((Object)this._currentState) + (this._introducers != null ? " Introducers: " + this._introducers.toString() : "");
    }

    private static final String _x(String s) {
        return s;
    }

    public static enum IntroState {
        INTRO_STATE_INIT,
        INTRO_STATE_LOOKUP_SENT,
        INTRO_STATE_HAS_RI,
        INTRO_STATE_CONNECTING,
        INTRO_STATE_CONNECTED,
        INTRO_STATE_RELAY_REQUEST_SENT,
        INTRO_STATE_RELAY_CHARLIE_ACCEPTED,
        INTRO_STATE_EXPIRED,
        INTRO_STATE_LOOKUP_FAILED,
        INTRO_STATE_REJECTED,
        INTRO_STATE_CONNECT_FAILED,
        INTRO_STATE_DISCONNECTED,
        INTRO_STATE_RELAY_RESPONSE_TIMEOUT,
        INTRO_STATE_BOB_REJECT,
        INTRO_STATE_CHARLIE_REJECT,
        INTRO_STATE_FAILED,
        INTRO_STATE_INVALID,
        INTRO_STATE_US,
        INTRO_STATE_SUCCESS;

    }
}

