/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.Wavetable;

abstract class WavetableGenerator {
    WavetableGenerator() {
    }

    public static Wavetable gen7(int size, float[] val, int[] dist) {
        float[] waveform = new float[size];
        if (val.length - 1 != dist.length) {
            System.out.println("Input arrays of invalid sizes!");
            return null;
        }
        int sum = 0;
        int i = 0;
        while (i < dist.length) {
            sum += dist[i];
            ++i;
        }
        if (size != sum) {
            System.out.println("Distances do not sum to size!");
            return null;
        }
        i = 0;
        int j = 1;
        while (j < val.length) {
            waveform[i] = val[j - 1];
            float m = (val[j] - val[j - 1]) / (float)dist[j - 1];
            int k = i + 1;
            while (k < i + dist[j - 1]) {
                waveform[k] = m * (float)(k - i) + val[j - 1];
                ++k;
            }
            i += dist[j - 1];
            ++j;
        }
        waveform[waveform.length - 1] = val[val.length - 1];
        return new Wavetable(waveform);
    }

    public static Wavetable gen9(int size, float[] partial, float[] amp, float[] phase) {
        if (partial.length != amp.length || partial.length != phase.length || amp.length != phase.length) {
            System.err.println("Input arrays of different size!");
            return null;
        }
        float[] waveform = new float[size];
        float index = 0.0f;
        int i = 0;
        while (i < size) {
            index = (float)i / (float)(size - 1);
            int j = 0;
            while (j < partial.length) {
                int n = i;
                waveform[n] = (float)((double)waveform[n] + (double)amp[j] * Math.sin(Math.PI * 2 * (double)partial[j] * (double)index + (double)phase[j]));
                ++j;
            }
            ++i;
        }
        return new Wavetable(waveform);
    }

    public static Wavetable gen10(int size, float[] amp) {
        float[] waveform = new float[size];
        float index = 0.0f;
        int i = 0;
        while (i < size) {
            index = (float)i / (float)(size - 1);
            int j = 0;
            while (j < amp.length) {
                int n = i;
                waveform[n] = (float)((double)waveform[n] + (double)amp[j] * Math.sin(Math.PI * 2 * (double)(j + 1) * (double)index));
                ++j;
            }
            ++i;
        }
        return new Wavetable(waveform);
    }
}

