/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.values;

import java.awt.Color;
import java.net.URL;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionUtilities;
import org.jfree.layouting.layouter.style.functions.values.StyleValueFunction;
import org.jfree.layouting.layouter.style.values.CSSRawValue;
import org.jfree.layouting.layouter.style.values.CSSResourceValue;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.ColorUtil;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class AttrValueFunction
implements StyleValueFunction {
    @Override
    public CSSValue evaluate(LayoutProcess layoutProcess, LayoutElement layoutElement, CSSFunctionValue cSSFunctionValue) throws FunctionEvaluationException {
        CSSValue[] cSSValueArray = cSSFunctionValue.getParameters();
        if (cSSValueArray.length < 2) {
            throw new FunctionEvaluationException("The parsed attr() function needs at least two parameters.");
        }
        String string = FunctionUtilities.resolveString(layoutProcess, layoutElement, cSSValueArray[0]);
        String string2 = FunctionUtilities.resolveString(layoutProcess, layoutElement, cSSValueArray[1]);
        String string3 = null;
        if (cSSValueArray.length >= 3) {
            string3 = FunctionUtilities.resolveString(layoutProcess, layoutElement, cSSValueArray[2]);
        }
        AttributeMap attributeMap = layoutElement.getLayoutContext().getAttributes();
        if (string == null || "".equals(string)) {
            Object object = attributeMap.getAttribute(layoutElement.getLayoutContext().getNamespace(), string2);
            return this.convertValue(layoutProcess, object, string3);
        }
        if ("*".equals(string)) {
            Object object = attributeMap.getFirstAttribute(string2);
            return this.convertValue(layoutProcess, object, string3);
        }
        Object object = attributeMap.getAttribute(string, string2);
        return this.convertValue(layoutProcess, object, string3);
    }

    private CSSValue convertValue(LayoutProcess layoutProcess, Object object, String string) throws FunctionEvaluationException {
        if (object instanceof CSSValue) {
            throw new FunctionEvaluationException();
        }
        if (object instanceof String) {
            String string2 = (String)object;
            if ("length".equals(string)) {
                return FunctionUtilities.parseNumberValue(string2);
            }
            if ("url".equals(string)) {
                return FunctionUtilities.loadResource(layoutProcess, string2);
            }
            if ("color".equals(string)) {
                CSSValue cSSValue = ColorUtil.parseColor(string2);
                if (cSSValue == null) {
                    throw new FunctionEvaluationException();
                }
                return cSSValue;
            }
            return FunctionUtilities.parseValue(layoutProcess, string2);
        }
        if (object instanceof URL) {
            return FunctionUtilities.loadResource(layoutProcess, object);
        }
        if (object instanceof Resource) {
            return new CSSResourceValue((Resource)object);
        }
        if (object instanceof ResourceKey) {
            return FunctionUtilities.loadResource(layoutProcess, object);
        }
        if (object instanceof Number) {
            return FunctionUtilities.parseNumberValue(object.toString(), string);
        }
        if (object instanceof Color) {
            Color color = (Color)object;
            return new CSSColorValue(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return new CSSRawValue(object);
    }
}

