/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpHeaderField;
import org.parosproxy.paros.network.HttpMessage;

public class VariantHeader
implements Variant {
    @Deprecated
    public static final String[] injectableHeaders = new String[]{"User-Agent", "Referer", "Host"};
    private static final String[] injectablesTempArray = new String[]{"Content-Length".toLowerCase(Locale.ROOT), "Pragma".toLowerCase(Locale.ROOT), "Cache-Control".toLowerCase(Locale.ROOT), "Cookie".toLowerCase(Locale.ROOT), "Authorization".toLowerCase(Locale.ROOT), "Proxy-Authorization".toLowerCase(Locale.ROOT), "Connection".toLowerCase(Locale.ROOT), "Proxy-Connection".toLowerCase(Locale.ROOT), "If-Modified-Since".toLowerCase(Locale.ROOT), "If-None-Match".toLowerCase(Locale.ROOT), "X-Csrf-Token".toLowerCase(Locale.ROOT), "X-CsrfToken".toLowerCase(Locale.ROOT), "X-Xsrf-Token".toLowerCase(Locale.ROOT), "X-ZAP-Scan-ID".toLowerCase(Locale.ROOT), "X-ZAP-RequestID".toLowerCase(Locale.ROOT), "X-Security-Proxy".toLowerCase(Locale.ROOT)};
    private static final HashSet<String> NON_INJECTABLE_HEADERS = new HashSet<String>(Arrays.asList(injectablesTempArray));
    private List<NameValuePair> params = Collections.emptyList();

    @Override
    public void setMessage(HttpMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter message must not be null.");
        }
        ArrayList<NameValuePair> extractedParameters = new ArrayList<NameValuePair>();
        List<HttpHeaderField> httpHeaders = message.getRequestHeader().getHeaders();
        for (HttpHeaderField header : httpHeaders) {
            if (NON_INJECTABLE_HEADERS.contains(header.getName().toLowerCase(Locale.ROOT))) continue;
            extractedParameters.add(new NameValuePair(8, header.getName(), header.getValue(), extractedParameters.size()));
        }
        if (extractedParameters.isEmpty()) {
            this.params = Collections.emptyList();
        } else {
            extractedParameters.trimToSize();
            this.params = Collections.unmodifiableList(extractedParameters);
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        msg.getRequestHeader().setHeader(originalPair.getName(), value);
        if (value == null) {
            return "";
        }
        return originalPair.getName() + ": " + value;
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value);
    }
}

