# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=pango
VER=1.20.5
REV=2
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev
usemsvs6

(

set -x

DEPS=`latest --arch=${ARCH} glib cairo fontconfig freetype`
PROXY_LIBINTL=`latest --arch=${ARCH} proxy-libintl`

for D in $DEPS; do
    PATH=/devel/dist/${ARCH}/$D/bin:$PATH
    PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
done

# Don't do any relinking crap in libtool.

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I can only
# do this if you have shared version of the library, which you do not
# appear to have." Screw libtool. I know what I am doing. Yes, I do
# want to link with a static libintl now. (The proxy-libintl libintl
# wrapper.) (Although Pango as such doesn't use any functions from
# libintl, the glib pc file insists on specifying -lintl on its Libs
# line, so libtool needs to find libintl.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

patch -p0 <<\EOF &&
--- pango/pango-utils.c
+++ pango/pango-utils.c
@@ -659,9 +659,25 @@
 
 #ifdef G_OS_WIN32
 
-/* DllMain function needed to tuck away the DLL name */
-
-G_WIN32_DLLMAIN_FOR_DLL_NAME(static, dll_name)
+/* DllMain function needed to tuck away the DLL handle */
+
+static HMODULE pango_dll;
+
+BOOL WINAPI
+DllMain (HINSTANCE hinstDLL,
+	 DWORD     fdwReason,
+	 LPVOID    lpvReserved)
+{
+  switch (fdwReason)
+    {
+    case DLL_PROCESS_ATTACH:
+      pango_dll = (HMODULE) hinstDLL;
+      break;
+    }
+
+  return TRUE;
+}
+
 #endif
 
 /**
@@ -682,9 +682,11 @@
   static gchar *result = NULL;
 
   if (result == NULL)
-    result = g_win32_get_package_installation_subdirectory
-      (PACKAGE " " VERSION, dll_name, "etc\\pango");
-
+    {
+      gchar *root = g_win32_get_package_installation_directory_of_module (pango_dll);
+      result = g_build_filename (root, "etc\\pango", NULL);
+      g_free (root);
+    }
   return result;
 #else
   return SYSCONFDIR "/pango";
@@ -710,9 +710,11 @@
   static gchar *result = NULL;
 
   if (result == NULL)
-    result = g_win32_get_package_installation_subdirectory
-      (PACKAGE " " VERSION, dll_name, "lib\\pango");
-
+    {
+      gchar *root = g_win32_get_package_installation_directory_of_module (pango_dll);
+      result = g_build_filename (root, "lib\\pango", NULL);
+      g_free (root);
+    }
   return result;
 #else
   return LIBDIR "/pango";
--- pango/Makefile.in
+++ pango/Makefile.in
@@ -1426,6 +1426,7 @@
 # ------------------- win32 build stuff -------------------
 
 @OS_WIN32_TRUE@install-def-files:
+@OS_WIN32_TRUE@	mkdir -p $(DESTDIR)$(libdir)
 @OS_WIN32_TRUE@	$(INSTALL) $(srcdir)/pango.def $(DESTDIR)$(libdir)/pango-$(PANGO_API_VERSION).def
 @HAVE_FREETYPE_TRUE@@OS_WIN32_TRUE@	$(INSTALL) $(srcdir)/pangoft2.def $(DESTDIR)$(libdir)/pangoft2-$(PANGO_API_VERSION).def
 @OS_WIN32_TRUE@	$(INSTALL) $(srcdir)/pangowin32.def $(DESTDIR)$(libdir)/pangowin32-$(PANGO_API_VERSION).def
EOF

CC='gcc -mtune=pentium3 -mthreads' LDFLAGS="-L/devel/dist/${ARCH}/${PROXY_LIBINTL}/lib -Wl,--exclude-libs=libintl.a -Wl,--enable-auto-image-base" CFLAGS=-O2 ./configure --enable-debug=yes --disable-gtk-doc --without-x --prefix=c:/devel/target/$HEX --enable-explicit-deps=no --with-included-modules=yes &&
libtoolcacheize &&

PATH=/devel/target/$HEX/bin:.libs:$PATH make -j3 install &&

./pango-zip.sh &&

mv /tmp/pango-$VER.zip /tmp/$RUNZIP &&
mv /tmp/pango-dev-$VER.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/make/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
