/* Random regression tests etc. */

#include <fstream.h>
#include <stdio.h>
#include <strstream.h>
#include <string.h>

#define BUF_SIZE 4096

void
test1 ()
{
   fstream f;
   char    buf[BUF_SIZE];

   f.setbuf( buf, BUF_SIZE );
}

void
test2 ( )
{
   char string[BUF_SIZE];
   ostrstream s( string, BUF_SIZE );

   s << "Bla bla bla " << 55 << ' ' << 3.23 << '\0' << endl;
   cout << "Test2: " << string << endl;
}


/* Test case from Joe Buck <jbuck@Synopsys.COM>. */

class special_ofstream : public ofstream {
public:
	special_ofstream() : ofstream() {}
	special_ofstream(int fd) : ofstream(fd) {}
	special_ofstream(const char *name, int mode=ios::out, int prot=0664) {
		open(name,mode,prot);
	}
	void open(const char *name, int mode=ios::out, int prot=0664);
};

void special_ofstream::open(const char* name, int mode, int prot) {
	if (strcmp(name, "<cout>") == 0) {
		rdbuf()->attach(1);
	}
	else if (strcmp(name, "<cerr>") == 0) {
		rdbuf()->attach(2);
		setf(unitbuf);
	}
	else ofstream::open(name,mode,prot);
}

void
test3 ()
{
	{
		special_ofstream o("<cout>");
		o << "Hello\n";
		// o is destructed now.  This should not close cout
	}
	{
		special_ofstream o("<cout>");
		o << "Line 2\n";
	}
}

int main( )
{
  test1 ();
  test2 ();
  test3 ();
  return 0;
}
