/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.CachedRow;
import org.hsqldb.Trace;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextCache;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowOutputText
extends RowOutputBase {
    protected String fieldSep;
    protected String varSep;
    protected String longvarSep;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private String nextSep = "";
    private boolean nextSepEnd;
    protected boolean allQuoted;
    private String encoding;

    public RowOutputText(String string, String string2, String string3, boolean bl, String string4) {
        this.initTextDatabaseRowOutput(string, string2, string3, bl, string4);
    }

    private void initTextDatabaseRowOutput(String string, String string2, String string3, boolean bl, String string4) {
        if (string.endsWith("\n")) {
            this.fieldSepEnd = true;
            string = string.substring(0, string.length() - 1);
        }
        if (string2.endsWith("\n")) {
            this.varSepEnd = true;
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string3.endsWith("\n")) {
            this.longvarSepEnd = true;
            string3 = string3.substring(0, string3.length() - 1);
        }
        this.fieldSep = string;
        this.varSep = string2;
        this.longvarSep = string3;
        this.allQuoted = bl;
        this.encoding = string4;
    }

    public void writeEnd() {
        if (this.nextSepEnd) {
            this.writeBytes(this.nextSep);
        }
        this.writeBytes(TextCache.NL);
    }

    public void writeSize(int n) {
        this.nextSep = "";
        this.nextSepEnd = false;
    }

    public void writeType(int n) {
    }

    public void writeString(String string) {
        if ((string = this.checkConvertString(string, this.fieldSep)) == null) {
            return;
        }
        byte[] byArray = this.getBytes(string);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    protected void writeVarString(String string) {
        if ((string = this.checkConvertString(string, this.varSep)) == null) {
            return;
        }
        byte[] byArray = this.getBytes(string);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    protected void writeLongVarString(String string) {
        if ((string = this.checkConvertString(string, this.longvarSep)) == null) {
            return;
        }
        byte[] byArray = this.getBytes(string);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    protected String checkConvertString(String string, String string2) {
        if (string.indexOf(10) != -1 || string.indexOf(13) != -1) {
            throw new IllegalArgumentException(Trace.getMessage(145));
        }
        if (string.indexOf(string2) != -1) {
            return null;
        }
        return string;
    }

    private byte[] getBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        return byArray;
    }

    protected void writeByteArray(byte[] byArray) {
        this.ensureRoom(byArray.length * 2);
        StringConverter.writeHex(this.getBuffer(), this.count, byArray);
        this.count += byArray.length * 2;
    }

    public void writeShortData(short s) {
        this.writeIntData(s);
    }

    public void writeIntData(int n) {
        this.writeBytes(Integer.toString(n));
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    public void writeIntData(int n, int n2) {
        throw new RuntimeException(Trace.getMessage(152));
    }

    public void writeLongData(long l) {
        throw new RuntimeException();
    }

    protected void writeFieldType(int n) {
        this.writeBytes(this.nextSep);
        switch (n) {
            case 12: 
            case 100: {
                this.nextSep = this.varSep;
                this.nextSepEnd = this.varSepEnd;
                break;
            }
            case -1: {
                this.nextSep = this.longvarSep;
                this.nextSepEnd = this.longvarSepEnd;
                break;
            }
            default: {
                this.nextSep = this.fieldSep;
                this.nextSepEnd = this.fieldSepEnd;
            }
        }
    }

    protected void writeNull(int n) {
        this.writeFieldType(n);
    }

    protected void writeChar(String string, int n) {
        switch (n) {
            case 1: {
                this.writeString(string);
                return;
            }
            case 12: 
            case 100: {
                this.writeVarString(string);
                return;
            }
        }
        this.writeLongVarString(string);
    }

    protected void writeSmallint(Number number) {
        this.writeString(number.toString());
    }

    protected void writeInteger(Number number) {
        this.writeString(number.toString());
    }

    protected void writeBigint(Number number) {
        this.writeString(number.toString());
    }

    protected void writeReal(Double d, int n) {
        this.writeString(d.toString());
    }

    protected void writeDecimal(BigDecimal bigDecimal) {
        this.writeString(bigDecimal.toString());
    }

    protected void writeBit(Boolean bl) {
        this.writeString(bl.toString());
    }

    protected void writeDate(Date date) {
        this.writeString(date.toString());
    }

    protected void writeTime(Time time) {
        this.writeString(time.toString());
    }

    protected void writeTimestamp(Timestamp timestamp) {
        this.writeString(timestamp.toString());
    }

    protected void writeOther(JavaObject javaObject) {
        byte[] byArray = javaObject.getBytes();
        this.writeByteArray(byArray);
    }

    protected void writeBinary(Binary binary, int n) {
        this.writeByteArray(binary.getBytes());
    }

    public int getSize(CachedRow cachedRow) {
        this.reset();
        try {
            this.writeSize(0);
            this.writeData(cachedRow.getData(), cachedRow.getTable());
            this.writeEnd();
        }
        catch (Exception exception) {
            this.reset();
        }
        int n = this.size();
        this.reset();
        return n;
    }
}

